//=================================================================
//                       LineChartSeries
//=================================================================
//
//    This class provides the means to create an appropriate chart
// of either Line, Area, Bubble, or Scatter data series. The object
// is meant to be a be of type XYChart.Series<Number, Number> or
// XYChart.Series<Number, Number, Number>.
//
//                   << LineChartSeries.java >>
//
//=================================================================
// Copyright (C) 2017 Dana M. Proctor.
// Version 1.2 11/21/2017
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version
// 2 of the License, or (at your option) any later version. This
// program is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty
// of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
// the GNU General Public License for more details. You should
// have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// (http://opensource.org)
//
//=================================================================
// Revision History
// Changes to the code should be documented here and reflected
// in the present version number. Author information should
// also be included with the original copyright author.
//=================================================================
// Version 1.0 Initial LineChartSeries Class.
//         1.1 Changed Single Argument Constructor to Call Multi-Argument
//             Constructor Using DefaultChartProperties, Rather Than
//             Default XYSeries Constructor. Method addDataPoint() Added
//             Throws.
//         1.2 Modified to be Used as Demostration Plugin for lindyFrame.
//                           
//-----------------------------------------------------------------
//                 danap@dandymadeproductions.com
//=================================================================

package com.dandymadeproductions.scatterplot.data;

import org.jfree.data.general.SeriesException;
import org.jfree.data.xy.XYSeries;

import com.dandymadeproductions.scatterplot.ScatterPlot;

/**
 *    The LineChartSeries class provides the means to create an
 * appropriate chart of either Line, Area, or Scatter data
 * series. The object is meant to be a be of type XYSeries&lt;
 * Number, Number&gt;.
 * 
 * @author Dana M. Proctor
 * @version 1.2 11/21/2017
 */

public class LineChartSeries extends DataChartSeries
{
   // Class Instances
   private XYSeries dataSeries;
   
   //==============================================================
   // LineChartSeries Constructor
   //==============================================================

   public LineChartSeries(String seriesName)
   {
      super(seriesName);
      dataSeries = new XYSeries(seriesName, ScatterPlot.getChartDefaultProperties().getAutoSort(),
                                ScatterPlot.getChartDefaultProperties().getAllowDuplicateXValues());
   }
   
   //==============================================================
   // LineChartSeries Constructor
   //==============================================================

   public LineChartSeries(String seriesName, boolean autoSort, boolean allowDuplicateXValues)
   {
      super(seriesName);
      dataSeries = new XYSeries(seriesName, autoSort, allowDuplicateXValues);
   }
   
   //==============================================================
   // Class methods to add an data point to the series.
   //==============================================================
   
   public void addDataPoint(Number xAxisNumber, Number yAxisNumber) throws SeriesException
   {
      dataSeries.add(xAxisNumber, yAxisNumber);
   }
   
   //==============================================================
   // Class method to remove all data point from the series.
   //==============================================================
   
   public void clear()
   {
      dataSeries.clear();
   }
   
   //==============================================================
   // Class methods to get the series
   //==============================================================
   
   public XYSeries getDataSeries()
   {
      return dataSeries;
   }
}