//=================================================================
//                       DataChartSeries
//=================================================================
//
//    This class provides the means to tie all data series to a
// common class, interface.
//
//                   << DataChartSeries.java >>
//
//=================================================================
// Copyright (C) 2017 Dana M. Proctor.
// Version 1.1 11/21/2017
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version
// 2 of the License, or (at your option) any later version. This
// program is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty
// of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
// the GNU General Public License for more details. You should
// have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// (http://opensource.org)
//
//=================================================================
// Revision History
// Changes to the code should be documented here and reflected
// in the present version number. Author information should
// also be included with the original copyright author.
//=================================================================
// Version 1.0 Initial DataChartSeries Class.
//         1.1 Modified to be Used as Demostration Plugin for lindyFrame.
//                           
//-----------------------------------------------------------------
//                 danap@dandymadeproductions.com
//=================================================================

package com.dandymadeproductions.scatterplot.data;

/**
 *    The DataChartSeries class provides the means to tie all data series
 * to a common class, interface.
 * 
 * @author Dana M. Proctor
 * @version 1.1 11/21/2017
 */

public class DataChartSeries
{
   // Class Instances
   public String name;
   
   //==============================================================
   // DataChartSeries Constructor
   //==============================================================

   public DataChartSeries(String seriesName)
   {
      name = seriesName;
   }
   
   public void setSeriesName(String value)
   {
      name = value;
   }
   
   //==============================================================
   // Class methods to add an data point to a series. Series will
   // override these.
   //==============================================================
   
   public void addDataPoint(Number xAxisNumber, Number yAxisNumber) {}
   
   public void addDataPoint(String xAxisString, Number yAxisNumber) {}
   
   public void addDataPoint(Number xAxisNumber, String yAxisString) {}
   
   public void addDataPoint(Number xAxisNumber, Number yAxisNumber, Number zAxisNumber) {}
   
   //==============================================================
   // Class methods to remove all elements in a series. Series will
   // override these.
   //==============================================================
   
   public void clear() {}
}