//=================================================================
//                  ScatterPlot ChartsPanel
//=================================================================
//
//    This class provides the common panel for the charts to be used
// in the Data Charts plugin.
//
//                   << ChartsPanel.java >>
//
//=================================================================
// Copyright (C) 2017 Dana M. Proctor.
// Version 2.2 11/20/2017
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version
// 2 of the License, or (at your option) any later version. This
// program is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty
// of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
// the GNU General Public License for more details. You should
// have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// (http://opensource.org)
//
//=================================================================
// Revision History
// Changes to the code should be documented here and reflected
// in the present version number. Author information should
// also be included with the original copyright author.
//=================================================================
// Version 1.0 09/16/2017 Initial ChartsPanel Class.
//         1.1 09/19/2017 Constructor Changed Border. Added Method getSeriesCount().
//                        Misc. Cleanup.
//         1.2 09/20/2017 Added DEFAULT Class Instances.
//         1.3 09/22/2017 Removed Class Instance queryStatementString, ESTIMATED_
//                        MEMORY_PER_DATAPOINT, CONTROLLED_DATASET_SIZE, LOW_MEMORY_LIMIT.
//                        Added DEFAULT_PLOTBACKGROUNDCOLOR. Method addSeries() Changed
//                        Argument From Series to DataChartSeries & Cast Appropriately
//                        for LineChartSeries & CategoryLineChartSeries. Cleanup.
//         1.4 09/23/2017 Method addSeries() Additions to Conditional for Bar, Area, &
//                        XYArea Charts.
//         1.5 09/23/2017 Method addSeries Corrected XYArea Chart LineChartSeries to Return
//                        XYSeries as Required by XYAreaChartPanel.
//         1.6 09/24/2017 Method addSeries() Added Processing XYBar Chart. Removed Reference
//                        to HORIZONTAL_BAR.
//         1.7 09/25/2017 Method addSeries() Included PieChartPanel & ScatterChartPanel.
//         1.8 09/27/2017 Method addSeries() Included BubbleChartPanel Conditional.
//         1.9 09/30/2017 Added Class Instance chartDefaultProperties & Comments to 
//                        Static DEFAULT Class Instances.
//         2.0 10/01/2017 Added Method setDefaultProperties().
//         2.1 10/05/2017 Added Class Instances PIE_CHART_ALPHA, BUBBLE_CHART_ALPHA, &
//                        AREA_CHART_ALPHA. Method setDefaultProperties() Added Instance
//                        chartSeriesColors & Paint Sequence Setting for chart.
//         2.2 11/20/2017 Modified to be Used as Demostration Plugin for lindyFrame.
//                           
//-----------------------------------------------------------------
//                 danap@dandymadeproductions.com
//=================================================================

package com.dandymadeproductions.scatterplot.charts;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;

import javax.swing.BorderFactory;
import javax.swing.JPanel;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.plot.XYPlot;

import com.dandymadeproductions.scatterplot.ScatterPlot;
import com.dandymadeproductions.scatterplot.data.ChartSeriesColors;
import com.dandymadeproductions.scatterplot.data.DataChartSeries;
import com.dandymadeproductions.scatterplot.data.LineChartSeries;

/**
 *    The ChartsPanel class provides the common pane for the charts
 * to be used in the Data Charts plugin.
 * 
 * @author Dana M. Proctor
 * @version 2.2 11/20/2017
 */

public class ChartsPanel extends JPanel
{
   private static final long serialVersionUID = -6003287593001429926L;
   
   // Class Instances
   protected JFreeChart chart;
   protected ChartPanel chartPanel;
   protected String resourceExample, resourceChart;
   protected ChartProperties chartDefaultProperties;
   
   protected static final int EXAMPLE_SERIES_NUMBER = 1;
   private static final int PIE_CHART_ALPHA = 0xDD;
   private static final int BUBBLE_CHART_ALPHA = 0x80;
   private static final int AREA_CHART_ALPHA = 0xB0;
   
   // Chart
   public static final Color DEFAULT_FOREGROUND = (new JPanel()).getForeground();
   public static final Color DEFAULT_BACKGROUND = (new JPanel()).getBackground();
   
   // Series
   public static final boolean DEFAULT_AUTOSORT = true;
   public static final boolean DEFAULT_ALLOWDUPLICATEXVALUES = true;
   
   // Plot
   public static final Color DEFAULT_PLOTBACKGROUNDCOLOR = Color.WHITE;
   public static final Color DEFAULT_DOMAINGRIDLINECOLOR = Color.LIGHT_GRAY;
   public static final Color DEFAULT_RANGEGRIDLINECOLOR = Color.LIGHT_GRAY;
   public static final boolean DEFAULT_PLOTBASESHAPEVISIBLE = true;
   public static final boolean DEFAULT_PLOTBASESHAPEFILLED = true;
   
   // Line
   public static final boolean DEFAULT_DRAWSERIESLINEPATH = true;

   //==============================================================
   // DataChartPanel Constructor
   //==============================================================

   public ChartsPanel()
   {
      setLayout(new GridLayout(1, 1, 0, 0));
      setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(12, 5, 12, 5),
         BorderFactory.createRaisedSoftBevelBorder()));
      
      chartDefaultProperties = ScatterPlot.getChartDefaultProperties();
   }
   
   //==============================================================
   // Class Method to set the various chart's properties via the
   // preference's tool.
   //==============================================================
   
   public void setProperties(String chartType)
   {
      // Method Instances
      ChartSeriesColors chartSeriesColors;
      
      // General Chart
      chart.getTitle().setFont(new Font(getFont().getFamily(), Font.PLAIN,
                               chartDefaultProperties.getTitleFontSize()));
      
      //chart.setBackgroundPaint(chartDefaultProperties.getChartBackgroundColor());
      setBackground(chartDefaultProperties.getChartBackgroundColor());
      chart.getTitle().setPaint(chartDefaultProperties.getChartForegroundColor());
      
      // Paint Sequence
      if (ChartFactory.getChartTheme() instanceof StandardChartTheme)
      {
         if (chartType.equals(ScatterPlot.PIE_CHART))
            chartSeriesColors = new ChartSeriesColors(PIE_CHART_ALPHA);
         else if (chartType.equals(ScatterPlot.BUBBLE_CHART))
            chartSeriesColors = new ChartSeriesColors(BUBBLE_CHART_ALPHA);
         else if (chartType.equals(ScatterPlot.AREA_CHART))
            chartSeriesColors = new ChartSeriesColors(AREA_CHART_ALPHA);
         else
            chartSeriesColors = new ChartSeriesColors();
         
         StandardChartTheme chartTheme = (StandardChartTheme) ChartFactory.getChartTheme();
         chartTheme.setDrawingSupplier(chartSeriesColors.getDefaultDrawingSupplier());
         chartTheme.apply(chart);
      }
      
      // Chart Types Specifics
      if (chartType.equals(ScatterPlot.LINE_CHART) || chartType.equals(ScatterPlot.XYAREA_CHART)
          || chartType.equals(ScatterPlot.SCATTER_CHART) || chartType.equals(ScatterPlot.XYBAR_CHART)
          || chartType.equals(ScatterPlot.BUBBLE_CHART))
      {
         // Plot
         XYPlot xyPlot = (XYPlot) chart.getPlot();
         xyPlot.setBackgroundPaint(chartDefaultProperties.getPlotBackgroundColor());
         
         xyPlot.getDomainAxis().setLabelPaint(chartDefaultProperties.getChartForegroundColor());
         xyPlot.getDomainAxis().setAxisLinePaint(chartDefaultProperties.getChartForegroundColor());
         xyPlot.getDomainAxis().setTickLabelPaint(chartDefaultProperties.getChartForegroundColor());
         xyPlot.setDomainMinorGridlinePaint(chartDefaultProperties.getChartForegroundColor());
         xyPlot.setDomainGridlinePaint(chartDefaultProperties.getDomainGridLineColor());
         
         xyPlot.getRangeAxis().setLabelPaint(chartDefaultProperties.getChartForegroundColor());
         xyPlot.getRangeAxis().setAxisLinePaint(chartDefaultProperties.getChartForegroundColor());
         xyPlot.getRangeAxis().setTickLabelPaint(chartDefaultProperties.getChartForegroundColor());
         xyPlot.setRangeMinorGridlinePaint(chartDefaultProperties.getChartForegroundColor());
         xyPlot.setRangeGridlinePaint(chartDefaultProperties.getRangeGridLineColor());
      }
      /*
      else if (chartType.equals(ScatterPlot.CATEGORY_LINE_CHART) || chartType.equals(ScatterPlot.BAR_CHART)
               || chartType.equals(ScatterPlot.AREA_CHART))
      {
         // Plot
         CategoryPlot categoryPlot = (CategoryPlot) chart.getPlot();
         categoryPlot.setBackgroundPaint(chartDefaultProperties.getPlotBackgroundColor());
         
         categoryPlot.getDomainAxis().setLabelPaint(chartDefaultProperties.getChartForegroundColor());
         categoryPlot.getDomainAxis().setAxisLinePaint(chartDefaultProperties.getChartForegroundColor());
         categoryPlot.getDomainAxis().setTickLabelPaint(chartDefaultProperties.getChartForegroundColor());
         categoryPlot.setDomainGridlinePaint(chartDefaultProperties.getDomainGridLineColor());
         
         categoryPlot.getRangeAxis().setLabelPaint(chartDefaultProperties.getChartForegroundColor());
         categoryPlot.getRangeAxis().setAxisLinePaint(chartDefaultProperties.getChartForegroundColor());
         categoryPlot.getRangeAxis().setTickLabelPaint(chartDefaultProperties.getChartForegroundColor());
         categoryPlot.setRangeMinorGridlinePaint(chartDefaultProperties.getChartForegroundColor());
         categoryPlot.setRangeGridlinePaint(chartDefaultProperties.getRangeGridLineColor());
      }
      else if (chartType.equals(ScatterPlot.PIE_CHART))
      {
         // Plot
         PiePlot piePlot = (PiePlot) chart.getPlot();
         piePlot.setBackgroundPaint(chartDefaultProperties.getPlotBackgroundColor());
         piePlot.setLabelPaint(chartDefaultProperties.getChartForegroundColor());
         
         piePlot.setLabelLinksVisible(true);
      }
      */
      else
      {
         // What?
      }
      
   }
   
   public void setExampleData()
   {
      // Override this method to set example data in the
      // particular chart.
   }
   
   //==============================================================
   // Class method to add a series to the existing chart type.
   //==============================================================
   
   public void addSeries(DataChartSeries series)
   {
      if (this instanceof LineChartPanel)
         ((LineChartPanel) this).addSeries(((LineChartSeries) series).getDataSeries());
      /*
      else if (this instanceof CategoryLineChartPanel)
         ((CategoryLineChartPanel) this).addSeries(((CategoryChartSeries) series));
      else if (this instanceof BarChartPanel)
         ((BarChartPanel) this).addSeries(((CategoryChartSeries) series));
      else if (this instanceof XYBarChartPanel)
         ((XYBarChartPanel) this).addSeries(((LineChartSeries) series).getDataSeries());
      else if (this instanceof PieChartPanel)
         ((PieChartPanel) this).addSeries(((CategoryChartSeries) series));
      else if (this instanceof AreaChartPanel)
         ((AreaChartPanel) this).addSeries(((CategoryChartSeries) series));
      else if (this instanceof XYAreaChartPanel)
         ((XYAreaChartPanel) this).addSeries(((LineChartSeries) series).getDataSeries());
      else if (this instanceof BubbleChartPanel)
         ((BubbleChartPanel) this).addSeries(((BubbleChartSeries) series));
      */
      else if (this instanceof ScatterChartPanel)
         ((ScatterChartPanel) this).addSeries(((LineChartSeries) series).getDataSeries());
      else
      {
         // Do Nothing.
      }
   }
   
   public void clearData()
   {
      // Override this method to clear all series data from
      // the particular chart.
   }
   
   public void removeAllData()
   {
      // Override this method to remove all series from the
      // particular chart.
   }
   
   public int getSeriesCount()
   {
      // Override this method to collect
      // the current number of series.
      return 0;
   }
   
   public String getChartTitle()
   {
      // Override this method to return the title for the
      // particular chart.
      return null;
   }
   
   public void setChartTitle(String value)
   {
      // Override this method to set the title for the
      // particular chart.  
   }
   
   public String getChartXAxisLabel()
   {
      // Override this method to return the xaxis label
      // for the particular chart.
      return null;
   }
   
   public void setChartXAxisLabel(String value)
   {
      // Override this method to set the xaxis label
      // for the particular chart.  
   }
   
   public String getChartYAxisLabel()
   {
      // Override this method to return the yaxis label
      // for the particular chart.
      return null;
   }
   
   public void setChartYAxisLabel(String value)
   {
      // Override this method to set the yaxis label
      // for the particular chart.  
   }
}