//=================================================================
//               ScatterPlot PluginModule Class
//=================================================================
//
//    This class provides the hook to incorporate a external plugin
// module into the lindyFrame framework.
//
//                  << PluginModule.java >>
//
//=================================================================
// Copyright (c) 2017 Dana M. Proctor.
// Version 1.1 - 11/18/2017
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version
// 2 of the License, or (at your option) any later version. This
// program is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty
// of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
// the GNU General Public License for more details. You should
// have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// (http://opensource.org)
//
//=================================================================
// Revision History
// Changes to the code should be documented here and reflected
// in the present version number. Author information should
// also be included with the original copyright author.
//=================================================================
// Version 1.0 Original ScatterPlot PluginModule.
//         1.1 Added category String in initPlugin().
//
//-----------------------------------------------------------------
//                 danap@dandymadeproductions.com
//=================================================================

package com.dandymadeproductions.scatterplot;

import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

import com.dandymadeproductions.lindyframe.gui.Main_Frame;
import com.dandymadeproductions.lindyframe.plugin.LindyFrame_PluginModule;

/**
 *    The PluginModule class provides the hook to incorporate a external plugin
 * module into the lindyFrame framework.
 * 
 * @author Dana M. Proctor
 * @version 1.1 11/18/2017
 */

public class PluginModule extends LindyFrame_PluginModule
{
   // Class Instances
   private String pluginName, pluginAuthor, category;
   private ScatterPlot scatterPlot;

   //==============================================================
   // PluginModule Constructor.
   //==============================================================

   public PluginModule()
   {
      super();
   }

   //==============================================================
   // Class method to initialize your plugin.
   //==============================================================

   public void initPlugin(Main_Frame parentFrame, String path)
   {
      pluginName = "Scatter Plot";
      pluginAuthor = "Dandy Made Productions";
      category = "Utility";
      scatterPlot = new ScatterPlot(parentFrame, path);
   }

   //==============================================================
   // Class method to meet the interface requirements for getting
   // the name of the module.
   //==============================================================

   public String getName()
   {
      return pluginName;
   }
   
   //==============================================================
   // Class method to meet the interface requirements for getting
   // the author of the module.
   //==============================================================

   public String getAuthor()
   {
      return pluginAuthor;
   }
   
   //==============================================================
   // Class method to return the version release number of the
   // plugin module.
   //==============================================================
   
   public String getVersion()
   {
      return scatterPlot.getVersion();
   }
   
   //==============================================================
   // Class method to meet the interface requirements for getting
   // the description for the module.
   //==============================================================
   
   public String getDescription()
   {
      return scatterPlot.getDescription();
   }
   
   //==============================================================
   // Class method to obtain the plugin's category.
   // Interface requirement.
   //==============================================================

   public String getCategory()
   {
      return category;
   }
   
   //==============================================================
   // Class method to meet the interface requirements of returning
   // a ImageIcon that will be used as the plugin's tab Icon.
   //==============================================================

   public ImageIcon getTabIcon()
   {
      return scatterPlot.getTabIcon();
   }
   
   //==============================================================
   // Class method to meet the interface requirements of returning
   // a Menu Bar that will be used as the plugin's Menu Bar.
   //==============================================================

   public JMenuBar getMenuBar()
   {
      return scatterPlot.getMenuBar();
   }
   
   //==============================================================
   // Class method to meet the interface requirements of returning
   // a Tool Bar that will be used as the plugin's Tool Bar.
   //==============================================================

   public JToolBar getToolBar()
   {
      return scatterPlot.getToolBar();
   }

   //==============================================================
   // Class method to meet the interface requirements for returning
   // a JPanel for inclusion in the MyJSQLView application's main
   // tab.
   //==============================================================

   public JComponent getPanel()
   {
     return scatterPlot.getPanel();
   }
}