//=================================================================
//             Scatter Plot Plotter_ToolBar Class
//=================================================================
//
//    This class is used to construct the toolbar to be used in the
// Scatter Plot plugin.
//
//                  << Plotter_ToolBar.java >>
//
//=================================================================
// Copyright (c) 2017 Dana M. Proctor.
// Version 1.0 11/01/2017
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version
// 2 of the License, or (at your option) any later version. This
// program is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty
// of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
// the GNU General Public License for more details. You should
// have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// (http://opensource.org)
//
//=================================================================
// Revision History
// Changes to the code should be documented here and reflected
// in the present version number. Author information should
// also be included with the original copyright author.
//=================================================================
// Version 1.0 11/01/2017 Original Plotter_ToolBar Class.
//         
//-----------------------------------------------------------------
//                 danap@dandymadeproductions.com
//=================================================================

package com.dandymadeproductions.scatterplot;

import java.awt.Insets;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

import com.dandymadeproductions.lindyframe.gui.LindyFrame_MenuActionCommands;
import com.dandymadeproductions.lindyframe.gui.Main_Frame;
import com.dandymadeproductions.lindyframe.utilities.LindyFrame_ResourceBundle;

/**
 *    The Plotter_TooBar class is used to construct the toolbar to be
 * used in the Scatter Plot plugin.
 * 
 * @author Dana M. Proctor
 * @version 1.0 11/01/2017
 */

class Plotter_ToolBar extends JToolBar
{
   // Instance & Class Fields.
   private static final long serialVersionUID = -2604937668646350131L;
   
   private Main_Frame mainFrame;
   private MenuActionListener menuListener;

   //==============================================================
   // Plotter_ToolBar Constructor.
   //==============================================================

   protected Plotter_ToolBar(String title, Main_Frame parent, String imagesDirectory,
                            LindyFrame_ResourceBundle resourceBundle, MenuActionListener menuListener)
   {
      super(title);
      mainFrame = parent;
      this.menuListener = menuListener;

      // Constructor Instances
      String iconsDirectory, resource;
      ImageIcon openIcon, exitIcon;
      ImageIcon editPreferencesIcon;
      JButton buttonItem;

      // Setting up icons directory and other instances.

      buttonItem = null;
      iconsDirectory = imagesDirectory + "icons/";

      // Tool Bar Configuration.
      setBorder(BorderFactory.createLoweredBevelBorder());
      setFloatable(false);

      // ===============
      // File Menu

      // Open
      openIcon = resourceBundle.getResourceImage(iconsDirectory + "openIcon_20x20.png");

      resource = resourceBundle.getResourceString("Plotter_MenuBar.menu.Open", "Open");
      buttonItem = buttonItem(resource, openIcon, Plotter_MenuBar.ACTION_FILE_OPEN);
      add(buttonItem);
      
      // Exit
      exitIcon = resourceBundle.getResourceImage(iconsDirectory + "exitIcon_20x20.png");

      buttonItem = new JButton(exitIcon);
      buttonItem.setFocusable(false);
      buttonItem.setMargin(new Insets(0, 0, 0, 0));
      buttonItem.setActionCommand(LindyFrame_MenuActionCommands.ACTION_EXIT);
      buttonItem.addActionListener(mainFrame);

      resource = resourceBundle.getResourceString("Plotter_MenuBar.menu.Exit", "Exit");
      buttonItem.setToolTipText(resource);
      add(buttonItem);
      
      addSeparator();
      
      // ===============
      // Edit Search

      // Preferences
      editPreferencesIcon = resourceBundle.getResourceImage(iconsDirectory + "preferencesIcon_20x20.png");

      resource = resourceBundle.getResourceString("Plotter_MenuBar.menu.Preferences",
                                                  "Preferences");
      buttonItem = buttonItem(resource, editPreferencesIcon, Plotter_MenuBar.ACTION_EDIT_PREFERENCES);
      add(buttonItem);
   }
   
   //==============================================================
   // Instance method used for the helping in the creation of tool
   // bar button items.
   //==============================================================

   private JButton buttonItem(String toolTip, ImageIcon icon, String actionLabel)
   {
      JButton item = new JButton(icon);
      item.setFocusable(false);
      item.setMargin(new Insets(0, 0, 0, 0));
      item.setToolTipText(toolTip);
      item.setActionCommand(actionLabel);
      item.addActionListener(menuListener);

      return item;
   }
}