//=================================================================
//               ScatterPlot Plotter_MenuBar
//=================================================================
//
//    This class is used to constructed the menubar for the Scatter
// Plot plugin module.
//
//                 << Plotter_MenuBar.java >>
//
//=================================================================
// Copyright (c) 2017 Dana M. Proctor.
// Version 1.0 11/01/2017
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version
// 2 of the License, or (at your option) any later version. This
// program is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty
// of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
// the GNU General Public License for more details. You should
// have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// (http://opensource.org)
//
//=================================================================
// Revision History
// Changes to the code should be documented here and reflected
// in the present version number. Author information should
// also be included with the original copyright author.
//=================================================================
// Version 1.0 11/01/2017 Original Plotter_MenuBar Class.
//         
//-----------------------------------------------------------------
//                 danap@dandymadeproductions.com
//=================================================================

package com.dandymadeproductions.scatterplot;

import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

import com.dandymadeproductions.lindyframe.LindyFrame;
import com.dandymadeproductions.lindyframe.gui.LindyFrame_MenuActionCommands;
import com.dandymadeproductions.lindyframe.gui.Main_Frame;
import com.dandymadeproductions.lindyframe.utilities.LindyFrame_ResourceBundle;
import com.dandymadeproductions.lindyframe.utilities.LindyFrame_Utils;

/**
 *    The Plotter_MenuBar class is used to constructed the menubar for
 * the Scatter Plot plugin module.
 * 
 * @author Dana M. Proctor
 * @version 1.0 11/01/2017
 */

class Plotter_MenuBar extends JMenuBar
{
   // Instance & Class Fields.
   private static final long serialVersionUID = 849042602191435761L;
   
   private Main_Frame mainFrame;
   private LindyFrame_ResourceBundle resourceBundle;
   private MenuActionListener menuListener;

   public static final String ACTION_FILE_OPEN = "File Open";
   public static final String ACTION_SAVE_AS_IMAGE = "Save As Image";
   public static final String ACTION_EDIT_PREFERENCES = "Edit Preferences";
   public static final String ACTION_DATA_IMPORT_CSV = "Data Import CSV";

   //==============================================================
   // Plotter_MenuBar JMenuBar Constructor.
   //==============================================================

   protected Plotter_MenuBar(Main_Frame parent, LindyFrame_ResourceBundle resourceBundle,
                             MenuActionListener menuListener)
   {
      mainFrame = parent;
      this.resourceBundle = resourceBundle;
      this.menuListener = menuListener;

      // Constructor Instances.
      String iconsDirectory;

      // JMenu Bar for the plugin.
      setBorder(BorderFactory.createEtchedBorder());

      // Creating the File, & Tools Menus
      createFileMenu();
      createEditMenu();

      add(Box.createHorizontalGlue());

      // Logo
      iconsDirectory = LindyFrame_Utils.getIconsDirectory() + LindyFrame_Utils.getFileSeparator();
      ImageIcon logoIcon = LindyFrame.getResourceBundle().getResourceImage(iconsDirectory
                                                                           + "lindyFrameIcon.gif");
      JButton logoIconItem = new JButton(logoIcon);
      logoIconItem.setDisabledIcon(logoIcon);
      logoIconItem.setFocusPainted(false);
      logoIconItem.setBorder(BorderFactory.createLoweredBevelBorder());
      add(logoIconItem);
   }

   //==============================================================
   // Helper Method to create the File Menu.
   //==============================================================

   private void createFileMenu()
   {
      // Method Instances.
      String resource;
      JMenu fileMenu;
      JMenuItem item;

      // ===========
      // File Menu

      resource = resourceBundle.getResourceString("Plotter_MenuBar.menu.File",
                                                  "File");
      fileMenu = new JMenu(resource);
      fileMenu.setFont(fileMenu.getFont().deriveFont(Font.BOLD));
      
      // Open
      resource = resourceBundle.getResourceString("Plotter_MenuBar.menu.Open",
                                                  "Open");
      fileMenu.add(menuItem(resource, ACTION_FILE_OPEN));
      fileMenu.addSeparator();

      // Exit
      resource = resourceBundle.getResourceString("Plotter_MenuBar.menu.Exit",
                                                  "Exit");
      item = new JMenuItem(resource);
      item.addActionListener(mainFrame);
      item.setActionCommand(LindyFrame_MenuActionCommands.ACTION_EXIT);
      fileMenu.add(item);

      add(fileMenu);
   }
   
   //==============================================================
   // Helper Method to create the Edit Menu.
   //==============================================================

   private void createEditMenu()
   {
      // Method Instances.
      String resource;
      JMenu editMenu;

      // ===========
      // Edit Menu

      resource = resourceBundle.getResourceString("Plotter_MenuBar.menu.Edit",
                                                  "Edit");
      editMenu = new JMenu(resource);
      editMenu.setFont(editMenu.getFont().deriveFont(Font.BOLD));

      // Search
      resource = resourceBundle.getResourceString("Plotter_MenuBar.menu.Preferences",
                                                  "Preferences");
      editMenu.add(menuItem(resource, ACTION_EDIT_PREFERENCES));
     
      add(editMenu);
   }
   
   //==============================================================
   // Instance method used for the creation of menu bar items.
   // Helper Method.
   //==============================================================

   private JMenuItem menuItem(String label, String actionLabel)
   {
      JMenuItem item = new JMenuItem(label);
      item.addActionListener(menuListener);
      item.setActionCommand(actionLabel);
      return item;
   }
}