/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.jfree.util.Log;

public class PaintUtilities {
    private PaintUtilities() {
    }

    public static boolean equal(Paint paint, Paint paint2) {
        if (paint == paint2) {
            return true;
        }
        if (paint == null) {
            return paint2 == null;
        }
        if (paint2 == null) {
            return false;
        }
        if (paint instanceof GradientPaint && paint2 instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            GradientPaint gradientPaint2 = (GradientPaint)paint2;
            return gradientPaint.getColor1().equals(gradientPaint2.getColor1()) && gradientPaint.getColor2().equals(gradientPaint2.getColor2()) && gradientPaint.getPoint1().equals(gradientPaint2.getPoint1()) && gradientPaint.getPoint2().equals(gradientPaint2.getPoint2()) && gradientPaint.isCyclic() == gradientPaint2.isCyclic() && gradientPaint.getTransparency() == gradientPaint.getTransparency();
        }
        if (paint instanceof LinearGradientPaint && paint2 instanceof LinearGradientPaint) {
            LinearGradientPaint linearGradientPaint = (LinearGradientPaint)paint;
            LinearGradientPaint linearGradientPaint2 = (LinearGradientPaint)paint2;
            return linearGradientPaint.getStartPoint().equals(linearGradientPaint2.getStartPoint()) && linearGradientPaint.getEndPoint().equals(linearGradientPaint2.getEndPoint()) && Arrays.equals(linearGradientPaint.getFractions(), linearGradientPaint2.getFractions()) && Arrays.equals(linearGradientPaint.getColors(), linearGradientPaint2.getColors()) && linearGradientPaint.getCycleMethod() == linearGradientPaint2.getCycleMethod() && linearGradientPaint.getColorSpace() == linearGradientPaint2.getColorSpace() && linearGradientPaint.getTransform().equals(linearGradientPaint2.getTransform());
        }
        if (paint instanceof RadialGradientPaint && paint2 instanceof RadialGradientPaint) {
            RadialGradientPaint radialGradientPaint = (RadialGradientPaint)paint;
            RadialGradientPaint radialGradientPaint2 = (RadialGradientPaint)paint2;
            return radialGradientPaint.getCenterPoint().equals(radialGradientPaint2.getCenterPoint()) && radialGradientPaint.getRadius() == radialGradientPaint2.getRadius() && radialGradientPaint.getFocusPoint().equals(radialGradientPaint2.getFocusPoint()) && Arrays.equals(radialGradientPaint.getFractions(), radialGradientPaint2.getFractions()) && Arrays.equals(radialGradientPaint.getColors(), radialGradientPaint2.getColors()) && radialGradientPaint.getCycleMethod() == radialGradientPaint2.getCycleMethod() && radialGradientPaint.getColorSpace() == radialGradientPaint2.getColorSpace() && radialGradientPaint.getTransform().equals(radialGradientPaint2.getTransform());
        }
        return paint.equals(paint2);
    }

    public static String colorToString(Color color) {
        Object object;
        try {
            object = Color.class.getFields();
            for (int i = 0; i < ((Field[])object).length; ++i) {
                Field field = object[i];
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
                String string = field.getName();
                Object object2 = field.get(null);
                if (!(object2 instanceof Color) || !color.equals(object2)) continue;
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        StringBuffer stringBuffer = new StringBuffer(7);
        stringBuffer.append("#");
        int n = 6 - ((String)object).length();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append((String)object);
        return stringBuffer.toString();
    }

    public static Color stringToColor(String string) {
        if (string == null) {
            return Color.black;
        }
        try {
            return Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Field field = Color.class.getField(string);
                return (Color)field.get(null);
            }
            catch (Exception exception) {
                Log.info("No such Color : " + string);
                return Color.black;
            }
        }
    }
}

