/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.DomainInfo;
import org.jfree.data.DomainOrder;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.general.Series;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.IntervalXYDelegate;
import org.jfree.data.xy.XYSeries;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class XYSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
DomainInfo,
RangeInfo,
VetoableChangeListener,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -7590013825931496766L;
    private List data = new ArrayList();
    private IntervalXYDelegate intervalDelegate = new IntervalXYDelegate(this, false);

    public XYSeriesCollection() {
        this(null);
    }

    public XYSeriesCollection(XYSeries xYSeries) {
        this.addChangeListener(this.intervalDelegate);
        if (xYSeries != null) {
            this.data.add(xYSeries);
            xYSeries.addChangeListener(this);
            xYSeries.addVetoableChangeListener(this);
        }
    }

    @Override
    public DomainOrder getDomainOrder() {
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            XYSeries xYSeries = this.getSeries(i);
            if (xYSeries.getAutoSort()) continue;
            return DomainOrder.NONE;
        }
        return DomainOrder.ASCENDING;
    }

    public void addSeries(XYSeries xYSeries) {
        ParamChecks.nullNotPermitted(xYSeries, "series");
        if (this.getSeriesIndex(xYSeries.getKey()) >= 0) {
            throw new IllegalArgumentException("This dataset already contains a series with the key " + xYSeries.getKey());
        }
        this.data.add(xYSeries);
        xYSeries.addChangeListener(this);
        xYSeries.addVetoableChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds.");
        }
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        if (xYSeries != null) {
            this.removeSeries(xYSeries);
        }
    }

    public void removeSeries(XYSeries xYSeries) {
        ParamChecks.nullNotPermitted(xYSeries, "series");
        if (this.data.contains(xYSeries)) {
            xYSeries.removeChangeListener(this);
            xYSeries.removeVetoableChangeListener(this);
            this.data.remove(xYSeries);
            this.fireDatasetChanged();
        }
    }

    public void removeAllSeries() {
        for (int i = 0; i < this.data.size(); ++i) {
            XYSeries xYSeries = (XYSeries)this.data.get(i);
            xYSeries.removeChangeListener(this);
            xYSeries.removeVetoableChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public List getSeries() {
        return Collections.unmodifiableList(this.data);
    }

    public int indexOf(XYSeries xYSeries) {
        ParamChecks.nullNotPermitted(xYSeries, "series");
        return this.data.indexOf(xYSeries);
    }

    public XYSeries getSeries(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (XYSeries)this.data.get(n);
    }

    public XYSeries getSeries(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        for (XYSeries xYSeries : this.data) {
            if (!comparable.equals(xYSeries.getKey())) continue;
            return xYSeries;
        }
        throw new UnknownKeyException("Key not found: " + comparable);
    }

    @Override
    public Comparable getSeriesKey(int n) {
        return this.getSeries(n).getKey();
    }

    public int getSeriesIndex(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            XYSeries xYSeries = (XYSeries)this.data.get(i);
            if (!comparable.equals(xYSeries.getKey())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    @Override
    public Number getX(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        return xYSeries.getX(n2);
    }

    @Override
    public Number getStartX(int n, int n2) {
        return this.intervalDelegate.getStartX(n, n2);
    }

    @Override
    public Number getEndX(int n, int n2) {
        return this.intervalDelegate.getEndX(n, n2);
    }

    @Override
    public Number getY(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        return xYSeries.getY(n2);
    }

    @Override
    public Number getStartY(int n, int n2) {
        return this.getY(n, n2);
    }

    @Override
    public Number getEndY(int n, int n2) {
        return this.getY(n, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYSeriesCollection)) {
            return false;
        }
        XYSeriesCollection xYSeriesCollection = (XYSeriesCollection)object;
        if (!this.intervalDelegate.equals(xYSeriesCollection.intervalDelegate)) {
            return false;
        }
        return ObjectUtilities.equal(this.data, xYSeriesCollection.data);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        XYSeriesCollection xYSeriesCollection = (XYSeriesCollection)super.clone();
        xYSeriesCollection.data = (List)ObjectUtilities.deepClone(this.data);
        xYSeriesCollection.intervalDelegate = (IntervalXYDelegate)this.intervalDelegate.clone();
        return xYSeriesCollection;
    }

    public int hashCode() {
        int n = 5;
        n = HashUtilities.hashCode(n, this.intervalDelegate);
        n = HashUtilities.hashCode(n, this.data);
        return n;
    }

    @Override
    public double getDomainLowerBound(boolean bl) {
        if (bl) {
            return this.intervalDelegate.getDomainLowerBound(bl);
        }
        double d = Double.NaN;
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            XYSeries xYSeries = this.getSeries(i);
            double d2 = xYSeries.getMinX();
            if (Double.isNaN(d)) {
                d = d2;
                continue;
            }
            if (Double.isNaN(d2)) continue;
            d = Math.min(d, d2);
        }
        return d;
    }

    @Override
    public double getDomainUpperBound(boolean bl) {
        if (bl) {
            return this.intervalDelegate.getDomainUpperBound(bl);
        }
        double d = Double.NaN;
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            XYSeries xYSeries = this.getSeries(i);
            double d2 = xYSeries.getMaxX();
            if (Double.isNaN(d)) {
                d = d2;
                continue;
            }
            if (Double.isNaN(d2)) continue;
            d = Math.max(d, d2);
        }
        return d;
    }

    @Override
    public Range getDomainBounds(boolean bl) {
        if (bl) {
            return this.intervalDelegate.getDomainBounds(bl);
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            double d3;
            XYSeries xYSeries = this.getSeries(i);
            double d4 = xYSeries.getMinX();
            if (!Double.isNaN(d4)) {
                d = Math.min(d, d4);
            }
            if (Double.isNaN(d3 = xYSeries.getMaxX())) continue;
            d2 = Math.max(d2, d3);
        }
        if (d > d2) {
            return null;
        }
        return new Range(d, d2);
    }

    public double getIntervalWidth() {
        return this.intervalDelegate.getIntervalWidth();
    }

    public void setIntervalWidth(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative 'width' argument.");
        }
        this.intervalDelegate.setFixedIntervalWidth(d);
        this.fireDatasetChanged();
    }

    public double getIntervalPositionFactor() {
        return this.intervalDelegate.getIntervalPositionFactor();
    }

    public void setIntervalPositionFactor(double d) {
        this.intervalDelegate.setIntervalPositionFactor(d);
        this.fireDatasetChanged();
    }

    public boolean isAutoWidth() {
        return this.intervalDelegate.isAutoWidth();
    }

    public void setAutoWidth(boolean bl) {
        this.intervalDelegate.setAutoWidth(bl);
        this.fireDatasetChanged();
    }

    @Override
    public Range getRangeBounds(boolean bl) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            double d3;
            XYSeries xYSeries = this.getSeries(i);
            double d4 = xYSeries.getMinY();
            if (!Double.isNaN(d4)) {
                d = Math.min(d, d4);
            }
            if (Double.isNaN(d3 = xYSeries.getMaxY())) continue;
            d2 = Math.max(d2, d3);
        }
        if (d > d2) {
            return null;
        }
        return new Range(d, d2);
    }

    @Override
    public double getRangeLowerBound(boolean bl) {
        double d = Double.NaN;
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            XYSeries xYSeries = this.getSeries(i);
            double d2 = xYSeries.getMinY();
            if (Double.isNaN(d)) {
                d = d2;
                continue;
            }
            if (Double.isNaN(d2)) continue;
            d = Math.min(d, d2);
        }
        return d;
    }

    @Override
    public double getRangeUpperBound(boolean bl) {
        double d = Double.NaN;
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            XYSeries xYSeries = this.getSeries(i);
            double d2 = xYSeries.getMaxY();
            if (Double.isNaN(d)) {
                d = d2;
                continue;
            }
            if (Double.isNaN(d2)) continue;
            d = Math.max(d, d2);
        }
        return d;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (!"Key".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        Series series = (Series)propertyChangeEvent.getSource();
        if (this.getSeriesIndex(series.getKey()) == -1) {
            throw new IllegalStateException("Receiving events from a series that does not belong to this collection.");
        }
        Comparable comparable = (Comparable)propertyChangeEvent.getNewValue();
        if (this.getSeriesIndex(comparable) >= 0) {
            throw new PropertyVetoException("Duplicate key2", propertyChangeEvent);
        }
    }
}

