/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import org.jfree.chart.util.ParamChecks;
import org.jfree.util.ObjectUtilities;

public class XYDataItem
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 2751513470325494890L;
    private Number x;
    private Number y;

    public XYDataItem(Number number, Number number2) {
        ParamChecks.nullNotPermitted(number, "x");
        this.x = number;
        this.y = number2;
    }

    public XYDataItem(double d, double d2) {
        this(new Double(d), new Double(d2));
    }

    public Number getX() {
        return this.x;
    }

    public double getXValue() {
        return this.x.doubleValue();
    }

    public Number getY() {
        return this.y;
    }

    public double getYValue() {
        double d = Double.NaN;
        if (this.y != null) {
            d = this.y.doubleValue();
        }
        return d;
    }

    public void setY(double d) {
        this.setY(new Double(d));
    }

    public void setY(Number number) {
        this.y = number;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof XYDataItem) {
            XYDataItem xYDataItem = (XYDataItem)object;
            double d = this.x.doubleValue() - xYDataItem.getX().doubleValue();
            n = d > 0.0 ? 1 : (d < 0.0 ? -1 : 0);
        } else {
            n = 1;
        }
        return n;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return object;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYDataItem)) {
            return false;
        }
        XYDataItem xYDataItem = (XYDataItem)object;
        if (!this.x.equals(xYDataItem.x)) {
            return false;
        }
        return ObjectUtilities.equal(this.y, xYDataItem.y);
    }

    public int hashCode() {
        int n = this.x.hashCode();
        n = 29 * n + (this.y != null ? this.y.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "[" + this.getXValue() + ", " + this.getYValue() + "]";
    }
}

