/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class IntervalXYDelegate
implements DatasetChangeListener,
DomainInfo,
Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = -685166711639592857L;
    private XYDataset dataset;
    private boolean autoWidth;
    private double intervalPositionFactor;
    private double fixedIntervalWidth;
    private double autoIntervalWidth;

    public IntervalXYDelegate(XYDataset xYDataset) {
        this(xYDataset, true);
    }

    public IntervalXYDelegate(XYDataset xYDataset, boolean bl) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        this.dataset = xYDataset;
        this.autoWidth = bl;
        this.intervalPositionFactor = 0.5;
        this.autoIntervalWidth = Double.POSITIVE_INFINITY;
        this.fixedIntervalWidth = 1.0;
    }

    public boolean isAutoWidth() {
        return this.autoWidth;
    }

    public void setAutoWidth(boolean bl) {
        this.autoWidth = bl;
        if (bl) {
            this.autoIntervalWidth = this.recalculateInterval();
        }
    }

    public double getIntervalPositionFactor() {
        return this.intervalPositionFactor;
    }

    public void setIntervalPositionFactor(double d) {
        if (d < 0.0 || 1.0 < d) {
            throw new IllegalArgumentException("Argument 'd' outside valid range.");
        }
        this.intervalPositionFactor = d;
    }

    public double getFixedIntervalWidth() {
        return this.fixedIntervalWidth;
    }

    public void setFixedIntervalWidth(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative 'w' argument.");
        }
        this.fixedIntervalWidth = d;
        this.autoWidth = false;
    }

    public double getIntervalWidth() {
        if (this.isAutoWidth() && !Double.isInfinite(this.autoIntervalWidth)) {
            return this.autoIntervalWidth;
        }
        return this.fixedIntervalWidth;
    }

    public Number getStartX(int n, int n2) {
        Double d = null;
        Number number = this.dataset.getX(n, n2);
        if (number != null) {
            d = new Double(number.doubleValue() - this.getIntervalPositionFactor() * this.getIntervalWidth());
        }
        return d;
    }

    public double getStartXValue(int n, int n2) {
        return this.dataset.getXValue(n, n2) - this.getIntervalPositionFactor() * this.getIntervalWidth();
    }

    public Number getEndX(int n, int n2) {
        Double d = null;
        Number number = this.dataset.getX(n, n2);
        if (number != null) {
            d = new Double(number.doubleValue() + (1.0 - this.getIntervalPositionFactor()) * this.getIntervalWidth());
        }
        return d;
    }

    public double getEndXValue(int n, int n2) {
        return this.dataset.getXValue(n, n2) + (1.0 - this.getIntervalPositionFactor()) * this.getIntervalWidth();
    }

    @Override
    public double getDomainLowerBound(boolean bl) {
        double d = Double.NaN;
        Range range = this.getDomainBounds(bl);
        if (range != null) {
            d = range.getLowerBound();
        }
        return d;
    }

    @Override
    public double getDomainUpperBound(boolean bl) {
        double d = Double.NaN;
        Range range = this.getDomainBounds(bl);
        if (range != null) {
            d = range.getUpperBound();
        }
        return d;
    }

    @Override
    public Range getDomainBounds(boolean bl) {
        Range range = DatasetUtilities.findDomainBounds(this.dataset, false);
        if (bl && range != null) {
            double d = this.getIntervalWidth() * this.getIntervalPositionFactor();
            double d2 = this.getIntervalWidth() - d;
            range = new Range(range.getLowerBound() - d, range.getUpperBound() + d2);
        }
        return range;
    }

    @Override
    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        if (this.autoWidth) {
            this.autoIntervalWidth = this.recalculateInterval();
        }
    }

    private double recalculateInterval() {
        double d = Double.POSITIVE_INFINITY;
        int n = this.dataset.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            d = Math.min(d, this.calculateIntervalForSeries(i));
        }
        return d;
    }

    private double calculateIntervalForSeries(int n) {
        double d = Double.POSITIVE_INFINITY;
        int n2 = this.dataset.getItemCount(n);
        if (n2 > 1) {
            double d2 = this.dataset.getXValue(n, 0);
            for (int i = 1; i < n2; ++i) {
                double d3 = this.dataset.getXValue(n, i);
                d = Math.min(d, d3 - d2);
                d2 = d3;
            }
        }
        return d;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntervalXYDelegate)) {
            return false;
        }
        IntervalXYDelegate intervalXYDelegate = (IntervalXYDelegate)object;
        if (this.autoWidth != intervalXYDelegate.autoWidth) {
            return false;
        }
        if (this.intervalPositionFactor != intervalXYDelegate.intervalPositionFactor) {
            return false;
        }
        return this.fixedIntervalWidth == intervalXYDelegate.fixedIntervalWidth;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int hashCode() {
        int n = 5;
        n = HashUtilities.hashCode(n, this.autoWidth);
        n = HashUtilities.hashCode(n, this.intervalPositionFactor);
        n = HashUtilities.hashCode(n, this.fixedIntervalWidth);
        return n;
    }
}

