/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.RegularTimePeriod;

public class Minute
extends RegularTimePeriod
implements Serializable {
    private static final long serialVersionUID = 2144572840034842871L;
    public static final int FIRST_MINUTE_IN_HOUR = 0;
    public static final int LAST_MINUTE_IN_HOUR = 59;
    private Day day;
    private byte hour;
    private byte minute;
    private long firstMillisecond;
    private long lastMillisecond;

    public Minute() {
        this(new Date());
    }

    public Minute(int n, Hour hour) {
        ParamChecks.nullNotPermitted(hour, "hour");
        this.minute = (byte)n;
        this.hour = (byte)hour.getHour();
        this.day = hour.getDay();
        this.peg(Calendar.getInstance());
    }

    public Minute(Date date) {
        this(date, TimeZone.getDefault(), Locale.getDefault());
    }

    public Minute(Date date, TimeZone timeZone) {
        this(date, timeZone, Locale.getDefault());
    }

    public Minute(Date date, TimeZone timeZone, Locale locale) {
        ParamChecks.nullNotPermitted(date, "time");
        ParamChecks.nullNotPermitted(timeZone, "zone");
        ParamChecks.nullNotPermitted(locale, "locale");
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        calendar.setTime(date);
        int n = calendar.get(12);
        this.minute = (byte)n;
        this.hour = (byte)calendar.get(11);
        this.day = new Day(date, timeZone, locale);
        this.peg(calendar);
    }

    public Minute(int n, int n2, int n3, int n4, int n5) {
        this(n, new Hour(n2, new Day(n3, n4, n5)));
    }

    public Day getDay() {
        return this.day;
    }

    public Hour getHour() {
        return new Hour(this.hour, this.day);
    }

    public int getHourValue() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    @Override
    public long getFirstMillisecond() {
        return this.firstMillisecond;
    }

    @Override
    public long getLastMillisecond() {
        return this.lastMillisecond;
    }

    @Override
    public void peg(Calendar calendar) {
        this.firstMillisecond = this.getFirstMillisecond(calendar);
        this.lastMillisecond = this.getLastMillisecond(calendar);
    }

    @Override
    public RegularTimePeriod previous() {
        Hour hour;
        Minute minute = this.minute != 0 ? new Minute(this.minute - 1, this.getHour()) : ((hour = (Hour)this.getHour().previous()) != null ? new Minute(59, hour) : null);
        return minute;
    }

    @Override
    public RegularTimePeriod next() {
        Hour hour;
        Minute minute = this.minute != 59 ? new Minute(this.minute + 1, this.getHour()) : ((hour = (Hour)this.getHour().next()) != null ? new Minute(0, hour) : null);
        return minute;
    }

    @Override
    public long getSerialIndex() {
        long l = this.day.getSerialIndex() * 24L + (long)this.hour;
        return l * 60L + (long)this.minute;
    }

    @Override
    public long getFirstMillisecond(Calendar calendar) {
        int n = this.day.getYear();
        int n2 = this.day.getMonth() - 1;
        int n3 = this.day.getDayOfMonth();
        calendar.clear();
        calendar.set(n, n2, n3, this.hour, this.minute, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    @Override
    public long getLastMillisecond(Calendar calendar) {
        int n = this.day.getYear();
        int n2 = this.day.getMonth() - 1;
        int n3 = this.day.getDayOfMonth();
        calendar.clear();
        calendar.set(n, n2, n3, this.hour, this.minute, 59);
        calendar.set(14, 999);
        return calendar.getTimeInMillis();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Minute)) {
            return false;
        }
        Minute minute = (Minute)object;
        if (this.minute != minute.minute) {
            return false;
        }
        return this.hour == minute.hour;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.minute;
        n = 37 * n + this.hour;
        n = 37 * n + this.day.hashCode();
        return n;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Minute) {
            Minute minute = (Minute)object;
            n = this.getHour().compareTo(minute.getHour());
            if (n == 0) {
                n = this.minute - minute.getMinute();
            }
        } else {
            n = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n;
    }

    public static Minute parseMinute(String string) {
        Minute minute = null;
        String string2 = (string = string.trim()).substring(0, Math.min(10, string.length()));
        Day day = Day.parseDay(string2);
        if (day != null) {
            String string3;
            int n;
            String string4 = string.substring(Math.min(string2.length() + 1, string.length()), string.length());
            String string5 = (string4 = string4.trim()).substring(0, Math.min(2, string4.length()));
            int n2 = Integer.parseInt(string5);
            if (n2 >= 0 && n2 <= 23 && (n = Integer.parseInt(string3 = string4.substring(Math.min(string5.length() + 1, string4.length()), string4.length()))) >= 0 && n <= 59) {
                minute = new Minute(n, new Hour(n2, day));
            }
        }
        return minute;
    }
}

