/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.date.SerialDate;

public class Day
extends RegularTimePeriod
implements Serializable {
    private static final long serialVersionUID = -7082667380758962755L;
    protected static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    protected static final DateFormat DATE_FORMAT_SHORT = DateFormat.getDateInstance(3);
    protected static final DateFormat DATE_FORMAT_MEDIUM = DateFormat.getDateInstance(2);
    protected static final DateFormat DATE_FORMAT_LONG = DateFormat.getDateInstance(1);
    private SerialDate serialDate;
    private long firstMillisecond;
    private long lastMillisecond;

    public Day() {
        this(new Date());
    }

    public Day(int n, int n2, int n3) {
        this.serialDate = SerialDate.createInstance(n, n2, n3);
        this.peg(Calendar.getInstance());
    }

    public Day(SerialDate serialDate) {
        ParamChecks.nullNotPermitted(serialDate, "serialDate");
        this.serialDate = serialDate;
        this.peg(Calendar.getInstance());
    }

    public Day(Date date) {
        this(date, TimeZone.getDefault(), Locale.getDefault());
    }

    public Day(Date date, TimeZone timeZone) {
        this(date, timeZone, Locale.getDefault());
    }

    public Day(Date date, TimeZone timeZone, Locale locale) {
        ParamChecks.nullNotPermitted(date, "time");
        ParamChecks.nullNotPermitted(timeZone, "zone");
        ParamChecks.nullNotPermitted(locale, "locale");
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        calendar.setTime(date);
        int n = calendar.get(5);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(1);
        this.serialDate = SerialDate.createInstance(n, n2, n3);
        this.peg(calendar);
    }

    public SerialDate getSerialDate() {
        return this.serialDate;
    }

    public int getYear() {
        return this.serialDate.getYYYY();
    }

    public int getMonth() {
        return this.serialDate.getMonth();
    }

    public int getDayOfMonth() {
        return this.serialDate.getDayOfMonth();
    }

    @Override
    public long getFirstMillisecond() {
        return this.firstMillisecond;
    }

    @Override
    public long getLastMillisecond() {
        return this.lastMillisecond;
    }

    @Override
    public void peg(Calendar calendar) {
        this.firstMillisecond = this.getFirstMillisecond(calendar);
        this.lastMillisecond = this.getLastMillisecond(calendar);
    }

    @Override
    public RegularTimePeriod previous() {
        int n = this.serialDate.toSerial();
        if (n > 2) {
            SerialDate serialDate = SerialDate.createInstance(n - 1);
            return new Day(serialDate);
        }
        RegularTimePeriod regularTimePeriod = null;
        return regularTimePeriod;
    }

    @Override
    public RegularTimePeriod next() {
        int n = this.serialDate.toSerial();
        if (n < 2958465) {
            SerialDate serialDate = SerialDate.createInstance(n + 1);
            return new Day(serialDate);
        }
        RegularTimePeriod regularTimePeriod = null;
        return regularTimePeriod;
    }

    @Override
    public long getSerialIndex() {
        return this.serialDate.toSerial();
    }

    @Override
    public long getFirstMillisecond(Calendar calendar) {
        int n = this.serialDate.getYYYY();
        int n2 = this.serialDate.getMonth();
        int n3 = this.serialDate.getDayOfMonth();
        calendar.clear();
        calendar.set(n, n2 - 1, n3, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    @Override
    public long getLastMillisecond(Calendar calendar) {
        int n = this.serialDate.getYYYY();
        int n2 = this.serialDate.getMonth();
        int n3 = this.serialDate.getDayOfMonth();
        calendar.clear();
        calendar.set(n, n2 - 1, n3, 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTimeInMillis();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Day)) {
            return false;
        }
        Day day = (Day)object;
        return this.serialDate.equals(day.getSerialDate());
    }

    public int hashCode() {
        return this.serialDate.hashCode();
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Day) {
            Day day = (Day)object;
            n = -day.getSerialDate().compare(this.serialDate);
        } else {
            n = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n;
    }

    @Override
    public String toString() {
        return this.serialDate.toString();
    }

    public static Day parseDay(String string) {
        try {
            return new Day(DATE_FORMAT.parse(string));
        }
        catch (ParseException parseException) {
            try {
                return new Day(DATE_FORMAT_SHORT.parse(string));
            }
            catch (ParseException parseException2) {
                return null;
            }
        }
    }
}

