/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.util.ObjectUtilities;

public abstract class Series
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6906561437538683581L;
    private Comparable key;
    private String description;
    private EventListenerList listeners;
    private PropertyChangeSupport propertyChangeSupport;
    private VetoableChangeSupport vetoableChangeSupport;
    private boolean notify;

    protected Series(Comparable comparable) {
        this(comparable, null);
    }

    protected Series(Comparable comparable, String string) {
        ParamChecks.nullNotPermitted(comparable, "key");
        this.key = comparable;
        this.description = string;
        this.listeners = new EventListenerList();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.vetoableChangeSupport = new VetoableChangeSupport(this);
        this.notify = true;
    }

    public Comparable getKey() {
        return this.key;
    }

    public void setKey(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        Comparable comparable2 = this.key;
        try {
            this.vetoableChangeSupport.fireVetoableChange("Key", comparable2, comparable);
            this.key = comparable;
            this.propertyChangeSupport.firePropertyChange("Key", comparable2, comparable);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new IllegalArgumentException(propertyVetoException.getMessage());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        this.propertyChangeSupport.firePropertyChange("Description", string2, string);
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean bl) {
        if (this.notify != bl) {
            this.notify = bl;
            this.fireSeriesChanged();
        }
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public abstract int getItemCount();

    public Object clone() throws CloneNotSupportedException {
        Series series = (Series)super.clone();
        series.listeners = new EventListenerList();
        series.propertyChangeSupport = new PropertyChangeSupport(series);
        series.vetoableChangeSupport = new VetoableChangeSupport(series);
        return series;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Series)) {
            return false;
        }
        Series series = (Series)object;
        if (!this.getKey().equals(series.getKey())) {
            return false;
        }
        return ObjectUtilities.equal(this.getDescription(), series.getDescription());
    }

    public int hashCode() {
        int n = this.key.hashCode();
        n = 29 * n + (this.description != null ? this.description.hashCode() : 0);
        return n;
    }

    public void addChangeListener(SeriesChangeListener seriesChangeListener) {
        this.listeners.add(SeriesChangeListener.class, seriesChangeListener);
    }

    public void removeChangeListener(SeriesChangeListener seriesChangeListener) {
        this.listeners.remove(SeriesChangeListener.class, seriesChangeListener);
    }

    public void fireSeriesChanged() {
        if (this.notify) {
            this.notifyListeners(new SeriesChangeEvent(this));
        }
    }

    protected void notifyListeners(SeriesChangeEvent seriesChangeEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SeriesChangeListener.class) continue;
            ((SeriesChangeListener)objectArray[i + 1]).seriesChanged(seriesChangeEvent);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        this.vetoableChangeSupport.fireVetoableChange(string, object, object2);
    }
}

