/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.DomainInfo;
import org.jfree.data.DomainOrder;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.function.Function2D;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYDomainInfo;
import org.jfree.data.xy.XYRangeInfo;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.XYZDataset;

public final class DatasetUtilities {
    private DatasetUtilities() {
    }

    public static XYDataset sampleFunction2D(Function2D function2D, double d, double d2, int n, Comparable comparable) {
        XYSeries xYSeries = DatasetUtilities.sampleFunction2DToSeries(function2D, d, d2, n, comparable);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        return xYSeriesCollection;
    }

    public static XYSeries sampleFunction2DToSeries(Function2D function2D, double d, double d2, int n, Comparable comparable) {
        ParamChecks.nullNotPermitted(function2D, "f");
        ParamChecks.nullNotPermitted(comparable, "seriesKey");
        if (d >= d2) {
            throw new IllegalArgumentException("Requires 'start' < 'end'.");
        }
        if (n < 2) {
            throw new IllegalArgumentException("Requires 'samples' > 1");
        }
        XYSeries xYSeries = new XYSeries(comparable);
        double d3 = (d2 - d) / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            double d4 = d + d3 * (double)i;
            xYSeries.add(d4, function2D.getValue(d4));
        }
        return xYSeries;
    }

    public static boolean isEmptyOrNull(XYDataset xYDataset) {
        if (xYDataset != null) {
            for (int i = 0; i < xYDataset.getSeriesCount(); ++i) {
                if (xYDataset.getItemCount(i) <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public static Range findDomainBounds(XYDataset xYDataset) {
        return DatasetUtilities.findDomainBounds(xYDataset, true);
    }

    public static Range findDomainBounds(XYDataset xYDataset, boolean bl) {
        Range range;
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)xYDataset);
            range = domainInfo.getDomainBounds(bl);
        } else {
            range = DatasetUtilities.iterateDomainBounds(xYDataset, bl);
        }
        return range;
    }

    public static Range findDomainBounds(XYDataset xYDataset, List list, boolean bl) {
        Range range;
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof XYDomainInfo) {
            XYDomainInfo xYDomainInfo = (XYDomainInfo)((Object)xYDataset);
            range = xYDomainInfo.getDomainBounds(list, bl);
        } else {
            range = DatasetUtilities.iterateToFindDomainBounds(xYDataset, list, bl);
        }
        return range;
    }

    public static Range iterateDomainBounds(XYDataset xYDataset) {
        return DatasetUtilities.iterateDomainBounds(xYDataset, true);
    }

    public static Range iterateDomainBounds(XYDataset xYDataset, boolean bl) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        if (bl && xYDataset instanceof IntervalXYDataset) {
            IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
            for (int i = 0; i < n; ++i) {
                int n2 = xYDataset.getItemCount(i);
                for (int j = 0; j < n2; ++j) {
                    double d3 = intervalXYDataset.getXValue(i, j);
                    double d4 = intervalXYDataset.getStartXValue(i, j);
                    double d5 = intervalXYDataset.getEndXValue(i, j);
                    if (!Double.isNaN(d3)) {
                        d = Math.min(d, d3);
                        d2 = Math.max(d2, d3);
                    }
                    if (!Double.isNaN(d4)) {
                        d = Math.min(d, d4);
                        d2 = Math.max(d2, d4);
                    }
                    if (Double.isNaN(d5)) continue;
                    d = Math.min(d, d5);
                    d2 = Math.max(d2, d5);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n3 = xYDataset.getItemCount(i);
                for (int j = 0; j < n3; ++j) {
                    double d6;
                    double d7 = d6 = xYDataset.getXValue(i, j);
                    if (Double.isNaN(d6)) continue;
                    d = Math.min(d, d6);
                    d2 = Math.max(d2, d7);
                }
            }
        }
        if (d > d2) {
            return null;
        }
        return new Range(d, d2);
    }

    public static Range findRangeBounds(XYDataset xYDataset) {
        return DatasetUtilities.findRangeBounds(xYDataset, true);
    }

    public static Range findRangeBounds(XYDataset xYDataset, boolean bl) {
        Range range;
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)xYDataset);
            range = rangeInfo.getRangeBounds(bl);
        } else {
            range = DatasetUtilities.iterateRangeBounds(xYDataset, bl);
        }
        return range;
    }

    public static Range findRangeBounds(XYDataset xYDataset, List list, Range range, boolean bl) {
        Range range2;
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof XYRangeInfo) {
            XYRangeInfo xYRangeInfo = (XYRangeInfo)((Object)xYDataset);
            range2 = xYRangeInfo.getRangeBounds(list, range, bl);
        } else {
            range2 = DatasetUtilities.iterateToFindRangeBounds(xYDataset, list, range, bl);
        }
        return range2;
    }

    public static Range iterateXYRangeBounds(XYDataset xYDataset) {
        return DatasetUtilities.iterateRangeBounds(xYDataset);
    }

    public static Range iterateRangeBounds(XYDataset xYDataset) {
        return DatasetUtilities.iterateRangeBounds(xYDataset, true);
    }

    public static Range iterateRangeBounds(XYDataset xYDataset, boolean bl) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        if (bl && xYDataset instanceof IntervalXYDataset) {
            IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
            for (int i = 0; i < n; ++i) {
                int n2 = xYDataset.getItemCount(i);
                for (int j = 0; j < n2; ++j) {
                    double d3 = intervalXYDataset.getYValue(i, j);
                    double d4 = intervalXYDataset.getStartYValue(i, j);
                    double d5 = intervalXYDataset.getEndYValue(i, j);
                    if (!Double.isNaN(d3)) {
                        d = Math.min(d, d3);
                        d2 = Math.max(d2, d3);
                    }
                    if (!Double.isNaN(d4)) {
                        d = Math.min(d, d4);
                        d2 = Math.max(d2, d4);
                    }
                    if (Double.isNaN(d5)) continue;
                    d = Math.min(d, d5);
                    d2 = Math.max(d2, d5);
                }
            }
        } else if (bl && xYDataset instanceof OHLCDataset) {
            OHLCDataset oHLCDataset = (OHLCDataset)xYDataset;
            for (int i = 0; i < n; ++i) {
                int n3 = xYDataset.getItemCount(i);
                for (int j = 0; j < n3; ++j) {
                    double d6 = oHLCDataset.getLowValue(i, j);
                    double d7 = oHLCDataset.getHighValue(i, j);
                    if (!Double.isNaN(d6)) {
                        d = Math.min(d, d6);
                    }
                    if (Double.isNaN(d7)) continue;
                    d2 = Math.max(d2, d7);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n4 = xYDataset.getItemCount(i);
                for (int j = 0; j < n4; ++j) {
                    double d8 = xYDataset.getYValue(i, j);
                    if (Double.isNaN(d8)) continue;
                    d = Math.min(d, d8);
                    d2 = Math.max(d2, d8);
                }
            }
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d, d2);
    }

    public static Range findZBounds(XYZDataset xYZDataset) {
        return DatasetUtilities.findZBounds(xYZDataset, true);
    }

    public static Range findZBounds(XYZDataset xYZDataset, boolean bl) {
        ParamChecks.nullNotPermitted(xYZDataset, "dataset");
        Range range = DatasetUtilities.iterateZBounds(xYZDataset, bl);
        return range;
    }

    public static Range findZBounds(XYZDataset xYZDataset, List list, Range range, boolean bl) {
        ParamChecks.nullNotPermitted(xYZDataset, "dataset");
        Range range2 = DatasetUtilities.iterateToFindZBounds(xYZDataset, list, range, bl);
        return range2;
    }

    public static Range iterateZBounds(XYZDataset xYZDataset) {
        return DatasetUtilities.iterateZBounds(xYZDataset, true);
    }

    public static Range iterateZBounds(XYZDataset xYZDataset, boolean bl) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = xYZDataset.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            int n2 = xYZDataset.getItemCount(i);
            for (int j = 0; j < n2; ++j) {
                double d3 = xYZDataset.getZValue(i, j);
                if (Double.isNaN(d3)) continue;
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d, d2);
    }

    public static Range iterateToFindDomainBounds(XYDataset xYDataset, List list, boolean bl) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        ParamChecks.nullNotPermitted(list, "visibleSeriesKeys");
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        if (bl && xYDataset instanceof IntervalXYDataset) {
            IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
            for (Comparable comparable : list) {
                int n = xYDataset.indexOf(comparable);
                int n2 = xYDataset.getItemCount(n);
                for (int i = 0; i < n2; ++i) {
                    double d3 = intervalXYDataset.getStartXValue(n, i);
                    double d4 = intervalXYDataset.getEndXValue(n, i);
                    if (!Double.isNaN(d3)) {
                        d = Math.min(d, d3);
                    }
                    if (Double.isNaN(d4)) continue;
                    d2 = Math.max(d2, d4);
                }
            }
        } else {
            for (Comparable comparable : list) {
                int n = xYDataset.indexOf(comparable);
                int n3 = xYDataset.getItemCount(n);
                for (int i = 0; i < n3; ++i) {
                    double d5 = xYDataset.getXValue(n, i);
                    if (Double.isNaN(d5)) continue;
                    d = Math.min(d, d5);
                    d2 = Math.max(d2, d5);
                }
            }
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d, d2);
    }

    public static Range iterateToFindRangeBounds(XYDataset xYDataset, List list, Range range, boolean bl) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        ParamChecks.nullNotPermitted(list, "visibleSeriesKeys");
        ParamChecks.nullNotPermitted(range, "xRange");
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        if (bl && xYDataset instanceof OHLCDataset) {
            OHLCDataset oHLCDataset = (OHLCDataset)xYDataset;
            for (Comparable comparable : list) {
                int n = xYDataset.indexOf(comparable);
                int n2 = xYDataset.getItemCount(n);
                for (int i = 0; i < n2; ++i) {
                    double d3 = oHLCDataset.getXValue(n, i);
                    if (!range.contains(d3)) continue;
                    double d4 = oHLCDataset.getLowValue(n, i);
                    double d5 = oHLCDataset.getHighValue(n, i);
                    if (!Double.isNaN(d4)) {
                        d = Math.min(d, d4);
                    }
                    if (Double.isNaN(d5)) continue;
                    d2 = Math.max(d2, d5);
                }
            }
        } else if (bl && xYDataset instanceof IntervalXYDataset) {
            IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
            for (Comparable comparable : list) {
                int n = xYDataset.indexOf(comparable);
                int n3 = xYDataset.getItemCount(n);
                for (int i = 0; i < n3; ++i) {
                    double d6 = intervalXYDataset.getXValue(n, i);
                    if (!range.contains(d6)) continue;
                    double d7 = intervalXYDataset.getStartYValue(n, i);
                    double d8 = intervalXYDataset.getEndYValue(n, i);
                    if (!Double.isNaN(d7)) {
                        d = Math.min(d, d7);
                    }
                    if (Double.isNaN(d8)) continue;
                    d2 = Math.max(d2, d8);
                }
            }
        } else {
            for (Comparable comparable : list) {
                int n = xYDataset.indexOf(comparable);
                int n4 = xYDataset.getItemCount(n);
                for (int i = 0; i < n4; ++i) {
                    double d9 = xYDataset.getXValue(n, i);
                    double d10 = xYDataset.getYValue(n, i);
                    if (!range.contains(d9) || Double.isNaN(d10)) continue;
                    d = Math.min(d, d10);
                    d2 = Math.max(d2, d10);
                }
            }
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d, d2);
    }

    public static Range iterateToFindZBounds(XYZDataset xYZDataset, List list, Range range, boolean bl) {
        ParamChecks.nullNotPermitted(xYZDataset, "dataset");
        ParamChecks.nullNotPermitted(list, "visibleSeriesKeys");
        ParamChecks.nullNotPermitted(range, "xRange");
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (Comparable comparable : list) {
            int n = xYZDataset.indexOf(comparable);
            int n2 = xYZDataset.getItemCount(n);
            for (int i = 0; i < n2; ++i) {
                double d3 = xYZDataset.getXValue(n, i);
                double d4 = xYZDataset.getZValue(n, i);
                if (!range.contains(d3) || Double.isNaN(d4)) continue;
                d = Math.min(d, d4);
                d2 = Math.max(d2, d4);
            }
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d, d2);
    }

    public static Number findMinimumDomainValue(XYDataset xYDataset) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)xYDataset);
            return new Double(domainInfo.getDomainLowerBound(true));
        }
        double d = Double.POSITIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            int n2 = xYDataset.getItemCount(i);
            for (int j = 0; j < n2; ++j) {
                double d2;
                if (xYDataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
                    d2 = intervalXYDataset.getStartXValue(i, j);
                } else {
                    d2 = xYDataset.getXValue(i, j);
                }
                if (Double.isNaN(d2)) continue;
                d = Math.min(d, d2);
            }
        }
        Double d3 = d == Double.POSITIVE_INFINITY ? null : new Double(d);
        return d3;
    }

    public static Number findMaximumDomainValue(XYDataset xYDataset) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)xYDataset);
            return new Double(domainInfo.getDomainUpperBound(true));
        }
        double d = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            int n2 = xYDataset.getItemCount(i);
            for (int j = 0; j < n2; ++j) {
                double d2;
                if (xYDataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
                    d2 = intervalXYDataset.getEndXValue(i, j);
                } else {
                    d2 = xYDataset.getXValue(i, j);
                }
                if (Double.isNaN(d2)) continue;
                d = Math.max(d, d2);
            }
        }
        Double d3 = d == Double.NEGATIVE_INFINITY ? null : new Double(d);
        return d3;
    }

    public static Number findMinimumRangeValue(XYDataset xYDataset) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)xYDataset);
            return new Double(rangeInfo.getRangeLowerBound(true));
        }
        double d = Double.POSITIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            int n2 = xYDataset.getItemCount(i);
            for (int j = 0; j < n2; ++j) {
                double d2;
                XYDataset xYDataset2;
                if (xYDataset instanceof IntervalXYDataset) {
                    xYDataset2 = (IntervalXYDataset)xYDataset;
                    d2 = xYDataset2.getStartYValue(i, j);
                } else if (xYDataset instanceof OHLCDataset) {
                    xYDataset2 = (OHLCDataset)xYDataset;
                    d2 = xYDataset2.getLowValue(i, j);
                } else {
                    d2 = xYDataset.getYValue(i, j);
                }
                if (Double.isNaN(d2)) continue;
                d = Math.min(d, d2);
            }
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Double(d);
    }

    public static Number findMaximumRangeValue(XYDataset xYDataset) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)xYDataset);
            return new Double(rangeInfo.getRangeUpperBound(true));
        }
        double d = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            int n2 = xYDataset.getItemCount(i);
            for (int j = 0; j < n2; ++j) {
                double d2;
                XYDataset xYDataset2;
                if (xYDataset instanceof IntervalXYDataset) {
                    xYDataset2 = (IntervalXYDataset)xYDataset;
                    d2 = xYDataset2.getEndYValue(i, j);
                } else if (xYDataset instanceof OHLCDataset) {
                    xYDataset2 = (OHLCDataset)xYDataset;
                    d2 = xYDataset2.getHighValue(i, j);
                } else {
                    d2 = xYDataset.getYValue(i, j);
                }
                if (Double.isNaN(d2)) continue;
                d = Math.max(d, d2);
            }
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return new Double(d);
    }

    public static Range findStackedRangeBounds(TableXYDataset tableXYDataset) {
        return DatasetUtilities.findStackedRangeBounds(tableXYDataset, 0.0);
    }

    public static Range findStackedRangeBounds(TableXYDataset tableXYDataset, double d) {
        ParamChecks.nullNotPermitted(tableXYDataset, "dataset");
        double d2 = d;
        double d3 = d;
        for (int i = 0; i < tableXYDataset.getItemCount(); ++i) {
            double d4 = d;
            double d5 = d;
            int n = tableXYDataset.getSeriesCount();
            for (int j = 0; j < n; ++j) {
                double d6 = tableXYDataset.getYValue(j, i);
                if (Double.isNaN(d6)) continue;
                if (d6 > 0.0) {
                    d4 += d6;
                    continue;
                }
                d5 += d6;
            }
            if (d4 > d3) {
                d3 = d4;
            }
            if (!(d5 < d2)) continue;
            d2 = d5;
        }
        if (d2 <= d3) {
            return new Range(d2, d3);
        }
        return null;
    }

    public static double calculateStackTotal(TableXYDataset tableXYDataset, int n) {
        double d = 0.0;
        int n2 = tableXYDataset.getSeriesCount();
        for (int i = 0; i < n2; ++i) {
            double d2 = tableXYDataset.getYValue(i, n);
            if (Double.isNaN(d2)) continue;
            d += d2;
        }
        return d;
    }

    public static double findYValue(XYDataset xYDataset, int n, double d) {
        int[] nArray = DatasetUtilities.findItemIndicesForX(xYDataset, n, d);
        if (nArray[0] == -1) {
            return Double.NaN;
        }
        if (nArray[0] == nArray[1]) {
            return xYDataset.getYValue(n, nArray[0]);
        }
        double d2 = xYDataset.getXValue(n, nArray[0]);
        double d3 = xYDataset.getXValue(n, nArray[1]);
        double d4 = xYDataset.getYValue(n, nArray[0]);
        double d5 = xYDataset.getYValue(n, nArray[1]);
        return d4 + (d5 - d4) * (d - d2) / (d3 - d2);
    }

    public static int[] findItemIndicesForX(XYDataset xYDataset, int n, double d) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        int n2 = xYDataset.getItemCount(n);
        if (n2 == 0) {
            return new int[]{-1, -1};
        }
        if (n2 == 1) {
            if (d == xYDataset.getXValue(n, 0)) {
                return new int[]{0, 0};
            }
            return new int[]{-1, -1};
        }
        if (xYDataset.getDomainOrder() == DomainOrder.ASCENDING) {
            int n3 = 0;
            int n4 = n2 - 1;
            double d2 = xYDataset.getXValue(n, n3);
            if (d2 > d) {
                return new int[]{-1, -1};
            }
            if (d2 == d) {
                return new int[]{n3, n3};
            }
            double d3 = xYDataset.getXValue(n, n4);
            if (d3 < d) {
                return new int[]{-1, -1};
            }
            if (d3 == d) {
                return new int[]{n4, n4};
            }
            int n5 = (n3 + n4) / 2;
            while (n4 - n3 > 1) {
                double d4 = xYDataset.getXValue(n, n5);
                if (d == d4) {
                    return new int[]{n5, n5};
                }
                if (d4 < d) {
                    n3 = n5;
                } else {
                    n4 = n5;
                }
                n5 = (n3 + n4) / 2;
            }
            return new int[]{n3, n4};
        }
        if (xYDataset.getDomainOrder() == DomainOrder.DESCENDING) {
            int n6 = 0;
            int n7 = n2 - 1;
            double d5 = xYDataset.getXValue(n, n7);
            if (d5 > d) {
                return new int[]{-1, -1};
            }
            double d6 = xYDataset.getXValue(n, n6);
            if (d6 < d) {
                return new int[]{-1, -1};
            }
            int n8 = (n7 + n6) / 2;
            while (n6 - n7 > 1) {
                double d7 = xYDataset.getXValue(n, n8);
                if (d == d7) {
                    return new int[]{n8, n8};
                }
                if (d7 < d) {
                    n7 = n8;
                } else {
                    n6 = n8;
                }
                n8 = (n7 + n6) / 2;
            }
            return new int[]{n7, n6};
        }
        double d8 = xYDataset.getXValue(n, 0);
        if (d == d8) {
            return new int[]{0, 0};
        }
        for (int i = 1; i < n2; ++i) {
            double d9 = xYDataset.getXValue(n, i);
            if (d == d9) {
                return new int[]{i, i};
            }
            if (!(d > d8 && d < d9) && (!(d < d8) || !(d > d9))) continue;
            return new int[]{i - 1, i};
        }
        return new int[]{-1, -1};
    }
}

