/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import org.jfree.chart.util.ParamChecks;

public strictfp class Range
implements Serializable {
    private static final long serialVersionUID = -906333695431863380L;
    private double lower;
    private double upper;

    public Range(double d, double d2) {
        if (d > d2) {
            String string = "Range(double, double): require lower (" + d + ") <= upper (" + d2 + ").";
            throw new IllegalArgumentException(string);
        }
        this.lower = d;
        this.upper = d2;
    }

    public double getLowerBound() {
        return this.lower;
    }

    public double getUpperBound() {
        return this.upper;
    }

    public double getLength() {
        return this.upper - this.lower;
    }

    public double getCentralValue() {
        return this.lower / 2.0 + this.upper / 2.0;
    }

    public boolean contains(double d) {
        return d >= this.lower && d <= this.upper;
    }

    public boolean intersects(double d, double d2) {
        if (d <= this.lower) {
            return d2 > this.lower;
        }
        return d < this.upper && d2 >= d;
    }

    public boolean intersects(Range range) {
        return this.intersects(range.getLowerBound(), range.getUpperBound());
    }

    public double constrain(double d) {
        double d2 = d;
        if (!this.contains(d)) {
            if (d > this.upper) {
                d2 = this.upper;
            } else if (d < this.lower) {
                d2 = this.lower;
            }
        }
        return d2;
    }

    public static Range combine(Range range, Range range2) {
        if (range == null) {
            return range2;
        }
        if (range2 == null) {
            return range;
        }
        double d = Math.min(range.getLowerBound(), range2.getLowerBound());
        double d2 = Math.max(range.getUpperBound(), range2.getUpperBound());
        return new Range(d, d2);
    }

    public static Range combineIgnoringNaN(Range range, Range range2) {
        if (range == null) {
            if (range2 != null && range2.isNaNRange()) {
                return null;
            }
            return range2;
        }
        if (range2 == null) {
            if (range.isNaNRange()) {
                return null;
            }
            return range;
        }
        double d = Range.min(range.getLowerBound(), range2.getLowerBound());
        double d2 = Range.max(range.getUpperBound(), range2.getUpperBound());
        if (Double.isNaN(d) && Double.isNaN(d2)) {
            return null;
        }
        return new Range(d, d2);
    }

    private static double min(double d, double d2) {
        if (Double.isNaN(d)) {
            return d2;
        }
        if (Double.isNaN(d2)) {
            return d;
        }
        return Math.min(d, d2);
    }

    private static double max(double d, double d2) {
        if (Double.isNaN(d)) {
            return d2;
        }
        if (Double.isNaN(d2)) {
            return d;
        }
        return Math.max(d, d2);
    }

    public static Range expandToInclude(Range range, double d) {
        if (range == null) {
            return new Range(d, d);
        }
        if (d < range.getLowerBound()) {
            return new Range(d, range.getUpperBound());
        }
        if (d > range.getUpperBound()) {
            return new Range(range.getLowerBound(), d);
        }
        return range;
    }

    public static Range expand(Range range, double d, double d2) {
        ParamChecks.nullNotPermitted(range, "range");
        double d3 = range.getLength();
        double d4 = range.getLowerBound() - d3 * d;
        double d5 = range.getUpperBound() + d3 * d2;
        if (d4 > d5) {
            d5 = d4 = d4 / 2.0 + d5 / 2.0;
        }
        return new Range(d4, d5);
    }

    public static Range shift(Range range, double d) {
        return Range.shift(range, d, false);
    }

    public static Range shift(Range range, double d, boolean bl) {
        ParamChecks.nullNotPermitted(range, "base");
        if (bl) {
            return new Range(range.getLowerBound() + d, range.getUpperBound() + d);
        }
        return new Range(Range.shiftWithNoZeroCrossing(range.getLowerBound(), d), Range.shiftWithNoZeroCrossing(range.getUpperBound(), d));
    }

    private static double shiftWithNoZeroCrossing(double d, double d2) {
        if (d > 0.0) {
            return Math.max(d + d2, 0.0);
        }
        if (d < 0.0) {
            return Math.min(d + d2, 0.0);
        }
        return d + d2;
    }

    public static Range scale(Range range, double d) {
        ParamChecks.nullNotPermitted(range, "base");
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative 'factor' argument.");
        }
        return new Range(range.getLowerBound() * d, range.getUpperBound() * d);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        if (this.lower != range.lower) {
            return false;
        }
        return this.upper == range.upper;
    }

    public boolean isNaNRange() {
        return Double.isNaN(this.lower) && Double.isNaN(this.upper);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.lower);
        int n = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.upper);
        n = 29 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public String toString() {
        return "Range[" + this.lower + "," + this.upper + "]";
    }
}

