/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues2D;
import org.jfree.data.UnknownKeyException;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class DefaultKeyedValues2D
implements KeyedValues2D,
PublicCloneable,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5514169970951994748L;
    private List rowKeys = new ArrayList();
    private List columnKeys = new ArrayList();
    private List rows = new ArrayList();
    private boolean sortRowKeys;

    public DefaultKeyedValues2D() {
        this(false);
    }

    public DefaultKeyedValues2D(boolean bl) {
        this.sortRowKeys = bl;
    }

    @Override
    public int getRowCount() {
        return this.rowKeys.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnKeys.size();
    }

    @Override
    public Number getValue(int n, int n2) {
        Comparable comparable;
        int n3;
        Number number = null;
        DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n);
        if (defaultKeyedValues != null && (n3 = defaultKeyedValues.getIndex(comparable = (Comparable)this.columnKeys.get(n2))) >= 0) {
            number = defaultKeyedValues.getValue(n3);
        }
        return number;
    }

    @Override
    public Comparable getRowKey(int n) {
        return (Comparable)this.rowKeys.get(n);
    }

    @Override
    public int getRowIndex(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        if (this.sortRowKeys) {
            return Collections.binarySearch(this.rowKeys, comparable);
        }
        return this.rowKeys.indexOf(comparable);
    }

    @Override
    public List getRowKeys() {
        return Collections.unmodifiableList(this.rowKeys);
    }

    @Override
    public Comparable getColumnKey(int n) {
        return (Comparable)this.columnKeys.get(n);
    }

    @Override
    public int getColumnIndex(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        return this.columnKeys.indexOf(comparable);
    }

    @Override
    public List getColumnKeys() {
        return Collections.unmodifiableList(this.columnKeys);
    }

    @Override
    public Number getValue(Comparable comparable, Comparable comparable2) {
        ParamChecks.nullNotPermitted(comparable, "rowKey");
        ParamChecks.nullNotPermitted(comparable2, "columnKey");
        if (!this.columnKeys.contains(comparable2)) {
            throw new UnknownKeyException("Unrecognised columnKey: " + comparable2);
        }
        int n = this.getRowIndex(comparable);
        if (n >= 0) {
            DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n);
            int n2 = defaultKeyedValues.getIndex(comparable2);
            return n2 >= 0 ? (Number)defaultKeyedValues.getValue(n2) : (Number)null;
        }
        throw new UnknownKeyException("Unrecognised rowKey: " + comparable);
    }

    public void addValue(Number number, Comparable comparable, Comparable comparable2) {
        this.setValue(number, comparable, comparable2);
    }

    public void setValue(Number number, Comparable comparable, Comparable comparable2) {
        DefaultKeyedValues defaultKeyedValues;
        int n = this.getRowIndex(comparable);
        if (n >= 0) {
            defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n);
        } else {
            defaultKeyedValues = new DefaultKeyedValues();
            if (this.sortRowKeys) {
                n = -n - 1;
                this.rowKeys.add(n, comparable);
                this.rows.add(n, defaultKeyedValues);
            } else {
                this.rowKeys.add(comparable);
                this.rows.add(defaultKeyedValues);
            }
        }
        defaultKeyedValues.setValue(comparable2, number);
        int n2 = this.columnKeys.indexOf(comparable2);
        if (n2 < 0) {
            this.columnKeys.add(comparable2);
        }
    }

    public void removeValue(Comparable comparable, Comparable comparable2) {
        int n;
        int n2;
        this.setValue(null, comparable, comparable2);
        boolean bl = true;
        int n3 = this.getRowIndex(comparable);
        DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n3);
        int n4 = defaultKeyedValues.getItemCount();
        for (n2 = 0; n2 < n4; ++n2) {
            if (defaultKeyedValues.getValue(n2) == null) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.rowKeys.remove(n3);
            this.rows.remove(n3);
        }
        bl = true;
        n4 = this.rows.size();
        for (n2 = 0; n2 < n4; ++n2) {
            defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n2);
            n = defaultKeyedValues.getIndex(comparable2);
            if (n < 0 || defaultKeyedValues.getValue(n) == null) continue;
            bl = false;
            break;
        }
        if (bl) {
            n4 = this.rows.size();
            for (n2 = 0; n2 < n4; ++n2) {
                defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n2);
                n = defaultKeyedValues.getIndex(comparable2);
                if (n < 0) continue;
                defaultKeyedValues.removeValue(n);
            }
            this.columnKeys.remove(comparable2);
        }
    }

    public void removeRow(int n) {
        this.rowKeys.remove(n);
        this.rows.remove(n);
    }

    public void removeRow(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "rowKey");
        int n = this.getRowIndex(comparable);
        if (n < 0) {
            throw new UnknownKeyException("Unknown key: " + comparable);
        }
        this.removeRow(n);
    }

    public void removeColumn(int n) {
        Comparable comparable = this.getColumnKey(n);
        this.removeColumn(comparable);
    }

    public void removeColumn(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "columnKey");
        if (!this.columnKeys.contains(comparable)) {
            throw new UnknownKeyException("Unknown key: " + comparable);
        }
        for (DefaultKeyedValues defaultKeyedValues : this.rows) {
            int n = defaultKeyedValues.getIndex(comparable);
            if (n < 0) continue;
            defaultKeyedValues.removeValue(comparable);
        }
        this.columnKeys.remove(comparable);
    }

    public void clear() {
        this.rowKeys.clear();
        this.columnKeys.clear();
        this.rows.clear();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyedValues2D)) {
            return false;
        }
        KeyedValues2D keyedValues2D = (KeyedValues2D)object;
        if (!this.getRowKeys().equals(keyedValues2D.getRowKeys())) {
            return false;
        }
        if (!this.getColumnKeys().equals(keyedValues2D.getColumnKeys())) {
            return false;
        }
        int n = this.getRowCount();
        if (n != keyedValues2D.getRowCount()) {
            return false;
        }
        int n2 = this.getColumnCount();
        if (n2 != keyedValues2D.getColumnCount()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Number number = this.getValue(i, j);
                Number number2 = keyedValues2D.getValue(i, j);
                if (!(number == null ? number2 != null : !number.equals(number2))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = this.rowKeys.hashCode();
        n = 29 * n + this.columnKeys.hashCode();
        n = 29 * n + this.rows.hashCode();
        return n;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultKeyedValues2D defaultKeyedValues2D = (DefaultKeyedValues2D)super.clone();
        defaultKeyedValues2D.columnKeys = new ArrayList(this.columnKeys);
        defaultKeyedValues2D.rowKeys = new ArrayList(this.rowKeys);
        defaultKeyedValues2D.rows = (List)ObjectUtilities.deepClone(this.rows);
        return defaultKeyedValues2D;
    }
}

