/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import org.jfree.chart.util.ParamChecks;
import org.jfree.ui.TextAnchor;

public class AttrStringUtils {
    private AttrStringUtils() {
    }

    public static Rectangle2D getTextBounds(AttributedString attributedString, Graphics2D graphics2D) {
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
        return textLayout.getBounds();
    }

    public static void drawRotatedString(AttributedString attributedString, Graphics2D graphics2D, double d, float f, float f2) {
        AttrStringUtils.drawRotatedString(attributedString, graphics2D, f, f2, d, f, f2);
    }

    public static void drawRotatedString(AttributedString attributedString, Graphics2D graphics2D, float f, float f2, double d, float f3, float f4) {
        ParamChecks.nullNotPermitted(attributedString, "text");
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(d, f3, f4);
        graphics2D.transform(affineTransform2);
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
        textLayout.draw(graphics2D, f, f2);
        graphics2D.setTransform(affineTransform);
    }

    public static void drawRotatedString(AttributedString attributedString, Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor, double d, float f3, float f4) {
        ParamChecks.nullNotPermitted(attributedString, "text");
        float[] fArray = AttrStringUtils.deriveTextBoundsAnchorOffsets(graphics2D, attributedString, textAnchor, null);
        AttrStringUtils.drawRotatedString(attributedString, graphics2D, f + fArray[0], f2 + fArray[1], d, f3, f4);
    }

    public static void drawRotatedString(AttributedString attributedString, Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor, double d, TextAnchor textAnchor2) {
        ParamChecks.nullNotPermitted(attributedString, "text");
        float[] fArray = AttrStringUtils.deriveTextBoundsAnchorOffsets(graphics2D, attributedString, textAnchor, null);
        float[] fArray2 = AttrStringUtils.deriveRotationAnchorOffsets(graphics2D, attributedString, textAnchor2);
        AttrStringUtils.drawRotatedString(attributedString, graphics2D, f + fArray[0], f2 + fArray[1], d, f + fArray[0] + fArray2[0], f2 + fArray[1] + fArray2[1]);
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D graphics2D, AttributedString attributedString, TextAnchor textAnchor, Rectangle2D rectangle2D) {
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
        Rectangle2D rectangle2D2 = textLayout.getBounds();
        float[] fArray = new float[3];
        float f = textLayout.getAscent();
        fArray[2] = -f;
        float f2 = f / 2.0f;
        float f3 = textLayout.getDescent();
        float f4 = textLayout.getLeading();
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (AttrStringUtils.isHorizontalCenter(textAnchor)) {
            f5 = (float)(-rectangle2D2.getWidth()) / 2.0f;
        } else if (AttrStringUtils.isHorizontalRight(textAnchor)) {
            f5 = (float)(-rectangle2D2.getWidth());
        }
        if (AttrStringUtils.isTop(textAnchor)) {
            f6 = (float)rectangle2D2.getHeight();
        } else if (AttrStringUtils.isHalfAscent(textAnchor)) {
            f6 = f2;
        } else if (AttrStringUtils.isHalfHeight(textAnchor)) {
            f6 = -f3 - f4 + (float)(rectangle2D2.getHeight() / 2.0);
        } else if (AttrStringUtils.isBaseline(textAnchor)) {
            f6 = 0.0f;
        } else if (AttrStringUtils.isBottom(textAnchor)) {
            f6 = -f3 - f4;
        }
        if (rectangle2D != null) {
            rectangle2D.setRect(rectangle2D2);
        }
        fArray[0] = f5;
        fArray[1] = f6;
        return fArray;
    }

    private static float[] deriveRotationAnchorOffsets(Graphics2D graphics2D, AttributedString attributedString, TextAnchor textAnchor) {
        float[] fArray = new float[2];
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
        Rectangle2D rectangle2D = textLayout.getBounds();
        float f = textLayout.getAscent();
        float f2 = f / 2.0f;
        float f3 = textLayout.getDescent();
        float f4 = textLayout.getLeading();
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (AttrStringUtils.isHorizontalLeft(textAnchor)) {
            f5 = 0.0f;
        } else if (AttrStringUtils.isHorizontalCenter(textAnchor)) {
            f5 = (float)rectangle2D.getWidth() / 2.0f;
        } else if (AttrStringUtils.isHorizontalRight(textAnchor)) {
            f5 = (float)rectangle2D.getWidth();
        }
        if (AttrStringUtils.isTop(textAnchor)) {
            f6 = f3 + f4 - (float)rectangle2D.getHeight();
        } else if (AttrStringUtils.isHalfHeight(textAnchor)) {
            f6 = f3 + f4 - (float)(rectangle2D.getHeight() / 2.0);
        } else if (AttrStringUtils.isHalfAscent(textAnchor)) {
            f6 = -f2;
        } else if (AttrStringUtils.isBaseline(textAnchor)) {
            f6 = 0.0f;
        } else if (AttrStringUtils.isBottom(textAnchor)) {
            f6 = f3 + f4;
        }
        fArray[0] = f5;
        fArray[1] = f6;
        return fArray;
    }

    private static boolean isTop(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.TOP_LEFT) || textAnchor.equals(TextAnchor.TOP_CENTER) || textAnchor.equals(TextAnchor.TOP_RIGHT);
    }

    private static boolean isBaseline(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.BASELINE_LEFT) || textAnchor.equals(TextAnchor.BASELINE_CENTER) || textAnchor.equals(TextAnchor.BASELINE_RIGHT);
    }

    private static boolean isHalfAscent(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.HALF_ASCENT_LEFT) || textAnchor.equals(TextAnchor.HALF_ASCENT_CENTER) || textAnchor.equals(TextAnchor.HALF_ASCENT_RIGHT);
    }

    private static boolean isHalfHeight(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.CENTER_LEFT) || textAnchor.equals(TextAnchor.CENTER) || textAnchor.equals(TextAnchor.CENTER_RIGHT);
    }

    private static boolean isBottom(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.BOTTOM_LEFT) || textAnchor.equals(TextAnchor.BOTTOM_CENTER) || textAnchor.equals(TextAnchor.BOTTOM_RIGHT);
    }

    private static boolean isHorizontalLeft(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.TOP_LEFT) || textAnchor.equals(TextAnchor.CENTER_LEFT) || textAnchor.equals(TextAnchor.HALF_ASCENT_LEFT) || textAnchor.equals(TextAnchor.BASELINE_LEFT) || textAnchor.equals(TextAnchor.BOTTOM_LEFT);
    }

    private static boolean isHorizontalCenter(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.TOP_CENTER) || textAnchor.equals(TextAnchor.CENTER) || textAnchor.equals(TextAnchor.HALF_ASCENT_CENTER) || textAnchor.equals(TextAnchor.BASELINE_CENTER) || textAnchor.equals(TextAnchor.BOTTOM_CENTER);
    }

    private static boolean isHorizontalRight(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.TOP_RIGHT) || textAnchor.equals(TextAnchor.CENTER_RIGHT) || textAnchor.equals(TextAnchor.HALF_ASCENT_RIGHT) || textAnchor.equals(TextAnchor.BASELINE_RIGHT) || textAnchor.equals(TextAnchor.BOTTOM_RIGHT);
    }
}

