/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import org.jfree.chart.util.ParamChecks;
import org.jfree.data.DomainOrder;
import org.jfree.data.xy.XYDataset;

public class RendererUtilities {
    public static int findLiveItemsLowerBound(XYDataset xYDataset, int n, double d, double d2) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (d >= d2) {
            throw new IllegalArgumentException("Requires xLow < xHigh.");
        }
        int n2 = xYDataset.getItemCount(n);
        if (n2 <= 1) {
            return 0;
        }
        if (xYDataset.getDomainOrder() == DomainOrder.ASCENDING) {
            int n3 = 0;
            int n4 = n2 - 1;
            double d3 = xYDataset.getXValue(n, n3);
            if (d3 >= d) {
                return n3;
            }
            double d4 = xYDataset.getXValue(n, n4);
            if (d4 < d) {
                return n4;
            }
            while (n4 - n3 > 1) {
                int n5 = (n3 + n4) / 2;
                double d5 = xYDataset.getXValue(n, n5);
                if (d5 >= d) {
                    n4 = n5;
                    continue;
                }
                n3 = n5;
            }
            return n4;
        }
        if (xYDataset.getDomainOrder() == DomainOrder.DESCENDING) {
            int n6 = 0;
            int n7 = n2 - 1;
            double d6 = xYDataset.getXValue(n, n6);
            if (d6 <= d2) {
                return n6;
            }
            double d7 = xYDataset.getXValue(n, n7);
            if (d7 > d2) {
                return n7;
            }
            while (n7 - n6 > 1) {
                int n8 = (n6 + n7) / 2;
                double d8 = xYDataset.getXValue(n, n8);
                if (d8 > d2) {
                    n6 = n8;
                    continue;
                }
                n7 = n8;
            }
            return n7;
        }
        int n9 = 0;
        double d9 = xYDataset.getXValue(n, n9);
        while (n9 < n2 && d9 < d) {
            if (++n9 >= n2) continue;
            d9 = xYDataset.getXValue(n, n9);
        }
        return Math.min(Math.max(0, n9), n2 - 1);
    }

    public static int findLiveItemsUpperBound(XYDataset xYDataset, int n, double d, double d2) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (d >= d2) {
            throw new IllegalArgumentException("Requires xLow < xHigh.");
        }
        int n2 = xYDataset.getItemCount(n);
        if (n2 <= 1) {
            return 0;
        }
        if (xYDataset.getDomainOrder() == DomainOrder.ASCENDING) {
            int n3 = 0;
            int n4 = n2 - 1;
            double d3 = xYDataset.getXValue(n, n3);
            if (d3 > d2) {
                return n3;
            }
            double d4 = xYDataset.getXValue(n, n4);
            if (d4 <= d2) {
                return n4;
            }
            int n5 = (n3 + n4) / 2;
            while (n4 - n3 > 1) {
                double d5 = xYDataset.getXValue(n, n5);
                if (d5 <= d2) {
                    n3 = n5;
                } else {
                    n4 = n5;
                }
                n5 = (n3 + n4) / 2;
            }
            return n5;
        }
        if (xYDataset.getDomainOrder() == DomainOrder.DESCENDING) {
            int n6 = 0;
            int n7 = n2 - 1;
            int n8 = (n6 + n7) / 2;
            double d6 = xYDataset.getXValue(n, n6);
            if (d6 < d) {
                return n6;
            }
            double d7 = xYDataset.getXValue(n, n7);
            if (d7 >= d) {
                return n7;
            }
            while (n7 - n6 > 1) {
                double d8 = xYDataset.getXValue(n, n8);
                if (d8 >= d) {
                    n6 = n8;
                } else {
                    n7 = n8;
                }
                n8 = (n6 + n7) / 2;
            }
            return n8;
        }
        int n9 = n2 - 1;
        double d9 = xYDataset.getXValue(n, n9);
        while (n9 >= 0 && d9 > d2) {
            if (--n9 < 0) continue;
            d9 = xYDataset.getXValue(n, n9);
        }
        return Math.max(n9, 0);
    }

    public static int[] findLiveItems(XYDataset xYDataset, int n, double d, double d2) {
        int n2;
        int n3 = RendererUtilities.findLiveItemsLowerBound(xYDataset, n, d, d2);
        if (n3 > (n2 = RendererUtilities.findLiveItemsUpperBound(xYDataset, n, d, d2))) {
            n3 = n2;
        }
        return new int[]{n3, n2};
    }
}

