/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.util.CloneUtils;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.BooleanList;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintList;
import org.jfree.util.PaintUtilities;
import org.jfree.util.ShapeList;
import org.jfree.util.ShapeUtilities;
import org.jfree.util.StrokeList;

public abstract class AbstractRenderer
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -828267569428206075L;
    public static final Double ZERO = new Double(0.0);
    public static final Paint DEFAULT_PAINT = Color.blue;
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke(1.0f);
    public static final Shape DEFAULT_SHAPE = new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0);
    public static final Font DEFAULT_VALUE_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_VALUE_LABEL_PAINT = Color.black;
    private BooleanList seriesVisibleList = new BooleanList();
    private boolean baseSeriesVisible = true;
    private BooleanList seriesVisibleInLegendList = new BooleanList();
    private boolean baseSeriesVisibleInLegend = true;
    private PaintList paintList = new PaintList();
    private boolean autoPopulateSeriesPaint = true;
    private transient Paint basePaint = DEFAULT_PAINT;
    private PaintList fillPaintList = new PaintList();
    private boolean autoPopulateSeriesFillPaint = false;
    private transient Paint baseFillPaint = Color.white;
    private PaintList outlinePaintList = new PaintList();
    private boolean autoPopulateSeriesOutlinePaint = false;
    private transient Paint baseOutlinePaint = DEFAULT_OUTLINE_PAINT;
    private StrokeList strokeList = new StrokeList();
    private boolean autoPopulateSeriesStroke = true;
    private transient Stroke baseStroke = DEFAULT_STROKE;
    private StrokeList outlineStrokeList = new StrokeList();
    private transient Stroke baseOutlineStroke = DEFAULT_OUTLINE_STROKE;
    private boolean autoPopulateSeriesOutlineStroke = false;
    private ShapeList shapeList = new ShapeList();
    private boolean autoPopulateSeriesShape = true;
    private transient Shape baseShape = DEFAULT_SHAPE;
    private BooleanList itemLabelsVisibleList = new BooleanList();
    private Boolean baseItemLabelsVisible = Boolean.FALSE;
    private Map<Integer, Font> itemLabelFontMap = new HashMap<Integer, Font>();
    private Font baseItemLabelFont = new Font("SansSerif", 0, 10);
    private PaintList itemLabelPaintList = new PaintList();
    private transient Paint baseItemLabelPaint = Color.black;
    private Map<Integer, ItemLabelPosition> positiveItemLabelPositionMap = new HashMap<Integer, ItemLabelPosition>();
    private ItemLabelPosition basePositiveItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
    private Map<Integer, ItemLabelPosition> negativeItemLabelPositionMap = new HashMap<Integer, ItemLabelPosition>();
    private ItemLabelPosition baseNegativeItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
    private double itemLabelAnchorOffset = 2.0;
    private BooleanList createEntitiesList = new BooleanList();
    private boolean baseCreateEntities = true;
    private ShapeList legendShapeList = new ShapeList();
    private transient Shape baseLegendShape = null;
    private boolean treatLegendShapeAsLine = false;
    private Map<Integer, Font> legendTextFontMap = new HashMap<Integer, Font>();
    private Font baseLegendTextFont = null;
    private PaintList legendTextPaint = new PaintList();
    private transient Paint baseLegendTextPaint = null;
    private boolean dataBoundsIncludesVisibleSeriesOnly = true;
    private int defaultEntityRadius = 3;
    private transient EventListenerList listenerList = new EventListenerList();
    private transient RendererChangeEvent event;
    private static final double ADJ = Math.cos(0.5235987755982988);
    private static final double OPP = Math.sin(0.5235987755982988);
    private Boolean seriesVisible = null;
    private Boolean seriesVisibleInLegend = null;
    private transient Paint paint = null;
    private transient Paint fillPaint = null;
    private transient Paint outlinePaint = null;
    private transient Stroke stroke = null;
    private transient Stroke outlineStroke = null;
    private transient Shape shape = null;
    private Boolean itemLabelsVisible = null;
    private Font itemLabelFont = null;
    private transient Paint itemLabelPaint = null;
    private ItemLabelPosition positiveItemLabelPosition = null;
    private ItemLabelPosition negativeItemLabelPosition = null;
    private Boolean createEntities = null;

    public abstract DrawingSupplier getDrawingSupplier();

    public boolean getItemVisible(int n, int n2) {
        return this.isSeriesVisible(n);
    }

    public boolean isSeriesVisible(int n) {
        boolean bl = this.baseSeriesVisible;
        if (this.seriesVisible != null) {
            bl = this.seriesVisible;
        } else {
            Boolean bl2 = this.seriesVisibleList.getBoolean(n);
            if (bl2 != null) {
                bl = bl2;
            }
        }
        return bl;
    }

    public Boolean getSeriesVisible(int n) {
        return this.seriesVisibleList.getBoolean(n);
    }

    public void setSeriesVisible(int n, Boolean bl) {
        this.setSeriesVisible(n, bl, true);
    }

    public void setSeriesVisible(int n, Boolean bl, boolean bl2) {
        this.seriesVisibleList.setBoolean(n, bl);
        if (bl2) {
            RendererChangeEvent rendererChangeEvent = new RendererChangeEvent((Object)this, true);
            this.notifyListeners(rendererChangeEvent);
        }
    }

    public boolean getBaseSeriesVisible() {
        return this.baseSeriesVisible;
    }

    public void setBaseSeriesVisible(boolean bl) {
        this.setBaseSeriesVisible(bl, true);
    }

    public void setBaseSeriesVisible(boolean bl, boolean bl2) {
        this.baseSeriesVisible = bl;
        if (bl2) {
            RendererChangeEvent rendererChangeEvent = new RendererChangeEvent((Object)this, true);
            this.notifyListeners(rendererChangeEvent);
        }
    }

    public boolean isSeriesVisibleInLegend(int n) {
        boolean bl = this.baseSeriesVisibleInLegend;
        if (this.seriesVisibleInLegend != null) {
            bl = this.seriesVisibleInLegend;
        } else {
            Boolean bl2 = this.seriesVisibleInLegendList.getBoolean(n);
            if (bl2 != null) {
                bl = bl2;
            }
        }
        return bl;
    }

    public Boolean getSeriesVisibleInLegend(int n) {
        return this.seriesVisibleInLegendList.getBoolean(n);
    }

    public void setSeriesVisibleInLegend(int n, Boolean bl) {
        this.setSeriesVisibleInLegend(n, bl, true);
    }

    public void setSeriesVisibleInLegend(int n, Boolean bl, boolean bl2) {
        this.seriesVisibleInLegendList.setBoolean(n, bl);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public boolean getBaseSeriesVisibleInLegend() {
        return this.baseSeriesVisibleInLegend;
    }

    public void setBaseSeriesVisibleInLegend(boolean bl) {
        this.setBaseSeriesVisibleInLegend(bl, true);
    }

    public void setBaseSeriesVisibleInLegend(boolean bl, boolean bl2) {
        this.baseSeriesVisibleInLegend = bl;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Paint getItemPaint(int n, int n2) {
        return this.lookupSeriesPaint(n);
    }

    public Paint lookupSeriesPaint(int n) {
        DrawingSupplier drawingSupplier;
        if (this.paint != null) {
            return this.paint;
        }
        Paint paint = this.getSeriesPaint(n);
        if (paint == null && this.autoPopulateSeriesPaint && (drawingSupplier = this.getDrawingSupplier()) != null) {
            paint = drawingSupplier.getNextPaint();
            this.setSeriesPaint(n, paint, false);
        }
        if (paint == null) {
            paint = this.basePaint;
        }
        return paint;
    }

    public Paint getSeriesPaint(int n) {
        return this.paintList.getPaint(n);
    }

    public void setSeriesPaint(int n, Paint paint) {
        this.setSeriesPaint(n, paint, true);
    }

    public void setSeriesPaint(int n, Paint paint, boolean bl) {
        this.paintList.setPaint(n, paint);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void clearSeriesPaints(boolean bl) {
        this.paintList.clear();
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Paint getBasePaint() {
        return this.basePaint;
    }

    public void setBasePaint(Paint paint) {
        this.setBasePaint(paint, true);
    }

    public void setBasePaint(Paint paint, boolean bl) {
        this.basePaint = paint;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesPaint() {
        return this.autoPopulateSeriesPaint;
    }

    public void setAutoPopulateSeriesPaint(boolean bl) {
        this.autoPopulateSeriesPaint = bl;
    }

    public Paint getItemFillPaint(int n, int n2) {
        return this.lookupSeriesFillPaint(n);
    }

    public Paint lookupSeriesFillPaint(int n) {
        DrawingSupplier drawingSupplier;
        if (this.fillPaint != null) {
            return this.fillPaint;
        }
        Paint paint = this.getSeriesFillPaint(n);
        if (paint == null && this.autoPopulateSeriesFillPaint && (drawingSupplier = this.getDrawingSupplier()) != null) {
            paint = drawingSupplier.getNextFillPaint();
            this.setSeriesFillPaint(n, paint, false);
        }
        if (paint == null) {
            paint = this.baseFillPaint;
        }
        return paint;
    }

    public Paint getSeriesFillPaint(int n) {
        return this.fillPaintList.getPaint(n);
    }

    public void setSeriesFillPaint(int n, Paint paint) {
        this.setSeriesFillPaint(n, paint, true);
    }

    public void setSeriesFillPaint(int n, Paint paint, boolean bl) {
        this.fillPaintList.setPaint(n, paint);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Paint getBaseFillPaint() {
        return this.baseFillPaint;
    }

    public void setBaseFillPaint(Paint paint) {
        this.setBaseFillPaint(paint, true);
    }

    public void setBaseFillPaint(Paint paint, boolean bl) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.baseFillPaint = paint;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesFillPaint() {
        return this.autoPopulateSeriesFillPaint;
    }

    public void setAutoPopulateSeriesFillPaint(boolean bl) {
        this.autoPopulateSeriesFillPaint = bl;
    }

    public Paint getItemOutlinePaint(int n, int n2) {
        return this.lookupSeriesOutlinePaint(n);
    }

    public Paint lookupSeriesOutlinePaint(int n) {
        DrawingSupplier drawingSupplier;
        if (this.outlinePaint != null) {
            return this.outlinePaint;
        }
        Paint paint = this.getSeriesOutlinePaint(n);
        if (paint == null && this.autoPopulateSeriesOutlinePaint && (drawingSupplier = this.getDrawingSupplier()) != null) {
            paint = drawingSupplier.getNextOutlinePaint();
            this.setSeriesOutlinePaint(n, paint, false);
        }
        if (paint == null) {
            paint = this.baseOutlinePaint;
        }
        return paint;
    }

    public Paint getSeriesOutlinePaint(int n) {
        return this.outlinePaintList.getPaint(n);
    }

    public void setSeriesOutlinePaint(int n, Paint paint) {
        this.setSeriesOutlinePaint(n, paint, true);
    }

    public void setSeriesOutlinePaint(int n, Paint paint, boolean bl) {
        this.outlinePaintList.setPaint(n, paint);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Paint getBaseOutlinePaint() {
        return this.baseOutlinePaint;
    }

    public void setBaseOutlinePaint(Paint paint) {
        this.setBaseOutlinePaint(paint, true);
    }

    public void setBaseOutlinePaint(Paint paint, boolean bl) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.baseOutlinePaint = paint;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesOutlinePaint() {
        return this.autoPopulateSeriesOutlinePaint;
    }

    public void setAutoPopulateSeriesOutlinePaint(boolean bl) {
        this.autoPopulateSeriesOutlinePaint = bl;
    }

    public Stroke getItemStroke(int n, int n2) {
        return this.lookupSeriesStroke(n);
    }

    public Stroke lookupSeriesStroke(int n) {
        DrawingSupplier drawingSupplier;
        if (this.stroke != null) {
            return this.stroke;
        }
        Stroke stroke = this.getSeriesStroke(n);
        if (stroke == null && this.autoPopulateSeriesStroke && (drawingSupplier = this.getDrawingSupplier()) != null) {
            stroke = drawingSupplier.getNextStroke();
            this.setSeriesStroke(n, stroke, false);
        }
        if (stroke == null) {
            stroke = this.baseStroke;
        }
        return stroke;
    }

    public Stroke getSeriesStroke(int n) {
        return this.strokeList.getStroke(n);
    }

    public void setSeriesStroke(int n, Stroke stroke) {
        this.setSeriesStroke(n, stroke, true);
    }

    public void setSeriesStroke(int n, Stroke stroke, boolean bl) {
        this.strokeList.setStroke(n, stroke);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void clearSeriesStrokes(boolean bl) {
        this.strokeList.clear();
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Stroke getBaseStroke() {
        return this.baseStroke;
    }

    public void setBaseStroke(Stroke stroke) {
        this.setBaseStroke(stroke, true);
    }

    public void setBaseStroke(Stroke stroke, boolean bl) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.baseStroke = stroke;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesStroke() {
        return this.autoPopulateSeriesStroke;
    }

    public void setAutoPopulateSeriesStroke(boolean bl) {
        this.autoPopulateSeriesStroke = bl;
    }

    public Stroke getItemOutlineStroke(int n, int n2) {
        return this.lookupSeriesOutlineStroke(n);
    }

    public Stroke lookupSeriesOutlineStroke(int n) {
        DrawingSupplier drawingSupplier;
        if (this.outlineStroke != null) {
            return this.outlineStroke;
        }
        Stroke stroke = this.getSeriesOutlineStroke(n);
        if (stroke == null && this.autoPopulateSeriesOutlineStroke && (drawingSupplier = this.getDrawingSupplier()) != null) {
            stroke = drawingSupplier.getNextOutlineStroke();
            this.setSeriesOutlineStroke(n, stroke, false);
        }
        if (stroke == null) {
            stroke = this.baseOutlineStroke;
        }
        return stroke;
    }

    public Stroke getSeriesOutlineStroke(int n) {
        return this.outlineStrokeList.getStroke(n);
    }

    public void setSeriesOutlineStroke(int n, Stroke stroke) {
        this.setSeriesOutlineStroke(n, stroke, true);
    }

    public void setSeriesOutlineStroke(int n, Stroke stroke, boolean bl) {
        this.outlineStrokeList.setStroke(n, stroke);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Stroke getBaseOutlineStroke() {
        return this.baseOutlineStroke;
    }

    public void setBaseOutlineStroke(Stroke stroke) {
        this.setBaseOutlineStroke(stroke, true);
    }

    public void setBaseOutlineStroke(Stroke stroke, boolean bl) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.baseOutlineStroke = stroke;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesOutlineStroke() {
        return this.autoPopulateSeriesOutlineStroke;
    }

    public void setAutoPopulateSeriesOutlineStroke(boolean bl) {
        this.autoPopulateSeriesOutlineStroke = bl;
    }

    public Shape getItemShape(int n, int n2) {
        return this.lookupSeriesShape(n);
    }

    public Shape lookupSeriesShape(int n) {
        DrawingSupplier drawingSupplier;
        if (this.shape != null) {
            return this.shape;
        }
        Shape shape = this.getSeriesShape(n);
        if (shape == null && this.autoPopulateSeriesShape && (drawingSupplier = this.getDrawingSupplier()) != null) {
            shape = drawingSupplier.getNextShape();
            this.setSeriesShape(n, shape, false);
        }
        if (shape == null) {
            shape = this.baseShape;
        }
        return shape;
    }

    public Shape getSeriesShape(int n) {
        return this.shapeList.getShape(n);
    }

    public void setSeriesShape(int n, Shape shape) {
        this.setSeriesShape(n, shape, true);
    }

    public void setSeriesShape(int n, Shape shape, boolean bl) {
        this.shapeList.setShape(n, shape);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Shape getBaseShape() {
        return this.baseShape;
    }

    public void setBaseShape(Shape shape) {
        this.setBaseShape(shape, true);
    }

    public void setBaseShape(Shape shape, boolean bl) {
        ParamChecks.nullNotPermitted(shape, "shape");
        this.baseShape = shape;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesShape() {
        return this.autoPopulateSeriesShape;
    }

    public void setAutoPopulateSeriesShape(boolean bl) {
        this.autoPopulateSeriesShape = bl;
    }

    public boolean isItemLabelVisible(int n, int n2) {
        return this.isSeriesItemLabelsVisible(n);
    }

    public boolean isSeriesItemLabelsVisible(int n) {
        if (this.itemLabelsVisible != null) {
            return this.itemLabelsVisible;
        }
        Boolean bl = this.itemLabelsVisibleList.getBoolean(n);
        if (bl == null) {
            bl = this.baseItemLabelsVisible;
        }
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public void setSeriesItemLabelsVisible(int n, boolean bl) {
        this.setSeriesItemLabelsVisible(n, (Boolean)bl);
    }

    public void setSeriesItemLabelsVisible(int n, Boolean bl) {
        this.setSeriesItemLabelsVisible(n, bl, true);
    }

    public void setSeriesItemLabelsVisible(int n, Boolean bl, boolean bl2) {
        this.itemLabelsVisibleList.setBoolean(n, bl);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Boolean getBaseItemLabelsVisible() {
        return this.baseItemLabelsVisible;
    }

    public void setBaseItemLabelsVisible(boolean bl) {
        this.setBaseItemLabelsVisible((Boolean)bl);
    }

    public void setBaseItemLabelsVisible(Boolean bl) {
        this.setBaseItemLabelsVisible(bl, true);
    }

    public void setBaseItemLabelsVisible(Boolean bl, boolean bl2) {
        this.baseItemLabelsVisible = bl;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Font getItemLabelFont(int n, int n2) {
        Font font = this.itemLabelFont;
        if (font == null && (font = this.getSeriesItemLabelFont(n)) == null) {
            font = this.baseItemLabelFont;
        }
        return font;
    }

    public Font getSeriesItemLabelFont(int n) {
        return this.itemLabelFontMap.get(n);
    }

    public void setSeriesItemLabelFont(int n, Font font) {
        this.setSeriesItemLabelFont(n, font, true);
    }

    public void setSeriesItemLabelFont(int n, Font font, boolean bl) {
        this.itemLabelFontMap.put(n, font);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Font getBaseItemLabelFont() {
        return this.baseItemLabelFont;
    }

    public void setBaseItemLabelFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.setBaseItemLabelFont(font, true);
    }

    public void setBaseItemLabelFont(Font font, boolean bl) {
        this.baseItemLabelFont = font;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Paint getItemLabelPaint(int n, int n2) {
        Paint paint = this.itemLabelPaint;
        if (paint == null && (paint = this.getSeriesItemLabelPaint(n)) == null) {
            paint = this.baseItemLabelPaint;
        }
        return paint;
    }

    public Paint getSeriesItemLabelPaint(int n) {
        return this.itemLabelPaintList.getPaint(n);
    }

    public void setSeriesItemLabelPaint(int n, Paint paint) {
        this.setSeriesItemLabelPaint(n, paint, true);
    }

    public void setSeriesItemLabelPaint(int n, Paint paint, boolean bl) {
        this.itemLabelPaintList.setPaint(n, paint);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Paint getBaseItemLabelPaint() {
        return this.baseItemLabelPaint;
    }

    public void setBaseItemLabelPaint(Paint paint) {
        this.setBaseItemLabelPaint(paint, true);
    }

    public void setBaseItemLabelPaint(Paint paint, boolean bl) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.baseItemLabelPaint = paint;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getPositiveItemLabelPosition(int n, int n2) {
        return this.getSeriesPositiveItemLabelPosition(n);
    }

    public ItemLabelPosition getSeriesPositiveItemLabelPosition(int n) {
        if (this.positiveItemLabelPosition != null) {
            return this.positiveItemLabelPosition;
        }
        ItemLabelPosition itemLabelPosition = this.positiveItemLabelPositionMap.get(n);
        if (itemLabelPosition == null) {
            itemLabelPosition = this.basePositiveItemLabelPosition;
        }
        return itemLabelPosition;
    }

    public void setSeriesPositiveItemLabelPosition(int n, ItemLabelPosition itemLabelPosition) {
        this.setSeriesPositiveItemLabelPosition(n, itemLabelPosition, true);
    }

    public void setSeriesPositiveItemLabelPosition(int n, ItemLabelPosition itemLabelPosition, boolean bl) {
        this.positiveItemLabelPositionMap.put(n, itemLabelPosition);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getBasePositiveItemLabelPosition() {
        return this.basePositiveItemLabelPosition;
    }

    public void setBasePositiveItemLabelPosition(ItemLabelPosition itemLabelPosition) {
        this.setBasePositiveItemLabelPosition(itemLabelPosition, true);
    }

    public void setBasePositiveItemLabelPosition(ItemLabelPosition itemLabelPosition, boolean bl) {
        ParamChecks.nullNotPermitted(itemLabelPosition, "position");
        this.basePositiveItemLabelPosition = itemLabelPosition;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getNegativeItemLabelPosition(int n, int n2) {
        return this.getSeriesNegativeItemLabelPosition(n);
    }

    public ItemLabelPosition getSeriesNegativeItemLabelPosition(int n) {
        if (this.negativeItemLabelPosition != null) {
            return this.negativeItemLabelPosition;
        }
        ItemLabelPosition itemLabelPosition = this.negativeItemLabelPositionMap.get(n);
        if (itemLabelPosition == null) {
            itemLabelPosition = this.baseNegativeItemLabelPosition;
        }
        return itemLabelPosition;
    }

    public void setSeriesNegativeItemLabelPosition(int n, ItemLabelPosition itemLabelPosition) {
        this.setSeriesNegativeItemLabelPosition(n, itemLabelPosition, true);
    }

    public void setSeriesNegativeItemLabelPosition(int n, ItemLabelPosition itemLabelPosition, boolean bl) {
        this.negativeItemLabelPositionMap.put(n, itemLabelPosition);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getBaseNegativeItemLabelPosition() {
        return this.baseNegativeItemLabelPosition;
    }

    public void setBaseNegativeItemLabelPosition(ItemLabelPosition itemLabelPosition) {
        this.setBaseNegativeItemLabelPosition(itemLabelPosition, true);
    }

    public void setBaseNegativeItemLabelPosition(ItemLabelPosition itemLabelPosition, boolean bl) {
        ParamChecks.nullNotPermitted(itemLabelPosition, "position");
        this.baseNegativeItemLabelPosition = itemLabelPosition;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public double getItemLabelAnchorOffset() {
        return this.itemLabelAnchorOffset;
    }

    public void setItemLabelAnchorOffset(double d) {
        this.itemLabelAnchorOffset = d;
        this.fireChangeEvent();
    }

    public boolean getItemCreateEntity(int n, int n2) {
        if (this.createEntities != null) {
            return this.createEntities;
        }
        Boolean bl = this.getSeriesCreateEntities(n);
        if (bl != null) {
            return bl;
        }
        return this.baseCreateEntities;
    }

    public Boolean getSeriesCreateEntities(int n) {
        return this.createEntitiesList.getBoolean(n);
    }

    public void setSeriesCreateEntities(int n, Boolean bl) {
        this.setSeriesCreateEntities(n, bl, true);
    }

    public void setSeriesCreateEntities(int n, Boolean bl, boolean bl2) {
        this.createEntitiesList.setBoolean(n, bl);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public boolean getBaseCreateEntities() {
        return this.baseCreateEntities;
    }

    public void setBaseCreateEntities(boolean bl) {
        this.setBaseCreateEntities(bl, true);
    }

    public void setBaseCreateEntities(boolean bl, boolean bl2) {
        this.baseCreateEntities = bl;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public int getDefaultEntityRadius() {
        return this.defaultEntityRadius;
    }

    public void setDefaultEntityRadius(int n) {
        this.defaultEntityRadius = n;
    }

    public Shape lookupLegendShape(int n) {
        Shape shape = this.getLegendShape(n);
        if (shape == null) {
            shape = this.baseLegendShape;
        }
        if (shape == null) {
            shape = this.lookupSeriesShape(n);
        }
        return shape;
    }

    public Shape getLegendShape(int n) {
        return this.legendShapeList.getShape(n);
    }

    public void setLegendShape(int n, Shape shape) {
        this.legendShapeList.setShape(n, shape);
        this.fireChangeEvent();
    }

    public Shape getBaseLegendShape() {
        return this.baseLegendShape;
    }

    public void setBaseLegendShape(Shape shape) {
        this.baseLegendShape = shape;
        this.fireChangeEvent();
    }

    protected boolean getTreatLegendShapeAsLine() {
        return this.treatLegendShapeAsLine;
    }

    protected void setTreatLegendShapeAsLine(boolean bl) {
        if (this.treatLegendShapeAsLine != bl) {
            this.treatLegendShapeAsLine = bl;
            this.fireChangeEvent();
        }
    }

    public Font lookupLegendTextFont(int n) {
        Font font = this.getLegendTextFont(n);
        if (font == null) {
            font = this.baseLegendTextFont;
        }
        return font;
    }

    public Font getLegendTextFont(int n) {
        return this.legendTextFontMap.get(n);
    }

    public void setLegendTextFont(int n, Font font) {
        this.legendTextFontMap.put(n, font);
        this.fireChangeEvent();
    }

    public Font getBaseLegendTextFont() {
        return this.baseLegendTextFont;
    }

    public void setBaseLegendTextFont(Font font) {
        this.baseLegendTextFont = font;
        this.fireChangeEvent();
    }

    public Paint lookupLegendTextPaint(int n) {
        Paint paint = this.getLegendTextPaint(n);
        if (paint == null) {
            paint = this.baseLegendTextPaint;
        }
        return paint;
    }

    public Paint getLegendTextPaint(int n) {
        return this.legendTextPaint.getPaint(n);
    }

    public void setLegendTextPaint(int n, Paint paint) {
        this.legendTextPaint.setPaint(n, paint);
        this.fireChangeEvent();
    }

    public Paint getBaseLegendTextPaint() {
        return this.baseLegendTextPaint;
    }

    public void setBaseLegendTextPaint(Paint paint) {
        this.baseLegendTextPaint = paint;
        this.fireChangeEvent();
    }

    public boolean getDataBoundsIncludesVisibleSeriesOnly() {
        return this.dataBoundsIncludesVisibleSeriesOnly;
    }

    public void setDataBoundsIncludesVisibleSeriesOnly(boolean bl) {
        this.dataBoundsIncludesVisibleSeriesOnly = bl;
        this.notifyListeners(new RendererChangeEvent((Object)this, true));
    }

    protected Point2D calculateLabelAnchorPoint(ItemLabelAnchor itemLabelAnchor, double d, double d2, PlotOrientation plotOrientation) {
        Point2D.Double double_ = null;
        if (itemLabelAnchor == ItemLabelAnchor.CENTER) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE1) {
            double_ = new Point2D.Double(d + OPP * this.itemLabelAnchorOffset, d2 - ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE2) {
            double_ = new Point2D.Double(d + ADJ * this.itemLabelAnchorOffset, d2 - OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE3) {
            double_ = new Point2D.Double(d + this.itemLabelAnchorOffset, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE4) {
            double_ = new Point2D.Double(d + ADJ * this.itemLabelAnchorOffset, d2 + OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE5) {
            double_ = new Point2D.Double(d + OPP * this.itemLabelAnchorOffset, d2 + ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE6) {
            double_ = new Point2D.Double(d, d2 + this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE7) {
            double_ = new Point2D.Double(d - OPP * this.itemLabelAnchorOffset, d2 + ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE8) {
            double_ = new Point2D.Double(d - ADJ * this.itemLabelAnchorOffset, d2 + OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE9) {
            double_ = new Point2D.Double(d - this.itemLabelAnchorOffset, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE10) {
            double_ = new Point2D.Double(d - ADJ * this.itemLabelAnchorOffset, d2 - OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE11) {
            double_ = new Point2D.Double(d - OPP * this.itemLabelAnchorOffset, d2 - ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE12) {
            double_ = new Point2D.Double(d, d2 - this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE1) {
            double_ = new Point2D.Double(d + 2.0 * OPP * this.itemLabelAnchorOffset, d2 - 2.0 * ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE2) {
            double_ = new Point2D.Double(d + 2.0 * ADJ * this.itemLabelAnchorOffset, d2 - 2.0 * OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE3) {
            double_ = new Point2D.Double(d + 2.0 * this.itemLabelAnchorOffset, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE4) {
            double_ = new Point2D.Double(d + 2.0 * ADJ * this.itemLabelAnchorOffset, d2 + 2.0 * OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE5) {
            double_ = new Point2D.Double(d + 2.0 * OPP * this.itemLabelAnchorOffset, d2 + 2.0 * ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE6) {
            double_ = new Point2D.Double(d, d2 + 2.0 * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE7) {
            double_ = new Point2D.Double(d - 2.0 * OPP * this.itemLabelAnchorOffset, d2 + 2.0 * ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE8) {
            double_ = new Point2D.Double(d - 2.0 * ADJ * this.itemLabelAnchorOffset, d2 + 2.0 * OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE9) {
            double_ = new Point2D.Double(d - 2.0 * this.itemLabelAnchorOffset, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE10) {
            double_ = new Point2D.Double(d - 2.0 * ADJ * this.itemLabelAnchorOffset, d2 - 2.0 * OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE11) {
            double_ = new Point2D.Double(d - 2.0 * OPP * this.itemLabelAnchorOffset, d2 - 2.0 * ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE12) {
            double_ = new Point2D.Double(d, d2 - 2.0 * this.itemLabelAnchorOffset);
        }
        return double_;
    }

    public void addChangeListener(RendererChangeListener rendererChangeListener) {
        ParamChecks.nullNotPermitted(rendererChangeListener, "listener");
        this.listenerList.add(RendererChangeListener.class, rendererChangeListener);
    }

    public void removeChangeListener(RendererChangeListener rendererChangeListener) {
        ParamChecks.nullNotPermitted(rendererChangeListener, "listener");
        this.listenerList.remove(RendererChangeListener.class, rendererChangeListener);
    }

    public boolean hasListener(EventListener eventListener) {
        List<Object> list = Arrays.asList(this.listenerList.getListenerList());
        return list.contains(eventListener);
    }

    protected void fireChangeEvent() {
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void notifyListeners(RendererChangeEvent rendererChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != RendererChangeListener.class) continue;
            ((RendererChangeListener)objectArray[i + 1]).rendererChanged(rendererChangeEvent);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractRenderer)) {
            return false;
        }
        AbstractRenderer abstractRenderer = (AbstractRenderer)object;
        if (this.dataBoundsIncludesVisibleSeriesOnly != abstractRenderer.dataBoundsIncludesVisibleSeriesOnly) {
            return false;
        }
        if (this.treatLegendShapeAsLine != abstractRenderer.treatLegendShapeAsLine) {
            return false;
        }
        if (this.defaultEntityRadius != abstractRenderer.defaultEntityRadius) {
            return false;
        }
        if (!ObjectUtilities.equal(this.seriesVisible, abstractRenderer.seriesVisible)) {
            return false;
        }
        if (!this.seriesVisibleList.equals(abstractRenderer.seriesVisibleList)) {
            return false;
        }
        if (this.baseSeriesVisible != abstractRenderer.baseSeriesVisible) {
            return false;
        }
        if (!ObjectUtilities.equal(this.seriesVisibleInLegend, abstractRenderer.seriesVisibleInLegend)) {
            return false;
        }
        if (!this.seriesVisibleInLegendList.equals(abstractRenderer.seriesVisibleInLegendList)) {
            return false;
        }
        if (this.baseSeriesVisibleInLegend != abstractRenderer.baseSeriesVisibleInLegend) {
            return false;
        }
        if (!PaintUtilities.equal(this.paint, abstractRenderer.paint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.paintList, abstractRenderer.paintList)) {
            return false;
        }
        if (!PaintUtilities.equal(this.basePaint, abstractRenderer.basePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.fillPaint, abstractRenderer.fillPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fillPaintList, abstractRenderer.fillPaintList)) {
            return false;
        }
        if (!PaintUtilities.equal(this.baseFillPaint, abstractRenderer.baseFillPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.outlinePaint, abstractRenderer.outlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlinePaintList, abstractRenderer.outlinePaintList)) {
            return false;
        }
        if (!PaintUtilities.equal(this.baseOutlinePaint, abstractRenderer.baseOutlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.stroke, abstractRenderer.stroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.strokeList, abstractRenderer.strokeList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseStroke, abstractRenderer.baseStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlineStroke, abstractRenderer.outlineStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlineStrokeList, abstractRenderer.outlineStrokeList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseOutlineStroke, abstractRenderer.baseOutlineStroke)) {
            return false;
        }
        if (!ShapeUtilities.equal(this.shape, abstractRenderer.shape)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.shapeList, abstractRenderer.shapeList)) {
            return false;
        }
        if (!ShapeUtilities.equal(this.baseShape, abstractRenderer.baseShape)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemLabelsVisible, abstractRenderer.itemLabelsVisible)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemLabelsVisibleList, abstractRenderer.itemLabelsVisibleList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseItemLabelsVisible, abstractRenderer.baseItemLabelsVisible)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemLabelFont, abstractRenderer.itemLabelFont)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemLabelFontMap, abstractRenderer.itemLabelFontMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseItemLabelFont, abstractRenderer.baseItemLabelFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.itemLabelPaint, abstractRenderer.itemLabelPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemLabelPaintList, abstractRenderer.itemLabelPaintList)) {
            return false;
        }
        if (!PaintUtilities.equal(this.baseItemLabelPaint, abstractRenderer.baseItemLabelPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.positiveItemLabelPosition, abstractRenderer.positiveItemLabelPosition)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.positiveItemLabelPositionMap, abstractRenderer.positiveItemLabelPositionMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.basePositiveItemLabelPosition, abstractRenderer.basePositiveItemLabelPosition)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.negativeItemLabelPosition, abstractRenderer.negativeItemLabelPosition)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.negativeItemLabelPositionMap, abstractRenderer.negativeItemLabelPositionMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseNegativeItemLabelPosition, abstractRenderer.baseNegativeItemLabelPosition)) {
            return false;
        }
        if (this.itemLabelAnchorOffset != abstractRenderer.itemLabelAnchorOffset) {
            return false;
        }
        if (!ObjectUtilities.equal(this.createEntities, abstractRenderer.createEntities)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.createEntitiesList, abstractRenderer.createEntitiesList)) {
            return false;
        }
        if (this.baseCreateEntities != abstractRenderer.baseCreateEntities) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendShapeList, abstractRenderer.legendShapeList)) {
            return false;
        }
        if (!ShapeUtilities.equal(this.baseLegendShape, abstractRenderer.baseLegendShape)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendTextFontMap, abstractRenderer.legendTextFontMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseLegendTextFont, abstractRenderer.baseLegendTextFont)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendTextPaint, abstractRenderer.legendTextPaint)) {
            return false;
        }
        return PaintUtilities.equal(this.baseLegendTextPaint, abstractRenderer.baseLegendTextPaint);
    }

    public int hashCode() {
        int n = 193;
        n = HashUtilities.hashCode(n, this.seriesVisibleList);
        n = HashUtilities.hashCode(n, this.baseSeriesVisible);
        n = HashUtilities.hashCode(n, this.seriesVisibleInLegendList);
        n = HashUtilities.hashCode(n, this.baseSeriesVisibleInLegend);
        n = HashUtilities.hashCode(n, this.paintList);
        n = HashUtilities.hashCode(n, this.basePaint);
        n = HashUtilities.hashCode(n, this.fillPaintList);
        n = HashUtilities.hashCode(n, this.baseFillPaint);
        n = HashUtilities.hashCode(n, this.outlinePaintList);
        n = HashUtilities.hashCode(n, this.baseOutlinePaint);
        n = HashUtilities.hashCode(n, this.strokeList);
        n = HashUtilities.hashCode(n, this.baseStroke);
        n = HashUtilities.hashCode(n, this.outlineStrokeList);
        n = HashUtilities.hashCode(n, this.baseOutlineStroke);
        n = HashUtilities.hashCode(n, this.itemLabelsVisibleList);
        n = HashUtilities.hashCode(n, this.baseItemLabelsVisible);
        return n;
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractRenderer abstractRenderer = (AbstractRenderer)super.clone();
        if (this.seriesVisibleList != null) {
            abstractRenderer.seriesVisibleList = (BooleanList)this.seriesVisibleList.clone();
        }
        if (this.seriesVisibleInLegendList != null) {
            abstractRenderer.seriesVisibleInLegendList = (BooleanList)this.seriesVisibleInLegendList.clone();
        }
        if (this.paintList != null) {
            abstractRenderer.paintList = (PaintList)this.paintList.clone();
        }
        if (this.fillPaintList != null) {
            abstractRenderer.fillPaintList = (PaintList)this.fillPaintList.clone();
        }
        if (this.outlinePaintList != null) {
            abstractRenderer.outlinePaintList = (PaintList)this.outlinePaintList.clone();
        }
        if (this.strokeList != null) {
            abstractRenderer.strokeList = (StrokeList)this.strokeList.clone();
        }
        if (this.outlineStrokeList != null) {
            abstractRenderer.outlineStrokeList = (StrokeList)this.outlineStrokeList.clone();
        }
        if (this.shape != null) {
            abstractRenderer.shape = ShapeUtilities.clone(this.shape);
        }
        if (this.shapeList != null) {
            abstractRenderer.shapeList = (ShapeList)this.shapeList.clone();
        }
        if (this.baseShape != null) {
            abstractRenderer.baseShape = ShapeUtilities.clone(this.baseShape);
        }
        if (this.itemLabelsVisibleList != null) {
            abstractRenderer.itemLabelsVisibleList = (BooleanList)this.itemLabelsVisibleList.clone();
        }
        if (this.itemLabelFontMap != null) {
            abstractRenderer.itemLabelFontMap = CloneUtils.cloneMapValues(this.itemLabelFontMap);
        }
        if (this.itemLabelPaintList != null) {
            abstractRenderer.itemLabelPaintList = (PaintList)this.itemLabelPaintList.clone();
        }
        if (this.positiveItemLabelPositionMap != null) {
            abstractRenderer.positiveItemLabelPositionMap = CloneUtils.cloneMapValues(this.positiveItemLabelPositionMap);
        }
        if (this.negativeItemLabelPositionMap != null) {
            abstractRenderer.negativeItemLabelPositionMap = CloneUtils.cloneMapValues(this.negativeItemLabelPositionMap);
        }
        if (this.createEntitiesList != null) {
            abstractRenderer.createEntitiesList = (BooleanList)this.createEntitiesList.clone();
        }
        if (this.legendShapeList != null) {
            abstractRenderer.legendShapeList = (ShapeList)this.legendShapeList.clone();
        }
        if (this.legendTextFontMap != null) {
            abstractRenderer.legendTextFontMap = CloneUtils.cloneMapValues(this.legendTextFontMap);
        }
        if (this.legendTextPaint != null) {
            abstractRenderer.legendTextPaint = (PaintList)this.legendTextPaint.clone();
        }
        abstractRenderer.listenerList = new EventListenerList();
        abstractRenderer.event = null;
        return abstractRenderer;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
        SerialUtilities.writePaint(this.basePaint, objectOutputStream);
        SerialUtilities.writePaint(this.fillPaint, objectOutputStream);
        SerialUtilities.writePaint(this.baseFillPaint, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.baseOutlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.stroke, objectOutputStream);
        SerialUtilities.writeStroke(this.baseStroke, objectOutputStream);
        SerialUtilities.writeStroke(this.outlineStroke, objectOutputStream);
        SerialUtilities.writeStroke(this.baseOutlineStroke, objectOutputStream);
        SerialUtilities.writeShape(this.shape, objectOutputStream);
        SerialUtilities.writeShape(this.baseShape, objectOutputStream);
        SerialUtilities.writePaint(this.itemLabelPaint, objectOutputStream);
        SerialUtilities.writePaint(this.baseItemLabelPaint, objectOutputStream);
        SerialUtilities.writeShape(this.baseLegendShape, objectOutputStream);
        SerialUtilities.writePaint(this.baseLegendTextPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
        this.basePaint = SerialUtilities.readPaint(objectInputStream);
        this.fillPaint = SerialUtilities.readPaint(objectInputStream);
        this.baseFillPaint = SerialUtilities.readPaint(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.baseOutlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.stroke = SerialUtilities.readStroke(objectInputStream);
        this.baseStroke = SerialUtilities.readStroke(objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.baseOutlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.shape = SerialUtilities.readShape(objectInputStream);
        this.baseShape = SerialUtilities.readShape(objectInputStream);
        this.itemLabelPaint = SerialUtilities.readPaint(objectInputStream);
        this.baseItemLabelPaint = SerialUtilities.readPaint(objectInputStream);
        this.baseLegendShape = SerialUtilities.readShape(objectInputStream);
        this.baseLegendTextPaint = SerialUtilities.readPaint(objectInputStream);
        this.listenerList = new EventListenerList();
    }

    public Boolean getSeriesVisible() {
        return this.seriesVisible;
    }

    public void setSeriesVisible(Boolean bl) {
        this.setSeriesVisible(bl, true);
    }

    public void setSeriesVisible(Boolean bl, boolean bl2) {
        this.seriesVisible = bl;
        if (bl2) {
            RendererChangeEvent rendererChangeEvent = new RendererChangeEvent((Object)this, true);
            this.notifyListeners(rendererChangeEvent);
        }
    }

    public Boolean getSeriesVisibleInLegend() {
        return this.seriesVisibleInLegend;
    }

    public void setSeriesVisibleInLegend(Boolean bl) {
        this.setSeriesVisibleInLegend(bl, true);
    }

    public void setSeriesVisibleInLegend(Boolean bl, boolean bl2) {
        this.seriesVisibleInLegend = bl;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void setPaint(Paint paint) {
        this.setPaint(paint, true);
    }

    public void setPaint(Paint paint, boolean bl) {
        this.paint = paint;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void setFillPaint(Paint paint) {
        this.setFillPaint(paint, true);
    }

    public void setFillPaint(Paint paint, boolean bl) {
        this.fillPaint = paint;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void setOutlinePaint(Paint paint) {
        this.setOutlinePaint(paint, true);
    }

    public void setOutlinePaint(Paint paint, boolean bl) {
        this.outlinePaint = paint;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void setStroke(Stroke stroke) {
        this.setStroke(stroke, true);
    }

    public void setStroke(Stroke stroke, boolean bl) {
        this.stroke = stroke;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void setOutlineStroke(Stroke stroke) {
        this.setOutlineStroke(stroke, true);
    }

    public void setOutlineStroke(Stroke stroke, boolean bl) {
        this.outlineStroke = stroke;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void setShape(Shape shape) {
        this.setShape(shape, true);
    }

    public void setShape(Shape shape, boolean bl) {
        this.shape = shape;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void setItemLabelsVisible(boolean bl) {
        this.setItemLabelsVisible((Boolean)bl);
    }

    public void setItemLabelsVisible(Boolean bl) {
        this.setItemLabelsVisible(bl, true);
    }

    public void setItemLabelsVisible(Boolean bl, boolean bl2) {
        this.itemLabelsVisible = bl;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Font getItemLabelFont() {
        return this.itemLabelFont;
    }

    public void setItemLabelFont(Font font) {
        this.setItemLabelFont(font, true);
    }

    public void setItemLabelFont(Font font, boolean bl) {
        this.itemLabelFont = font;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Paint getItemLabelPaint() {
        return this.itemLabelPaint;
    }

    public void setItemLabelPaint(Paint paint) {
        this.setItemLabelPaint(paint, true);
    }

    public void setItemLabelPaint(Paint paint, boolean bl) {
        this.itemLabelPaint = paint;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getPositiveItemLabelPosition() {
        return this.positiveItemLabelPosition;
    }

    public void setPositiveItemLabelPosition(ItemLabelPosition itemLabelPosition) {
        this.setPositiveItemLabelPosition(itemLabelPosition, true);
    }

    public void setPositiveItemLabelPosition(ItemLabelPosition itemLabelPosition, boolean bl) {
        this.positiveItemLabelPosition = itemLabelPosition;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getNegativeItemLabelPosition() {
        return this.negativeItemLabelPosition;
    }

    public void setNegativeItemLabelPosition(ItemLabelPosition itemLabelPosition) {
        this.setNegativeItemLabelPosition(itemLabelPosition, true);
    }

    public void setNegativeItemLabelPosition(ItemLabelPosition itemLabelPosition, boolean bl) {
        this.negativeItemLabelPosition = itemLabelPosition;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Boolean getCreateEntities() {
        return this.createEntities;
    }

    public void setCreateEntities(Boolean bl) {
        this.setCreateEntities(bl, true);
    }

    public void setCreateEntities(Boolean bl, boolean bl2) {
        this.createEntities = bl;
        if (bl2) {
            this.fireChangeEvent();
        }
    }
}

