/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.geom.Point2D;
import org.jfree.chart.plot.PlotOrientation;

public class CrosshairState {
    private boolean calculateDistanceInDataSpace = false;
    private double anchorX;
    private double anchorY;
    private Point2D anchor;
    private double crosshairX;
    private double crosshairY;
    private int datasetIndex;
    private int domainAxisIndex;
    private int rangeAxisIndex;
    private double distance;

    public CrosshairState() {
        this(false);
    }

    public CrosshairState(boolean bl) {
        this.calculateDistanceInDataSpace = bl;
    }

    public double getCrosshairDistance() {
        return this.distance;
    }

    public void setCrosshairDistance(double d) {
        this.distance = d;
    }

    public void updateCrosshairPoint(double d, double d2, double d3, double d4, PlotOrientation plotOrientation) {
        this.updateCrosshairPoint(d, d2, 0, 0, d3, d4, plotOrientation);
    }

    public void updateCrosshairPoint(double d, double d2, int n, int n2, double d3, double d4, PlotOrientation plotOrientation) {
        if (this.anchor != null) {
            double d5 = 0.0;
            if (this.calculateDistanceInDataSpace) {
                d5 = (d - this.anchorX) * (d - this.anchorX) + (d2 - this.anchorY) * (d2 - this.anchorY);
            } else {
                double d6 = this.anchor.getX();
                double d7 = this.anchor.getY();
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    double d8 = d7;
                    d7 = d6;
                    d6 = d8;
                }
                d5 = (d3 - d6) * (d3 - d6) + (d4 - d7) * (d4 - d7);
            }
            if (d5 < this.distance) {
                this.crosshairX = d;
                this.crosshairY = d2;
                this.domainAxisIndex = n;
                this.rangeAxisIndex = n2;
                this.distance = d5;
            }
        }
    }

    public void updateCrosshairX(double d) {
        this.updateCrosshairX(d, 0);
    }

    public void updateCrosshairX(double d, int n) {
        double d2 = Math.abs(d - this.anchorX);
        if (d2 < this.distance) {
            this.crosshairX = d;
            this.domainAxisIndex = n;
            this.distance = d2;
        }
    }

    public void updateCrosshairY(double d) {
        this.updateCrosshairY(d, 0);
    }

    public void updateCrosshairY(double d, int n) {
        double d2 = Math.abs(d - this.anchorY);
        if (d2 < this.distance) {
            this.crosshairY = d;
            this.rangeAxisIndex = n;
            this.distance = d2;
        }
    }

    public Point2D getAnchor() {
        return this.anchor;
    }

    public void setAnchor(Point2D point2D) {
        this.anchor = point2D;
    }

    public double getAnchorX() {
        return this.anchorX;
    }

    public void setAnchorX(double d) {
        this.anchorX = d;
    }

    public double getAnchorY() {
        return this.anchorY;
    }

    public void setAnchorY(double d) {
        this.anchorY = d;
    }

    public double getCrosshairX() {
        return this.crosshairX;
    }

    public void setCrosshairX(double d) {
        this.crosshairX = d;
    }

    public double getCrosshairY() {
        return this.crosshairY;
    }

    public void setCrosshairY(double d) {
        this.crosshairY = d;
    }

    public int getDatasetIndex() {
        return this.datasetIndex;
    }

    public void setDatasetIndex(int n) {
        this.datasetIndex = n;
    }

    public int getDomainAxisIndex() {
        return this.domainAxisIndex;
    }

    public int getRangeAxisIndex() {
        return this.rangeAxisIndex;
    }
}

