/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ShadowGenerator;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;

public class CombinedRangeXYPlot
extends XYPlot
implements PlotChangeListener {
    private static final long serialVersionUID = -5177814085082031168L;
    private List<XYPlot> subplots = new ArrayList<XYPlot>();
    private double gap = 5.0;
    private transient Rectangle2D[] subplotAreas;

    public CombinedRangeXYPlot() {
        this(new NumberAxis());
    }

    public CombinedRangeXYPlot(ValueAxis valueAxis) {
        super(null, null, valueAxis, null);
    }

    @Override
    public String getPlotType() {
        return localizationResources.getString("Combined_Range_XYPlot");
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double d) {
        this.gap = d;
    }

    @Override
    public boolean isDomainPannable() {
        for (XYPlot xYPlot : this.subplots) {
            if (!xYPlot.isDomainPannable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDomainPannable(boolean bl) {
        for (XYPlot xYPlot : this.subplots) {
            xYPlot.setDomainPannable(bl);
        }
    }

    public void add(XYPlot xYPlot) {
        this.add(xYPlot, 1);
    }

    public void add(XYPlot xYPlot, int n) {
        ParamChecks.nullNotPermitted(xYPlot, "subplot");
        if (n <= 0) {
            String string = "The 'weight' must be positive.";
            throw new IllegalArgumentException(string);
        }
        xYPlot.setParent(this);
        xYPlot.setWeight(n);
        xYPlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        xYPlot.setRangeAxis(null);
        xYPlot.addChangeListener(this);
        this.subplots.add(xYPlot);
        this.configureRangeAxes();
        this.fireChangeEvent();
    }

    public void remove(XYPlot xYPlot) {
        ParamChecks.nullNotPermitted(xYPlot, "subplot");
        int n = -1;
        int n2 = this.subplots.size();
        for (int i = 0; n == -1 && i < n2; ++i) {
            if (this.subplots.get(i) != xYPlot) continue;
            n = i;
        }
        if (n != -1) {
            this.subplots.remove(n);
            xYPlot.setParent(null);
            xYPlot.removeChangeListener(this);
            this.configureRangeAxes();
            this.fireChangeEvent();
        }
    }

    public List getSubplots() {
        if (this.subplots != null) {
            return Collections.unmodifiableList(this.subplots);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Cloneable cloneable;
        AxisSpace axisSpace = new AxisSpace();
        PlotOrientation plotOrientation = this.getOrientation();
        AxisSpace axisSpace2 = this.getFixedRangeAxisSpace();
        if (axisSpace2 != null) {
            if (plotOrientation == PlotOrientation.VERTICAL) {
                axisSpace.setLeft(axisSpace2.getLeft());
                axisSpace.setRight(axisSpace2.getRight());
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                axisSpace.setTop(axisSpace2.getTop());
                axisSpace.setBottom(axisSpace2.getBottom());
            }
        } else {
            cloneable = this.getRangeAxis();
            RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), plotOrientation);
            if (cloneable != null) {
                axisSpace = ((ValueAxis)cloneable).reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        cloneable = axisSpace.shrink(rectangle2D, null);
        int n = this.subplots.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            XYPlot xYPlot = this.subplots.get(i);
            n2 += xYPlot.getWeight();
        }
        this.subplotAreas = new Rectangle2D[n];
        double d = ((RectangularShape)cloneable).getX();
        double d2 = ((RectangularShape)cloneable).getY();
        double d3 = 0.0;
        if (plotOrientation == PlotOrientation.VERTICAL) {
            d3 = ((RectangularShape)cloneable).getWidth() - this.gap * (double)(n - 1);
        } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d3 = ((RectangularShape)cloneable).getHeight() - this.gap * (double)(n - 1);
        }
        for (int i = 0; i < n; ++i) {
            XYPlot xYPlot = this.subplots.get(i);
            if (plotOrientation == PlotOrientation.VERTICAL) {
                double d4 = d3 * (double)xYPlot.getWeight() / (double)n2;
                this.subplotAreas[i] = new Rectangle2D.Double(d, d2, d4, ((RectangularShape)cloneable).getHeight());
                d = d + d4 + this.gap;
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double d5 = d3 * (double)xYPlot.getWeight() / (double)n2;
                this.subplotAreas[i] = new Rectangle2D.Double(d, d2, ((RectangularShape)cloneable).getWidth(), d5);
                d2 = d2 + d5 + this.gap;
            }
            AxisSpace axisSpace3 = xYPlot.calculateDomainAxisSpace(graphics2D, this.subplotAreas[i], null);
            axisSpace.ensureAtLeast(axisSpace3);
        }
        return axisSpace;
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.setFixedDomainAxisSpaceForSubplots(axisSpace);
        ValueAxis valueAxis = this.getRangeAxis();
        RectangleEdge rectangleEdge = this.getRangeAxisEdge();
        double d = RectangleEdge.coordinate(rectangle2D2, rectangleEdge);
        AxisState axisState = valueAxis.draw(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge, plotRenderingInfo);
        if (plotState == null) {
            plotState = new PlotState();
        }
        plotState.getSharedAxisStates().put(valueAxis, axisState);
        for (int i = 0; i < this.subplots.size(); ++i) {
            XYPlot xYPlot = this.subplots.get(i);
            PlotRenderingInfo plotRenderingInfo2 = null;
            if (plotRenderingInfo != null) {
                plotRenderingInfo2 = new PlotRenderingInfo(plotRenderingInfo.getOwner());
                plotRenderingInfo.addSubplotInfo(plotRenderingInfo2);
            }
            xYPlot.draw(graphics2D, this.subplotAreas[i], point2D, plotState, plotRenderingInfo2);
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
    }

    @Override
    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = this.getFixedLegendItems();
        if (legendItemCollection == null) {
            legendItemCollection = new LegendItemCollection();
            if (this.subplots != null) {
                for (XYPlot xYPlot : this.subplots) {
                    LegendItemCollection legendItemCollection2 = xYPlot.getLegendItems();
                    legendItemCollection.addAll(legendItemCollection2);
                }
            }
        }
        return legendItemCollection;
    }

    @Override
    public void zoomDomainAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.zoomDomainAxes(d, plotRenderingInfo, point2D, false);
    }

    @Override
    public void zoomDomainAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl) {
        XYPlot xYPlot2 = this.findSubplot(plotRenderingInfo, point2D);
        if (xYPlot2 != null) {
            xYPlot2.zoomDomainAxes(d, plotRenderingInfo, point2D, bl);
        } else {
            for (XYPlot xYPlot2 : this.getSubplots()) {
                xYPlot2.zoomDomainAxes(d, plotRenderingInfo, point2D, bl);
            }
        }
    }

    @Override
    public void zoomDomainAxes(double d, double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        XYPlot xYPlot2 = this.findSubplot(plotRenderingInfo, point2D);
        if (xYPlot2 != null) {
            xYPlot2.zoomDomainAxes(d, d2, plotRenderingInfo, point2D);
        } else {
            for (XYPlot xYPlot2 : this.getSubplots()) {
                xYPlot2.zoomDomainAxes(d, d2, plotRenderingInfo, point2D);
            }
        }
    }

    @Override
    public void panDomainAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        XYPlot xYPlot = this.findSubplot(plotRenderingInfo, point2D);
        if (xYPlot == null) {
            return;
        }
        if (!xYPlot.isDomainPannable()) {
            return;
        }
        PlotRenderingInfo plotRenderingInfo2 = plotRenderingInfo.getSubplotInfo(plotRenderingInfo.getSubplotIndex(point2D));
        if (plotRenderingInfo2 == null) {
            return;
        }
        for (int i = 0; i < xYPlot.getDomainAxisCount(); ++i) {
            ValueAxis valueAxis = xYPlot.getDomainAxis(i);
            if (valueAxis == null) continue;
            valueAxis.pan(d);
        }
    }

    public XYPlot findSubplot(PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        ParamChecks.nullNotPermitted(plotRenderingInfo, "info");
        ParamChecks.nullNotPermitted(point2D, "source");
        XYPlot xYPlot = null;
        int n = plotRenderingInfo.getSubplotIndex(point2D);
        if (n >= 0) {
            xYPlot = this.subplots.get(n);
        }
        return xYPlot;
    }

    @Override
    public void setRenderer(XYItemRenderer xYItemRenderer) {
        super.setRenderer(xYItemRenderer);
        for (XYPlot xYPlot : this.subplots) {
            xYPlot.setRenderer(xYItemRenderer);
        }
    }

    @Override
    public void setOrientation(PlotOrientation plotOrientation) {
        super.setOrientation(plotOrientation);
        for (XYPlot xYPlot : this.subplots) {
            xYPlot.setOrientation(plotOrientation);
        }
    }

    @Override
    public void setShadowGenerator(ShadowGenerator shadowGenerator) {
        this.setNotify(false);
        super.setShadowGenerator(shadowGenerator);
        for (XYPlot xYPlot : this.subplots) {
            xYPlot.setShadowGenerator(shadowGenerator);
        }
        this.setNotify(true);
    }

    @Override
    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (this.subplots != null) {
            for (XYPlot xYPlot : this.subplots) {
                range = Range.combine(range, xYPlot.getDataRange(valueAxis));
            }
        }
        return range;
    }

    protected void setFixedDomainAxisSpaceForSubplots(AxisSpace axisSpace) {
        for (XYPlot xYPlot : this.subplots) {
            xYPlot.setFixedDomainAxisSpace(axisSpace, false);
        }
    }

    @Override
    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n, n2)) {
            for (int i = 0; i < this.subplots.size(); ++i) {
                XYPlot xYPlot = this.subplots.get(i);
                PlotRenderingInfo plotRenderingInfo2 = plotRenderingInfo.getSubplotInfo(i);
                xYPlot.handleClick(n, n2, plotRenderingInfo2);
            }
        }
    }

    @Override
    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        this.notifyListeners(plotChangeEvent);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CombinedRangeXYPlot)) {
            return false;
        }
        CombinedRangeXYPlot combinedRangeXYPlot = (CombinedRangeXYPlot)object;
        if (this.gap != combinedRangeXYPlot.gap) {
            return false;
        }
        if (!ObjectUtilities.equal(this.subplots, combinedRangeXYPlot.subplots)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CombinedRangeXYPlot combinedRangeXYPlot = (CombinedRangeXYPlot)super.clone();
        combinedRangeXYPlot.subplots = (List)ObjectUtilities.deepClone(this.subplots);
        for (Plot plot : combinedRangeXYPlot.subplots) {
            plot.setParent(combinedRangeXYPlot);
        }
        ValueAxis valueAxis = combinedRangeXYPlot.getRangeAxis();
        if (valueAxis != null) {
            valueAxis.configure();
        }
        return combinedRangeXYPlot;
    }
}

