/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.MessageFormat;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class StandardXYSeriesLabelGenerator
implements XYSeriesLabelGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 1916017081848400024L;
    public static final String DEFAULT_LABEL_FORMAT = "{0}";
    private String formatPattern;

    public StandardXYSeriesLabelGenerator() {
        this(DEFAULT_LABEL_FORMAT);
    }

    public StandardXYSeriesLabelGenerator(String string) {
        ParamChecks.nullNotPermitted(string, "format");
        this.formatPattern = string;
    }

    @Override
    public String generateLabel(XYDataset xYDataset, int n) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        String string = MessageFormat.format(this.formatPattern, this.createItemArray(xYDataset, n));
        return string;
    }

    protected Object[] createItemArray(XYDataset xYDataset, int n) {
        Object[] objectArray = new Object[]{xYDataset.getSeriesKey(n).toString()};
        return objectArray;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardXYSeriesLabelGenerator)) {
            return false;
        }
        StandardXYSeriesLabelGenerator standardXYSeriesLabelGenerator = (StandardXYSeriesLabelGenerator)object;
        return this.formatPattern.equals(standardXYSeriesLabelGenerator.formatPattern);
    }

    public int hashCode() {
        int n = 127;
        n = HashUtilities.hashCode(n, this.formatPattern);
        return n;
    }
}

