/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.util.ParamChecks;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class StandardEntityCollection
implements EntityCollection,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 5384773031184897047L;
    private List entities = new ArrayList();

    @Override
    public int getEntityCount() {
        return this.entities.size();
    }

    @Override
    public ChartEntity getEntity(int n) {
        return (ChartEntity)this.entities.get(n);
    }

    @Override
    public void clear() {
        this.entities.clear();
    }

    @Override
    public void add(ChartEntity chartEntity) {
        ParamChecks.nullNotPermitted(chartEntity, "entity");
        this.entities.add(chartEntity);
    }

    @Override
    public void addAll(EntityCollection entityCollection) {
        this.entities.addAll(entityCollection.getEntities());
    }

    @Override
    public ChartEntity getEntity(double d, double d2) {
        int n = this.entities.size();
        for (int i = n - 1; i >= 0; --i) {
            ChartEntity chartEntity = (ChartEntity)this.entities.get(i);
            if (!chartEntity.getArea().contains(d, d2)) continue;
            return chartEntity;
        }
        return null;
    }

    @Override
    public Collection getEntities() {
        return Collections.unmodifiableCollection(this.entities);
    }

    @Override
    public Iterator iterator() {
        return this.entities.iterator();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof StandardEntityCollection) {
            StandardEntityCollection standardEntityCollection = (StandardEntityCollection)object;
            return ObjectUtilities.equal(this.entities, standardEntityCollection.entities);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        StandardEntityCollection standardEntityCollection = (StandardEntityCollection)super.clone();
        standardEntityCollection.entities = new ArrayList(this.entities.size());
        for (int i = 0; i < this.entities.size(); ++i) {
            ChartEntity chartEntity = (ChartEntity)this.entities.get(i);
            standardEntityCollection.entities.add(chartEntity.clone());
        }
        return standardEntityCollection;
    }
}

