/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.awt.Shape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtilities;

public class PlotEntity
extends ChartEntity {
    private static final long serialVersionUID = -4445994133561919083L;
    private Plot plot;

    public PlotEntity(Shape shape, Plot plot) {
        this(shape, plot, null);
    }

    public PlotEntity(Shape shape, Plot plot, String string) {
        this(shape, plot, string, null);
    }

    public PlotEntity(Shape shape, Plot plot, String string, String string2) {
        super(shape, string, string2);
        ParamChecks.nullNotPermitted(plot, "plot");
        this.plot = plot;
    }

    public Plot getPlot() {
        return this.plot;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("PlotEntity: ");
        stringBuilder.append("tooltip = ");
        stringBuilder.append(this.getToolTipText());
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PlotEntity)) {
            return false;
        }
        PlotEntity plotEntity = (PlotEntity)object;
        if (!this.getArea().equals(plotEntity.getArea())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.getToolTipText(), plotEntity.getToolTipText())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.getURLText(), plotEntity.getURLText())) {
            return false;
        }
        return this.plot.equals(plotEntity.plot);
    }

    @Override
    public int hashCode() {
        int n = 39;
        n = HashUtilities.hashCode(n, this.getToolTipText());
        n = HashUtilities.hashCode(n, this.getURLText());
        return n;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.getArea(), objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setArea(SerialUtilities.readShape(objectInputStream));
    }
}

