/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.editor;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.editor.DefaultAxisEditor;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.PaintSample;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.StrokeChooserPanel;
import org.jfree.ui.StrokeSample;
import org.jfree.util.BooleanUtilities;

class DefaultPlotEditor
extends JPanel
implements ActionListener {
    private static final String[] orientationNames = new String[]{"Vertical", "Horizontal"};
    private static final int ORIENTATION_VERTICAL = 0;
    private static final int ORIENTATION_HORIZONTAL = 1;
    private PaintSample backgroundPaintSample;
    private StrokeSample outlineStrokeSample;
    private PaintSample outlinePaintSample;
    private DefaultAxisEditor domainAxisPropertyPanel;
    private DefaultAxisEditor rangeAxisPropertyPanel;
    private StrokeSample[] availableStrokeSamples;
    private RectangleInsets plotInsets;
    private PlotOrientation plotOrientation;
    private JComboBox orientationCombo;
    private Boolean drawLines;
    private JCheckBox drawLinesCheckBox;
    private Boolean drawShapes;
    private JCheckBox drawShapesCheckBox;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("org.jfree.chart.editor.LocalizationBundle");

    public DefaultPlotEditor(Plot plot) {
        JPanel jPanel = this.createPlotPanel(plot);
        this.add(jPanel);
    }

    protected JPanel createPlotPanel(Plot plot) {
        Serializable serializable;
        Object object;
        this.plotInsets = plot.getInsets();
        this.backgroundPaintSample = new PaintSample(plot.getBackgroundPaint());
        this.outlineStrokeSample = new StrokeSample(plot.getOutlineStroke());
        this.outlinePaintSample = new PaintSample(plot.getOutlinePaint());
        if (plot instanceof XYPlot) {
            this.plotOrientation = ((XYPlot)plot).getOrientation();
        }
        if (plot instanceof XYPlot && (object = ((XYPlot)plot).getRenderer()) instanceof StandardXYItemRenderer) {
            serializable = (StandardXYItemRenderer)object;
            this.drawLines = BooleanUtilities.valueOf(((StandardXYItemRenderer)serializable).getPlotLines());
            this.drawShapes = BooleanUtilities.valueOf(((StandardXYItemRenderer)serializable).getBaseShapesVisible());
        }
        this.setLayout(new BorderLayout());
        this.availableStrokeSamples = new StrokeSample[4];
        this.availableStrokeSamples[0] = new StrokeSample(null);
        this.availableStrokeSamples[1] = new StrokeSample(new BasicStroke(1.0f));
        this.availableStrokeSamples[2] = new StrokeSample(new BasicStroke(2.0f));
        this.availableStrokeSamples[3] = new StrokeSample(new BasicStroke(3.0f));
        object = new JPanel(new BorderLayout());
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), plot.getPlotType() + localizationResources.getString(":")));
        serializable = new JPanel(new BorderLayout());
        ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder(localizationResources.getString("General")));
        JPanel jPanel = new JPanel(new LCBLayout(7));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jPanel.add(new JLabel(localizationResources.getString("Outline_stroke")));
        JButton jButton = new JButton(localizationResources.getString("Select..."));
        jButton.setActionCommand("OutlineStroke");
        jButton.addActionListener(this);
        jPanel.add(this.outlineStrokeSample);
        jPanel.add(jButton);
        jPanel.add(new JLabel(localizationResources.getString("Outline_Paint")));
        jButton = new JButton(localizationResources.getString("Select..."));
        jButton.setActionCommand("OutlinePaint");
        jButton.addActionListener(this);
        jPanel.add(this.outlinePaintSample);
        jPanel.add(jButton);
        jPanel.add(new JLabel(localizationResources.getString("Background_paint")));
        jButton = new JButton(localizationResources.getString("Select..."));
        jButton.setActionCommand("BackgroundPaint");
        jButton.addActionListener(this);
        jPanel.add(this.backgroundPaintSample);
        jPanel.add(jButton);
        if (this.plotOrientation != null) {
            boolean bl = this.plotOrientation.equals(PlotOrientation.VERTICAL);
            int n = bl ? 0 : 1;
            jPanel.add(new JLabel(localizationResources.getString("Orientation")));
            this.orientationCombo = new JComboBox<String>(orientationNames);
            this.orientationCombo.setSelectedIndex(n);
            this.orientationCombo.setActionCommand("Orientation");
            this.orientationCombo.addActionListener(this);
            jPanel.add(new JPanel());
            jPanel.add(this.orientationCombo);
        }
        if (this.drawLines != null) {
            jPanel.add(new JLabel(localizationResources.getString("Draw_lines")));
            this.drawLinesCheckBox = new JCheckBox();
            this.drawLinesCheckBox.setSelected(this.drawLines);
            this.drawLinesCheckBox.setActionCommand("DrawLines");
            this.drawLinesCheckBox.addActionListener(this);
            jPanel.add(new JPanel());
            jPanel.add(this.drawLinesCheckBox);
        }
        if (this.drawShapes != null) {
            jPanel.add(new JLabel(localizationResources.getString("Draw_shapes")));
            this.drawShapesCheckBox = new JCheckBox();
            this.drawShapesCheckBox.setSelected(this.drawShapes);
            this.drawShapesCheckBox.setActionCommand("DrawShapes");
            this.drawShapesCheckBox.addActionListener(this);
            jPanel.add(new JPanel());
            jPanel.add(this.drawShapesCheckBox);
        }
        ((Container)serializable).add(jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel2.add((Component)serializable, "North");
        JTabbedPane jTabbedPane = this.createPlotTabs(plot);
        jTabbedPane.add(localizationResources.getString("Appearance"), jPanel2);
        ((Container)object).add(jTabbedPane);
        return object;
    }

    protected JTabbedPane createPlotTabs(Plot plot) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        ValueAxis valueAxis = null;
        if (plot instanceof XYPlot) {
            valueAxis = ((XYPlot)plot).getDomainAxis();
        }
        this.domainAxisPropertyPanel = DefaultAxisEditor.getInstance(valueAxis);
        if (this.domainAxisPropertyPanel != null) {
            this.domainAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            jTabbedPane.add(localizationResources.getString("Domain_Axis"), this.domainAxisPropertyPanel);
        }
        ValueAxis valueAxis2 = null;
        if (plot instanceof XYPlot) {
            valueAxis2 = ((XYPlot)plot).getRangeAxis();
        }
        this.rangeAxisPropertyPanel = DefaultAxisEditor.getInstance(valueAxis2);
        if (this.rangeAxisPropertyPanel != null) {
            this.rangeAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            jTabbedPane.add(localizationResources.getString("Range_Axis"), this.rangeAxisPropertyPanel);
        }
        return jTabbedPane;
    }

    public RectangleInsets getPlotInsets() {
        if (this.plotInsets == null) {
            this.plotInsets = new RectangleInsets(0.0, 0.0, 0.0, 0.0);
        }
        return this.plotInsets;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaintSample.getPaint();
    }

    public Stroke getOutlineStroke() {
        return this.outlineStrokeSample.getStroke();
    }

    public Paint getOutlinePaint() {
        return this.outlinePaintSample.getPaint();
    }

    public DefaultAxisEditor getDomainAxisPropertyEditPanel() {
        return this.domainAxisPropertyPanel;
    }

    public DefaultAxisEditor getRangeAxisPropertyEditPanel() {
        return this.rangeAxisPropertyPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("BackgroundPaint")) {
            this.attemptBackgroundPaintSelection();
        } else if (string.equals("OutlineStroke")) {
            this.attemptOutlineStrokeSelection();
        } else if (string.equals("OutlinePaint")) {
            this.attemptOutlinePaintSelection();
        } else if (string.equals("Orientation")) {
            this.attemptOrientationSelection();
        } else if (string.equals("DrawLines")) {
            this.attemptDrawLinesSelection();
        } else if (string.equals("DrawShapes")) {
            this.attemptDrawShapesSelection();
        }
    }

    private void attemptBackgroundPaintSelection() {
        Color color = JColorChooser.showDialog(this, localizationResources.getString("Background_Color"), Color.blue);
        if (color != null) {
            this.backgroundPaintSample.setPaint(color);
        }
    }

    private void attemptOutlineStrokeSelection() {
        StrokeChooserPanel strokeChooserPanel = new StrokeChooserPanel(this.outlineStrokeSample, this.availableStrokeSamples);
        int n = JOptionPane.showConfirmDialog(this, strokeChooserPanel, localizationResources.getString("Stroke_Selection"), 2, -1);
        if (n == 0) {
            this.outlineStrokeSample.setStroke(strokeChooserPanel.getSelectedStroke());
        }
    }

    private void attemptOutlinePaintSelection() {
        Color color = JColorChooser.showDialog(this, localizationResources.getString("Outline_Color"), Color.blue);
        if (color != null) {
            this.outlinePaintSample.setPaint(color);
        }
    }

    private void attemptOrientationSelection() {
        int n = this.orientationCombo.getSelectedIndex();
        this.plotOrientation = n == 0 ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL;
    }

    private void attemptDrawLinesSelection() {
        this.drawLines = BooleanUtilities.valueOf(this.drawLinesCheckBox.isSelected());
    }

    private void attemptDrawShapesSelection() {
        this.drawShapes = BooleanUtilities.valueOf(this.drawShapesCheckBox.isSelected());
    }

    public void updatePlotProperties(Plot plot) {
        LegendItemSource legendItemSource;
        Serializable serializable;
        plot.setOutlinePaint(this.getOutlinePaint());
        plot.setOutlineStroke(this.getOutlineStroke());
        plot.setBackgroundPaint(this.getBackgroundPaint());
        plot.setInsets(this.getPlotInsets());
        if (this.domainAxisPropertyPanel != null) {
            serializable = null;
            if (plot instanceof XYPlot) {
                legendItemSource = (XYPlot)plot;
                serializable = legendItemSource.getDomainAxis();
            }
            if (serializable != null) {
                this.domainAxisPropertyPanel.setAxisProperties((Axis)serializable);
            }
        }
        if (this.rangeAxisPropertyPanel != null) {
            serializable = null;
            if (plot instanceof XYPlot) {
                legendItemSource = (XYPlot)plot;
                serializable = legendItemSource.getRangeAxis();
            }
            if (serializable != null) {
                this.rangeAxisPropertyPanel.setAxisProperties((Axis)serializable);
            }
        }
        if (this.plotOrientation != null && plot instanceof XYPlot) {
            serializable = (XYPlot)plot;
            ((XYPlot)serializable).setOrientation(this.plotOrientation);
        }
        if (this.drawLines != null && plot instanceof XYPlot && (legendItemSource = ((XYPlot)(serializable = (XYPlot)plot)).getRenderer()) instanceof StandardXYItemRenderer) {
            ((StandardXYItemRenderer)legendItemSource).setPlotLines(this.drawLines);
        }
        if (this.drawShapes != null && plot instanceof XYPlot && (legendItemSource = ((XYPlot)(serializable = (XYPlot)plot)).getRenderer()) instanceof StandardXYItemRenderer) {
            ((StandardXYItemRenderer)legendItemSource).setBaseShapesVisible(this.drawShapes);
        }
    }
}

