/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.editor;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.editor.DefaultValueAxisEditor;

public class DefaultLogAxisEditor
extends DefaultValueAxisEditor {
    private double manualTickUnitValue;
    private JTextField manualTickUnit;

    public DefaultLogAxisEditor(LogAxis logAxis) {
        super(logAxis);
        this.manualTickUnitValue = logAxis.getTickUnit().getSize();
        this.manualTickUnit.setText(Double.toString(this.manualTickUnitValue));
    }

    @Override
    protected JPanel createTickUnitPanel() {
        JPanel jPanel = super.createTickUnitPanel();
        jPanel.add(new JLabel(localizationResources.getString("Manual_TickUnit_value")));
        this.manualTickUnit = new JTextField(Double.toString(this.manualTickUnitValue));
        this.manualTickUnit.setEnabled(!this.isAutoTickUnitSelection());
        this.manualTickUnit.setActionCommand("TickUnitValue");
        this.manualTickUnit.addActionListener(this);
        this.manualTickUnit.addFocusListener(this);
        jPanel.add(this.manualTickUnit);
        jPanel.add(new JPanel());
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("TickUnitValue")) {
            this.validateTickUnit();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        if (focusEvent.getSource() == this.manualTickUnit) {
            this.validateTickUnit();
        }
    }

    @Override
    public void toggleAutoTick() {
        super.toggleAutoTick();
        if (this.isAutoTickUnitSelection()) {
            this.manualTickUnit.setText(Double.toString(this.manualTickUnitValue));
            this.manualTickUnit.setEnabled(false);
        } else {
            this.manualTickUnit.setEnabled(true);
        }
    }

    public void validateTickUnit() {
        double d;
        try {
            d = Double.parseDouble(this.manualTickUnit.getText());
        }
        catch (NumberFormatException numberFormatException) {
            d = this.manualTickUnitValue;
        }
        if (d > 0.0) {
            this.manualTickUnitValue = d;
        }
        this.manualTickUnit.setText(Double.toString(this.manualTickUnitValue));
    }

    @Override
    public void setAxisProperties(Axis axis) {
        super.setAxisProperties(axis);
        LogAxis logAxis = (LogAxis)axis;
        if (!this.isAutoTickUnitSelection()) {
            logAxis.setTickUnit(new NumberTickUnit(this.manualTickUnitValue));
        }
    }
}

