/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.PaintUtilities;

public class BlockBorder
implements BlockFrame,
Serializable {
    private static final long serialVersionUID = 4961579220410228283L;
    public static final BlockBorder NONE = new BlockBorder(RectangleInsets.ZERO_INSETS, Color.white);
    private RectangleInsets insets;
    private transient Paint paint;

    public BlockBorder() {
        this(Color.black);
    }

    public BlockBorder(Paint paint) {
        this(new RectangleInsets(1.0, 1.0, 1.0, 1.0), paint);
    }

    public BlockBorder(double d, double d2, double d3, double d4) {
        this(new RectangleInsets(d, d2, d3, d4), Color.black);
    }

    public BlockBorder(double d, double d2, double d3, double d4, Paint paint) {
        this(new RectangleInsets(d, d2, d3, d4), paint);
    }

    public BlockBorder(RectangleInsets rectangleInsets, Paint paint) {
        ParamChecks.nullNotPermitted(rectangleInsets, "insets");
        ParamChecks.nullNotPermitted(paint, "paint");
        this.insets = rectangleInsets;
        this.paint = paint;
    }

    @Override
    public RectangleInsets getInsets() {
        return this.insets;
    }

    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d = this.insets.calculateTopInset(rectangle2D.getHeight());
        double d2 = this.insets.calculateBottomInset(rectangle2D.getHeight());
        double d3 = this.insets.calculateLeftInset(rectangle2D.getWidth());
        double d4 = this.insets.calculateRightInset(rectangle2D.getWidth());
        double d5 = rectangle2D.getX();
        double d6 = rectangle2D.getY();
        double d7 = rectangle2D.getWidth();
        double d8 = rectangle2D.getHeight();
        graphics2D.setPaint(this.paint);
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        if (d > 0.0) {
            ((Rectangle2D)double_).setRect(d5, d6, d7, d);
            graphics2D.fill(double_);
        }
        if (d2 > 0.0) {
            ((Rectangle2D)double_).setRect(d5, d6 + d8 - d2, d7, d2);
            graphics2D.fill(double_);
        }
        if (d3 > 0.0) {
            ((Rectangle2D)double_).setRect(d5, d6, d3, d8);
            graphics2D.fill(double_);
        }
        if (d4 > 0.0) {
            ((Rectangle2D)double_).setRect(d5 + d7 - d4, d6, d4, d8);
            graphics2D.fill(double_);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BlockBorder)) {
            return false;
        }
        BlockBorder blockBorder = (BlockBorder)object;
        if (!this.insets.equals(blockBorder.insets)) {
            return false;
        }
        return PaintUtilities.equal(this.paint, blockBorder.paint);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
    }
}

