/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.LogTick;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.TickType;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.util.AttrStringUtils;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public abstract class ValueAxis
extends Axis
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 3698345477322391456L;
    public static final Range DEFAULT_RANGE = new Range(0.0, 1.0);
    public static final boolean DEFAULT_AUTO_RANGE = true;
    public static final boolean DEFAULT_INVERTED = false;
    public static final double DEFAULT_AUTO_RANGE_MINIMUM_SIZE = 1.0E-8;
    public static final double DEFAULT_LOWER_MARGIN = 0.05;
    public static final double DEFAULT_UPPER_MARGIN = 0.05;
    public static final double DEFAULT_LOWER_BOUND = 0.0;
    public static final double DEFAULT_UPPER_BOUND = 1.0;
    public static final boolean DEFAULT_AUTO_TICK_UNIT_SELECTION = true;
    public static final int MAXIMUM_TICK_COUNT = 500;
    private boolean positiveArrowVisible = false;
    private boolean negativeArrowVisible = false;
    private transient Shape upArrow;
    private transient Shape downArrow;
    private transient Shape leftArrow;
    private transient Shape rightArrow;
    private boolean inverted = false;
    private Range range = DEFAULT_RANGE;
    private boolean autoRange = true;
    private double autoRangeMinimumSize = 1.0E-8;
    private Range defaultAutoRange = DEFAULT_RANGE;
    private double upperMargin = 0.05;
    private double lowerMargin = 0.05;
    private double fixedAutoRange = 0.0;
    private boolean autoTickUnitSelection = true;
    private TickUnitSource standardTickUnits;
    private int autoTickIndex;
    private int minorTickCount;
    private boolean verticalTickLabels;

    protected ValueAxis(String string, TickUnitSource tickUnitSource) {
        super(string);
        this.standardTickUnits = tickUnitSource;
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(-2, 2);
        polygon.addPoint(2, 2);
        this.upArrow = polygon;
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(0, 0);
        polygon2.addPoint(-2, -2);
        polygon2.addPoint(2, -2);
        this.downArrow = polygon2;
        Polygon polygon3 = new Polygon();
        polygon3.addPoint(0, 0);
        polygon3.addPoint(-2, -2);
        polygon3.addPoint(-2, 2);
        this.rightArrow = polygon3;
        Polygon polygon4 = new Polygon();
        polygon4.addPoint(0, 0);
        polygon4.addPoint(2, -2);
        polygon4.addPoint(2, 2);
        this.leftArrow = polygon4;
        this.verticalTickLabels = false;
        this.minorTickCount = 0;
    }

    public boolean isVerticalTickLabels() {
        return this.verticalTickLabels;
    }

    public void setVerticalTickLabels(boolean bl) {
        if (this.verticalTickLabels != bl) {
            this.verticalTickLabels = bl;
            this.fireChangeEvent();
        }
    }

    public boolean isPositiveArrowVisible() {
        return this.positiveArrowVisible;
    }

    public void setPositiveArrowVisible(boolean bl) {
        this.positiveArrowVisible = bl;
        this.fireChangeEvent();
    }

    public boolean isNegativeArrowVisible() {
        return this.negativeArrowVisible;
    }

    public void setNegativeArrowVisible(boolean bl) {
        this.negativeArrowVisible = bl;
        this.fireChangeEvent();
    }

    public Shape getUpArrow() {
        return this.upArrow;
    }

    public void setUpArrow(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "arrow");
        this.upArrow = shape;
        this.fireChangeEvent();
    }

    public Shape getDownArrow() {
        return this.downArrow;
    }

    public void setDownArrow(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "arrow");
        this.downArrow = shape;
        this.fireChangeEvent();
    }

    public Shape getLeftArrow() {
        return this.leftArrow;
    }

    public void setLeftArrow(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "arrow");
        this.leftArrow = shape;
        this.fireChangeEvent();
    }

    public Shape getRightArrow() {
        return this.rightArrow;
    }

    public void setRightArrow(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "arrow");
        this.rightArrow = shape;
        this.fireChangeEvent();
    }

    @Override
    protected void drawAxisLine(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Shape shape;
        AffineTransform affineTransform;
        Shape shape2;
        double d2;
        double d3;
        Line2D.Double double_ = null;
        double d4 = d;
        if (rectangleEdge == RectangleEdge.TOP) {
            double_ = new Line2D.Double(rectangle2D.getX(), d4, rectangle2D.getMaxX(), d4);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            double_ = new Line2D.Double(rectangle2D.getX(), d4, rectangle2D.getMaxX(), d4);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            double_ = new Line2D.Double(d4, rectangle2D.getY(), d4, rectangle2D.getMaxY());
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            double_ = new Line2D.Double(d4, rectangle2D.getY(), d4, rectangle2D.getMaxY());
        }
        graphics2D.setPaint(this.getAxisLinePaint());
        graphics2D.setStroke(this.getAxisLineStroke());
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.draw(double_);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
        boolean bl = false;
        boolean bl2 = false;
        if (this.positiveArrowVisible) {
            if (this.inverted) {
                bl2 = true;
            } else {
                bl = true;
            }
        }
        if (this.negativeArrowVisible) {
            if (this.inverted) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        if (bl) {
            d3 = 0.0;
            d2 = 0.0;
            shape2 = null;
            if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                d3 = rectangle2D.getMaxX();
                d2 = d;
                shape2 = this.rightArrow;
            } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                d3 = d;
                d2 = rectangle2D.getMinY();
                shape2 = this.upArrow;
            }
            affineTransform = new AffineTransform();
            affineTransform.setToTranslation(d3, d2);
            shape = affineTransform.createTransformedShape(shape2);
            graphics2D.fill(shape);
            graphics2D.draw(shape);
        }
        if (bl2) {
            d3 = 0.0;
            d2 = 0.0;
            shape2 = null;
            if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                d3 = rectangle2D.getMinX();
                d2 = d;
                shape2 = this.leftArrow;
            } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                d3 = d;
                d2 = rectangle2D.getMaxY();
                shape2 = this.downArrow;
            }
            affineTransform = new AffineTransform();
            affineTransform.setToTranslation(d3, d2);
            shape = affineTransform.createTransformedShape(shape2);
            graphics2D.fill(shape);
            graphics2D.draw(shape);
        }
    }

    protected float[] calculateAnchorPoint(ValueTick valueTick, double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        float[] fArray = new float[2];
        if (rectangleEdge == RectangleEdge.TOP) {
            fArray[0] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
            fArray[1] = (float)(d - rectangleInsets.getBottom() - 2.0);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            fArray[0] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
            fArray[1] = (float)(d + rectangleInsets.getTop() + 2.0);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            fArray[0] = (float)(d - rectangleInsets.getLeft() - 2.0);
            fArray[1] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            fArray[0] = (float)(d + rectangleInsets.getRight() + 2.0);
            fArray[1] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
        }
        return fArray;
    }

    protected AxisState drawTickMarksAndLabels(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        AxisState axisState = new AxisState(d);
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d, rectangle2D2, rectangleEdge);
        }
        List list = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
        axisState.setTicks(list);
        graphics2D.setFont(this.getTickLabelFont());
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        for (ValueTick valueTick : list) {
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                float[] fArray = this.calculateAnchorPoint(valueTick, d, rectangle2D2, rectangleEdge);
                if (valueTick instanceof LogTick) {
                    LogTick logTick = (LogTick)valueTick;
                    if (logTick.getAttributedLabel() == null) continue;
                    AttrStringUtils.drawRotatedString(logTick.getAttributedLabel(), graphics2D, fArray[0], fArray[1], valueTick.getTextAnchor(), valueTick.getAngle(), valueTick.getRotationAnchor());
                } else {
                    if (valueTick.getText() == null) continue;
                    TextUtilities.drawRotatedString(valueTick.getText(), graphics2D, fArray[0], fArray[1], valueTick.getTextAnchor(), valueTick.getAngle(), valueTick.getRotationAnchor());
                }
            }
            if ((!this.isTickMarksVisible() || !valueTick.getTickType().equals(TickType.MAJOR)) && (!this.isMinorTickMarksVisible() || !valueTick.getTickType().equals(TickType.MINOR))) continue;
            double d2 = valueTick.getTickType().equals(TickType.MINOR) ? (double)this.getMinorTickMarkOutsideLength() : (double)this.getTickMarkOutsideLength();
            double d3 = valueTick.getTickType().equals(TickType.MINOR) ? (double)this.getMinorTickMarkInsideLength() : (double)this.getTickMarkInsideLength();
            float f = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D2, rectangleEdge);
            Line2D.Double double_ = null;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            if (rectangleEdge == RectangleEdge.LEFT) {
                double_ = new Line2D.Double(d - d2, f, d + d3, f);
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                double_ = new Line2D.Double(d + d2, f, d - d3, f);
            } else if (rectangleEdge == RectangleEdge.TOP) {
                double_ = new Line2D.Double(f, d - d2, f, d + d3);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                double_ = new Line2D.Double(f, d + d2, f, d - d3);
            }
            graphics2D.draw(double_);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
        double d4 = 0.0;
        if (this.isTickLabelsVisible()) {
            if (rectangleEdge == RectangleEdge.LEFT) {
                axisState.cursorLeft(d4 += this.findMaximumTickLabelWidth(list, graphics2D, rectangle2D, this.isVerticalTickLabels()));
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                d4 = this.findMaximumTickLabelWidth(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorRight(d4);
            } else if (rectangleEdge == RectangleEdge.TOP) {
                d4 = this.findMaximumTickLabelHeight(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorUp(d4);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                d4 = this.findMaximumTickLabelHeight(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorDown(d4);
            }
        }
        return axisState;
    }

    @Override
    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        Object object;
        if (axisSpace == null) {
            axisSpace = new AxisSpace();
        }
        if (!this.isVisible()) {
            return axisSpace;
        }
        double d = this.getFixedDimension();
        if (d > 0.0) {
            axisSpace.add(d, rectangleEdge);
            return axisSpace;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            object = this.refreshTicks(graphics2D, new AxisState(), rectangle2D, rectangleEdge);
            if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
                d2 = this.findMaximumTickLabelHeight((List)object, graphics2D, rectangle2D, this.isVerticalTickLabels());
            } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
                d3 = this.findMaximumTickLabelWidth((List)object, graphics2D, rectangle2D, this.isVerticalTickLabels());
            }
        }
        object = this.getLabelEnclosure(graphics2D, rectangleEdge);
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            double d4 = ((RectangularShape)object).getHeight();
            axisSpace.add(d4 + d2, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            double d5 = ((RectangularShape)object).getWidth();
            axisSpace.add(d5 + d3, rectangleEdge);
        }
        return axisSpace;
    }

    protected double findMaximumTickLabelHeight(List list, Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        double d = 0.0;
        if (bl) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            for (Tick tick : list) {
                RectangularShape rectangularShape = null;
                if (tick instanceof LogTick) {
                    LogTick logTick = (LogTick)tick;
                    if (logTick.getAttributedLabel() != null) {
                        rectangularShape = AttrStringUtils.getTextBounds(logTick.getAttributedLabel(), graphics2D);
                    }
                } else if (tick.getText() != null) {
                    rectangularShape = TextUtilities.getTextBounds(tick.getText(), graphics2D, fontMetrics);
                }
                if (rectangularShape == null || !(rectangularShape.getWidth() + rectangleInsets.getTop() + rectangleInsets.getBottom() > d)) continue;
                d = rectangularShape.getWidth() + rectangleInsets.getTop() + rectangleInsets.getBottom();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", graphics2D.getFontRenderContext());
            d = (double)lineMetrics.getHeight() + rectangleInsets.getTop() + rectangleInsets.getBottom();
        }
        return d;
    }

    protected double findMaximumTickLabelWidth(List list, Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        Font font = this.getTickLabelFont();
        double d = 0.0;
        if (!bl) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            for (Tick tick : list) {
                RectangularShape rectangularShape = null;
                if (tick instanceof LogTick) {
                    LogTick logTick = (LogTick)tick;
                    if (logTick.getAttributedLabel() != null) {
                        rectangularShape = AttrStringUtils.getTextBounds(logTick.getAttributedLabel(), graphics2D);
                    }
                } else if (tick.getText() != null) {
                    rectangularShape = TextUtilities.getTextBounds(tick.getText(), graphics2D, fontMetrics);
                }
                if (rectangularShape == null || !(rectangularShape.getWidth() + rectangleInsets.getLeft() + rectangleInsets.getRight() > d)) continue;
                d = rectangularShape.getWidth() + rectangleInsets.getLeft() + rectangleInsets.getRight();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", graphics2D.getFontRenderContext());
            d = (double)lineMetrics.getHeight() + rectangleInsets.getTop() + rectangleInsets.getBottom();
        }
        return d;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean bl) {
        if (this.inverted != bl) {
            this.inverted = bl;
            this.fireChangeEvent();
        }
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public void setAutoRange(boolean bl) {
        this.setAutoRange(bl, true);
    }

    protected void setAutoRange(boolean bl, boolean bl2) {
        if (this.autoRange != bl) {
            this.autoRange = bl;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            if (bl2) {
                this.fireChangeEvent();
            }
        }
    }

    public double getAutoRangeMinimumSize() {
        return this.autoRangeMinimumSize;
    }

    public void setAutoRangeMinimumSize(double d) {
        this.setAutoRangeMinimumSize(d, true);
    }

    public void setAutoRangeMinimumSize(double d, boolean bl) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("NumberAxis.setAutoRangeMinimumSize(double): must be > 0.0.");
        }
        if (this.autoRangeMinimumSize != d) {
            this.autoRangeMinimumSize = d;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            if (bl) {
                this.fireChangeEvent();
            }
        }
    }

    public Range getDefaultAutoRange() {
        return this.defaultAutoRange;
    }

    public void setDefaultAutoRange(Range range) {
        ParamChecks.nullNotPermitted(range, "range");
        this.defaultAutoRange = range;
        this.fireChangeEvent();
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double d) {
        this.lowerMargin = d;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.fireChangeEvent();
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double d) {
        this.upperMargin = d;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.fireChangeEvent();
    }

    public double getFixedAutoRange() {
        return this.fixedAutoRange;
    }

    public void setFixedAutoRange(double d) {
        this.fixedAutoRange = d;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.fireChangeEvent();
    }

    public double getLowerBound() {
        return this.range.getLowerBound();
    }

    public void setLowerBound(double d) {
        if (this.range.getUpperBound() > d) {
            this.setRange(new Range(d, this.range.getUpperBound()));
        } else {
            this.setRange(new Range(d, d + 1.0));
        }
    }

    public double getUpperBound() {
        return this.range.getUpperBound();
    }

    public void setUpperBound(double d) {
        if (this.range.getLowerBound() < d) {
            this.setRange(new Range(this.range.getLowerBound(), d));
        } else {
            this.setRange(d - 1.0, d);
        }
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.setRange(range, true, true);
    }

    public void setRange(Range range, boolean bl, boolean bl2) {
        ParamChecks.nullNotPermitted(range, "range");
        if (range.getLength() <= 0.0) {
            throw new IllegalArgumentException("A positive range length is required: " + range);
        }
        if (bl) {
            this.autoRange = false;
        }
        this.range = range;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void setRange(double d, double d2) {
        this.setRange(new Range(d, d2));
    }

    public void setRangeWithMargins(Range range) {
        this.setRangeWithMargins(range, true, true);
    }

    public void setRangeWithMargins(Range range, boolean bl, boolean bl2) {
        ParamChecks.nullNotPermitted(range, "range");
        this.setRange(Range.expand(range, this.getLowerMargin(), this.getUpperMargin()), bl, bl2);
    }

    public void setRangeWithMargins(double d, double d2) {
        this.setRangeWithMargins(new Range(d, d2));
    }

    public void setRangeAboutValue(double d, double d2) {
        this.setRange(new Range(d - d2 / 2.0, d + d2 / 2.0));
    }

    public boolean isAutoTickUnitSelection() {
        return this.autoTickUnitSelection;
    }

    public void setAutoTickUnitSelection(boolean bl) {
        this.setAutoTickUnitSelection(bl, true);
    }

    public void setAutoTickUnitSelection(boolean bl, boolean bl2) {
        if (this.autoTickUnitSelection != bl) {
            this.autoTickUnitSelection = bl;
            if (bl2) {
                this.fireChangeEvent();
            }
        }
    }

    public TickUnitSource getStandardTickUnits() {
        return this.standardTickUnits;
    }

    public void setStandardTickUnits(TickUnitSource tickUnitSource) {
        this.standardTickUnits = tickUnitSource;
        this.fireChangeEvent();
    }

    public int getMinorTickCount() {
        return this.minorTickCount;
    }

    public void setMinorTickCount(int n) {
        this.minorTickCount = n;
        this.fireChangeEvent();
    }

    public abstract double valueToJava2D(double var1, Rectangle2D var3, RectangleEdge var4);

    public double lengthToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = this.valueToJava2D(0.0, rectangle2D, rectangleEdge);
        double d3 = this.valueToJava2D(d, rectangle2D, rectangleEdge);
        return Math.abs(d3 - d2);
    }

    public abstract double java2DToValue(double var1, Rectangle2D var3, RectangleEdge var4);

    protected abstract void autoAdjustRange();

    public void centerRange(double d) {
        double d2 = this.range.getCentralValue();
        Range range = new Range(this.range.getLowerBound() + d - d2, this.range.getUpperBound() + d - d2);
        this.setRange(range);
    }

    public void resizeRange(double d) {
        this.resizeRange(d, this.range.getCentralValue());
    }

    public void resizeRange(double d, double d2) {
        if (d > 0.0) {
            double d3 = this.range.getLength() * d / 2.0;
            Range range = new Range(d2 - d3, d2 + d3);
            this.setRange(range);
        } else {
            this.setAutoRange(true);
        }
    }

    public void resizeRange2(double d, double d2) {
        if (d > 0.0) {
            double d3 = d2 - this.getLowerBound();
            double d4 = this.getUpperBound() - d2;
            Range range = new Range(d2 - d3 * d, d2 + d4 * d);
            this.setRange(range);
        } else {
            this.setAutoRange(true);
        }
    }

    public void zoomRange(double d, double d2) {
        double d3;
        double d4;
        double d5 = this.range.getLowerBound();
        double d6 = this.range.getLength();
        if (this.isInverted()) {
            d4 = d5 + d6 * (1.0 - d2);
            d3 = d5 + d6 * (1.0 - d);
        } else {
            d4 = d5 + d6 * d;
            d3 = d5 + d6 * d2;
        }
        if (d3 > d4 && !Double.isInfinite(d3 - d4)) {
            this.setRange(new Range(d4, d3));
        }
    }

    public void pan(double d) {
        Range range = this.getRange();
        double d2 = this.range.getLength();
        double d3 = d2 * d;
        double d4 = range.getLowerBound() + d3;
        double d5 = range.getUpperBound() + d3;
        this.setRange(d4, d5);
    }

    protected int getAutoTickIndex() {
        return this.autoTickIndex;
    }

    protected void setAutoTickIndex(int n) {
        this.autoTickIndex = n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ValueAxis)) {
            return false;
        }
        ValueAxis valueAxis = (ValueAxis)object;
        if (this.positiveArrowVisible != valueAxis.positiveArrowVisible) {
            return false;
        }
        if (this.negativeArrowVisible != valueAxis.negativeArrowVisible) {
            return false;
        }
        if (this.inverted != valueAxis.inverted) {
            return false;
        }
        if (!this.autoRange && !ObjectUtilities.equal(this.range, valueAxis.range)) {
            return false;
        }
        if (this.autoRange != valueAxis.autoRange) {
            return false;
        }
        if (this.autoRangeMinimumSize != valueAxis.autoRangeMinimumSize) {
            return false;
        }
        if (!this.defaultAutoRange.equals(valueAxis.defaultAutoRange)) {
            return false;
        }
        if (this.upperMargin != valueAxis.upperMargin) {
            return false;
        }
        if (this.lowerMargin != valueAxis.lowerMargin) {
            return false;
        }
        if (this.fixedAutoRange != valueAxis.fixedAutoRange) {
            return false;
        }
        if (this.autoTickUnitSelection != valueAxis.autoTickUnitSelection) {
            return false;
        }
        if (!ObjectUtilities.equal(this.standardTickUnits, valueAxis.standardTickUnits)) {
            return false;
        }
        if (this.verticalTickLabels != valueAxis.verticalTickLabels) {
            return false;
        }
        if (this.minorTickCount != valueAxis.minorTickCount) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ValueAxis valueAxis = (ValueAxis)super.clone();
        return valueAxis;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.upArrow, objectOutputStream);
        SerialUtilities.writeShape(this.downArrow, objectOutputStream);
        SerialUtilities.writeShape(this.leftArrow, objectOutputStream);
        SerialUtilities.writeShape(this.rightArrow, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.upArrow = SerialUtilities.readShape(objectInputStream);
        this.downArrow = SerialUtilities.readShape(objectInputStream);
        this.leftArrow = SerialUtilities.readShape(objectInputStream);
        this.rightArrow = SerialUtilities.readShape(objectInputStream);
    }
}

