/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.data.time.Day;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Year;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PublicCloneable;

public class PeriodAxis
extends ValueAxis
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 8353295532075872069L;
    private RegularTimePeriod first;
    private RegularTimePeriod last;
    private TimeZone timeZone;
    private Locale locale;
    private Calendar calendar;
    private Class autoRangeTimePeriodClass;
    private Class majorTickTimePeriodClass;
    private boolean minorTickMarksVisible;
    private Class minorTickTimePeriodClass;
    private float minorTickMarkInsideLength = 0.0f;
    private float minorTickMarkOutsideLength = 2.0f;
    private transient Stroke minorTickMarkStroke = new BasicStroke(0.5f);
    private transient Paint minorTickMarkPaint = Color.black;
    private PeriodAxisLabelInfo[] labelInfo;

    public PeriodAxis(String string) {
        this(string, new Day(), new Day());
    }

    public PeriodAxis(String string, RegularTimePeriod regularTimePeriod, RegularTimePeriod regularTimePeriod2) {
        this(string, regularTimePeriod, regularTimePeriod2, TimeZone.getDefault(), Locale.getDefault());
    }

    public PeriodAxis(String string, RegularTimePeriod regularTimePeriod, RegularTimePeriod regularTimePeriod2, TimeZone timeZone) {
        this(string, regularTimePeriod, regularTimePeriod2, timeZone, Locale.getDefault());
    }

    public PeriodAxis(String string, RegularTimePeriod regularTimePeriod, RegularTimePeriod regularTimePeriod2, TimeZone timeZone, Locale locale) {
        super(string, null);
        ParamChecks.nullNotPermitted(timeZone, "timeZone");
        ParamChecks.nullNotPermitted(locale, "locale");
        this.first = regularTimePeriod;
        this.last = regularTimePeriod2;
        this.timeZone = timeZone;
        this.locale = locale;
        this.calendar = Calendar.getInstance(timeZone, locale);
        this.first.peg(this.calendar);
        this.last.peg(this.calendar);
        this.autoRangeTimePeriodClass = regularTimePeriod.getClass();
        this.majorTickTimePeriodClass = regularTimePeriod.getClass();
        this.minorTickMarksVisible = false;
        this.minorTickTimePeriodClass = RegularTimePeriod.downsize(this.majorTickTimePeriodClass);
        this.setAutoRange(true);
        this.labelInfo = new PeriodAxisLabelInfo[2];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM", locale);
        simpleDateFormat.setTimeZone(timeZone);
        this.labelInfo[0] = new PeriodAxisLabelInfo(Month.class, simpleDateFormat);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy", locale);
        simpleDateFormat2.setTimeZone(timeZone);
        this.labelInfo[1] = new PeriodAxisLabelInfo(Year.class, simpleDateFormat2);
    }

    public RegularTimePeriod getFirst() {
        return this.first;
    }

    public void setFirst(RegularTimePeriod regularTimePeriod) {
        ParamChecks.nullNotPermitted(regularTimePeriod, "first");
        this.first = regularTimePeriod;
        this.first.peg(this.calendar);
        this.fireChangeEvent();
    }

    public RegularTimePeriod getLast() {
        return this.last;
    }

    public void setLast(RegularTimePeriod regularTimePeriod) {
        ParamChecks.nullNotPermitted(regularTimePeriod, "last");
        this.last = regularTimePeriod;
        this.last.peg(this.calendar);
        this.fireChangeEvent();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        ParamChecks.nullNotPermitted(timeZone, "zone");
        this.timeZone = timeZone;
        this.calendar = Calendar.getInstance(timeZone, this.locale);
        this.first.peg(this.calendar);
        this.last.peg(this.calendar);
        this.fireChangeEvent();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Class getAutoRangeTimePeriodClass() {
        return this.autoRangeTimePeriodClass;
    }

    public void setAutoRangeTimePeriodClass(Class clazz) {
        ParamChecks.nullNotPermitted(clazz, "c");
        this.autoRangeTimePeriodClass = clazz;
        this.fireChangeEvent();
    }

    public Class getMajorTickTimePeriodClass() {
        return this.majorTickTimePeriodClass;
    }

    public void setMajorTickTimePeriodClass(Class clazz) {
        ParamChecks.nullNotPermitted(clazz, "c");
        this.majorTickTimePeriodClass = clazz;
        this.fireChangeEvent();
    }

    @Override
    public boolean isMinorTickMarksVisible() {
        return this.minorTickMarksVisible;
    }

    @Override
    public void setMinorTickMarksVisible(boolean bl) {
        this.minorTickMarksVisible = bl;
        this.fireChangeEvent();
    }

    public Class getMinorTickTimePeriodClass() {
        return this.minorTickTimePeriodClass;
    }

    public void setMinorTickTimePeriodClass(Class clazz) {
        ParamChecks.nullNotPermitted(clazz, "c");
        this.minorTickTimePeriodClass = clazz;
        this.fireChangeEvent();
    }

    public Stroke getMinorTickMarkStroke() {
        return this.minorTickMarkStroke;
    }

    public void setMinorTickMarkStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.minorTickMarkStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getMinorTickMarkPaint() {
        return this.minorTickMarkPaint;
    }

    public void setMinorTickMarkPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.minorTickMarkPaint = paint;
        this.fireChangeEvent();
    }

    @Override
    public float getMinorTickMarkInsideLength() {
        return this.minorTickMarkInsideLength;
    }

    @Override
    public void setMinorTickMarkInsideLength(float f) {
        this.minorTickMarkInsideLength = f;
        this.fireChangeEvent();
    }

    @Override
    public float getMinorTickMarkOutsideLength() {
        return this.minorTickMarkOutsideLength;
    }

    @Override
    public void setMinorTickMarkOutsideLength(float f) {
        this.minorTickMarkOutsideLength = f;
        this.fireChangeEvent();
    }

    public PeriodAxisLabelInfo[] getLabelInfo() {
        return this.labelInfo;
    }

    public void setLabelInfo(PeriodAxisLabelInfo[] periodAxisLabelInfoArray) {
        this.labelInfo = periodAxisLabelInfoArray;
        this.fireChangeEvent();
    }

    @Override
    public void setRange(Range range, boolean bl, boolean bl2) {
        long l = Math.round(range.getUpperBound());
        long l2 = Math.round(range.getLowerBound());
        this.first = this.createInstance(this.autoRangeTimePeriodClass, new Date(l2), this.timeZone, this.locale);
        this.last = this.createInstance(this.autoRangeTimePeriodClass, new Date(l), this.timeZone, this.locale);
        super.setRange(new Range(this.first.getFirstMillisecond(), (double)this.last.getLastMillisecond() + 1.0), bl, bl2);
    }

    @Override
    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    @Override
    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        if (axisSpace == null) {
            axisSpace = new AxisSpace();
        }
        if (!this.isVisible()) {
            return axisSpace;
        }
        double d = this.getFixedDimension();
        if (d > 0.0) {
            axisSpace.ensureAtLeast(d, rectangleEdge);
        }
        Rectangle2D rectangle2D2 = this.getLabelEnclosure(graphics2D, rectangleEdge);
        double d2 = 0.0;
        for (int i = 0; i < this.labelInfo.length; ++i) {
            PeriodAxisLabelInfo periodAxisLabelInfo = this.labelInfo[i];
            FontMetrics fontMetrics = graphics2D.getFontMetrics(periodAxisLabelInfo.getLabelFont());
            d2 += periodAxisLabelInfo.getPadding().extendHeight(fontMetrics.getHeight());
        }
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            double d3 = rectangle2D2.getHeight();
            axisSpace.add(d3 + d2, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            double d4 = rectangle2D2.getWidth();
            axisSpace.add(d4 + d2, rectangleEdge);
        }
        double d5 = 0.0;
        if (this.isTickMarksVisible()) {
            d5 = this.getTickMarkOutsideLength();
        }
        if (this.minorTickMarksVisible) {
            d5 = Math.max(d5, (double)this.minorTickMarkOutsideLength);
        }
        axisSpace.add(d5, rectangleEdge);
        return axisSpace;
    }

    @Override
    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        AxisState axisState = new AxisState(d);
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d, rectangle2D2, rectangleEdge);
        }
        if (this.isTickMarksVisible()) {
            this.drawTickMarks(graphics2D, axisState, rectangle2D2, rectangleEdge);
        }
        if (this.isTickLabelsVisible()) {
            for (int i = 0; i < this.labelInfo.length; ++i) {
                axisState = this.drawTickLabels(i, graphics2D, axisState, rectangle2D2, rectangleEdge);
            }
        }
        axisState = this.getAttributedLabel() != null ? this.drawAttributedLabel(this.getAttributedLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState) : this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        return axisState;
    }

    protected void drawTickMarks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.drawTickMarksHorizontal(graphics2D, axisState, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.drawTickMarksVertical(graphics2D, axisState, rectangle2D, rectangleEdge);
        }
    }

    protected void drawTickMarksHorizontal(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        double d = axisState.getCursor();
        double d2 = this.getTickMarkInsideLength();
        double d3 = this.getTickMarkOutsideLength();
        RegularTimePeriod regularTimePeriod = this.createInstance(this.majorTickTimePeriodClass, this.first.getStart(), this.getTimeZone(), this.locale);
        long l = regularTimePeriod.getFirstMillisecond();
        Line2D.Double double_ = null;
        Line2D.Double double_2 = null;
        long l2 = this.getFirst().getFirstMillisecond();
        long l3 = this.getLast().getLastMillisecond() + 1L;
        while (l <= l3) {
            arrayList.add(new NumberTick((Number)l, "", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
            double d4 = this.valueToJava2D(l, rectangle2D, rectangleEdge);
            if (rectangleEdge == RectangleEdge.TOP) {
                double_ = new Line2D.Double(d4, d, d4, d + d2);
                double_2 = new Line2D.Double(d4, d, d4, d - d3);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                double_ = new Line2D.Double(d4, d, d4, d - d2);
                double_2 = new Line2D.Double(d4, d, d4, d + d3);
            }
            if (l >= l2) {
                graphics2D.setPaint(this.getTickMarkPaint());
                graphics2D.setStroke(this.getTickMarkStroke());
                graphics2D.draw(double_);
                graphics2D.draw(double_2);
            }
            if (this.minorTickMarksVisible) {
                RegularTimePeriod regularTimePeriod2 = this.createInstance(this.minorTickTimePeriodClass, new Date(l), this.getTimeZone(), this.locale);
                long l4 = regularTimePeriod2.getFirstMillisecond();
                while (l4 < regularTimePeriod.getLastMillisecond() && l4 < l3) {
                    double d5 = this.valueToJava2D(l4, rectangle2D, rectangleEdge);
                    if (rectangleEdge == RectangleEdge.TOP) {
                        double_ = new Line2D.Double(d5, d, d5, d + (double)this.minorTickMarkInsideLength);
                        double_2 = new Line2D.Double(d5, d, d5, d - (double)this.minorTickMarkOutsideLength);
                    } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                        double_ = new Line2D.Double(d5, d, d5, d - (double)this.minorTickMarkInsideLength);
                        double_2 = new Line2D.Double(d5, d, d5, d + (double)this.minorTickMarkOutsideLength);
                    }
                    if (l4 >= l2) {
                        graphics2D.setPaint(this.minorTickMarkPaint);
                        graphics2D.setStroke(this.minorTickMarkStroke);
                        graphics2D.draw(double_);
                        graphics2D.draw(double_2);
                    }
                    regularTimePeriod2 = regularTimePeriod2.next();
                    regularTimePeriod2.peg(this.calendar);
                    l4 = regularTimePeriod2.getFirstMillisecond();
                }
            }
            regularTimePeriod = regularTimePeriod.next();
            regularTimePeriod.peg(this.calendar);
            l = regularTimePeriod.getFirstMillisecond();
        }
        if (rectangleEdge == RectangleEdge.TOP) {
            axisState.cursorUp(Math.max(d3, (double)this.minorTickMarkOutsideLength));
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            axisState.cursorDown(Math.max(d3, (double)this.minorTickMarkOutsideLength));
        }
        axisState.setTicks(arrayList);
    }

    protected void drawTickMarksVertical(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
    }

    protected AxisState drawTickLabels(int n, Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.labelInfo[n].getLabelFont());
        if (rectangleEdge == RectangleEdge.BOTTOM) {
            d = this.labelInfo[n].getPadding().calculateTopOutset(fontMetrics.getHeight());
        } else if (rectangleEdge == RectangleEdge.TOP) {
            d = this.labelInfo[n].getPadding().calculateBottomOutset(fontMetrics.getHeight());
        }
        axisState.moveCursor(d, rectangleEdge);
        long l = this.first.getFirstMillisecond();
        long l2 = this.last.getLastMillisecond();
        graphics2D.setFont(this.labelInfo[n].getLabelFont());
        graphics2D.setPaint(this.labelInfo[n].getLabelPaint());
        RegularTimePeriod regularTimePeriod = this.labelInfo[n].createInstance(new Date(l), this.timeZone, this.locale);
        RegularTimePeriod regularTimePeriod2 = this.labelInfo[n].createInstance(new Date(l2), this.timeZone, this.locale);
        DateFormat dateFormat = this.labelInfo[n].getDateFormat();
        dateFormat.setTimeZone(this.timeZone);
        String string = dateFormat.format(new Date(regularTimePeriod.getMiddleMillisecond()));
        String string2 = dateFormat.format(new Date(regularTimePeriod2.getMiddleMillisecond()));
        Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(string, graphics2D, graphics2D.getFontMetrics());
        Rectangle2D rectangle2D3 = TextUtilities.getTextBounds(string2, graphics2D, graphics2D.getFontMetrics());
        double d2 = Math.max(rectangle2D2.getWidth(), rectangle2D3.getWidth());
        long l3 = Math.round(this.java2DToValue(rectangle2D.getX() + d2 + 5.0, rectangle2D, rectangleEdge));
        l3 = this.isInverted() ? l2 - l3 : (l3 -= l);
        long l4 = regularTimePeriod.getLastMillisecond() - regularTimePeriod.getFirstMillisecond();
        int n2 = (int)(l3 / l4) + 1;
        RegularTimePeriod regularTimePeriod3 = this.labelInfo[n].createInstance(new Date(l), this.timeZone, this.locale);
        RectangularShape rectangularShape = null;
        long l5 = 0L;
        float f = (float)axisState.getCursor();
        TextAnchor textAnchor = TextAnchor.TOP_CENTER;
        float f2 = (float)rectangle2D2.getHeight();
        if (rectangleEdge == RectangleEdge.TOP) {
            textAnchor = TextAnchor.BOTTOM_CENTER;
            f2 = -f2;
        }
        while (regularTimePeriod3.getFirstMillisecond() <= l2) {
            float f3;
            Rectangle2D rectangle2D4;
            float f4 = (float)this.valueToJava2D(regularTimePeriod3.getMiddleMillisecond(), rectangle2D, rectangleEdge);
            String string3 = dateFormat.format(new Date(regularTimePeriod3.getMiddleMillisecond()));
            long l6 = regularTimePeriod3.getFirstMillisecond();
            long l7 = regularTimePeriod3.getLastMillisecond();
            if (l7 > l2 && (double)f4 + (rectangle2D4 = TextUtilities.getTextBounds(string3, graphics2D, graphics2D.getFontMetrics())).getWidth() / 2.0 > rectangle2D.getMaxX()) {
                f3 = (float)this.valueToJava2D(Math.max(l6, l), rectangle2D, rectangleEdge);
                if (rectangle2D4.getWidth() < rectangle2D.getMaxX() - (double)f3) {
                    f4 = ((float)rectangle2D.getMaxX() + f3) / 2.0f;
                } else {
                    string3 = null;
                }
            }
            if (l6 < l && (double)f4 - (rectangle2D4 = TextUtilities.getTextBounds(string3, graphics2D, graphics2D.getFontMetrics())).getWidth() / 2.0 < rectangle2D.getX()) {
                f3 = (float)this.valueToJava2D(Math.min(l7, l2), rectangle2D, rectangleEdge);
                if (rectangle2D4.getWidth() < (double)f3 - rectangle2D.getX()) {
                    f4 = (f3 + (float)rectangle2D.getX()) / 2.0f;
                } else {
                    string3 = null;
                }
            }
            if (string3 != null) {
                graphics2D.setPaint(this.labelInfo[n].getLabelPaint());
                rectangularShape = TextUtilities.drawAlignedString(string3, graphics2D, f4, f, textAnchor);
            }
            if (l5 > 0L && this.labelInfo[n].getDrawDividers()) {
                long l8 = regularTimePeriod3.getFirstMillisecond();
                long l9 = (l5 + l8) / 2L;
                float f5 = (float)this.valueToJava2D(l9, rectangle2D, rectangleEdge);
                graphics2D.setStroke(this.labelInfo[n].getDividerStroke());
                graphics2D.setPaint(this.labelInfo[n].getDividerPaint());
                graphics2D.draw(new Line2D.Float(f5, f, f5, f + f2));
            }
            l5 = l7;
            for (int i = 0; i < n2; ++i) {
                regularTimePeriod3 = regularTimePeriod3.next();
            }
            regularTimePeriod3.peg(this.calendar);
        }
        double d3 = 0.0;
        if (rectangularShape != null) {
            d3 = rectangularShape.getHeight();
            if (rectangleEdge == RectangleEdge.BOTTOM) {
                d3 += this.labelInfo[n].getPadding().calculateBottomOutset(fontMetrics.getHeight());
            } else if (rectangleEdge == RectangleEdge.TOP) {
                d3 += this.labelInfo[n].getPadding().calculateTopOutset(fontMetrics.getHeight());
            }
        }
        axisState.moveCursor(d3, rectangleEdge);
        return axisState;
    }

    @Override
    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public double valueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = Double.NaN;
        double d3 = this.first.getFirstMillisecond();
        double d4 = this.last.getLastMillisecond();
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            double d5 = rectangle2D.getX();
            double d6 = rectangle2D.getMaxX();
            d2 = this.isInverted() ? d6 + (d - d3) / (d4 - d3) * (d5 - d6) : d5 + (d - d3) / (d4 - d3) * (d6 - d5);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            double d7 = rectangle2D.getMinY();
            double d8 = rectangle2D.getMaxY();
            d2 = this.isInverted() ? d7 + (d - d3) / (d4 - d3) * (d8 - d7) : d8 - (d - d3) / (d4 - d3) * (d8 - d7);
        }
        return d2;
    }

    @Override
    public double java2DToValue(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.first.getFirstMillisecond();
        double d5 = this.last.getLastMillisecond();
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d2 = rectangle2D.getX();
            d3 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d2 = rectangle2D.getMaxY();
            d3 = rectangle2D.getY();
        }
        double d6 = this.isInverted() ? d5 - (d - d2) / (d3 - d2) * (d5 - d4) : d4 + (d - d2) / (d3 - d2) * (d5 - d4);
        return d6;
    }

    @Override
    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = this.getDefaultAutoRange();
            }
            long l = Math.round(range.getUpperBound());
            long l2 = Math.round(range.getLowerBound());
            this.first = this.createInstance(this.autoRangeTimePeriodClass, new Date(l2), this.timeZone, this.locale);
            this.last = this.createInstance(this.autoRangeTimePeriodClass, new Date(l), this.timeZone, this.locale);
            this.setRange(range, false, false);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PeriodAxis)) {
            return false;
        }
        PeriodAxis periodAxis = (PeriodAxis)object;
        if (!this.first.equals(periodAxis.first)) {
            return false;
        }
        if (!this.last.equals(periodAxis.last)) {
            return false;
        }
        if (!this.timeZone.equals(periodAxis.timeZone)) {
            return false;
        }
        if (!this.locale.equals(periodAxis.locale)) {
            return false;
        }
        if (!this.autoRangeTimePeriodClass.equals(periodAxis.autoRangeTimePeriodClass)) {
            return false;
        }
        if (this.isMinorTickMarksVisible() != periodAxis.isMinorTickMarksVisible()) {
            return false;
        }
        if (!this.majorTickTimePeriodClass.equals(periodAxis.majorTickTimePeriodClass)) {
            return false;
        }
        if (!this.minorTickTimePeriodClass.equals(periodAxis.minorTickTimePeriodClass)) {
            return false;
        }
        if (!this.minorTickMarkPaint.equals(periodAxis.minorTickMarkPaint)) {
            return false;
        }
        if (!this.minorTickMarkStroke.equals(periodAxis.minorTickMarkStroke)) {
            return false;
        }
        if (!Arrays.equals(this.labelInfo, periodAxis.labelInfo)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PeriodAxis periodAxis = (PeriodAxis)super.clone();
        periodAxis.timeZone = (TimeZone)this.timeZone.clone();
        periodAxis.labelInfo = (PeriodAxisLabelInfo[])this.labelInfo.clone();
        return periodAxis;
    }

    private RegularTimePeriod createInstance(Class clazz, Date date, TimeZone timeZone, Locale locale) {
        RegularTimePeriod regularTimePeriod = null;
        try {
            Constructor constructor = clazz.getDeclaredConstructor(Date.class, TimeZone.class, Locale.class);
            regularTimePeriod = (RegularTimePeriod)constructor.newInstance(date, timeZone, locale);
        }
        catch (Exception exception) {
            try {
                Constructor constructor = clazz.getDeclaredConstructor(Date.class);
                regularTimePeriod = (RegularTimePeriod)constructor.newInstance(date);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return regularTimePeriod;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.minorTickMarkStroke, objectOutputStream);
        SerialUtilities.writePaint(this.minorTickMarkPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.minorTickMarkStroke = SerialUtilities.readStroke(objectInputStream);
        this.minorTickMarkPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

