/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.util.ObjectUtilities;

public class NumberTickUnitSource
implements TickUnitSource,
Serializable {
    private boolean integers;
    private int power = 0;
    private int factor = 1;
    private NumberFormat formatter;
    private DecimalFormat dfNeg4 = new DecimalFormat("0.0000");
    private DecimalFormat dfNeg3 = new DecimalFormat("0.000");
    private DecimalFormat dfNeg2 = new DecimalFormat("0.00");
    private DecimalFormat dfNeg1 = new DecimalFormat("0.0");
    private DecimalFormat df0 = new DecimalFormat("#,##0");
    private DecimalFormat df = new DecimalFormat("#.######E0");

    public NumberTickUnitSource() {
        this(false);
    }

    public NumberTickUnitSource(boolean bl) {
        this(bl, null);
    }

    public NumberTickUnitSource(boolean bl, NumberFormat numberFormat) {
        this.integers = bl;
        this.formatter = numberFormat;
        this.power = 0;
        this.factor = 1;
    }

    @Override
    public TickUnit getLargerTickUnit(TickUnit tickUnit) {
        TickUnit tickUnit2 = this.getCeilingTickUnit(tickUnit);
        if (tickUnit2.equals(tickUnit)) {
            this.next();
            tickUnit2 = new NumberTickUnit(this.getTickSize(), this.getTickLabelFormat(), this.getMinorTickCount());
        }
        return tickUnit2;
    }

    @Override
    public TickUnit getCeilingTickUnit(TickUnit tickUnit) {
        return this.getCeilingTickUnit(tickUnit.getSize());
    }

    @Override
    public TickUnit getCeilingTickUnit(double d) {
        if (Double.isInfinite(d)) {
            throw new IllegalArgumentException("Must be finite.");
        }
        this.power = (int)Math.ceil(Math.log10(d));
        if (this.integers) {
            this.power = Math.max(this.power, 0);
        }
        this.factor = 1;
        boolean bl = false;
        while (!bl) {
            boolean bl2 = bl = !this.previous();
            if (!(this.getTickSize() < d)) continue;
            this.next();
            bl = true;
        }
        return new NumberTickUnit(this.getTickSize(), this.getTickLabelFormat(), this.getMinorTickCount());
    }

    private boolean next() {
        if (this.factor == 1) {
            this.factor = 2;
            return true;
        }
        if (this.factor == 2) {
            this.factor = 5;
            return true;
        }
        if (this.factor == 5) {
            if (this.power == 300) {
                return false;
            }
            ++this.power;
            this.factor = 1;
            return true;
        }
        throw new IllegalStateException("We should never get here.");
    }

    private boolean previous() {
        if (this.factor == 1) {
            if (this.integers && this.power == 0 || this.power == -300) {
                return false;
            }
            this.factor = 5;
            --this.power;
            return true;
        }
        if (this.factor == 2) {
            this.factor = 1;
            return true;
        }
        if (this.factor == 5) {
            this.factor = 2;
            return true;
        }
        throw new IllegalStateException("We should never get here.");
    }

    private double getTickSize() {
        return (double)this.factor * Math.pow(10.0, this.power);
    }

    private NumberFormat getTickLabelFormat() {
        if (this.formatter != null) {
            return this.formatter;
        }
        if (this.power == -4) {
            return this.dfNeg4;
        }
        if (this.power == -3) {
            return this.dfNeg3;
        }
        if (this.power == -2) {
            return this.dfNeg2;
        }
        if (this.power == -1) {
            return this.dfNeg1;
        }
        if (this.power >= 0 && this.power <= 6) {
            return this.df0;
        }
        return this.df;
    }

    private int getMinorTickCount() {
        if (this.factor == 1) {
            return 10;
        }
        if (this.factor == 5) {
            return 5;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NumberTickUnitSource)) {
            return false;
        }
        NumberTickUnitSource numberTickUnitSource = (NumberTickUnitSource)object;
        if (this.integers != numberTickUnitSource.integers) {
            return false;
        }
        if (!ObjectUtilities.equal(this.formatter, numberTickUnitSource.formatter)) {
            return false;
        }
        if (this.power != numberTickUnitSource.power) {
            return false;
        }
        return this.factor == numberTickUnitSource.factor;
    }
}

