/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import java.text.NumberFormat;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.util.ParamChecks;

public class NumberTickUnit
extends TickUnit
implements Serializable {
    private static final long serialVersionUID = 3849459506627654442L;
    private NumberFormat formatter;

    public NumberTickUnit(double d) {
        this(d, NumberFormat.getNumberInstance());
    }

    public NumberTickUnit(double d, NumberFormat numberFormat) {
        super(d);
        ParamChecks.nullNotPermitted(numberFormat, "formatter");
        this.formatter = numberFormat;
    }

    public NumberTickUnit(double d, NumberFormat numberFormat, int n) {
        super(d, n);
        ParamChecks.nullNotPermitted(numberFormat, "formatter");
        this.formatter = numberFormat;
    }

    @Override
    public String valueToString(double d) {
        return this.formatter.format(d);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NumberTickUnit)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        NumberTickUnit numberTickUnit = (NumberTickUnit)object;
        return this.formatter.equals(numberTickUnit.formatter);
    }

    public String toString() {
        return "[size=" + this.valueToString(this.getSize()) + "]";
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 29 * n + (this.formatter != null ? this.formatter.hashCode() : 0);
        return n;
    }
}

