/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.MarkerAxisBand;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.NumberTickUnitSource;
import org.jfree.chart.axis.TickType;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.data.RangeType;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;

public class NumberAxis
extends ValueAxis
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2805933088476185789L;
    public static final boolean DEFAULT_AUTO_RANGE_INCLUDES_ZERO = true;
    public static final boolean DEFAULT_AUTO_RANGE_STICKY_ZERO = true;
    public static final NumberTickUnit DEFAULT_TICK_UNIT = new NumberTickUnit(1.0, new DecimalFormat("0"));
    public static final boolean DEFAULT_VERTICAL_TICK_LABELS = false;
    private RangeType rangeType = RangeType.FULL;
    private boolean autoRangeIncludesZero = true;
    private boolean autoRangeStickyZero = true;
    private NumberTickUnit tickUnit = DEFAULT_TICK_UNIT;
    private NumberFormat numberFormatOverride = null;
    private MarkerAxisBand markerBand = null;

    public NumberAxis() {
        this(null);
    }

    public NumberAxis(String string) {
        super(string, NumberAxis.createStandardTickUnits());
    }

    public RangeType getRangeType() {
        return this.rangeType;
    }

    public void setRangeType(RangeType rangeType) {
        ParamChecks.nullNotPermitted(rangeType, "rangeType");
        this.rangeType = rangeType;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean getAutoRangeIncludesZero() {
        return this.autoRangeIncludesZero;
    }

    public void setAutoRangeIncludesZero(boolean bl) {
        if (this.autoRangeIncludesZero != bl) {
            this.autoRangeIncludesZero = bl;
            if (this.isAutoRange()) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean getAutoRangeStickyZero() {
        return this.autoRangeStickyZero;
    }

    public void setAutoRangeStickyZero(boolean bl) {
        if (this.autoRangeStickyZero != bl) {
            this.autoRangeStickyZero = bl;
            if (this.isAutoRange()) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public NumberTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(NumberTickUnit numberTickUnit) {
        this.setTickUnit(numberTickUnit, true, true);
    }

    public void setTickUnit(NumberTickUnit numberTickUnit, boolean bl, boolean bl2) {
        ParamChecks.nullNotPermitted(numberTickUnit, "unit");
        this.tickUnit = numberTickUnit;
        if (bl2) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (bl) {
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public NumberFormat getNumberFormatOverride() {
        return this.numberFormatOverride;
    }

    public void setNumberFormatOverride(NumberFormat numberFormat) {
        this.numberFormatOverride = numberFormat;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public MarkerAxisBand getMarkerBand() {
        return this.markerBand;
    }

    public void setMarkerBand(MarkerAxisBand markerAxisBand) {
        this.markerBand = markerAxisBand;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    @Override
    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    @Override
    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = this.getDefaultAutoRange();
            }
            double d = range.getUpperBound();
            double d2 = range.getLowerBound();
            if (this.rangeType == RangeType.POSITIVE) {
                d2 = Math.max(0.0, d2);
                d = Math.max(0.0, d);
            } else if (this.rangeType == RangeType.NEGATIVE) {
                d2 = Math.min(0.0, d2);
                d = Math.min(0.0, d);
            }
            if (this.getAutoRangeIncludesZero()) {
                d2 = Math.min(d2, 0.0);
                d = Math.max(d, 0.0);
            }
            double d3 = d - d2;
            double d4 = this.getFixedAutoRange();
            if (d4 > 0.0) {
                d2 = d - d4;
            } else {
                double d5 = this.getAutoRangeMinimumSize();
                if (d3 < d5) {
                    double d6 = (d5 - d3) / 2.0;
                    if ((d2 -= d6) == (d += d6)) {
                        double d7 = Math.abs(d2) / 10.0;
                        d2 -= d7;
                        d += d7;
                    }
                    if (this.rangeType == RangeType.POSITIVE) {
                        if (d2 < 0.0) {
                            d -= d2;
                            d2 = 0.0;
                        }
                    } else if (this.rangeType == RangeType.NEGATIVE && d > 0.0) {
                        d2 -= d;
                        d = 0.0;
                    }
                }
                if (this.getAutoRangeStickyZero()) {
                    d = d <= 0.0 ? Math.min(0.0, d + this.getUpperMargin() * d3) : (d += this.getUpperMargin() * d3);
                    d2 = d2 >= 0.0 ? Math.max(0.0, d2 - this.getLowerMargin() * d3) : (d2 -= this.getLowerMargin() * d3);
                } else {
                    d += this.getUpperMargin() * d3;
                    d2 -= this.getLowerMargin() * d3;
                }
            }
            this.setRange(new Range(d2, d), false, false);
        }
    }

    @Override
    public double valueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = range.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d5 = rectangle2D.getMinY();
            d4 = rectangle2D.getMaxY();
        }
        if (this.isInverted()) {
            return d5 - (d - d2) / (d3 - d2) * (d5 - d4);
        }
        return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
    }

    @Override
    public double java2DToValue(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = range.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d4 = rectangle2D.getMaxY();
            d5 = rectangle2D.getY();
        }
        if (this.isInverted()) {
            return d3 - (d - d4) / (d5 - d4) * (d3 - d2);
        }
        return d2 + (d - d4) / (d5 - d4) * (d3 - d2);
    }

    protected double calculateLowestVisibleTickValue() {
        double d = this.getTickUnit().getSize();
        double d2 = Math.ceil(this.getRange().getLowerBound() / d);
        return d2 * d;
    }

    protected double calculateHighestVisibleTickValue() {
        double d = this.getTickUnit().getSize();
        double d2 = Math.floor(this.getRange().getUpperBound() / d);
        return d2 * d;
    }

    protected int calculateVisibleTickCount() {
        double d = this.getTickUnit().getSize();
        Range range = this.getRange();
        return (int)(Math.floor(range.getUpperBound() / d) - Math.ceil(range.getLowerBound() / d) + 1.0);
    }

    @Override
    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        if (!this.isVisible()) {
            AxisState axisState = new AxisState(d);
            List list = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
            axisState.setTicks(list);
            return axisState;
        }
        AxisState axisState = this.drawTickMarksAndLabels(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        axisState = this.getAttributedLabel() != null ? this.drawAttributedLabel(this.getAttributedLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState) : this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        this.createAndAddEntity(d, axisState, rectangle2D2, rectangleEdge, plotRenderingInfo);
        return axisState;
    }

    public static TickUnitSource createStandardTickUnits() {
        return new NumberTickUnitSource();
    }

    public static TickUnitSource createIntegerTickUnits() {
        return new NumberTickUnitSource(true);
    }

    public static TickUnitSource createStandardTickUnits(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        return new NumberTickUnitSource(false, numberFormat);
    }

    public static TickUnitSource createIntegerTickUnits(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        return new NumberTickUnitSource(true, numberFormat);
    }

    protected double estimateMaximumTickLabelHeight(Graphics2D graphics2D) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        double d = rectangleInsets.getTop() + rectangleInsets.getBottom();
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        return d += (double)font.getLineMetrics("123", fontRenderContext).getHeight();
    }

    protected double estimateMaximumTickLabelWidth(Graphics2D graphics2D, TickUnit tickUnit) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        double d = rectangleInsets.getLeft() + rectangleInsets.getRight();
        if (this.isVerticalTickLabels()) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            LineMetrics lineMetrics = this.getTickLabelFont().getLineMetrics("0", fontRenderContext);
            d += (double)lineMetrics.getHeight();
        } else {
            String string;
            String string2;
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.getTickLabelFont());
            Range range = this.getRange();
            double d2 = range.getLowerBound();
            double d3 = range.getUpperBound();
            NumberFormat numberFormat = this.getNumberFormatOverride();
            if (numberFormat != null) {
                string2 = numberFormat.format(d2);
                string = numberFormat.format(d3);
            } else {
                string2 = tickUnit.valueToString(d2);
                string = tickUnit.valueToString(d3);
            }
            double d4 = fontMetrics.stringWidth(string2);
            double d5 = fontMetrics.stringWidth(string);
            d += Math.max(d4, d5);
        }
        return d;
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.selectHorizontalAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.selectVerticalAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
    }

    protected void selectHorizontalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = this.estimateMaximumTickLabelWidth(graphics2D, this.getTickUnit());
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit = tickUnitSource.getCeilingTickUnit(this.getTickUnit());
        double d2 = this.lengthToJava2D(tickUnit.getSize(), rectangle2D, rectangleEdge);
        double d3 = d / d2 * tickUnit.getSize();
        NumberTickUnit numberTickUnit = (NumberTickUnit)tickUnitSource.getCeilingTickUnit(d3);
        double d4 = this.lengthToJava2D(numberTickUnit.getSize(), rectangle2D, rectangleEdge);
        d = this.estimateMaximumTickLabelWidth(graphics2D, numberTickUnit);
        if (d > d4) {
            numberTickUnit = (NumberTickUnit)tickUnitSource.getLargerTickUnit(numberTickUnit);
        }
        this.setTickUnit(numberTickUnit, false, false);
    }

    protected void selectVerticalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = this.estimateMaximumTickLabelHeight(graphics2D);
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit = tickUnitSource.getCeilingTickUnit(this.getTickUnit());
        double d2 = this.lengthToJava2D(tickUnit.getSize(), rectangle2D, rectangleEdge);
        double d3 = tickUnit.getSize();
        if (d2 > 0.0) {
            d3 = d / d2 * tickUnit.getSize();
        }
        NumberTickUnit numberTickUnit = (NumberTickUnit)tickUnitSource.getCeilingTickUnit(d3);
        double d4 = this.lengthToJava2D(numberTickUnit.getSize(), rectangle2D, rectangleEdge);
        d = this.estimateMaximumTickLabelHeight(graphics2D);
        if (d > d4) {
            numberTickUnit = (NumberTickUnit)tickUnitSource.getLargerTickUnit(numberTickUnit);
        }
        this.setTickUnit(numberTickUnit, false, false);
    }

    @Override
    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        List list = new ArrayList();
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            list = this.refreshTicksHorizontal(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            list = this.refreshTicksVertical(graphics2D, rectangle2D, rectangleEdge);
        }
        return list;
    }

    protected List refreshTicksHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
        NumberTickUnit numberTickUnit = this.getTickUnit();
        double d = numberTickUnit.getSize();
        int n = this.calculateVisibleTickCount();
        double d2 = this.calculateLowestVisibleTickValue();
        if (n <= 500) {
            double d3;
            int n2;
            int n3 = this.getMinorTickCount();
            if (n3 <= 0) {
                n3 = numberTickUnit.getMinorTickCount();
            }
            for (n2 = 1; n2 < n3; ++n2) {
                d3 = d2 - d * (double)n2 / (double)n3;
                if (!this.getRange().contains(d3)) continue;
                arrayList.add(new NumberTick(TickType.MINOR, d3, "", TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
            }
            for (n2 = 0; n2 < n; ++n2) {
                TextAnchor textAnchor;
                TextAnchor textAnchor2;
                d3 = d2 + (double)n2 * d;
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d3) : this.getTickUnit().valueToString(d3);
                double d4 = 0.0;
                if (this.isVerticalTickLabels()) {
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    d4 = rectangleEdge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
                } else if (rectangleEdge == RectangleEdge.TOP) {
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                } else {
                    textAnchor2 = TextAnchor.TOP_CENTER;
                    textAnchor = TextAnchor.TOP_CENTER;
                }
                NumberTick numberTick = new NumberTick(new Double(d3), string, textAnchor2, textAnchor, d4);
                arrayList.add(numberTick);
                double d5 = d2 + (double)(n2 + 1) * d;
                for (int i = 1; i < n3; ++i) {
                    double d6 = d3 + (d5 - d3) * (double)i / (double)n3;
                    if (!this.getRange().contains(d6)) continue;
                    arrayList.add(new NumberTick(TickType.MINOR, d6, "", TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
                }
            }
        }
        return arrayList;
    }

    protected List refreshTicksVertical(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        arrayList.clear();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
        NumberTickUnit numberTickUnit = this.getTickUnit();
        double d = numberTickUnit.getSize();
        int n = this.calculateVisibleTickCount();
        double d2 = this.calculateLowestVisibleTickValue();
        if (n <= 500) {
            double d3;
            int n2;
            int n3 = this.getMinorTickCount();
            if (n3 <= 0) {
                n3 = numberTickUnit.getMinorTickCount();
            }
            for (n2 = 1; n2 < n3; ++n2) {
                d3 = d2 - d * (double)n2 / (double)n3;
                if (!this.getRange().contains(d3)) continue;
                arrayList.add(new NumberTick(TickType.MINOR, d3, "", TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
            }
            for (n2 = 0; n2 < n; ++n2) {
                TextAnchor textAnchor;
                TextAnchor textAnchor2;
                d3 = d2 + (double)n2 * d;
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d3) : this.getTickUnit().valueToString(d3);
                double d4 = 0.0;
                if (this.isVerticalTickLabels()) {
                    if (rectangleEdge == RectangleEdge.LEFT) {
                        textAnchor2 = TextAnchor.BOTTOM_CENTER;
                        textAnchor = TextAnchor.BOTTOM_CENTER;
                        d4 = -1.5707963267948966;
                    } else {
                        textAnchor2 = TextAnchor.BOTTOM_CENTER;
                        textAnchor = TextAnchor.BOTTOM_CENTER;
                        d4 = 1.5707963267948966;
                    }
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                    textAnchor = TextAnchor.CENTER_RIGHT;
                } else {
                    textAnchor2 = TextAnchor.CENTER_LEFT;
                    textAnchor = TextAnchor.CENTER_LEFT;
                }
                NumberTick numberTick = new NumberTick(new Double(d3), string, textAnchor2, textAnchor, d4);
                arrayList.add(numberTick);
                double d5 = d2 + (double)(n2 + 1) * d;
                for (int i = 1; i < n3; ++i) {
                    double d6 = d3 + (d5 - d3) * (double)i / (double)n3;
                    if (!this.getRange().contains(d6)) continue;
                    arrayList.add(new NumberTick(TickType.MINOR, d6, "", TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
                }
            }
        }
        return arrayList;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        NumberAxis numberAxis = (NumberAxis)super.clone();
        if (this.numberFormatOverride != null) {
            numberAxis.numberFormatOverride = (NumberFormat)this.numberFormatOverride.clone();
        }
        return numberAxis;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NumberAxis)) {
            return false;
        }
        NumberAxis numberAxis = (NumberAxis)object;
        if (this.autoRangeIncludesZero != numberAxis.autoRangeIncludesZero) {
            return false;
        }
        if (this.autoRangeStickyZero != numberAxis.autoRangeStickyZero) {
            return false;
        }
        if (!ObjectUtilities.equal(this.tickUnit, numberAxis.tickUnit)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.numberFormatOverride, numberAxis.numberFormatOverride)) {
            return false;
        }
        if (!this.rangeType.equals(numberAxis.rangeType)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

