/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.LogTick;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.NumberTickUnitSource;
import org.jfree.chart.axis.TickType;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.util.AttrStringUtils;
import org.jfree.chart.util.LogFormat;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;

public class LogAxis
extends ValueAxis {
    private double base = 10.0;
    private double baseLog = Math.log(10.0);
    private String baseSymbol = null;
    private Format baseFormatter = new DecimalFormat("0");
    private double smallestValue = 1.0E-100;
    private NumberTickUnit tickUnit;
    private NumberFormat numberFormatOverride;

    public LogAxis() {
        this(null);
    }

    public LogAxis(String string) {
        super(string, new NumberTickUnitSource());
        this.setDefaultAutoRange(new Range(0.01, 1.0));
        this.tickUnit = new NumberTickUnit(1.0, new DecimalFormat("0.#"), 10);
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double d) {
        if (d <= 1.0) {
            throw new IllegalArgumentException("Requires 'base' > 1.0.");
        }
        this.base = d;
        this.baseLog = Math.log(d);
        this.fireChangeEvent();
    }

    public String getBaseSymbol() {
        return this.baseSymbol;
    }

    public void setBaseSymbol(String string) {
        this.baseSymbol = string;
        this.fireChangeEvent();
    }

    public Format getBaseFormatter() {
        return this.baseFormatter;
    }

    public void setBaseFormatter(Format format) {
        ParamChecks.nullNotPermitted(format, "formatter");
        this.baseFormatter = format;
        this.fireChangeEvent();
    }

    public double getSmallestValue() {
        return this.smallestValue;
    }

    public void setSmallestValue(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Requires 'value' > 0.0.");
        }
        this.smallestValue = d;
        this.fireChangeEvent();
    }

    public NumberTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(NumberTickUnit numberTickUnit) {
        this.setTickUnit(numberTickUnit, true, true);
    }

    public void setTickUnit(NumberTickUnit numberTickUnit, boolean bl, boolean bl2) {
        ParamChecks.nullNotPermitted(numberTickUnit, "unit");
        this.tickUnit = numberTickUnit;
        if (bl2) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public NumberFormat getNumberFormatOverride() {
        return this.numberFormatOverride;
    }

    public void setNumberFormatOverride(NumberFormat numberFormat) {
        this.numberFormatOverride = numberFormat;
        this.fireChangeEvent();
    }

    public double calculateLog(double d) {
        return Math.log(d) / this.baseLog;
    }

    public double calculateValue(double d) {
        return Math.pow(this.base, d);
    }

    private double calculateValueNoINF(double d) {
        double d2 = this.calculateValue(d);
        if (Double.isInfinite(d2)) {
            d2 = Double.MAX_VALUE;
        }
        if (d2 <= 0.0) {
            d2 = Double.MIN_VALUE;
        }
        return d2;
    }

    @Override
    public double java2DToValue(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = this.calculateLog(Math.max(this.smallestValue, range.getLowerBound()));
        double d3 = this.calculateLog(range.getUpperBound());
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d4 = rectangle2D.getMaxY();
            d5 = rectangle2D.getY();
        }
        double d6 = this.isInverted() ? d3 - (d - d4) / (d5 - d4) * (d3 - d2) : d2 + (d - d4) / (d5 - d4) * (d3 - d2);
        return this.calculateValue(d6);
    }

    @Override
    public double valueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = this.calculateLog(range.getLowerBound());
        double d3 = this.calculateLog(range.getUpperBound());
        d = this.calculateLog(d);
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d5 = rectangle2D.getMinY();
            d4 = rectangle2D.getMaxY();
        }
        if (this.isInverted()) {
            return d5 - (d - d2) / (d3 - d2) * (d5 - d4);
        }
        return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
    }

    @Override
    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    @Override
    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = this.getDefaultAutoRange();
            }
            double d = range.getUpperBound();
            double d2 = Math.max(range.getLowerBound(), this.smallestValue);
            double d3 = d - d2;
            double d4 = this.getFixedAutoRange();
            if (d4 > 0.0) {
                d2 = Math.max(d - d4, this.smallestValue);
            } else {
                double d5;
                double d6 = this.getAutoRangeMinimumSize();
                if (d3 < d6) {
                    d5 = (d6 - d3) / 2.0;
                    d += d5;
                    d2 -= d5;
                }
                d5 = this.calculateLog(d);
                double d7 = this.calculateLog(d2);
                double d8 = d5 - d7;
                d = this.calculateValueNoINF(d5 += this.getUpperMargin() * d8);
                d2 = this.calculateValueNoINF(d7 -= this.getLowerMargin() * d8);
            }
            this.setRange(new Range(d2, d), false, false);
        }
    }

    @Override
    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        if (!this.isVisible()) {
            AxisState axisState = new AxisState(d);
            List list = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
            axisState.setTicks(list);
            return axisState;
        }
        AxisState axisState = this.drawTickMarksAndLabels(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        axisState = this.getAttributedLabel() != null ? this.drawAttributedLabel(this.getAttributedLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState) : this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        this.createAndAddEntity(d, axisState, rectangle2D2, rectangleEdge, plotRenderingInfo);
        return axisState;
    }

    @Override
    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        List list = new ArrayList();
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            list = this.refreshTicksHorizontal(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            list = this.refreshTicksVertical(graphics2D, rectangle2D, rectangleEdge);
        }
        return list;
    }

    protected List refreshTicksHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        boolean bl;
        Range range = this.getRange();
        ArrayList<LogTick> arrayList = new ArrayList<LogTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        TextAnchor textAnchor = rectangleEdge == RectangleEdge.TOP ? TextAnchor.BOTTOM_CENTER : TextAnchor.TOP_CENTER;
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
        int n = this.tickUnit.getMinorTickCount();
        double d = this.getTickUnit().getSize();
        double d2 = Math.ceil(this.calculateLog(this.getRange().getLowerBound()) / d);
        double d3 = d2 * d;
        double d4 = this.calculateLog(this.getUpperBound());
        boolean bl2 = bl = this.tickUnit.getSize() > 0.0 && !Double.isInfinite(d3);
        for (double d5 = d3; bl && d5 <= d4; d5 += this.tickUnit.getSize()) {
            double d6 = this.calculateValueNoINF(d5);
            if (range.contains(d6)) {
                arrayList.add(new LogTick(TickType.MAJOR, d6, this.createTickLabel(d6), textAnchor));
            }
            double d7 = Math.pow(this.base, d5 + this.tickUnit.getSize());
            for (int i = 1; i < n; ++i) {
                double d8 = d6 + (double)i * ((d7 - d6) / (double)n);
                if (!range.contains(d8)) continue;
                arrayList.add(new LogTick(TickType.MINOR, d8, null, textAnchor));
            }
        }
        return arrayList;
    }

    protected List refreshTicksVertical(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        boolean bl;
        Range range = this.getRange();
        ArrayList<LogTick> arrayList = new ArrayList<LogTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        TextAnchor textAnchor = rectangleEdge == RectangleEdge.RIGHT ? TextAnchor.CENTER_LEFT : TextAnchor.CENTER_RIGHT;
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
        int n = this.tickUnit.getMinorTickCount();
        double d = this.getTickUnit().getSize();
        double d2 = Math.ceil(this.calculateLog(this.getRange().getLowerBound()) / d);
        double d3 = d2 * d;
        double d4 = this.calculateLog(this.getUpperBound());
        boolean bl2 = bl = this.tickUnit.getSize() > 0.0 && !Double.isInfinite(d3);
        for (double d5 = d3; bl && d5 <= d4; d5 += this.tickUnit.getSize()) {
            double d6 = this.calculateValueNoINF(d5);
            if (range.contains(d6)) {
                arrayList.add(new LogTick(TickType.MAJOR, d6, this.createTickLabel(d6), textAnchor));
            }
            double d7 = Math.pow(this.base, d5 + this.tickUnit.getSize());
            for (int i = 1; i < n; ++i) {
                double d8 = d6 + (double)i * ((d7 - d6) / (double)n);
                if (!range.contains(d8)) continue;
                arrayList.add(new LogTick(TickType.MINOR, d8, null, textAnchor));
            }
        }
        return arrayList;
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.selectHorizontalAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.selectVerticalAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
    }

    protected void selectHorizontalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        TickUnit tickUnit;
        Range range = this.getRange();
        double d = this.calculateLog(Math.max(this.smallestValue, range.getLowerBound()));
        double d2 = this.calculateLog(range.getUpperBound());
        double d3 = (d2 - d) / 50.0;
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit2 = tickUnit = tickUnitSource.getCeilingTickUnit(d3);
        boolean bl = false;
        while (!bl) {
            double d4;
            this.tickUnit = (NumberTickUnit)tickUnit;
            double d5 = this.estimateMaximumTickLabelWidth(graphics2D, tickUnit);
            if (d5 < (d4 = this.exponentLengthToJava2D(tickUnit.getSize(), rectangle2D, rectangleEdge))) {
                bl = true;
                continue;
            }
            if (Double.isNaN(d4)) {
                tickUnit = tickUnit2;
                bl = true;
                continue;
            }
            tickUnit2 = tickUnit;
            if (!(tickUnit = tickUnitSource.getLargerTickUnit(tickUnit2)).equals(tickUnit2)) continue;
            bl = true;
        }
        this.setTickUnit((NumberTickUnit)tickUnit, false, false);
    }

    public double exponentLengthToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = this.valueToJava2D(this.calculateValueNoINF(1.0), rectangle2D, rectangleEdge);
        double d3 = this.valueToJava2D(this.calculateValueNoINF(d + 1.0), rectangle2D, rectangleEdge);
        return Math.abs(d3 - d2);
    }

    protected void selectVerticalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        TickUnit tickUnit;
        Range range = this.getRange();
        double d = this.calculateLog(Math.max(this.smallestValue, range.getLowerBound()));
        double d2 = this.calculateLog(range.getUpperBound());
        double d3 = (d2 - d) / 50.0;
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit2 = tickUnit = tickUnitSource.getCeilingTickUnit(d3);
        boolean bl = false;
        while (!bl) {
            double d4;
            this.tickUnit = (NumberTickUnit)tickUnit;
            double d5 = this.estimateMaximumTickLabelHeight(graphics2D);
            if (d5 < (d4 = this.exponentLengthToJava2D(tickUnit.getSize(), rectangle2D, rectangleEdge))) {
                bl = true;
                continue;
            }
            if (Double.isNaN(d4)) {
                tickUnit = tickUnit2;
                bl = true;
                continue;
            }
            tickUnit2 = tickUnit;
            if (!(tickUnit = tickUnitSource.getLargerTickUnit(tickUnit2)).equals(tickUnit2)) continue;
            bl = true;
        }
        this.setTickUnit((NumberTickUnit)tickUnit, false, false);
    }

    protected AttributedString createTickLabel(double d) {
        if (this.numberFormatOverride != null) {
            return new AttributedString(this.numberFormatOverride.format(d));
        }
        String string = this.baseSymbol;
        if (string == null) {
            string = this.baseFormatter.format(this.base);
        }
        double d2 = this.calculateLog(d);
        String string2 = this.getTickUnit().valueToString(d2);
        AttributedString attributedString = new AttributedString(string + string2);
        attributedString.addAttributes(this.getTickLabelFont().getAttributes(), 0, (string + string2).length());
        attributedString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, string.length(), string.length() + string2.length());
        return attributedString;
    }

    protected double estimateMaximumTickLabelHeight(Graphics2D graphics2D) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        double d = rectangleInsets.getTop() + rectangleInsets.getBottom();
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        return d += (double)font.getLineMetrics("123", fontRenderContext).getHeight();
    }

    protected double estimateMaximumTickLabelWidth(Graphics2D graphics2D, TickUnit tickUnit) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        double d = rectangleInsets.getLeft() + rectangleInsets.getRight();
        if (this.isVerticalTickLabels()) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            LineMetrics lineMetrics = this.getTickLabelFont().getLineMetrics("0", fontRenderContext);
            d += (double)lineMetrics.getHeight();
        } else {
            Range range = this.getRange();
            double d2 = range.getLowerBound();
            double d3 = range.getUpperBound();
            AttributedString attributedString = this.createTickLabel(d2);
            AttributedString attributedString2 = this.createTickLabel(d3);
            double d4 = AttrStringUtils.getTextBounds(attributedString, graphics2D).getWidth();
            double d5 = AttrStringUtils.getTextBounds(attributedString2, graphics2D).getWidth();
            d += Math.max(d4, d5);
        }
        return d;
    }

    @Override
    public void zoomRange(double d, double d2) {
        Range range;
        Range range2 = this.getRange();
        double d3 = range2.getLowerBound();
        double d4 = range2.getUpperBound();
        double d5 = this.calculateLog(d3);
        double d6 = this.calculateLog(d4);
        double d7 = d6 - d5;
        if (this.isInverted()) {
            double d8 = d5 + d7 * (1.0 - d2);
            double d9 = d5 + d7 * (1.0 - d);
            range = new Range(this.calculateValueNoINF(d8), this.calculateValueNoINF(d9));
        } else {
            double d10 = d5 + d7 * d;
            double d11 = d5 + d7 * d2;
            range = new Range(this.calculateValueNoINF(d10), this.calculateValueNoINF(d11));
        }
        this.setRange(range);
    }

    @Override
    public void pan(double d) {
        Range range = this.getRange();
        double d2 = range.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = this.calculateLog(d2);
        double d5 = this.calculateLog(d3);
        double d6 = d5 - d4;
        double d7 = d6 * d;
        this.setRange(this.calculateValueNoINF(d4 += d7), this.calculateValueNoINF(d5 += d7));
    }

    @Override
    public void resizeRange(double d) {
        Range range = this.getRange();
        double d2 = this.calculateLog(range.getLowerBound());
        double d3 = this.calculateLog(range.getUpperBound());
        double d4 = this.calculateValueNoINF((d2 + d3) / 2.0);
        this.resizeRange(d, d4);
    }

    @Override
    public void resizeRange(double d, double d2) {
        this.resizeRange2(d, d2);
    }

    @Override
    public void resizeRange2(double d, double d2) {
        if (d > 0.0) {
            double d3 = this.calculateLog(d2);
            Range range = this.getRange();
            double d4 = this.calculateLog(range.getLowerBound());
            double d5 = this.calculateLog(range.getUpperBound());
            double d6 = d * (d3 - d4);
            double d7 = d * (d5 - d3);
            double d8 = this.calculateValueNoINF(d3 + d7);
            Range range2 = new Range(this.calculateValueNoINF(d3 - d6), d8);
            this.setRange(range2);
        } else {
            this.setAutoRange(true);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LogAxis)) {
            return false;
        }
        LogAxis logAxis = (LogAxis)object;
        if (this.base != logAxis.base) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseSymbol, logAxis.baseSymbol)) {
            return false;
        }
        if (!this.baseFormatter.equals(logAxis.baseFormatter)) {
            return false;
        }
        if (this.smallestValue != logAxis.smallestValue) {
            return false;
        }
        if (!ObjectUtilities.equal(this.numberFormatOverride, logAxis.numberFormatOverride)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n = 193;
        long l = Double.doubleToLongBits(this.base);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.smallestValue);
        n = 37 * n + (int)(l ^ l >>> 32);
        if (this.numberFormatOverride != null) {
            n = 37 * n + this.numberFormatOverride.hashCode();
        }
        n = 37 * n + this.tickUnit.hashCode();
        return n;
    }

    public static TickUnitSource createLogTickUnits(Locale locale) {
        TickUnits tickUnits = new TickUnits();
        LogFormat logFormat = new LogFormat();
        tickUnits.add(new NumberTickUnit(0.05, logFormat, 2));
        tickUnits.add(new NumberTickUnit(0.1, logFormat, 10));
        tickUnits.add(new NumberTickUnit(0.2, logFormat, 2));
        tickUnits.add(new NumberTickUnit(0.5, logFormat, 5));
        tickUnits.add(new NumberTickUnit(1.0, logFormat, 10));
        tickUnits.add(new NumberTickUnit(2.0, logFormat, 10));
        tickUnits.add(new NumberTickUnit(3.0, logFormat, 15));
        tickUnits.add(new NumberTickUnit(4.0, logFormat, 20));
        tickUnits.add(new NumberTickUnit(5.0, logFormat, 25));
        tickUnits.add(new NumberTickUnit(6.0, logFormat));
        tickUnits.add(new NumberTickUnit(7.0, logFormat));
        tickUnits.add(new NumberTickUnit(8.0, logFormat));
        tickUnits.add(new NumberTickUnit(9.0, logFormat));
        tickUnits.add(new NumberTickUnit(10.0, logFormat));
        return tickUnits;
    }
}

