/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.util.ParamChecks;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class AxisSpace
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -2490732595134766305L;
    private double top = 0.0;
    private double bottom = 0.0;
    private double left = 0.0;
    private double right = 0.0;

    public double getTop() {
        return this.top;
    }

    public void setTop(double d) {
        this.top = d;
    }

    public double getBottom() {
        return this.bottom;
    }

    public void setBottom(double d) {
        this.bottom = d;
    }

    public double getLeft() {
        return this.left;
    }

    public void setLeft(double d) {
        this.left = d;
    }

    public double getRight() {
        return this.right;
    }

    public void setRight(double d) {
        this.right = d;
    }

    public void add(double d, RectangleEdge rectangleEdge) {
        ParamChecks.nullNotPermitted(rectangleEdge, "edge");
        if (rectangleEdge == RectangleEdge.TOP) {
            this.top += d;
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            this.bottom += d;
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            this.left += d;
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            this.right += d;
        } else {
            throw new IllegalStateException("Unrecognised 'edge' argument.");
        }
    }

    public void ensureAtLeast(AxisSpace axisSpace) {
        this.top = Math.max(this.top, axisSpace.top);
        this.bottom = Math.max(this.bottom, axisSpace.bottom);
        this.left = Math.max(this.left, axisSpace.left);
        this.right = Math.max(this.right, axisSpace.right);
    }

    public void ensureAtLeast(double d, RectangleEdge rectangleEdge) {
        if (rectangleEdge == RectangleEdge.TOP) {
            if (this.top < d) {
                this.top = d;
            }
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            if (this.bottom < d) {
                this.bottom = d;
            }
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            if (this.left < d) {
                this.left = d;
            }
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            if (this.right < d) {
                this.right = d;
            }
        } else {
            throw new IllegalStateException("AxisSpace.ensureAtLeast(): unrecognised AxisLocation.");
        }
    }

    public Rectangle2D shrink(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (rectangle2D2 == null) {
            rectangle2D2 = new Rectangle2D.Double();
        }
        rectangle2D2.setRect(rectangle2D.getX() + this.left, rectangle2D.getY() + this.top, rectangle2D.getWidth() - this.left - this.right, rectangle2D.getHeight() - this.top - this.bottom);
        return rectangle2D2;
    }

    public Rectangle2D expand(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (rectangle2D2 == null) {
            rectangle2D2 = new Rectangle2D.Double();
        }
        rectangle2D2.setRect(rectangle2D.getX() - this.left, rectangle2D.getY() - this.top, rectangle2D.getWidth() + this.left + this.right, rectangle2D.getHeight() + this.top + this.bottom);
        return rectangle2D2;
    }

    public Rectangle2D reserved(Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Rectangle2D.Double double_ = null;
        if (rectangleEdge == RectangleEdge.TOP) {
            double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), this.top);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getMaxY() - this.top, rectangle2D.getWidth(), this.bottom);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), this.left, rectangle2D.getHeight());
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            double_ = new Rectangle2D.Double(rectangle2D.getMaxX() - this.right, rectangle2D.getY(), this.right, rectangle2D.getHeight());
        }
        return double_;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AxisSpace)) {
            return false;
        }
        AxisSpace axisSpace = (AxisSpace)object;
        if (this.top != axisSpace.top) {
            return false;
        }
        if (this.bottom != axisSpace.bottom) {
            return false;
        }
        if (this.left != axisSpace.left) {
            return false;
        }
        return this.right == axisSpace.right;
    }

    public int hashCode() {
        int n = 23;
        long l = Double.doubleToLongBits(this.top);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.bottom);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.left);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.right);
        n = 37 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public String toString() {
        return super.toString() + "[left=" + this.left + ",right=" + this.right + ",top=" + this.top + ",bottom=" + this.bottom + "]";
    }
}

