/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.annotations.AbstractXYAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockParams;
import org.jfree.chart.block.EntityBlockResult;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.Title;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.XYCoordinateType;
import org.jfree.data.Range;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Size2D;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class XYTitleAnnotation
extends AbstractXYAnnotation
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -4364694501921559958L;
    private XYCoordinateType coordinateType;
    private double x;
    private double y;
    private double maxWidth;
    private double maxHeight;
    private Title title;
    private RectangleAnchor anchor;

    public XYTitleAnnotation(double d, double d2, Title title) {
        this(d, d2, title, RectangleAnchor.CENTER);
    }

    public XYTitleAnnotation(double d, double d2, Title title, RectangleAnchor rectangleAnchor) {
        ParamChecks.nullNotPermitted(title, "title");
        ParamChecks.nullNotPermitted(rectangleAnchor, "anchor");
        this.coordinateType = XYCoordinateType.RELATIVE;
        this.x = d;
        this.y = d2;
        this.maxWidth = 0.0;
        this.maxHeight = 0.0;
        this.title = title;
        this.anchor = rectangleAnchor;
    }

    public XYCoordinateType getCoordinateType() {
        return this.coordinateType;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Title getTitle() {
        return this.title;
    }

    public RectangleAnchor getTitleAnchor() {
        return this.anchor;
    }

    public double getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(double d) {
        this.maxWidth = d;
        this.fireAnnotationChanged();
    }

    public double getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(double d) {
        this.maxHeight = d;
        this.fireAnnotationChanged();
    }

    @Override
    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, int n, PlotRenderingInfo plotRenderingInfo) {
        double d;
        double d2;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        AxisLocation axisLocation = xYPlot.getDomainAxisLocation();
        AxisLocation axisLocation2 = xYPlot.getRangeAxisLocation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(axisLocation, plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(axisLocation2, plotOrientation);
        Range range = valueAxis.getRange();
        Range range2 = valueAxis2.getRange();
        if (this.coordinateType == XYCoordinateType.RELATIVE) {
            d2 = range.getLowerBound() + this.x * range.getLength();
            d = range2.getLowerBound() + this.y * range2.getLength();
        } else {
            d2 = valueAxis.valueToJava2D(this.x, rectangle2D, rectangleEdge);
            d = valueAxis2.valueToJava2D(this.y, rectangle2D, rectangleEdge2);
        }
        float f = (float)valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        float f2 = (float)valueAxis2.valueToJava2D(d, rectangle2D, rectangleEdge2);
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            f3 = f2;
            f4 = f;
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            f3 = f;
            f4 = f2;
        }
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        if (this.coordinateType == XYCoordinateType.RELATIVE) {
            if (this.maxWidth > 0.0) {
                d3 *= this.maxWidth;
            }
            if (this.maxHeight > 0.0) {
                d4 *= this.maxHeight;
            }
        }
        if (this.coordinateType == XYCoordinateType.DATA) {
            d3 = this.maxWidth;
            d4 = this.maxHeight;
        }
        RectangleConstraint rectangleConstraint = new RectangleConstraint(new Range(0.0, d3), new Range(0.0, d4));
        Size2D size2D = this.title.arrange(graphics2D, rectangleConstraint);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, size2D.width, size2D.height);
        Point2D point2D = RectangleAnchor.coordinates(double_, this.anchor);
        ((Rectangle2D)double_).setRect(f3 -= (float)point2D.getX(), f4 -= (float)point2D.getY(), ((RectangularShape)double_).getWidth(), ((RectangularShape)double_).getHeight());
        BlockParams blockParams = new BlockParams();
        if (plotRenderingInfo != null && plotRenderingInfo.getOwner().getEntityCollection() != null) {
            blockParams.setGenerateEntities(true);
        }
        Object object = this.title.draw(graphics2D, double_, blockParams);
        if (plotRenderingInfo != null) {
            Object object2;
            if (object instanceof EntityBlockResult) {
                object2 = (EntityBlockResult)object;
                plotRenderingInfo.getOwner().getEntityCollection().addAll(object2.getEntityCollection());
            }
            object2 = this.getToolTipText();
            String string = this.getURL();
            if (object2 != null || string != null) {
                this.addEntity(plotRenderingInfo, new Rectangle2D.Float(f3, f4, (float)size2D.width, (float)size2D.height), n, (String)object2, string);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYTitleAnnotation)) {
            return false;
        }
        XYTitleAnnotation xYTitleAnnotation = (XYTitleAnnotation)object;
        if (this.coordinateType != xYTitleAnnotation.coordinateType) {
            return false;
        }
        if (this.x != xYTitleAnnotation.x) {
            return false;
        }
        if (this.y != xYTitleAnnotation.y) {
            return false;
        }
        if (this.maxWidth != xYTitleAnnotation.maxWidth) {
            return false;
        }
        if (this.maxHeight != xYTitleAnnotation.maxHeight) {
            return false;
        }
        if (!ObjectUtilities.equal(this.title, xYTitleAnnotation.title)) {
            return false;
        }
        if (!this.anchor.equals(xYTitleAnnotation.anchor)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n = 193;
        n = HashUtilities.hashCode(n, this.anchor);
        n = HashUtilities.hashCode(n, this.coordinateType);
        n = HashUtilities.hashCode(n, this.x);
        n = HashUtilities.hashCode(n, this.y);
        n = HashUtilities.hashCode(n, this.maxWidth);
        n = HashUtilities.hashCode(n, this.maxHeight);
        n = HashUtilities.hashCode(n, this.title);
        return n;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

