/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.annotations.AbstractXYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class XYTextAnnotation
extends AbstractXYAnnotation
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -2946063342782506328L;
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_PAINT = Color.black;
    public static final TextAnchor DEFAULT_TEXT_ANCHOR = TextAnchor.CENTER;
    public static final TextAnchor DEFAULT_ROTATION_ANCHOR = TextAnchor.CENTER;
    public static final double DEFAULT_ROTATION_ANGLE = 0.0;
    private String text;
    private Font font;
    private transient Paint paint;
    private double x;
    private double y;
    private TextAnchor textAnchor;
    private TextAnchor rotationAnchor;
    private double rotationAngle;
    private transient Paint backgroundPaint;
    private boolean outlineVisible;
    private transient Paint outlinePaint;
    private transient Stroke outlineStroke;

    public XYTextAnnotation(String string, double d, double d2) {
        ParamChecks.nullNotPermitted(string, "text");
        this.text = string;
        this.font = DEFAULT_FONT;
        this.paint = DEFAULT_PAINT;
        this.x = d;
        this.y = d2;
        this.textAnchor = DEFAULT_TEXT_ANCHOR;
        this.rotationAnchor = DEFAULT_ROTATION_ANCHOR;
        this.rotationAngle = 0.0;
        this.backgroundPaint = null;
        this.outlineVisible = false;
        this.outlinePaint = Color.black;
        this.outlineStroke = new BasicStroke(0.5f);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        ParamChecks.nullNotPermitted(string, "text");
        this.text = string;
        this.fireAnnotationChanged();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.font = font;
        this.fireAnnotationChanged();
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.paint = paint;
        this.fireAnnotationChanged();
    }

    public TextAnchor getTextAnchor() {
        return this.textAnchor;
    }

    public void setTextAnchor(TextAnchor textAnchor) {
        ParamChecks.nullNotPermitted(textAnchor, "anchor");
        this.textAnchor = textAnchor;
        this.fireAnnotationChanged();
    }

    public TextAnchor getRotationAnchor() {
        return this.rotationAnchor;
    }

    public void setRotationAnchor(TextAnchor textAnchor) {
        ParamChecks.nullNotPermitted(textAnchor, "anchor");
        this.rotationAnchor = textAnchor;
        this.fireAnnotationChanged();
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(double d) {
        this.rotationAngle = d;
        this.fireAnnotationChanged();
    }

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        this.x = d;
        this.fireAnnotationChanged();
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        this.y = d;
        this.fireAnnotationChanged();
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.fireAnnotationChanged();
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.outlinePaint = paint;
        this.fireAnnotationChanged();
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.outlineStroke = stroke;
        this.fireAnnotationChanged();
    }

    public boolean isOutlineVisible() {
        return this.outlineVisible;
    }

    public void setOutlineVisible(boolean bl) {
        this.outlineVisible = bl;
        this.fireAnnotationChanged();
    }

    @Override
    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, int n, PlotRenderingInfo plotRenderingInfo) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(xYPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(xYPlot.getRangeAxisLocation(), plotOrientation);
        float f = (float)valueAxis.valueToJava2D(this.x, rectangle2D, rectangleEdge);
        float f2 = (float)valueAxis2.valueToJava2D(this.y, rectangle2D, rectangleEdge2);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            float f3 = f;
            f = f2;
            f2 = f3;
        }
        graphics2D.setFont(this.getFont());
        Shape shape = TextUtilities.calculateRotatedStringBounds(this.getText(), graphics2D, f, f2, this.getTextAnchor(), this.getRotationAngle(), this.getRotationAnchor());
        if (this.backgroundPaint != null) {
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(shape);
        }
        graphics2D.setPaint(this.getPaint());
        TextUtilities.drawRotatedString(this.getText(), graphics2D, f, f2, this.getTextAnchor(), this.getRotationAngle(), this.getRotationAnchor());
        if (this.outlineVisible) {
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.draw(shape);
        }
        String string = this.getToolTipText();
        String string2 = this.getURL();
        if (string != null || string2 != null) {
            this.addEntity(plotRenderingInfo, shape, n, string, string2);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYTextAnnotation)) {
            return false;
        }
        XYTextAnnotation xYTextAnnotation = (XYTextAnnotation)object;
        if (!this.text.equals(xYTextAnnotation.text)) {
            return false;
        }
        if (this.x != xYTextAnnotation.x) {
            return false;
        }
        if (this.y != xYTextAnnotation.y) {
            return false;
        }
        if (!this.font.equals(xYTextAnnotation.font)) {
            return false;
        }
        if (!PaintUtilities.equal(this.paint, xYTextAnnotation.paint)) {
            return false;
        }
        if (!this.rotationAnchor.equals(xYTextAnnotation.rotationAnchor)) {
            return false;
        }
        if (this.rotationAngle != xYTextAnnotation.rotationAngle) {
            return false;
        }
        if (!this.textAnchor.equals(xYTextAnnotation.textAnchor)) {
            return false;
        }
        if (this.outlineVisible != xYTextAnnotation.outlineVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.backgroundPaint, xYTextAnnotation.backgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.outlinePaint, xYTextAnnotation.outlinePaint)) {
            return false;
        }
        if (!this.outlineStroke.equals(xYTextAnnotation.outlineStroke)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n = 193;
        n = 37 * n + this.text.hashCode();
        n = 37 * n + this.font.hashCode();
        n = 37 * n + HashUtilities.hashCodeForPaint(this.paint);
        long l = Double.doubleToLongBits(this.x);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 37 * n + (int)(l ^ l >>> 32);
        n = 37 * n + this.textAnchor.hashCode();
        n = 37 * n + this.rotationAnchor.hashCode();
        l = Double.doubleToLongBits(this.rotationAngle);
        n = 37 * n + (int)(l ^ l >>> 32);
        return n;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
        SerialUtilities.writePaint(this.backgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.outlineStroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
        this.backgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke(objectInputStream);
    }
}

