/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.PeriodAxis;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.LabelBlock;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.CompositeTitle;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.util.DefaultShadowGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ShadowGenerator;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class StandardChartTheme
implements ChartTheme,
Cloneable,
PublicCloneable,
Serializable {
    private String name;
    private Font extraLargeFont;
    private Font largeFont;
    private Font regularFont;
    private Font smallFont;
    private transient Paint titlePaint;
    private transient Paint subtitlePaint;
    private transient Paint chartBackgroundPaint;
    private transient Paint legendBackgroundPaint;
    private transient Paint legendItemPaint;
    private DrawingSupplier drawingSupplier;
    private transient Paint plotBackgroundPaint;
    private transient Paint plotOutlinePaint;
    private transient Paint labelLinkPaint;
    private transient Paint domainGridlinePaint;
    private transient Paint rangeGridlinePaint;
    private transient Paint baselinePaint;
    private transient Paint crosshairPaint;
    private RectangleInsets axisOffset;
    private transient Paint axisLabelPaint;
    private transient Paint tickLabelPaint;
    private transient Paint itemLabelPaint;
    private boolean shadowVisible;
    private transient Paint shadowPaint;
    private transient Paint thermometerPaint;
    private transient Paint wallPaint;
    private transient Paint errorIndicatorPaint;
    private transient Paint gridBandPaint = SymbolAxis.DEFAULT_GRID_BAND_PAINT;
    private transient Paint gridBandAlternatePaint = SymbolAxis.DEFAULT_GRID_BAND_ALTERNATE_PAINT;
    private ShadowGenerator shadowGenerator;

    public static ChartTheme createJFreeTheme() {
        return new StandardChartTheme("JFree");
    }

    public static ChartTheme createDarknessTheme() {
        StandardChartTheme standardChartTheme = new StandardChartTheme("Darkness");
        standardChartTheme.titlePaint = Color.white;
        standardChartTheme.subtitlePaint = Color.white;
        standardChartTheme.legendBackgroundPaint = Color.black;
        standardChartTheme.legendItemPaint = Color.white;
        standardChartTheme.chartBackgroundPaint = Color.black;
        standardChartTheme.plotBackgroundPaint = Color.black;
        standardChartTheme.plotOutlinePaint = Color.yellow;
        standardChartTheme.baselinePaint = Color.white;
        standardChartTheme.crosshairPaint = Color.red;
        standardChartTheme.labelLinkPaint = Color.lightGray;
        standardChartTheme.tickLabelPaint = Color.white;
        standardChartTheme.axisLabelPaint = Color.white;
        standardChartTheme.shadowPaint = Color.darkGray;
        standardChartTheme.itemLabelPaint = Color.white;
        standardChartTheme.drawingSupplier = new DefaultDrawingSupplier(new Paint[]{Color.decode("0xFFFF00"), Color.decode("0x0036CC"), Color.decode("0xFF0000"), Color.decode("0xFFFF7F"), Color.decode("0x6681CC"), Color.decode("0xFF7F7F"), Color.decode("0xFFFFBF"), Color.decode("0x99A6CC"), Color.decode("0xFFBFBF"), Color.decode("0xA9A938"), Color.decode("0x2D4587")}, new Paint[]{Color.decode("0xFFFF00"), Color.decode("0x0036CC")}, new Stroke[]{new BasicStroke(2.0f)}, new Stroke[]{new BasicStroke(0.5f)}, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE);
        standardChartTheme.wallPaint = Color.darkGray;
        standardChartTheme.errorIndicatorPaint = Color.lightGray;
        standardChartTheme.gridBandPaint = new Color(255, 255, 255, 20);
        standardChartTheme.gridBandAlternatePaint = new Color(255, 255, 255, 40);
        standardChartTheme.shadowGenerator = null;
        return standardChartTheme;
    }

    public static ChartTheme createLegacyTheme() {
        StandardChartTheme standardChartTheme = new StandardChartTheme("Legacy"){

            @Override
            public void apply(JFreeChart jFreeChart) {
            }
        };
        return standardChartTheme;
    }

    public StandardChartTheme(String string) {
        this(string, false);
    }

    public StandardChartTheme(String string, boolean bl) {
        ParamChecks.nullNotPermitted(string, "name");
        this.name = string;
        this.extraLargeFont = new Font("Tahoma", 1, 20);
        this.largeFont = new Font("Tahoma", 1, 14);
        this.regularFont = new Font("Tahoma", 0, 12);
        this.smallFont = new Font("Tahoma", 0, 10);
        this.titlePaint = Color.black;
        this.subtitlePaint = Color.black;
        this.legendBackgroundPaint = Color.white;
        this.legendItemPaint = Color.darkGray;
        this.chartBackgroundPaint = Color.white;
        this.drawingSupplier = new DefaultDrawingSupplier();
        this.plotBackgroundPaint = Color.lightGray;
        this.plotOutlinePaint = Color.black;
        this.labelLinkPaint = Color.black;
        this.axisOffset = new RectangleInsets(4.0, 4.0, 4.0, 4.0);
        this.domainGridlinePaint = Color.white;
        this.rangeGridlinePaint = Color.white;
        this.baselinePaint = Color.black;
        this.crosshairPaint = Color.blue;
        this.axisLabelPaint = Color.darkGray;
        this.tickLabelPaint = Color.darkGray;
        this.shadowVisible = false;
        this.shadowPaint = Color.gray;
        this.itemLabelPaint = Color.black;
        this.thermometerPaint = Color.white;
        this.errorIndicatorPaint = Color.black;
        this.shadowGenerator = bl ? new DefaultShadowGenerator() : null;
    }

    public Font getExtraLargeFont() {
        return this.extraLargeFont;
    }

    public void setExtraLargeFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.extraLargeFont = font;
    }

    public Font getLargeFont() {
        return this.largeFont;
    }

    public void setLargeFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.largeFont = font;
    }

    public Font getRegularFont() {
        return this.regularFont;
    }

    public void setRegularFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.regularFont = font;
    }

    public Font getSmallFont() {
        return this.smallFont;
    }

    public void setSmallFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.smallFont = font;
    }

    public Paint getTitlePaint() {
        return this.titlePaint;
    }

    public void setTitlePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.titlePaint = paint;
    }

    public Paint getSubtitlePaint() {
        return this.subtitlePaint;
    }

    public void setSubtitlePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.subtitlePaint = paint;
    }

    public Paint getChartBackgroundPaint() {
        return this.chartBackgroundPaint;
    }

    public void setChartBackgroundPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.chartBackgroundPaint = paint;
    }

    public Paint getLegendBackgroundPaint() {
        return this.legendBackgroundPaint;
    }

    public void setLegendBackgroundPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.legendBackgroundPaint = paint;
    }

    public Paint getLegendItemPaint() {
        return this.legendItemPaint;
    }

    public void setLegendItemPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.legendItemPaint = paint;
    }

    public Paint getPlotBackgroundPaint() {
        return this.plotBackgroundPaint;
    }

    public void setPlotBackgroundPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.plotBackgroundPaint = paint;
    }

    public Paint getPlotOutlinePaint() {
        return this.plotOutlinePaint;
    }

    public void setPlotOutlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.plotOutlinePaint = paint;
    }

    public Paint getLabelLinkPaint() {
        return this.labelLinkPaint;
    }

    public void setLabelLinkPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.labelLinkPaint = paint;
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.domainGridlinePaint = paint;
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.rangeGridlinePaint = paint;
    }

    public Paint getBaselinePaint() {
        return this.baselinePaint;
    }

    public void setBaselinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.baselinePaint = paint;
    }

    public Paint getCrosshairPaint() {
        return this.crosshairPaint;
    }

    public void setCrosshairPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.crosshairPaint = paint;
    }

    public RectangleInsets getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(RectangleInsets rectangleInsets) {
        ParamChecks.nullNotPermitted(rectangleInsets, "offset");
        this.axisOffset = rectangleInsets;
    }

    public Paint getAxisLabelPaint() {
        return this.axisLabelPaint;
    }

    public void setAxisLabelPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.axisLabelPaint = paint;
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.tickLabelPaint = paint;
    }

    public Paint getItemLabelPaint() {
        return this.itemLabelPaint;
    }

    public void setItemLabelPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.itemLabelPaint = paint;
    }

    public boolean isShadowVisible() {
        return this.shadowVisible;
    }

    public void setShadowVisible(boolean bl) {
        this.shadowVisible = bl;
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.shadowPaint = paint;
    }

    public Paint getThermometerPaint() {
        return this.thermometerPaint;
    }

    public void setThermometerPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.thermometerPaint = paint;
    }

    public Paint getWallPaint() {
        return this.wallPaint;
    }

    public void setWallPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.wallPaint = paint;
    }

    public Paint getErrorIndicatorPaint() {
        return this.errorIndicatorPaint;
    }

    public void setErrorIndicatorPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.errorIndicatorPaint = paint;
    }

    public Paint getGridBandPaint() {
        return this.gridBandPaint;
    }

    public void setGridBandPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.gridBandPaint = paint;
    }

    public Paint getGridBandAlternatePaint() {
        return this.gridBandAlternatePaint;
    }

    public void setGridBandAlternatePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.gridBandAlternatePaint = paint;
    }

    public String getName() {
        return this.name;
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        if (this.drawingSupplier instanceof PublicCloneable) {
            PublicCloneable publicCloneable = (PublicCloneable)((Object)this.drawingSupplier);
            try {
                drawingSupplier = (DrawingSupplier)publicCloneable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        }
        return drawingSupplier;
    }

    public void setDrawingSupplier(DrawingSupplier drawingSupplier) {
        ParamChecks.nullNotPermitted(drawingSupplier, "supplier");
        this.drawingSupplier = drawingSupplier;
    }

    @Override
    public void apply(JFreeChart jFreeChart) {
        ParamChecks.nullNotPermitted(jFreeChart, "chart");
        TextTitle textTitle = jFreeChart.getTitle();
        if (textTitle != null) {
            textTitle.setFont(this.extraLargeFont);
            textTitle.setPaint(this.titlePaint);
        }
        int n = jFreeChart.getSubtitleCount();
        for (int i = 0; i < n; ++i) {
            this.applyToTitle(jFreeChart.getSubtitle(i));
        }
        jFreeChart.setBackgroundPaint(this.chartBackgroundPaint);
        Plot plot = jFreeChart.getPlot();
        if (plot != null) {
            this.applyToPlot(plot);
        }
    }

    protected void applyToTitle(Title title) {
        if (title instanceof TextTitle) {
            TextTitle textTitle = (TextTitle)title;
            textTitle.setFont(this.largeFont);
            textTitle.setPaint(this.subtitlePaint);
        } else if (title instanceof LegendTitle) {
            LegendTitle legendTitle = (LegendTitle)title;
            if (legendTitle.getBackgroundPaint() != null) {
                legendTitle.setBackgroundPaint(this.legendBackgroundPaint);
            }
            legendTitle.setItemFont(this.regularFont);
            legendTitle.setItemPaint(this.legendItemPaint);
            if (legendTitle.getWrapper() != null) {
                this.applyToBlockContainer(legendTitle.getWrapper());
            }
        } else if (title instanceof PaintScaleLegend) {
            PaintScaleLegend paintScaleLegend = (PaintScaleLegend)title;
            paintScaleLegend.setBackgroundPaint(this.legendBackgroundPaint);
            ValueAxis valueAxis = paintScaleLegend.getAxis();
            if (valueAxis != null) {
                this.applyToValueAxis(valueAxis);
            }
        } else if (title instanceof CompositeTitle) {
            CompositeTitle compositeTitle = (CompositeTitle)title;
            BlockContainer blockContainer = compositeTitle.getContainer();
            List list = blockContainer.getBlocks();
            for (Block block : list) {
                if (!(block instanceof Title)) continue;
                this.applyToTitle((Title)block);
            }
        }
    }

    protected void applyToBlockContainer(BlockContainer blockContainer) {
        for (Block block : blockContainer.getBlocks()) {
            this.applyToBlock(block);
        }
    }

    protected void applyToBlock(Block block) {
        if (block instanceof Title) {
            this.applyToTitle((Title)block);
        } else if (block instanceof LabelBlock) {
            LabelBlock labelBlock = (LabelBlock)block;
            labelBlock.setFont(this.regularFont);
            labelBlock.setPaint(this.legendItemPaint);
        }
    }

    protected void applyToPlot(Plot plot) {
        ParamChecks.nullNotPermitted(plot, "plot");
        if (plot.getDrawingSupplier() != null) {
            plot.setDrawingSupplier(this.getDrawingSupplier());
        }
        if (plot.getBackgroundPaint() != null) {
            plot.setBackgroundPaint(this.plotBackgroundPaint);
        }
        plot.setOutlinePaint(this.plotOutlinePaint);
    }

    protected void applyToXYPlot(XYPlot xYPlot) {
        Object object2;
        int n;
        int n2;
        xYPlot.setAxisOffset(this.axisOffset);
        xYPlot.setDomainZeroBaselinePaint(this.baselinePaint);
        xYPlot.setRangeZeroBaselinePaint(this.baselinePaint);
        xYPlot.setDomainGridlinePaint(this.domainGridlinePaint);
        xYPlot.setRangeGridlinePaint(this.rangeGridlinePaint);
        xYPlot.setDomainCrosshairPaint(this.crosshairPaint);
        xYPlot.setRangeCrosshairPaint(this.crosshairPaint);
        xYPlot.setShadowGenerator(this.shadowGenerator);
        int n3 = xYPlot.getDomainAxisCount();
        for (n2 = 0; n2 < n3; ++n2) {
            ValueAxis valueAxis = xYPlot.getDomainAxis(n2);
            if (valueAxis == null) continue;
            this.applyToValueAxis(valueAxis);
        }
        n2 = xYPlot.getRangeAxisCount();
        for (n = 0; n < n2; ++n) {
            ValueAxis valueAxis = xYPlot.getRangeAxis(n);
            if (valueAxis == null) continue;
            this.applyToValueAxis(valueAxis);
        }
        n = xYPlot.getRendererCount();
        for (int i = 0; i < n; ++i) {
            object2 = xYPlot.getRenderer(i);
            if (object2 == null) continue;
            this.applyToXYItemRenderer((XYItemRenderer)object2);
        }
        for (Object object2 : xYPlot.getAnnotations()) {
            this.applyToXYAnnotation((XYAnnotation)object2);
        }
        if (xYPlot instanceof CombinedDomainXYPlot) {
            object2 = (CombinedDomainXYPlot)xYPlot;
            for (XYPlot xYPlot2 : ((CombinedDomainXYPlot)object2).getSubplots()) {
                if (xYPlot2 == null) continue;
                this.applyToPlot(xYPlot2);
            }
        }
        if (xYPlot instanceof CombinedRangeXYPlot) {
            object2 = (CombinedRangeXYPlot)xYPlot;
            for (XYPlot xYPlot2 : ((CombinedRangeXYPlot)object2).getSubplots()) {
                if (xYPlot2 == null) continue;
                this.applyToPlot(xYPlot2);
            }
        }
    }

    protected void applyToFastScatterPlot(FastScatterPlot fastScatterPlot) {
        ValueAxis valueAxis;
        fastScatterPlot.setDomainGridlinePaint(this.domainGridlinePaint);
        fastScatterPlot.setRangeGridlinePaint(this.rangeGridlinePaint);
        ValueAxis valueAxis2 = fastScatterPlot.getDomainAxis();
        if (valueAxis2 != null) {
            this.applyToValueAxis(valueAxis2);
        }
        if ((valueAxis = fastScatterPlot.getRangeAxis()) != null) {
            this.applyToValueAxis(valueAxis);
        }
    }

    protected void applyToValueAxis(ValueAxis valueAxis) {
        valueAxis.setLabelFont(this.largeFont);
        valueAxis.setLabelPaint(this.axisLabelPaint);
        valueAxis.setTickLabelFont(this.regularFont);
        valueAxis.setTickLabelPaint(this.tickLabelPaint);
        if (valueAxis instanceof SymbolAxis) {
            this.applyToSymbolAxis((SymbolAxis)valueAxis);
        }
        if (valueAxis instanceof PeriodAxis) {
            this.applyToPeriodAxis((PeriodAxis)valueAxis);
        }
    }

    protected void applyToSymbolAxis(SymbolAxis symbolAxis) {
        symbolAxis.setGridBandPaint(this.gridBandPaint);
        symbolAxis.setGridBandAlternatePaint(this.gridBandAlternatePaint);
    }

    protected void applyToPeriodAxis(PeriodAxis periodAxis) {
        PeriodAxisLabelInfo[] periodAxisLabelInfoArray = periodAxis.getLabelInfo();
        for (int i = 0; i < periodAxisLabelInfoArray.length; ++i) {
            PeriodAxisLabelInfo periodAxisLabelInfo;
            PeriodAxisLabelInfo periodAxisLabelInfo2 = periodAxisLabelInfoArray[i];
            periodAxisLabelInfoArray[i] = periodAxisLabelInfo = new PeriodAxisLabelInfo(periodAxisLabelInfo2.getPeriodClass(), periodAxisLabelInfo2.getDateFormat(), periodAxisLabelInfo2.getPadding(), this.regularFont, this.tickLabelPaint, periodAxisLabelInfo2.getDrawDividers(), periodAxisLabelInfo2.getDividerStroke(), periodAxisLabelInfo2.getDividerPaint());
        }
        periodAxis.setLabelInfo(periodAxisLabelInfoArray);
    }

    protected void applyToAbstractRenderer(AbstractRenderer abstractRenderer) {
        if (abstractRenderer.getAutoPopulateSeriesPaint()) {
            abstractRenderer.clearSeriesPaints(false);
        }
        if (abstractRenderer.getAutoPopulateSeriesStroke()) {
            abstractRenderer.clearSeriesStrokes(false);
        }
    }

    protected void applyToXYItemRenderer(XYItemRenderer xYItemRenderer) {
        ParamChecks.nullNotPermitted(xYItemRenderer, "renderer");
        if (xYItemRenderer instanceof AbstractRenderer) {
            this.applyToAbstractRenderer((AbstractRenderer)((Object)xYItemRenderer));
        }
        xYItemRenderer.setBaseItemLabelFont(this.regularFont);
        xYItemRenderer.setBaseItemLabelPaint(this.itemLabelPaint);
    }

    protected void applyToXYAnnotation(XYAnnotation xYAnnotation) {
        ParamChecks.nullNotPermitted(xYAnnotation, "annotation");
        if (xYAnnotation instanceof XYTextAnnotation) {
            XYTextAnnotation xYTextAnnotation = (XYTextAnnotation)xYAnnotation;
            xYTextAnnotation.setFont(this.smallFont);
            xYTextAnnotation.setPaint(this.itemLabelPaint);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardChartTheme)) {
            return false;
        }
        StandardChartTheme standardChartTheme = (StandardChartTheme)object;
        if (!this.name.equals(standardChartTheme.name)) {
            return false;
        }
        if (!this.extraLargeFont.equals(standardChartTheme.extraLargeFont)) {
            return false;
        }
        if (!this.largeFont.equals(standardChartTheme.largeFont)) {
            return false;
        }
        if (!this.regularFont.equals(standardChartTheme.regularFont)) {
            return false;
        }
        if (!this.smallFont.equals(standardChartTheme.smallFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.titlePaint, standardChartTheme.titlePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.subtitlePaint, standardChartTheme.subtitlePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.chartBackgroundPaint, standardChartTheme.chartBackgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.legendBackgroundPaint, standardChartTheme.legendBackgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.legendItemPaint, standardChartTheme.legendItemPaint)) {
            return false;
        }
        if (!this.drawingSupplier.equals(standardChartTheme.drawingSupplier)) {
            return false;
        }
        if (!PaintUtilities.equal(this.plotBackgroundPaint, standardChartTheme.plotBackgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.plotOutlinePaint, standardChartTheme.plotOutlinePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.labelLinkPaint, standardChartTheme.labelLinkPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainGridlinePaint, standardChartTheme.domainGridlinePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeGridlinePaint, standardChartTheme.rangeGridlinePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.crosshairPaint, standardChartTheme.crosshairPaint)) {
            return false;
        }
        if (!this.axisOffset.equals(standardChartTheme.axisOffset)) {
            return false;
        }
        if (!PaintUtilities.equal(this.axisLabelPaint, standardChartTheme.axisLabelPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.tickLabelPaint, standardChartTheme.tickLabelPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.itemLabelPaint, standardChartTheme.itemLabelPaint)) {
            return false;
        }
        if (this.shadowVisible != standardChartTheme.shadowVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.shadowPaint, standardChartTheme.shadowPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.thermometerPaint, standardChartTheme.thermometerPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.wallPaint, standardChartTheme.wallPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.errorIndicatorPaint, standardChartTheme.errorIndicatorPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.gridBandPaint, standardChartTheme.gridBandPaint)) {
            return false;
        }
        return PaintUtilities.equal(this.gridBandAlternatePaint, standardChartTheme.gridBandAlternatePaint);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.titlePaint, objectOutputStream);
        SerialUtilities.writePaint(this.subtitlePaint, objectOutputStream);
        SerialUtilities.writePaint(this.chartBackgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.legendBackgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.legendItemPaint, objectOutputStream);
        SerialUtilities.writePaint(this.plotBackgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.plotOutlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.labelLinkPaint, objectOutputStream);
        SerialUtilities.writePaint(this.baselinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.domainGridlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.rangeGridlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.crosshairPaint, objectOutputStream);
        SerialUtilities.writePaint(this.axisLabelPaint, objectOutputStream);
        SerialUtilities.writePaint(this.tickLabelPaint, objectOutputStream);
        SerialUtilities.writePaint(this.itemLabelPaint, objectOutputStream);
        SerialUtilities.writePaint(this.shadowPaint, objectOutputStream);
        SerialUtilities.writePaint(this.thermometerPaint, objectOutputStream);
        SerialUtilities.writePaint(this.wallPaint, objectOutputStream);
        SerialUtilities.writePaint(this.errorIndicatorPaint, objectOutputStream);
        SerialUtilities.writePaint(this.gridBandPaint, objectOutputStream);
        SerialUtilities.writePaint(this.gridBandAlternatePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.titlePaint = SerialUtilities.readPaint(objectInputStream);
        this.subtitlePaint = SerialUtilities.readPaint(objectInputStream);
        this.chartBackgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.legendBackgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.legendItemPaint = SerialUtilities.readPaint(objectInputStream);
        this.plotBackgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.plotOutlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.labelLinkPaint = SerialUtilities.readPaint(objectInputStream);
        this.baselinePaint = SerialUtilities.readPaint(objectInputStream);
        this.domainGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.crosshairPaint = SerialUtilities.readPaint(objectInputStream);
        this.axisLabelPaint = SerialUtilities.readPaint(objectInputStream);
        this.tickLabelPaint = SerialUtilities.readPaint(objectInputStream);
        this.itemLabelPaint = SerialUtilities.readPaint(objectInputStream);
        this.shadowPaint = SerialUtilities.readPaint(objectInputStream);
        this.thermometerPaint = SerialUtilities.readPaint(objectInputStream);
        this.wallPaint = SerialUtilities.readPaint(objectInputStream);
        this.errorIndicatorPaint = SerialUtilities.readPaint(objectInputStream);
        this.gridBandPaint = SerialUtilities.readPaint(objectInputStream);
        this.gridBandAlternatePaint = SerialUtilities.readPaint(objectInputStream);
    }
}

