/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.util.BooleanList;
import org.jfree.util.PaintList;
import org.jfree.util.StrokeList;

public class HashUtilities {
    public static int hashCodeForPaint(Paint paint) {
        int n;
        if (paint == null) {
            return 0;
        }
        if (paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            n = 193;
            n = 37 * n + gradientPaint.getColor1().hashCode();
            n = 37 * n + gradientPaint.getPoint1().hashCode();
            n = 37 * n + gradientPaint.getColor2().hashCode();
            n = 37 * n + gradientPaint.getPoint2().hashCode();
        } else {
            n = paint.hashCode();
        }
        return n;
    }

    public static int hashCodeForDoubleArray(double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        int n = 193;
        for (int i = 0; i < dArray.length; ++i) {
            long l = Double.doubleToLongBits(dArray[i]);
            n = 29 * n + (int)(l ^ l >>> 32);
        }
        return n;
    }

    public static int hashCode(int n, boolean bl) {
        return 37 * n + (bl ? 0 : 1);
    }

    public static int hashCode(int n, int n2) {
        return 37 * n + n2;
    }

    public static int hashCode(int n, double d) {
        long l = Double.doubleToLongBits(d);
        return 37 * n + (int)(l ^ l >>> 32);
    }

    public static int hashCode(int n, Paint paint) {
        return 37 * n + HashUtilities.hashCodeForPaint(paint);
    }

    public static int hashCode(int n, Stroke stroke) {
        int n2 = stroke != null ? stroke.hashCode() : 0;
        return 37 * n + n2;
    }

    public static int hashCode(int n, String string) {
        int n2 = string != null ? string.hashCode() : 0;
        return 37 * n + n2;
    }

    public static int hashCode(int n, Comparable comparable) {
        int n2 = comparable != null ? comparable.hashCode() : 0;
        return 37 * n + n2;
    }

    public static int hashCode(int n, Object object) {
        int n2 = object != null ? object.hashCode() : 0;
        return 37 * n + n2;
    }

    public static int hashCode(int n, BooleanList booleanList) {
        if (booleanList == null) {
            return n;
        }
        int n2 = 127;
        int n3 = booleanList.size();
        n2 = HashUtilities.hashCode(n2, n3);
        if (n3 > 0) {
            n2 = HashUtilities.hashCode(n2, booleanList.getBoolean(0));
            if (n3 > 1) {
                n2 = HashUtilities.hashCode(n2, booleanList.getBoolean(n3 - 1));
                if (n3 > 2) {
                    n2 = HashUtilities.hashCode(n2, booleanList.getBoolean(n3 / 2));
                }
            }
        }
        return 37 * n + n2;
    }

    public static int hashCode(int n, PaintList paintList) {
        if (paintList == null) {
            return n;
        }
        int n2 = 127;
        int n3 = paintList.size();
        n2 = HashUtilities.hashCode(n2, n3);
        if (n3 > 0) {
            n2 = HashUtilities.hashCode(n2, paintList.getPaint(0));
            if (n3 > 1) {
                n2 = HashUtilities.hashCode(n2, paintList.getPaint(n3 - 1));
                if (n3 > 2) {
                    n2 = HashUtilities.hashCode(n2, paintList.getPaint(n3 / 2));
                }
            }
        }
        return 37 * n + n2;
    }

    public static int hashCode(int n, StrokeList strokeList) {
        if (strokeList == null) {
            return n;
        }
        int n2 = 127;
        int n3 = strokeList.size();
        n2 = HashUtilities.hashCode(n2, n3);
        if (n3 > 0) {
            n2 = HashUtilities.hashCode(n2, strokeList.getStroke(0));
            if (n3 > 1) {
                n2 = HashUtilities.hashCode(n2, strokeList.getStroke(n3 - 1));
                if (n3 > 2) {
                    n2 = HashUtilities.hashCode(n2, strokeList.getStroke(n3 / 2));
                }
            }
        }
        return 37 * n + n2;
    }
}

