/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.imagemap.OverLIBToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.StandardURLTagFragmentGenerator;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;
import org.jfree.chart.util.ParamChecks;

public abstract class ChartUtilities {
    public static void applyCurrentTheme(JFreeChart jFreeChart) {
        ChartFactory.getChartTheme().apply(jFreeChart);
    }

    public static void writeChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2) throws IOException {
        ChartUtilities.writeChartAsPNG(outputStream, jFreeChart, n, n2, null);
    }

    public static void writeChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, boolean bl, int n3) throws IOException {
        ChartUtilities.writeChartAsPNG(outputStream, jFreeChart, n, n2, null, bl, n3);
    }

    public static void writeChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) throws IOException {
        ParamChecks.nullNotPermitted(jFreeChart, "chart");
        BufferedImage bufferedImage = jFreeChart.createBufferedImage(n, n2, chartRenderingInfo);
        EncoderUtil.writeBufferedImage(bufferedImage, "png", outputStream);
    }

    public static void writeChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo, boolean bl, int n3) throws IOException {
        ParamChecks.nullNotPermitted(outputStream, "out");
        ParamChecks.nullNotPermitted(jFreeChart, "chart");
        BufferedImage bufferedImage = jFreeChart.createBufferedImage(n, n2, 2, chartRenderingInfo);
        ChartUtilities.writeBufferedImageAsPNG(outputStream, bufferedImage, bl, n3);
    }

    public static void writeScaledChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, int n3, int n4) throws IOException {
        ParamChecks.nullNotPermitted(outputStream, "out");
        ParamChecks.nullNotPermitted(jFreeChart, "chart");
        double d = n * n3;
        double d2 = n2 * n4;
        double d3 = n;
        double d4 = n2;
        boolean bl = false;
        if (n3 != 1 || n4 != 1) {
            bl = true;
        }
        double d5 = d / d3;
        double d6 = d2 / d4;
        BufferedImage bufferedImage = new BufferedImage((int)d, (int)d2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (bl) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.transform(AffineTransform.getScaleInstance(d5, d6));
            jFreeChart.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, d3, d4), null, null);
            graphics2D.setTransform(affineTransform);
            graphics2D.dispose();
        } else {
            jFreeChart.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, d3, d4), null, null);
        }
        outputStream.write(ChartUtilities.encodeAsPNG(bufferedImage));
    }

    public static void saveChartAsPNG(File file, JFreeChart jFreeChart, int n, int n2) throws IOException {
        ChartUtilities.saveChartAsPNG(file, jFreeChart, n, n2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveChartAsPNG(File file, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) throws IOException {
        ParamChecks.nullNotPermitted(file, "file");
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            ChartUtilities.writeChartAsPNG(bufferedOutputStream, jFreeChart, n, n2, chartRenderingInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveChartAsPNG(File file, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo, boolean bl, int n3) throws IOException {
        ParamChecks.nullNotPermitted(file, "file");
        ParamChecks.nullNotPermitted(jFreeChart, "chart");
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            ChartUtilities.writeChartAsPNG(bufferedOutputStream, jFreeChart, n, n2, chartRenderingInfo, bl, n3);
        }
    }

    public static void writeChartAsJPEG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2) throws IOException {
        ChartUtilities.writeChartAsJPEG(outputStream, jFreeChart, n, n2, null);
    }

    public static void writeChartAsJPEG(OutputStream outputStream, float f, JFreeChart jFreeChart, int n, int n2) throws IOException {
        ChartUtilities.writeChartAsJPEG(outputStream, f, jFreeChart, n, n2, null);
    }

    public static void writeChartAsJPEG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) throws IOException {
        ParamChecks.nullNotPermitted(outputStream, "out");
        ParamChecks.nullNotPermitted(jFreeChart, "chart");
        BufferedImage bufferedImage = jFreeChart.createBufferedImage(n, n2, 1, chartRenderingInfo);
        EncoderUtil.writeBufferedImage(bufferedImage, "jpeg", outputStream);
    }

    public static void writeChartAsJPEG(OutputStream outputStream, float f, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) throws IOException {
        ParamChecks.nullNotPermitted(outputStream, "out");
        ParamChecks.nullNotPermitted(jFreeChart, "chart");
        BufferedImage bufferedImage = jFreeChart.createBufferedImage(n, n2, 1, chartRenderingInfo);
        EncoderUtil.writeBufferedImage(bufferedImage, "jpeg", outputStream, f);
    }

    public static void saveChartAsJPEG(File file, JFreeChart jFreeChart, int n, int n2) throws IOException {
        ChartUtilities.saveChartAsJPEG(file, jFreeChart, n, n2, null);
    }

    public static void saveChartAsJPEG(File file, float f, JFreeChart jFreeChart, int n, int n2) throws IOException {
        ChartUtilities.saveChartAsJPEG(file, f, jFreeChart, n, n2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveChartAsJPEG(File file, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) throws IOException {
        ParamChecks.nullNotPermitted(file, "file");
        ParamChecks.nullNotPermitted(jFreeChart, "chart");
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            ChartUtilities.writeChartAsJPEG((OutputStream)bufferedOutputStream, jFreeChart, n, n2, chartRenderingInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveChartAsJPEG(File file, float f, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) throws IOException {
        ParamChecks.nullNotPermitted(file, "file");
        ParamChecks.nullNotPermitted(jFreeChart, "chart");
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            ChartUtilities.writeChartAsJPEG(bufferedOutputStream, f, jFreeChart, n, n2, chartRenderingInfo);
        }
    }

    public static void writeBufferedImageAsJPEG(OutputStream outputStream, BufferedImage bufferedImage) throws IOException {
        ChartUtilities.writeBufferedImageAsJPEG(outputStream, 0.75f, bufferedImage);
    }

    public static void writeBufferedImageAsJPEG(OutputStream outputStream, float f, BufferedImage bufferedImage) throws IOException {
        EncoderUtil.writeBufferedImage(bufferedImage, "jpeg", outputStream, f);
    }

    public static void writeBufferedImageAsPNG(OutputStream outputStream, BufferedImage bufferedImage) throws IOException {
        EncoderUtil.writeBufferedImage(bufferedImage, "png", outputStream);
    }

    public static void writeBufferedImageAsPNG(OutputStream outputStream, BufferedImage bufferedImage, boolean bl, int n) throws IOException {
        EncoderUtil.writeBufferedImage(bufferedImage, "png", outputStream, n, bl);
    }

    public static byte[] encodeAsPNG(BufferedImage bufferedImage) throws IOException {
        return EncoderUtil.encode(bufferedImage, "png");
    }

    public static byte[] encodeAsPNG(BufferedImage bufferedImage, boolean bl, int n) throws IOException {
        return EncoderUtil.encode(bufferedImage, "png", n, bl);
    }

    public static void writeImageMap(PrintWriter printWriter, String string, ChartRenderingInfo chartRenderingInfo, boolean bl) throws IOException {
        ToolTipTagFragmentGenerator toolTipTagFragmentGenerator = bl ? new OverLIBToolTipTagFragmentGenerator() : new StandardToolTipTagFragmentGenerator();
        ImageMapUtilities.writeImageMap(printWriter, string, chartRenderingInfo, toolTipTagFragmentGenerator, new StandardURLTagFragmentGenerator());
    }

    public static void writeImageMap(PrintWriter printWriter, String string, ChartRenderingInfo chartRenderingInfo, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator uRLTagFragmentGenerator) throws IOException {
        printWriter.println(ImageMapUtilities.getImageMap(string, chartRenderingInfo, toolTipTagFragmentGenerator, uRLTagFragmentGenerator));
    }

    public static String getImageMap(String string, ChartRenderingInfo chartRenderingInfo) {
        return ImageMapUtilities.getImageMap(string, chartRenderingInfo, new StandardToolTipTagFragmentGenerator(), new StandardURLTagFragmentGenerator());
    }

    public static String getImageMap(String string, ChartRenderingInfo chartRenderingInfo, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator uRLTagFragmentGenerator) {
        return ImageMapUtilities.getImageMap(string, chartRenderingInfo, toolTipTagFragmentGenerator, uRLTagFragmentGenerator);
    }
}

