/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartTransferable;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.MouseWheelHandler;
import org.jfree.chart.editor.ChartEditor;
import org.jfree.chart.editor.ChartEditorManager;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.event.OverlayChangeEvent;
import org.jfree.chart.event.OverlayChangeListener;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.Pannable;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.Zoomable;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.io.SerialUtilities;

public class ChartPanel
extends JPanel
implements ChartChangeListener,
ChartProgressListener,
ActionListener,
MouseListener,
MouseMotionListener,
OverlayChangeListener,
Printable,
Serializable {
    private static final long serialVersionUID = 6046366297214274674L;
    public static final boolean DEFAULT_BUFFER_USED = true;
    public static final int DEFAULT_WIDTH = 680;
    public static final int DEFAULT_HEIGHT = 420;
    public static final int DEFAULT_MINIMUM_DRAW_WIDTH = 300;
    public static final int DEFAULT_MINIMUM_DRAW_HEIGHT = 200;
    public static final int DEFAULT_MAXIMUM_DRAW_WIDTH = 1024;
    public static final int DEFAULT_MAXIMUM_DRAW_HEIGHT = 768;
    public static final int DEFAULT_ZOOM_TRIGGER_DISTANCE = 10;
    public static final String PROPERTIES_COMMAND = "PROPERTIES";
    public static final String COPY_COMMAND = "COPY";
    public static final String SAVE_COMMAND = "SAVE";
    private static final String SAVE_AS_PNG_COMMAND = "SAVE_AS_PNG";
    private static final String SAVE_AS_SVG_COMMAND = "SAVE_AS_SVG";
    private static final String SAVE_AS_PDF_COMMAND = "SAVE_AS_PDF";
    public static final String PRINT_COMMAND = "PRINT";
    public static final String ZOOM_IN_BOTH_COMMAND = "ZOOM_IN_BOTH";
    public static final String ZOOM_IN_DOMAIN_COMMAND = "ZOOM_IN_DOMAIN";
    public static final String ZOOM_IN_RANGE_COMMAND = "ZOOM_IN_RANGE";
    public static final String ZOOM_OUT_BOTH_COMMAND = "ZOOM_OUT_BOTH";
    public static final String ZOOM_OUT_DOMAIN_COMMAND = "ZOOM_DOMAIN_BOTH";
    public static final String ZOOM_OUT_RANGE_COMMAND = "ZOOM_RANGE_BOTH";
    public static final String ZOOM_RESET_BOTH_COMMAND = "ZOOM_RESET_BOTH";
    public static final String ZOOM_RESET_DOMAIN_COMMAND = "ZOOM_RESET_DOMAIN";
    public static final String ZOOM_RESET_RANGE_COMMAND = "ZOOM_RESET_RANGE";
    private JFreeChart chart;
    private transient EventListenerList chartMouseListeners;
    private boolean useBuffer;
    private boolean refreshBuffer;
    private transient Image chartBuffer;
    private int chartBufferHeight;
    private int chartBufferWidth;
    private int minimumDrawWidth;
    private int minimumDrawHeight;
    private int maximumDrawWidth;
    private int maximumDrawHeight;
    private JPopupMenu popup;
    private ChartRenderingInfo info;
    private Point2D anchor;
    private double scaleX;
    private double scaleY;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private boolean domainZoomable = false;
    private boolean rangeZoomable = false;
    private Point2D zoomPoint = null;
    private transient Rectangle2D zoomRectangle = null;
    private boolean fillZoomRectangle = true;
    private int zoomTriggerDistance;
    private boolean horizontalAxisTrace = false;
    private boolean verticalAxisTrace = false;
    private transient Line2D verticalTraceLine;
    private transient Line2D horizontalTraceLine;
    private JMenuItem zoomInBothMenuItem;
    private JMenuItem zoomInDomainMenuItem;
    private JMenuItem zoomInRangeMenuItem;
    private JMenuItem zoomOutBothMenuItem;
    private JMenuItem zoomOutDomainMenuItem;
    private JMenuItem zoomOutRangeMenuItem;
    private JMenuItem zoomResetBothMenuItem;
    private JMenuItem zoomResetDomainMenuItem;
    private JMenuItem zoomResetRangeMenuItem;
    private File defaultDirectoryForSaveAs;
    private boolean enforceFileExtensions;
    private boolean ownToolTipDelaysActive;
    private int originalToolTipInitialDelay;
    private int originalToolTipReshowDelay;
    private int originalToolTipDismissDelay;
    private int ownToolTipInitialDelay;
    private int ownToolTipReshowDelay;
    private int ownToolTipDismissDelay;
    private double zoomInFactor = 0.5;
    private double zoomOutFactor = 2.0;
    private boolean zoomAroundAnchor;
    private transient Paint zoomOutlinePaint;
    private transient Paint zoomFillPaint;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("org.jfree.chart.LocalizationBundle");
    private double panW;
    private double panH;
    private Point panLast;
    private int panMask = 2;
    private List overlays;
    private MouseWheelHandler mouseWheelHandler;

    public ChartPanel(JFreeChart jFreeChart) {
        this(jFreeChart, 680, 420, 300, 200, 1024, 768, true, true, true, true, true, true);
    }

    public ChartPanel(JFreeChart jFreeChart, boolean bl) {
        this(jFreeChart, 680, 420, 300, 200, 1024, 768, bl, true, true, true, true, true);
    }

    public ChartPanel(JFreeChart jFreeChart, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this(jFreeChart, 680, 420, 300, 200, 1024, 768, true, bl, bl2, bl3, bl4, bl5);
    }

    public ChartPanel(JFreeChart jFreeChart, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this(jFreeChart, n, n2, n3, n4, n5, n6, bl, bl2, true, bl3, bl4, bl5, bl6);
    }

    public ChartPanel(JFreeChart jFreeChart, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        this.setChart(jFreeChart);
        this.chartMouseListeners = new EventListenerList();
        this.info = new ChartRenderingInfo();
        this.setPreferredSize(new Dimension(n, n2));
        this.useBuffer = bl;
        this.refreshBuffer = false;
        this.minimumDrawWidth = n3;
        this.minimumDrawHeight = n4;
        this.maximumDrawWidth = n5;
        this.maximumDrawHeight = n6;
        this.zoomTriggerDistance = 10;
        this.popup = null;
        if (bl2 || bl3 || bl4 || bl5 || bl6) {
            this.popup = this.createPopupMenu(bl2, bl3, bl4, bl5, bl6);
        }
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.setDisplayToolTips(bl7);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.defaultDirectoryForSaveAs = null;
        this.enforceFileExtensions = true;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        this.ownToolTipInitialDelay = toolTipManager.getInitialDelay();
        this.ownToolTipDismissDelay = toolTipManager.getDismissDelay();
        this.ownToolTipReshowDelay = toolTipManager.getReshowDelay();
        this.zoomAroundAnchor = false;
        this.zoomOutlinePaint = Color.blue;
        this.zoomFillPaint = new Color(0, 0, 255, 63);
        this.panMask = 2;
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("mac os x")) {
            this.panMask = 8;
        }
        this.overlays = new ArrayList();
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart jFreeChart) {
        if (this.chart != null) {
            this.chart.removeChangeListener(this);
            this.chart.removeProgressListener(this);
        }
        this.chart = jFreeChart;
        if (jFreeChart != null) {
            this.chart.addChangeListener(this);
            this.chart.addProgressListener(this);
            Plot plot = jFreeChart.getPlot();
            this.domainZoomable = false;
            this.rangeZoomable = false;
            if (plot instanceof Zoomable) {
                Zoomable zoomable = (Zoomable)((Object)plot);
                this.domainZoomable = zoomable.isDomainZoomable();
                this.rangeZoomable = zoomable.isRangeZoomable();
                this.orientation = zoomable.getOrientation();
            }
        } else {
            this.domainZoomable = false;
            this.rangeZoomable = false;
        }
        if (this.useBuffer) {
            this.refreshBuffer = true;
        }
        this.repaint();
    }

    public int getMinimumDrawWidth() {
        return this.minimumDrawWidth;
    }

    public void setMinimumDrawWidth(int n) {
        this.minimumDrawWidth = n;
    }

    public int getMaximumDrawWidth() {
        return this.maximumDrawWidth;
    }

    public void setMaximumDrawWidth(int n) {
        this.maximumDrawWidth = n;
    }

    public int getMinimumDrawHeight() {
        return this.minimumDrawHeight;
    }

    public void setMinimumDrawHeight(int n) {
        this.minimumDrawHeight = n;
    }

    public int getMaximumDrawHeight() {
        return this.maximumDrawHeight;
    }

    public void setMaximumDrawHeight(int n) {
        this.maximumDrawHeight = n;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public Point2D getAnchor() {
        return this.anchor;
    }

    protected void setAnchor(Point2D point2D) {
        this.anchor = point2D;
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
    }

    public ChartRenderingInfo getChartRenderingInfo() {
        return this.info;
    }

    public void setMouseZoomable(boolean bl) {
        this.setMouseZoomable(bl, true);
    }

    public void setMouseZoomable(boolean bl, boolean bl2) {
        this.setDomainZoomable(bl);
        this.setRangeZoomable(bl);
        this.setFillZoomRectangle(bl2);
    }

    public boolean isDomainZoomable() {
        return this.domainZoomable;
    }

    public void setDomainZoomable(boolean bl) {
        if (bl) {
            Plot plot = this.chart.getPlot();
            if (plot instanceof Zoomable) {
                Zoomable zoomable = (Zoomable)((Object)plot);
                this.domainZoomable = bl && zoomable.isDomainZoomable();
            }
        } else {
            this.domainZoomable = false;
        }
    }

    public boolean isRangeZoomable() {
        return this.rangeZoomable;
    }

    public void setRangeZoomable(boolean bl) {
        if (bl) {
            Plot plot = this.chart.getPlot();
            if (plot instanceof Zoomable) {
                Zoomable zoomable = (Zoomable)((Object)plot);
                this.rangeZoomable = bl && zoomable.isRangeZoomable();
            }
        } else {
            this.rangeZoomable = false;
        }
    }

    public boolean getFillZoomRectangle() {
        return this.fillZoomRectangle;
    }

    public void setFillZoomRectangle(boolean bl) {
        this.fillZoomRectangle = bl;
    }

    public int getZoomTriggerDistance() {
        return this.zoomTriggerDistance;
    }

    public void setZoomTriggerDistance(int n) {
        this.zoomTriggerDistance = n;
    }

    public boolean getHorizontalAxisTrace() {
        return this.horizontalAxisTrace;
    }

    public void setHorizontalAxisTrace(boolean bl) {
        this.horizontalAxisTrace = bl;
    }

    protected Line2D getHorizontalTraceLine() {
        return this.horizontalTraceLine;
    }

    protected void setHorizontalTraceLine(Line2D line2D) {
        this.horizontalTraceLine = line2D;
    }

    public boolean getVerticalAxisTrace() {
        return this.verticalAxisTrace;
    }

    public void setVerticalAxisTrace(boolean bl) {
        this.verticalAxisTrace = bl;
    }

    protected Line2D getVerticalTraceLine() {
        return this.verticalTraceLine;
    }

    protected void setVerticalTraceLine(Line2D line2D) {
        this.verticalTraceLine = line2D;
    }

    public File getDefaultDirectoryForSaveAs() {
        return this.defaultDirectoryForSaveAs;
    }

    public void setDefaultDirectoryForSaveAs(File file) {
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("The 'directory' argument is not a directory.");
        }
        this.defaultDirectoryForSaveAs = file;
    }

    public boolean isEnforceFileExtensions() {
        return this.enforceFileExtensions;
    }

    public void setEnforceFileExtensions(boolean bl) {
        this.enforceFileExtensions = bl;
    }

    public boolean getZoomAroundAnchor() {
        return this.zoomAroundAnchor;
    }

    public void setZoomAroundAnchor(boolean bl) {
        this.zoomAroundAnchor = bl;
    }

    public Paint getZoomFillPaint() {
        return this.zoomFillPaint;
    }

    public void setZoomFillPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.zoomFillPaint = paint;
    }

    public Paint getZoomOutlinePaint() {
        return this.zoomOutlinePaint;
    }

    public void setZoomOutlinePaint(Paint paint) {
        this.zoomOutlinePaint = paint;
    }

    public boolean isMouseWheelEnabled() {
        return this.mouseWheelHandler != null;
    }

    public void setMouseWheelEnabled(boolean bl) {
        if (bl && this.mouseWheelHandler == null) {
            this.mouseWheelHandler = new MouseWheelHandler(this);
        } else if (!bl && this.mouseWheelHandler != null) {
            this.removeMouseWheelListener(this.mouseWheelHandler);
            this.mouseWheelHandler = null;
        }
    }

    public void addOverlay(Overlay overlay) {
        ParamChecks.nullNotPermitted(overlay, "overlay");
        this.overlays.add(overlay);
        overlay.addChangeListener(this);
        this.repaint();
    }

    public void removeOverlay(Overlay overlay) {
        ParamChecks.nullNotPermitted(overlay, "overlay");
        boolean bl = this.overlays.remove(overlay);
        if (bl) {
            overlay.removeChangeListener(this);
            this.repaint();
        }
    }

    @Override
    public void overlayChanged(OverlayChangeEvent overlayChangeEvent) {
        this.repaint();
    }

    public void setDisplayToolTips(boolean bl) {
        if (bl) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        EntityCollection entityCollection;
        String string = null;
        if (this.info != null && (entityCollection = this.info.getEntityCollection()) != null) {
            Insets insets = this.getInsets();
            ChartEntity chartEntity = entityCollection.getEntity((int)((double)(mouseEvent.getX() - insets.left) / this.scaleX), (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY));
            if (chartEntity != null) {
                string = chartEntity.getToolTipText();
            }
        }
        return string;
    }

    public Point translateJava2DToScreen(Point2D point2D) {
        Insets insets = this.getInsets();
        int n = (int)(point2D.getX() * this.scaleX + (double)insets.left);
        int n2 = (int)(point2D.getY() * this.scaleY + (double)insets.top);
        return new Point(n, n2);
    }

    public Point2D translateScreenToJava2D(Point point) {
        Insets insets = this.getInsets();
        double d = (point.getX() - (double)insets.left) / this.scaleX;
        double d2 = (point.getY() - (double)insets.top) / this.scaleY;
        return new Point2D.Double(d, d2);
    }

    public Rectangle2D scale(Rectangle2D rectangle2D) {
        Insets insets = this.getInsets();
        double d = rectangle2D.getX() * this.getScaleX() + (double)insets.left;
        double d2 = rectangle2D.getY() * this.getScaleY() + (double)insets.top;
        double d3 = rectangle2D.getWidth() * this.getScaleX();
        double d4 = rectangle2D.getHeight() * this.getScaleY();
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    public ChartEntity getEntityForPoint(int n, int n2) {
        ChartEntity chartEntity = null;
        if (this.info != null) {
            Insets insets = this.getInsets();
            double d = (double)(n - insets.left) / this.scaleX;
            double d2 = (double)(n2 - insets.top) / this.scaleY;
            EntityCollection entityCollection = this.info.getEntityCollection();
            chartEntity = entityCollection != null ? entityCollection.getEntity(d, d2) : null;
        }
        return chartEntity;
    }

    public boolean getRefreshBuffer() {
        return this.refreshBuffer;
    }

    public void setRefreshBuffer(boolean bl) {
        this.refreshBuffer = bl;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Object object3;
        Object object2;
        super.paintComponent(graphics);
        if (this.chart == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        Rectangle2D.Double double_ = new Rectangle2D.Double(insets.left, insets.top, dimension.getWidth() - (double)insets.left - (double)insets.right, dimension.getHeight() - (double)insets.top - (double)insets.bottom);
        boolean bl = false;
        double d = ((RectangularShape)double_).getWidth();
        double d2 = ((RectangularShape)double_).getHeight();
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        if (d < (double)this.minimumDrawWidth) {
            this.scaleX = d / (double)this.minimumDrawWidth;
            d = this.minimumDrawWidth;
            bl = true;
        } else if (d > (double)this.maximumDrawWidth) {
            this.scaleX = d / (double)this.maximumDrawWidth;
            d = this.maximumDrawWidth;
            bl = true;
        }
        if (d2 < (double)this.minimumDrawHeight) {
            this.scaleY = d2 / (double)this.minimumDrawHeight;
            d2 = this.minimumDrawHeight;
            bl = true;
        } else if (d2 > (double)this.maximumDrawHeight) {
            this.scaleY = d2 / (double)this.maximumDrawHeight;
            d2 = this.maximumDrawHeight;
            bl = true;
        }
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, d, d2);
        if (this.useBuffer) {
            if (this.chartBuffer == null || (double)this.chartBufferWidth != ((RectangularShape)double_).getWidth() || (double)this.chartBufferHeight != ((RectangularShape)double_).getHeight()) {
                this.chartBufferWidth = (int)((RectangularShape)double_).getWidth();
                this.chartBufferHeight = (int)((RectangularShape)double_).getHeight();
                object2 = graphics2D.getDeviceConfiguration();
                this.chartBuffer = ((GraphicsConfiguration)object2).createCompatibleImage(this.chartBufferWidth, this.chartBufferHeight, 3);
                this.refreshBuffer = true;
            }
            if (this.refreshBuffer) {
                this.refreshBuffer = false;
                object2 = new Rectangle2D.Double(0.0, 0.0, this.chartBufferWidth, this.chartBufferHeight);
                object3 = (Graphics2D)this.chartBuffer.getGraphics();
                Composite composite = ((Graphics2D)object3).getComposite();
                ((Graphics2D)object3).setComposite(AlphaComposite.getInstance(1, 0.0f));
                Rectangle rectangle = new Rectangle(0, 0, this.chartBufferWidth, this.chartBufferHeight);
                ((Graphics2D)object3).fill(rectangle);
                ((Graphics2D)object3).setComposite(composite);
                if (bl) {
                    AffineTransform affineTransform = ((Graphics2D)object3).getTransform();
                    AffineTransform affineTransform2 = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
                    ((Graphics2D)object3).transform(affineTransform2);
                    this.chart.draw((Graphics2D)object3, double_2, this.anchor, this.info);
                    ((Graphics2D)object3).setTransform(affineTransform);
                } else {
                    this.chart.draw((Graphics2D)object3, (Rectangle2D)object2, this.anchor, this.info);
                }
            }
            graphics2D.drawImage(this.chartBuffer, insets.left, insets.top, this);
        } else {
            object2 = graphics2D.getTransform();
            graphics2D.translate(insets.left, insets.top);
            if (bl) {
                object3 = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
                graphics2D.transform((AffineTransform)object3);
            }
            this.chart.draw(graphics2D, double_2, this.anchor, this.info);
            graphics2D.setTransform((AffineTransform)object2);
        }
        for (Object object3 : this.overlays) {
            object3.paintOverlay(graphics2D, this);
        }
        this.drawZoomRectangle(graphics2D, !this.useBuffer);
        graphics2D.dispose();
        this.anchor = null;
        this.verticalTraceLine = null;
        this.horizontalTraceLine = null;
    }

    @Override
    public void chartChanged(ChartChangeEvent chartChangeEvent) {
        this.refreshBuffer = true;
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable zoomable = (Zoomable)((Object)plot);
            this.orientation = zoomable.getOrientation();
        }
        this.repaint();
    }

    @Override
    public void chartProgress(ChartProgressEvent chartProgressEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        double d = -1.0;
        double d2 = -1.0;
        if (this.zoomPoint != null) {
            d = this.zoomPoint.getX();
            d2 = this.zoomPoint.getY();
        }
        if (string.equals(PROPERTIES_COMMAND)) {
            this.doEditChartProperties();
        } else if (string.equals(COPY_COMMAND)) {
            this.doCopy();
        } else if (string.equals(SAVE_AS_PNG_COMMAND)) {
            try {
                this.doSaveAs();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "I/O error occurred.", "Save As PNG", 2);
            }
        } else if (string.equals(SAVE_AS_SVG_COMMAND)) {
            try {
                this.saveAsSVG(null);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "I/O error occurred.", "Save As SVG", 2);
            }
        } else if (string.equals(SAVE_AS_PDF_COMMAND)) {
            this.saveAsPDF(null);
        } else if (string.equals(PRINT_COMMAND)) {
            this.createChartPrintJob();
        } else if (string.equals(ZOOM_IN_BOTH_COMMAND)) {
            this.zoomInBoth(d, d2);
        } else if (string.equals(ZOOM_IN_DOMAIN_COMMAND)) {
            this.zoomInDomain(d, d2);
        } else if (string.equals(ZOOM_IN_RANGE_COMMAND)) {
            this.zoomInRange(d, d2);
        } else if (string.equals(ZOOM_OUT_BOTH_COMMAND)) {
            this.zoomOutBoth(d, d2);
        } else if (string.equals(ZOOM_OUT_DOMAIN_COMMAND)) {
            this.zoomOutDomain(d, d2);
        } else if (string.equals(ZOOM_OUT_RANGE_COMMAND)) {
            this.zoomOutRange(d, d2);
        } else if (string.equals(ZOOM_RESET_BOTH_COMMAND)) {
            this.restoreAutoBounds();
        } else if (string.equals(ZOOM_RESET_DOMAIN_COMMAND)) {
            this.restoreAutoDomainBounds();
        } else if (string.equals(ZOOM_RESET_RANGE_COMMAND)) {
            this.restoreAutoRangeBounds();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.ownToolTipDelaysActive) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            this.originalToolTipInitialDelay = toolTipManager.getInitialDelay();
            toolTipManager.setInitialDelay(this.ownToolTipInitialDelay);
            this.originalToolTipReshowDelay = toolTipManager.getReshowDelay();
            toolTipManager.setReshowDelay(this.ownToolTipReshowDelay);
            this.originalToolTipDismissDelay = toolTipManager.getDismissDelay();
            toolTipManager.setDismissDelay(this.ownToolTipDismissDelay);
            this.ownToolTipDelaysActive = true;
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.ownToolTipDelaysActive) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.setInitialDelay(this.originalToolTipInitialDelay);
            toolTipManager.setReshowDelay(this.originalToolTipReshowDelay);
            toolTipManager.setDismissDelay(this.originalToolTipDismissDelay);
            this.ownToolTipDelaysActive = false;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.chart == null) {
            return;
        }
        Plot plot = this.chart.getPlot();
        int n = mouseEvent.getModifiers();
        if ((n & this.panMask) == this.panMask) {
            Rectangle2D rectangle2D;
            Pannable pannable;
            if (plot instanceof Pannable && ((pannable = (Pannable)((Object)plot)).isDomainPannable() || pannable.isRangePannable()) && (rectangle2D = this.getScreenDataArea(mouseEvent.getX(), mouseEvent.getY())) != null && rectangle2D.contains(mouseEvent.getPoint())) {
                this.panW = rectangle2D.getWidth();
                this.panH = rectangle2D.getHeight();
                this.panLast = mouseEvent.getPoint();
                this.setCursor(Cursor.getPredefinedCursor(13));
            }
        } else if (this.zoomRectangle == null) {
            Rectangle2D rectangle2D = this.getScreenDataArea(mouseEvent.getX(), mouseEvent.getY());
            this.zoomPoint = rectangle2D != null ? this.getPointInRectangle(mouseEvent.getX(), mouseEvent.getY(), rectangle2D) : null;
            if (mouseEvent.isPopupTrigger() && this.popup != null) {
                this.displayPopupMenu(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private Point2D getPointInRectangle(int n, int n2, Rectangle2D rectangle2D) {
        double d = Math.max(rectangle2D.getMinX(), Math.min((double)n, rectangle2D.getMaxX()));
        double d2 = Math.max(rectangle2D.getMinY(), Math.min((double)n2, rectangle2D.getMaxY()));
        return new Point2D.Double(d, d2);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2;
        if (this.popup != null && this.popup.isShowing()) {
            return;
        }
        if (this.panLast != null) {
            double d = (double)mouseEvent.getX() - this.panLast.getX();
            double d2 = (double)mouseEvent.getY() - this.panLast.getY();
            if (d == 0.0 && d2 == 0.0) {
                return;
            }
            double d3 = -d / this.panW;
            double d4 = d2 / this.panH;
            boolean bl3 = this.chart.getPlot().isNotify();
            this.chart.getPlot().setNotify(false);
            Pannable pannable = (Pannable)((Object)this.chart.getPlot());
            if (pannable.getOrientation() == PlotOrientation.VERTICAL) {
                pannable.panDomainAxes(d3, this.info.getPlotInfo(), this.panLast);
                pannable.panRangeAxes(d4, this.info.getPlotInfo(), this.panLast);
            } else {
                pannable.panDomainAxes(d4, this.info.getPlotInfo(), this.panLast);
                pannable.panRangeAxes(d3, this.info.getPlotInfo(), this.panLast);
            }
            this.panLast = mouseEvent.getPoint();
            this.chart.getPlot().setNotify(bl3);
            return;
        }
        if (this.zoomPoint == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (!this.useBuffer) {
            this.drawZoomRectangle(graphics2D, true);
        }
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            bl2 = this.rangeZoomable;
            bl = this.domainZoomable;
        } else {
            bl2 = this.domainZoomable;
            bl = this.rangeZoomable;
        }
        Rectangle2D rectangle2D = this.getScreenDataArea((int)this.zoomPoint.getX(), (int)this.zoomPoint.getY());
        if (bl2 && bl) {
            double d = Math.min((double)mouseEvent.getX(), rectangle2D.getMaxX());
            double d5 = Math.min((double)mouseEvent.getY(), rectangle2D.getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), this.zoomPoint.getY(), d - this.zoomPoint.getX(), d5 - this.zoomPoint.getY());
        } else if (bl2) {
            double d = Math.min((double)mouseEvent.getX(), rectangle2D.getMaxX());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), rectangle2D.getMinY(), d - this.zoomPoint.getX(), rectangle2D.getHeight());
        } else if (bl) {
            double d = Math.min((double)mouseEvent.getY(), rectangle2D.getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(rectangle2D.getMinX(), this.zoomPoint.getY(), rectangle2D.getWidth(), d - this.zoomPoint.getY());
        }
        if (this.useBuffer) {
            this.repaint();
        } else {
            this.drawZoomRectangle(graphics2D, true);
        }
        graphics2D.dispose();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.panLast != null) {
            this.panLast = null;
            this.setCursor(Cursor.getDefaultCursor());
        } else if (this.zoomRectangle != null) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            if (this.orientation == PlotOrientation.HORIZONTAL) {
                bl3 = this.rangeZoomable;
                bl2 = this.domainZoomable;
            } else {
                bl3 = this.domainZoomable;
                bl2 = this.rangeZoomable;
            }
            boolean bl4 = bl3 && Math.abs((double)mouseEvent.getX() - this.zoomPoint.getX()) >= (double)this.zoomTriggerDistance;
            boolean bl5 = bl = bl2 && Math.abs((double)mouseEvent.getY() - this.zoomPoint.getY()) >= (double)this.zoomTriggerDistance;
            if (bl4 || bl) {
                if (bl3 && (double)mouseEvent.getX() < this.zoomPoint.getX() || bl2 && (double)mouseEvent.getY() < this.zoomPoint.getY()) {
                    this.restoreAutoBounds();
                } else {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    Rectangle2D rectangle2D = this.getScreenDataArea((int)this.zoomPoint.getX(), (int)this.zoomPoint.getY());
                    double d5 = rectangle2D.getMaxX();
                    double d6 = rectangle2D.getMaxY();
                    if (!bl2) {
                        d4 = this.zoomPoint.getX();
                        d3 = rectangle2D.getMinY();
                        d2 = Math.min(this.zoomRectangle.getWidth(), d5 - this.zoomPoint.getX());
                        d = rectangle2D.getHeight();
                    } else if (!bl3) {
                        d4 = rectangle2D.getMinX();
                        d3 = this.zoomPoint.getY();
                        d2 = rectangle2D.getWidth();
                        d = Math.min(this.zoomRectangle.getHeight(), d6 - this.zoomPoint.getY());
                    } else {
                        d4 = this.zoomPoint.getX();
                        d3 = this.zoomPoint.getY();
                        d2 = Math.min(this.zoomRectangle.getWidth(), d5 - this.zoomPoint.getX());
                        d = Math.min(this.zoomRectangle.getHeight(), d6 - this.zoomPoint.getY());
                    }
                    Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d3, d2, d);
                    this.zoom(double_);
                }
                this.zoomPoint = null;
                this.zoomRectangle = null;
            } else {
                Graphics2D graphics2D = (Graphics2D)this.getGraphics();
                if (this.useBuffer) {
                    this.repaint();
                } else {
                    this.drawZoomRectangle(graphics2D, true);
                }
                graphics2D.dispose();
                this.zoomPoint = null;
                this.zoomRectangle = null;
            }
        } else if (mouseEvent.isPopupTrigger() && this.popup != null) {
            this.displayPopupMenu(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        Insets insets = this.getInsets();
        int n = (int)((double)(mouseEvent.getX() - insets.left) / this.scaleX);
        int n2 = (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY);
        this.anchor = new Point2D.Double(n, n2);
        if (this.chart == null) {
            return;
        }
        this.chart.setNotify(true);
        EventListener[] eventListenerArray = this.chartMouseListeners.getListeners(ChartMouseListener.class);
        if (eventListenerArray.length == 0) {
            return;
        }
        ChartEntity chartEntity = null;
        if (this.info != null && (object = this.info.getEntityCollection()) != null) {
            chartEntity = object.getEntity(n, n2);
        }
        object = new ChartMouseEvent(this.getChart(), mouseEvent, chartEntity);
        for (int i = eventListenerArray.length - 1; i >= 0; --i) {
            ((ChartMouseListener)eventListenerArray[i]).chartMouseClicked((ChartMouseEvent)object);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (this.horizontalAxisTrace) {
            this.drawHorizontalAxisTrace(graphics2D, mouseEvent.getX());
        }
        if (this.verticalAxisTrace) {
            this.drawVerticalAxisTrace(graphics2D, mouseEvent.getY());
        }
        graphics2D.dispose();
        EventListener[] eventListenerArray = this.chartMouseListeners.getListeners(ChartMouseListener.class);
        if (eventListenerArray.length == 0) {
            return;
        }
        Insets insets = this.getInsets();
        int n = (int)((double)(mouseEvent.getX() - insets.left) / this.scaleX);
        int n2 = (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY);
        ChartEntity chartEntity = null;
        if (this.info != null && (object = this.info.getEntityCollection()) != null) {
            chartEntity = object.getEntity(n, n2);
        }
        if (this.chart != null) {
            object = new ChartMouseEvent(this.getChart(), mouseEvent, chartEntity);
            for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                ((ChartMouseListener)eventListenerArray[i]).chartMouseMoved((ChartMouseEvent)object);
            }
        }
    }

    public void zoomInBoth(double d, double d2) {
        Plot plot = this.chart.getPlot();
        if (plot == null) {
            return;
        }
        boolean bl = plot.isNotify();
        plot.setNotify(false);
        this.zoomInDomain(d, d2);
        this.zoomInRange(d, d2);
        plot.setNotify(bl);
    }

    public void zoomInDomain(double d, double d2) {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            boolean bl = plot.isNotify();
            plot.setNotify(false);
            Zoomable zoomable = (Zoomable)((Object)plot);
            zoomable.zoomDomainAxes(this.zoomInFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)d, (int)d2)), this.zoomAroundAnchor);
            plot.setNotify(bl);
        }
    }

    public void zoomInRange(double d, double d2) {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            boolean bl = plot.isNotify();
            plot.setNotify(false);
            Zoomable zoomable = (Zoomable)((Object)plot);
            zoomable.zoomRangeAxes(this.zoomInFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)d, (int)d2)), this.zoomAroundAnchor);
            plot.setNotify(bl);
        }
    }

    public void zoomOutBoth(double d, double d2) {
        Plot plot = this.chart.getPlot();
        if (plot == null) {
            return;
        }
        boolean bl = plot.isNotify();
        plot.setNotify(false);
        this.zoomOutDomain(d, d2);
        this.zoomOutRange(d, d2);
        plot.setNotify(bl);
    }

    public void zoomOutDomain(double d, double d2) {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            boolean bl = plot.isNotify();
            plot.setNotify(false);
            Zoomable zoomable = (Zoomable)((Object)plot);
            zoomable.zoomDomainAxes(this.zoomOutFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)d, (int)d2)), this.zoomAroundAnchor);
            plot.setNotify(bl);
        }
    }

    public void zoomOutRange(double d, double d2) {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            boolean bl = plot.isNotify();
            plot.setNotify(false);
            Zoomable zoomable = (Zoomable)((Object)plot);
            zoomable.zoomRangeAxes(this.zoomOutFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)d, (int)d2)), this.zoomAroundAnchor);
            plot.setNotify(bl);
        }
    }

    public void zoom(Rectangle2D rectangle2D) {
        Point2D point2D = this.translateScreenToJava2D(new Point((int)Math.ceil(rectangle2D.getX()), (int)Math.ceil(rectangle2D.getY())));
        PlotRenderingInfo plotRenderingInfo = this.info.getPlotInfo();
        Rectangle2D rectangle2D2 = this.getScreenDataArea((int)rectangle2D.getCenterX(), (int)rectangle2D.getCenterY());
        if (rectangle2D.getHeight() > 0.0 && rectangle2D.getWidth() > 0.0) {
            double d = (rectangle2D.getMinX() - rectangle2D2.getMinX()) / rectangle2D2.getWidth();
            double d2 = (rectangle2D.getMaxX() - rectangle2D2.getMinX()) / rectangle2D2.getWidth();
            double d3 = (rectangle2D2.getMaxY() - rectangle2D.getMaxY()) / rectangle2D2.getHeight();
            double d4 = (rectangle2D2.getMaxY() - rectangle2D.getMinY()) / rectangle2D2.getHeight();
            Plot plot = this.chart.getPlot();
            if (plot instanceof Zoomable) {
                boolean bl = plot.isNotify();
                plot.setNotify(false);
                Zoomable zoomable = (Zoomable)((Object)plot);
                if (zoomable.getOrientation() == PlotOrientation.HORIZONTAL) {
                    zoomable.zoomDomainAxes(d3, d4, plotRenderingInfo, point2D);
                    zoomable.zoomRangeAxes(d, d2, plotRenderingInfo, point2D);
                } else {
                    zoomable.zoomDomainAxes(d, d2, plotRenderingInfo, point2D);
                    zoomable.zoomRangeAxes(d3, d4, plotRenderingInfo, point2D);
                }
                plot.setNotify(bl);
            }
        }
    }

    public void restoreAutoBounds() {
        Plot plot = this.chart.getPlot();
        if (plot == null) {
            return;
        }
        boolean bl = plot.isNotify();
        plot.setNotify(false);
        this.restoreAutoDomainBounds();
        this.restoreAutoRangeBounds();
        plot.setNotify(bl);
    }

    public void restoreAutoDomainBounds() {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable zoomable = (Zoomable)((Object)plot);
            boolean bl = plot.isNotify();
            plot.setNotify(false);
            Point2D point2D = this.zoomPoint != null ? this.zoomPoint : new Point();
            zoomable.zoomDomainAxes(0.0, this.info.getPlotInfo(), point2D);
            plot.setNotify(bl);
        }
    }

    public void restoreAutoRangeBounds() {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable zoomable = (Zoomable)((Object)plot);
            boolean bl = plot.isNotify();
            plot.setNotify(false);
            Point2D point2D = this.zoomPoint != null ? this.zoomPoint : new Point();
            zoomable.zoomRangeAxes(0.0, this.info.getPlotInfo(), point2D);
            plot.setNotify(bl);
        }
    }

    public Rectangle2D getScreenDataArea() {
        Rectangle2D rectangle2D = this.info.getPlotInfo().getDataArea();
        Insets insets = this.getInsets();
        double d = rectangle2D.getX() * this.scaleX + (double)insets.left;
        double d2 = rectangle2D.getY() * this.scaleY + (double)insets.top;
        double d3 = rectangle2D.getWidth() * this.scaleX;
        double d4 = rectangle2D.getHeight() * this.scaleY;
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    public Rectangle2D getScreenDataArea(int n, int n2) {
        Rectangle2D rectangle2D;
        PlotRenderingInfo plotRenderingInfo = this.info.getPlotInfo();
        if (plotRenderingInfo.getSubplotCount() == 0) {
            rectangle2D = this.getScreenDataArea();
        } else {
            Point2D point2D = this.translateScreenToJava2D(new Point(n, n2));
            int n3 = plotRenderingInfo.getSubplotIndex(point2D);
            if (n3 == -1) {
                return null;
            }
            rectangle2D = this.scale(plotRenderingInfo.getSubplotInfo(n3).getDataArea());
        }
        return rectangle2D;
    }

    public int getInitialDelay() {
        return this.ownToolTipInitialDelay;
    }

    public int getReshowDelay() {
        return this.ownToolTipReshowDelay;
    }

    public int getDismissDelay() {
        return this.ownToolTipDismissDelay;
    }

    public void setInitialDelay(int n) {
        this.ownToolTipInitialDelay = n;
    }

    public void setReshowDelay(int n) {
        this.ownToolTipReshowDelay = n;
    }

    public void setDismissDelay(int n) {
        this.ownToolTipDismissDelay = n;
    }

    public double getZoomInFactor() {
        return this.zoomInFactor;
    }

    public void setZoomInFactor(double d) {
        this.zoomInFactor = d;
    }

    public double getZoomOutFactor() {
        return this.zoomOutFactor;
    }

    public void setZoomOutFactor(double d) {
        this.zoomOutFactor = d;
    }

    private void drawZoomRectangle(Graphics2D graphics2D, boolean bl) {
        if (this.zoomRectangle != null) {
            if (bl) {
                graphics2D.setXORMode(Color.gray);
            }
            if (this.fillZoomRectangle) {
                graphics2D.setPaint(this.zoomFillPaint);
                graphics2D.fill(this.zoomRectangle);
            } else {
                graphics2D.setPaint(this.zoomOutlinePaint);
                graphics2D.draw(this.zoomRectangle);
            }
            if (bl) {
                graphics2D.setPaintMode();
            }
        }
    }

    private void drawHorizontalAxisTrace(Graphics2D graphics2D, int n) {
        Rectangle2D rectangle2D = this.getScreenDataArea();
        graphics2D.setXORMode(Color.orange);
        if ((int)rectangle2D.getMinX() < n && n < (int)rectangle2D.getMaxX()) {
            if (this.verticalTraceLine != null) {
                graphics2D.draw(this.verticalTraceLine);
                this.verticalTraceLine.setLine(n, (int)rectangle2D.getMinY(), n, (int)rectangle2D.getMaxY());
            } else {
                this.verticalTraceLine = new Line2D.Float(n, (int)rectangle2D.getMinY(), n, (int)rectangle2D.getMaxY());
            }
            graphics2D.draw(this.verticalTraceLine);
        }
        graphics2D.setPaintMode();
    }

    private void drawVerticalAxisTrace(Graphics2D graphics2D, int n) {
        Rectangle2D rectangle2D = this.getScreenDataArea();
        graphics2D.setXORMode(Color.orange);
        if ((int)rectangle2D.getMinY() < n && n < (int)rectangle2D.getMaxY()) {
            if (this.horizontalTraceLine != null) {
                graphics2D.draw(this.horizontalTraceLine);
                this.horizontalTraceLine.setLine((int)rectangle2D.getMinX(), n, (int)rectangle2D.getMaxX(), n);
            } else {
                this.horizontalTraceLine = new Line2D.Float((int)rectangle2D.getMinX(), n, (int)rectangle2D.getMaxX(), n);
            }
            graphics2D.draw(this.horizontalTraceLine);
        }
        graphics2D.setPaintMode();
    }

    public void doEditChartProperties() {
        ChartEditor chartEditor = ChartEditorManager.getChartEditor(this.chart);
        int n = JOptionPane.showConfirmDialog(this, chartEditor, localizationResources.getString("Chart_Properties"), 2, -1);
        if (n == 0) {
            chartEditor.updateChart(this.chart);
        }
    }

    public void doCopy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right;
        int n2 = this.getHeight() - insets.top - insets.bottom;
        ChartTransferable chartTransferable = new ChartTransferable(this.chart, n, n2, this.getMinimumDrawWidth(), this.getMinimumDrawHeight(), this.getMaximumDrawWidth(), this.getMaximumDrawHeight(), true);
        clipboard.setContents(chartTransferable, null);
    }

    public void doSaveAs() throws IOException {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(this.defaultDirectoryForSaveAs);
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(localizationResources.getString("PNG_Image_Files"), "png");
        jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getPath();
            if (this.isEnforceFileExtensions() && !string.endsWith(".png")) {
                string = string + ".png";
            }
            ChartUtilities.saveChartAsPNG(new File(string), this.chart, this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAsSVG(File file) throws IOException {
        Object object;
        Object object2;
        File file2 = file;
        if (file2 == null) {
            object2 = new JFileChooser();
            ((JFileChooser)object2).setCurrentDirectory(this.defaultDirectoryForSaveAs);
            object = new FileNameExtensionFilter(localizationResources.getString("SVG_Files"), "svg");
            ((JFileChooser)object2).addChoosableFileFilter((FileFilter)object);
            ((JFileChooser)object2).setFileFilter((FileFilter)object);
            int n = ((JFileChooser)object2).showSaveDialog(this);
            if (n == 0) {
                String string;
                int n2;
                String string2 = ((JFileChooser)object2).getSelectedFile().getPath();
                if (this.isEnforceFileExtensions() && !string2.endsWith(".svg")) {
                    string2 = string2 + ".svg";
                }
                if ((file2 = new File(string2)).exists() && (n2 = JOptionPane.showConfirmDialog(this, string = localizationResources.getString("FILE_EXISTS_CONFIRM_OVERWRITE"), "Save As SVG", 2)) == 2) {
                    file2 = null;
                }
            }
        }
        if (file2 != null) {
            object2 = this.generateSVG(this.getWidth(), this.getHeight());
            object = null;
            try {
                object = new BufferedWriter(new FileWriter(file2));
                ((Writer)object).write("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n");
                ((Writer)object).write((String)object2 + "\n");
                ((BufferedWriter)object).flush();
            }
            finally {
                try {
                    if (object != null) {
                        ((BufferedWriter)object).close();
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }
    }

    private String generateSVG(int n, int n2) {
        Graphics2D graphics2D = this.createSVGGraphics2D(n, n2);
        if (graphics2D == null) {
            throw new IllegalStateException("JFreeSVG library is not present.");
        }
        graphics2D.setRenderingHint(JFreeChart.KEY_SUPPRESS_SHADOW_GENERATION, true);
        String string = null;
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
        this.chart.draw(graphics2D, double_);
        try {
            Method method = graphics2D.getClass().getMethod("getSVGElement", new Class[0]);
            string = (String)method.invoke((Object)graphics2D, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return string;
    }

    private Graphics2D createSVGGraphics2D(int n, int n2) {
        try {
            Class<?> clazz = Class.forName("org.jfree.graphics2d.svg.SVGGraphics2D");
            Constructor<?> constructor = clazz.getConstructor(Integer.TYPE, Integer.TYPE);
            return (Graphics2D)constructor.newInstance(n, n2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    private void saveAsPDF(File file) {
        File file2 = file;
        if (file2 == null) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(this.defaultDirectoryForSaveAs);
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(localizationResources.getString("PDF_Files"), "pdf");
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
            jFileChooser.setFileFilter(fileNameExtensionFilter);
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                String string;
                int n2;
                String string2 = jFileChooser.getSelectedFile().getPath();
                if (this.isEnforceFileExtensions() && !string2.endsWith(".pdf")) {
                    string2 = string2 + ".pdf";
                }
                if ((file2 = new File(string2)).exists() && (n2 = JOptionPane.showConfirmDialog(this, string = localizationResources.getString("FILE_EXISTS_CONFIRM_OVERWRITE"), "Save As PDF", 2)) == 2) {
                    file2 = null;
                }
            }
        }
        if (file2 != null) {
            this.writeAsPDF(file2, this.getWidth(), this.getHeight());
        }
    }

    private boolean isOrsonPDFAvailable() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.orsonpdf.PDFDocument");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz != null;
    }

    private void writeAsPDF(File file, int n, int n2) {
        if (!this.isOrsonPDFAvailable()) {
            throw new IllegalStateException("OrsonPDF is not present on the classpath.");
        }
        ParamChecks.nullNotPermitted(file, "file");
        try {
            Class<?> clazz = Class.forName("com.orsonpdf.PDFDocument");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("createPage", Rectangle2D.class);
            Rectangle rectangle = new Rectangle(n, n2);
            Object object = method.invoke(obj, rectangle);
            Method method2 = object.getClass().getMethod("getGraphics2D", new Class[0]);
            Graphics2D graphics2D = (Graphics2D)method2.invoke(object, new Object[0]);
            graphics2D.setRenderingHint(JFreeChart.KEY_SUPPRESS_SHADOW_GENERATION, true);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
            this.chart.draw(graphics2D, double_);
            Method method3 = clazz.getMethod("writeToFile", File.class);
            method3.invoke(obj, file);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    public void createChartPrintJob() {
        PageFormat pageFormat;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat2 = printerJob.pageDialog(pageFormat = printerJob.defaultPage());
        if (pageFormat2 != pageFormat) {
            printerJob.setPrintable(this, pageFormat2);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    JOptionPane.showMessageDialog(this, printerException);
                }
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n != 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        this.chart.draw(graphics2D, new Rectangle2D.Double(d, d2, d3, d4), this.anchor, null);
        return 0;
    }

    public void addChartMouseListener(ChartMouseListener chartMouseListener) {
        ParamChecks.nullNotPermitted(chartMouseListener, "listener");
        this.chartMouseListeners.add(ChartMouseListener.class, chartMouseListener);
    }

    public void removeChartMouseListener(ChartMouseListener chartMouseListener) {
        this.chartMouseListeners.remove(ChartMouseListener.class, chartMouseListener);
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == ChartMouseListener.class) {
            return this.chartMouseListeners.getListeners(clazz);
        }
        return super.getListeners(clazz);
    }

    protected JPopupMenu createPopupMenu(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.createPopupMenu(bl, false, bl2, bl3, bl4);
    }

    protected JPopupMenu createPopupMenu(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        JMenuItem jMenuItem;
        JMenuItem jMenuItem2;
        JMenuItem jMenuItem3;
        JPopupMenu jPopupMenu = new JPopupMenu(localizationResources.getString("Chart") + ":");
        boolean bl6 = false;
        if (bl) {
            jMenuItem3 = new JMenuItem(localizationResources.getString("Properties..."));
            jMenuItem3.setActionCommand(PROPERTIES_COMMAND);
            jMenuItem3.addActionListener(this);
            jPopupMenu.add(jMenuItem3);
            bl6 = true;
        }
        if (bl2) {
            if (bl6) {
                jPopupMenu.addSeparator();
            }
            jMenuItem3 = new JMenuItem(localizationResources.getString("Copy"));
            jMenuItem3.setActionCommand(COPY_COMMAND);
            jMenuItem3.addActionListener(this);
            jPopupMenu.add(jMenuItem3);
            boolean bl7 = bl6 = !bl3;
        }
        if (bl3) {
            if (bl6) {
                jPopupMenu.addSeparator();
            }
            jMenuItem3 = new JMenu(localizationResources.getString("Save_as"));
            jMenuItem2 = new JMenuItem(localizationResources.getString("PNG..."));
            jMenuItem2.setActionCommand(SAVE_AS_PNG_COMMAND);
            jMenuItem2.addActionListener(this);
            ((JMenu)jMenuItem3).add(jMenuItem2);
            if (this.createSVGGraphics2D(10, 10) != null) {
                jMenuItem = new JMenuItem(localizationResources.getString("SVG..."));
                jMenuItem.setActionCommand(SAVE_AS_SVG_COMMAND);
                jMenuItem.addActionListener(this);
                ((JMenu)jMenuItem3).add(jMenuItem);
            }
            if (this.isOrsonPDFAvailable()) {
                jMenuItem = new JMenuItem(localizationResources.getString("PDF..."));
                jMenuItem.setActionCommand(SAVE_AS_PDF_COMMAND);
                jMenuItem.addActionListener(this);
                ((JMenu)jMenuItem3).add(jMenuItem);
            }
            jPopupMenu.add(jMenuItem3);
            bl6 = true;
        }
        if (bl4) {
            if (bl6) {
                jPopupMenu.addSeparator();
            }
            jMenuItem3 = new JMenuItem(localizationResources.getString("Print..."));
            jMenuItem3.setActionCommand(PRINT_COMMAND);
            jMenuItem3.addActionListener(this);
            jPopupMenu.add(jMenuItem3);
            bl6 = true;
        }
        if (bl5) {
            if (bl6) {
                jPopupMenu.addSeparator();
            }
            jMenuItem3 = new JMenu(localizationResources.getString("Zoom_In"));
            this.zoomInBothMenuItem = new JMenuItem(localizationResources.getString("All_Axes"));
            this.zoomInBothMenuItem.setActionCommand(ZOOM_IN_BOTH_COMMAND);
            this.zoomInBothMenuItem.addActionListener(this);
            ((JMenu)jMenuItem3).add(this.zoomInBothMenuItem);
            ((JMenu)jMenuItem3).addSeparator();
            this.zoomInDomainMenuItem = new JMenuItem(localizationResources.getString("Domain_Axis"));
            this.zoomInDomainMenuItem.setActionCommand(ZOOM_IN_DOMAIN_COMMAND);
            this.zoomInDomainMenuItem.addActionListener(this);
            ((JMenu)jMenuItem3).add(this.zoomInDomainMenuItem);
            this.zoomInRangeMenuItem = new JMenuItem(localizationResources.getString("Range_Axis"));
            this.zoomInRangeMenuItem.setActionCommand(ZOOM_IN_RANGE_COMMAND);
            this.zoomInRangeMenuItem.addActionListener(this);
            ((JMenu)jMenuItem3).add(this.zoomInRangeMenuItem);
            jPopupMenu.add(jMenuItem3);
            jMenuItem2 = new JMenu(localizationResources.getString("Zoom_Out"));
            this.zoomOutBothMenuItem = new JMenuItem(localizationResources.getString("All_Axes"));
            this.zoomOutBothMenuItem.setActionCommand(ZOOM_OUT_BOTH_COMMAND);
            this.zoomOutBothMenuItem.addActionListener(this);
            ((JMenu)jMenuItem2).add(this.zoomOutBothMenuItem);
            ((JMenu)jMenuItem2).addSeparator();
            this.zoomOutDomainMenuItem = new JMenuItem(localizationResources.getString("Domain_Axis"));
            this.zoomOutDomainMenuItem.setActionCommand(ZOOM_OUT_DOMAIN_COMMAND);
            this.zoomOutDomainMenuItem.addActionListener(this);
            ((JMenu)jMenuItem2).add(this.zoomOutDomainMenuItem);
            this.zoomOutRangeMenuItem = new JMenuItem(localizationResources.getString("Range_Axis"));
            this.zoomOutRangeMenuItem.setActionCommand(ZOOM_OUT_RANGE_COMMAND);
            this.zoomOutRangeMenuItem.addActionListener(this);
            ((JMenu)jMenuItem2).add(this.zoomOutRangeMenuItem);
            jPopupMenu.add(jMenuItem2);
            jMenuItem = new JMenu(localizationResources.getString("Auto_Range"));
            this.zoomResetBothMenuItem = new JMenuItem(localizationResources.getString("All_Axes"));
            this.zoomResetBothMenuItem.setActionCommand(ZOOM_RESET_BOTH_COMMAND);
            this.zoomResetBothMenuItem.addActionListener(this);
            ((JMenu)jMenuItem).add(this.zoomResetBothMenuItem);
            ((JMenu)jMenuItem).addSeparator();
            this.zoomResetDomainMenuItem = new JMenuItem(localizationResources.getString("Domain_Axis"));
            this.zoomResetDomainMenuItem.setActionCommand(ZOOM_RESET_DOMAIN_COMMAND);
            this.zoomResetDomainMenuItem.addActionListener(this);
            ((JMenu)jMenuItem).add(this.zoomResetDomainMenuItem);
            this.zoomResetRangeMenuItem = new JMenuItem(localizationResources.getString("Range_Axis"));
            this.zoomResetRangeMenuItem.setActionCommand(ZOOM_RESET_RANGE_COMMAND);
            this.zoomResetRangeMenuItem.addActionListener(this);
            ((JMenu)jMenuItem).add(this.zoomResetRangeMenuItem);
            jPopupMenu.addSeparator();
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    protected void displayPopupMenu(int n, int n2) {
        Plot plot;
        if (this.popup == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        Plot plot2 = plot = this.chart != null ? this.chart.getPlot() : null;
        if (plot instanceof Zoomable) {
            Zoomable zoomable = (Zoomable)((Object)plot);
            bl = zoomable.isDomainZoomable();
            bl2 = zoomable.isRangeZoomable();
        }
        if (this.zoomInDomainMenuItem != null) {
            this.zoomInDomainMenuItem.setEnabled(bl);
        }
        if (this.zoomOutDomainMenuItem != null) {
            this.zoomOutDomainMenuItem.setEnabled(bl);
        }
        if (this.zoomResetDomainMenuItem != null) {
            this.zoomResetDomainMenuItem.setEnabled(bl);
        }
        if (this.zoomInRangeMenuItem != null) {
            this.zoomInRangeMenuItem.setEnabled(bl2);
        }
        if (this.zoomOutRangeMenuItem != null) {
            this.zoomOutRangeMenuItem.setEnabled(bl2);
        }
        if (this.zoomResetRangeMenuItem != null) {
            this.zoomResetRangeMenuItem.setEnabled(bl2);
        }
        if (this.zoomInBothMenuItem != null) {
            this.zoomInBothMenuItem.setEnabled(bl && bl2);
        }
        if (this.zoomOutBothMenuItem != null) {
            this.zoomOutBothMenuItem.setEnabled(bl && bl2);
        }
        if (this.zoomResetBothMenuItem != null) {
            this.zoomResetBothMenuItem.setEnabled(bl && bl2);
        }
        this.popup.show(this, n, n2);
    }

    @Override
    public void updateUI() {
        if (this.popup != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
        super.updateUI();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.zoomFillPaint, objectOutputStream);
        SerialUtilities.writePaint(this.zoomOutlinePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.zoomFillPaint = SerialUtilities.readPaint(objectInputStream);
        this.zoomOutlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.chartMouseListeners = new EventListenerList();
        if (this.chart != null) {
            this.chart.addChangeListener(this);
        }
    }
}

