/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;

public abstract class ChartFactory {
    private static ChartTheme currentTheme = new StandardChartTheme("JFree");

    public static ChartTheme getChartTheme() {
        return currentTheme;
    }

    public static void setChartTheme(ChartTheme chartTheme) {
        ParamChecks.nullNotPermitted(chartTheme, "theme");
        currentTheme = chartTheme;
    }

    public static JFreeChart createScatterPlot(String string, String string2, String string3, XYDataset xYDataset) {
        return ChartFactory.createScatterPlot(string, string2, string3, xYDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createScatterPlot(String string, String string2, String string3, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        numberAxis2.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis2, null);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer(false, true);
        xYLineAndShapeRenderer.setBaseToolTipGenerator(standardXYToolTipGenerator);
        xYLineAndShapeRenderer.setURLGenerator(standardXYURLGenerator);
        xYPlot.setRenderer(xYLineAndShapeRenderer);
        xYPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createXYLineChart(String string, String string2, String string3, XYDataset xYDataset) {
        return ChartFactory.createXYLineChart(string, string2, string3, xYDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createXYLineChart(String string, String string2, String string3, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer(true, false);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis2, xYLineAndShapeRenderer);
        xYPlot.setOrientation(plotOrientation);
        if (bl2) {
            xYLineAndShapeRenderer.setBaseToolTipGenerator(new StandardXYToolTipGenerator());
        }
        if (bl3) {
            xYLineAndShapeRenderer.setURLGenerator(new StandardXYURLGenerator());
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }
}

