/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.scatterplot.data;

import com.dandymadeproductions.scatterplot.ScatterPlot;
import com.dandymadeproductions.scatterplot.charts.ChartProperties;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import org.jfree.chart.ChartColor;
import org.jfree.chart.plot.DefaultDrawingSupplier;

public class ChartSeriesColors {
    private DefaultDrawingSupplier drawingSupplier;
    private Paint[] paintSequence;
    private Paint[] outlinePaintSequence;
    private Paint[] fillPaintSequence;
    private Stroke[] strokeSequence;
    private Stroke[] outlineStrokeSequence;
    private Shape[] shapeSequence;
    private static final int PAINT_SEQUENCE_ALPHA = 255;

    public ChartSeriesColors() {
        this(255);
    }

    public ChartSeriesColors(int n) {
        this.paintSequence = this.createPaintArray(n);
        this.outlinePaintSequence = DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE;
        this.fillPaintSequence = DefaultDrawingSupplier.DEFAULT_FILL_PAINT_SEQUENCE;
        this.strokeSequence = DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE;
        this.outlineStrokeSequence = DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE;
        this.shapeSequence = DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE;
        this.drawingSupplier = new DefaultDrawingSupplier(this.paintSequence, this.outlinePaintSequence, this.fillPaintSequence, this.strokeSequence, this.outlineStrokeSequence, this.shapeSequence);
    }

    private Paint[] createPaintArray(int n) {
        int n2;
        ChartProperties chartProperties = ScatterPlot.getChartDefaultProperties();
        Paint[] paintArray = ChartColor.createDefaultPaintArray();
        for (n2 = 0; n2 < paintArray.length; ++n2) {
            if (n2 <= 7) continue;
            int n3 = ((Color)paintArray[n2]).getRed();
            int n4 = ((Color)paintArray[n2]).getGreen();
            int n5 = ((Color)paintArray[n2]).getBlue();
            paintArray[n2] = new Color(n3, n4, n5, n);
        }
        for (n2 = 0; n2 < 7; ++n2) {
            paintArray[n2] = new Color(chartProperties.getPlotSeriesColor(n2).getRed(), chartProperties.getPlotSeriesColor(n2).getGreen(), chartProperties.getPlotSeriesColor(n2).getBlue(), n);
        }
        return paintArray;
    }

    public static Paint[] createDefaultPaintArray() {
        Paint[] paintArray = ChartColor.createDefaultPaintArray();
        paintArray[0] = new Color(255, 128, 0);
        paintArray[1] = new Color(85, 255, 85);
        paintArray[2] = new Color(85, 85, 255);
        paintArray[3] = new Color(255, 255, 85);
        paintArray[4] = new Color(198, 11, 255);
        paintArray[5] = new Color(255, 85, 85);
        paintArray[6] = new Color(85, 255, 255);
        return paintArray;
    }

    public DefaultDrawingSupplier getDefaultDrawingSupplier() {
        return this.drawingSupplier;
    }
}

