/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.scatterplot.charts;

import com.dandymadeproductions.scatterplot.ScatterPlot;
import com.dandymadeproductions.scatterplot.charts.ChartsPanel;
import javax.swing.JOptionPane;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ScatterChartPanel
extends ChartsPanel {
    private static final long serialVersionUID = -3465778000758307134L;
    private XYSeriesCollection xyDataSet;
    private static int SET_EXAMPLE_DATA_NUMBER = 3;

    public ScatterChartPanel(String string, String string2) {
        this.resourceExample = string;
        this.resourceChart = string2;
        this.chartDefaultProperties = ScatterPlot.getChartDefaultProperties();
        this.add(this.createExampleChart());
    }

    private ChartPanel createExampleChart() {
        this.xyDataSet = new XYSeriesCollection();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"), false, true);
        for (int i = 0; i < 30; ++i) {
            xYSeries.add(Math.random() * 98.0, Math.random() * 98.0);
        }
        this.xyDataSet.addSeries(xYSeries);
        this.createChart("\t\t\t\t" + this.resourceExample + " Scatter " + this.resourceChart + "\n\nSELECT (X-AXIS) Number, (Y-AXIS) Number, FROM TABLE");
        this.chartPanel = new ChartPanel(this.chart);
        return this.chartPanel;
    }

    private void createChart(String string) {
        this.chart = ChartFactory.createScatterPlot(string, "X-AXIS", "Y-AXIS", this.xyDataSet);
        this.setProperties("Scatter Chart");
        XYItemRenderer xYItemRenderer = ((XYPlot)this.chart.getPlot()).getRenderer();
        if (xYItemRenderer instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYItemRenderer;
            xYLineAndShapeRenderer.setBaseShapesFilled(this.chartDefaultProperties.getPlotBaseShapeFilled());
        }
    }

    @Override
    public String getChartTitle() {
        return this.chart.getTitle().getText();
    }

    @Override
    public void setChartTitle(String string) {
        this.chart.setTitle(string);
    }

    @Override
    public String getChartXAxisLabel() {
        return this.chart.getXYPlot().getDomainAxis().getLabel();
    }

    @Override
    public void setChartXAxisLabel(String string) {
        this.chart.getXYPlot().getDomainAxis().setLabel(string);
    }

    @Override
    public String getChartYAxisLabel() {
        return this.chart.getXYPlot().getRangeAxis().getLabel();
    }

    @Override
    public void setChartYAxisLabel(String string) {
        this.chart.getXYPlot().getRangeAxis().setLabel(string);
    }

    @Override
    public void setExampleData() {
        this.xyDataSet.removeAllSeries();
        for (int i = 0; i < SET_EXAMPLE_DATA_NUMBER; ++i) {
            XYSeries xYSeries = new XYSeries((Comparable)((Object)("Series " + i)), false, true);
            double d = 0.0;
            for (int j = 0; j < 50; ++j) {
                xYSeries.add(d += Math.random() * 100.0, Math.random() * 800.0);
            }
            this.xyDataSet.addSeries(xYSeries);
        }
        this.chart.setTitle(this.resourceExample + " Scatter " + this.resourceChart);
    }

    public void addSeries(XYSeries xYSeries) {
        try {
            if (this.xyDataSet == null) {
                this.xyDataSet = new XYSeriesCollection();
            }
            this.xyDataSet.addSeries(xYSeries);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(null, illegalArgumentException.toString(), "Alert", 0);
        }
    }

    @Override
    public void clearData() {
        this.xyDataSet.removeAllSeries();
    }

    @Override
    public void removeAllData() {
        this.removeAll();
        this.xyDataSet = new XYSeriesCollection();
        this.createChart(" ");
        this.chartPanel = new ChartPanel(this.chart);
        this.add(this.chartPanel);
        this.validate();
    }

    @Override
    public int getSeriesCount() {
        return this.xyDataSet.getSeriesCount();
    }
}

