/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.scatterplot.charts;

import com.dandymadeproductions.scatterplot.charts.ChartsPanel;
import javax.swing.JOptionPane;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class LineChartPanel
extends ChartsPanel {
    private static final long serialVersionUID = 6758153488799132631L;
    private XYSeriesCollection xyDataSet;
    private static int SET_EXAMPLE_DATA_NUMBER = 3;

    public LineChartPanel(String string, String string2) {
        this.resourceExample = string;
        this.resourceChart = string2;
        this.add(this.createExampleChart());
    }

    private ChartPanel createExampleChart() {
        this.xyDataSet = new XYSeriesCollection();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"), false, true);
        double d = 0.0;
        for (int i = 0; i < 5; ++i) {
            xYSeries.add(d += Math.random() * 100.0, Math.random() * 800.0);
        }
        this.xyDataSet.addSeries(xYSeries);
        this.createChart("\t\t\t\t" + this.resourceExample + " Line " + this.resourceChart + "\n\nSELECT (X-AXIS) Number, (Y-AXIS) Number, FROM TABLE");
        this.chartPanel = new ChartPanel(this.chart);
        return this.chartPanel;
    }

    private void createChart(String string) {
        this.chart = ChartFactory.createXYLineChart(string, "X-AXIS", "Y-AXIS", this.xyDataSet);
        this.setProperties("Line Chart");
        XYItemRenderer xYItemRenderer = ((XYPlot)this.chart.getPlot()).getRenderer();
        if (xYItemRenderer instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYItemRenderer;
            xYLineAndShapeRenderer.setBaseShapesVisible(this.chartDefaultProperties.getPlotBaseShapeVisible());
            xYLineAndShapeRenderer.setBaseShapesFilled(this.chartDefaultProperties.getPlotBaseShapeFilled());
            xYLineAndShapeRenderer.setDrawSeriesLineAsPath(this.chartDefaultProperties.getDrawSeriesLinePath());
        }
    }

    @Override
    public String getChartTitle() {
        return this.chart.getTitle().getText();
    }

    @Override
    public void setChartTitle(String string) {
        this.chart.setTitle(string);
    }

    @Override
    public String getChartXAxisLabel() {
        return this.chart.getXYPlot().getDomainAxis().getLabel();
    }

    @Override
    public void setChartXAxisLabel(String string) {
        this.chart.getXYPlot().getDomainAxis().setLabel(string);
    }

    @Override
    public String getChartYAxisLabel() {
        return this.chart.getXYPlot().getRangeAxis().getLabel();
    }

    @Override
    public void setChartYAxisLabel(String string) {
        this.chart.getXYPlot().getRangeAxis().setLabel(string);
    }

    @Override
    public void setExampleData() {
        this.xyDataSet.removeAllSeries();
        for (int i = 0; i < SET_EXAMPLE_DATA_NUMBER; ++i) {
            XYSeries xYSeries = new XYSeries((Comparable)((Object)("Series " + i)), false, true);
            double d = 0.0;
            for (int j = 0; j < 5; ++j) {
                xYSeries.add(d += Math.random() * 100.0, Math.random() * 800.0);
            }
            this.xyDataSet.addSeries(xYSeries);
        }
        this.chart.setTitle(this.resourceExample + " Line " + this.resourceChart);
    }

    public void addSeries(XYSeries xYSeries) {
        try {
            if (this.xyDataSet == null) {
                this.xyDataSet = new XYSeriesCollection();
            }
            this.xyDataSet.addSeries(xYSeries);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(null, illegalArgumentException.toString(), "Alert", 0);
        }
    }

    @Override
    public void clearData() {
        this.xyDataSet.removeAllSeries();
    }

    @Override
    public void removeAllData() {
        this.removeAll();
        this.xyDataSet = new XYSeriesCollection();
        this.createChart(" ");
        this.chartPanel = new ChartPanel(this.chart);
        this.add(this.chartPanel);
        this.validate();
    }

    @Override
    public int getSeriesCount() {
        return this.xyDataSet.getSeriesCount();
    }
}

