/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.scatterplot.charts;

import com.dandymadeproductions.scatterplot.ScatterPlot;
import com.dandymadeproductions.scatterplot.charts.ChartProperties;
import com.dandymadeproductions.scatterplot.charts.LineChartPanel;
import com.dandymadeproductions.scatterplot.charts.ScatterChartPanel;
import com.dandymadeproductions.scatterplot.data.ChartSeriesColors;
import com.dandymadeproductions.scatterplot.data.DataChartSeries;
import com.dandymadeproductions.scatterplot.data.LineChartSeries;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.util.PublicCloneable;

public class ChartsPanel
extends JPanel {
    private static final long serialVersionUID = -6003287593001429926L;
    protected JFreeChart chart;
    protected ChartPanel chartPanel;
    protected String resourceExample;
    protected String resourceChart;
    protected ChartProperties chartDefaultProperties;
    protected static final int EXAMPLE_SERIES_NUMBER = 1;
    private static final int PIE_CHART_ALPHA = 221;
    private static final int BUBBLE_CHART_ALPHA = 128;
    private static final int AREA_CHART_ALPHA = 176;
    public static final Color DEFAULT_FOREGROUND = new JPanel().getForeground();
    public static final Color DEFAULT_BACKGROUND = new JPanel().getBackground();
    public static final boolean DEFAULT_AUTOSORT = true;
    public static final boolean DEFAULT_ALLOWDUPLICATEXVALUES = true;
    public static final Color DEFAULT_PLOTBACKGROUNDCOLOR = Color.WHITE;
    public static final Color DEFAULT_DOMAINGRIDLINECOLOR = Color.LIGHT_GRAY;
    public static final Color DEFAULT_RANGEGRIDLINECOLOR = Color.LIGHT_GRAY;
    public static final boolean DEFAULT_PLOTBASESHAPEVISIBLE = true;
    public static final boolean DEFAULT_PLOTBASESHAPEFILLED = true;
    public static final boolean DEFAULT_DRAWSERIESLINEPATH = true;

    public ChartsPanel() {
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(12, 5, 12, 5), BorderFactory.createRaisedSoftBevelBorder()));
        this.chartDefaultProperties = ScatterPlot.getChartDefaultProperties();
    }

    public void setProperties(String string) {
        PublicCloneable publicCloneable;
        this.chart.getTitle().setFont(new Font(this.getFont().getFamily(), 0, this.chartDefaultProperties.getTitleFontSize()));
        this.setBackground(this.chartDefaultProperties.getChartBackgroundColor());
        this.chart.getTitle().setPaint(this.chartDefaultProperties.getChartForegroundColor());
        if (ChartFactory.getChartTheme() instanceof StandardChartTheme) {
            ChartSeriesColors chartSeriesColors = string.equals("Pie Chart") ? new ChartSeriesColors(221) : (string.equals("Bubble Chart") ? new ChartSeriesColors(128) : (string.equals("Area Chart") ? new ChartSeriesColors(176) : new ChartSeriesColors()));
            publicCloneable = (StandardChartTheme)ChartFactory.getChartTheme();
            ((StandardChartTheme)publicCloneable).setDrawingSupplier(chartSeriesColors.getDefaultDrawingSupplier());
            ((StandardChartTheme)publicCloneable).apply(this.chart);
        }
        if (string.equals("Line Chart") || string.equals("XY Area Chart") || string.equals("Scatter Chart") || string.equals("XY Bar Chart") || string.equals("Bubble Chart")) {
            publicCloneable = (XYPlot)this.chart.getPlot();
            ((Plot)publicCloneable).setBackgroundPaint(this.chartDefaultProperties.getPlotBackgroundColor());
            ((XYPlot)publicCloneable).getDomainAxis().setLabelPaint(this.chartDefaultProperties.getChartForegroundColor());
            ((XYPlot)publicCloneable).getDomainAxis().setAxisLinePaint(this.chartDefaultProperties.getChartForegroundColor());
            ((XYPlot)publicCloneable).getDomainAxis().setTickLabelPaint(this.chartDefaultProperties.getChartForegroundColor());
            ((XYPlot)publicCloneable).setDomainMinorGridlinePaint(this.chartDefaultProperties.getChartForegroundColor());
            ((XYPlot)publicCloneable).setDomainGridlinePaint(this.chartDefaultProperties.getDomainGridLineColor());
            ((XYPlot)publicCloneable).getRangeAxis().setLabelPaint(this.chartDefaultProperties.getChartForegroundColor());
            ((XYPlot)publicCloneable).getRangeAxis().setAxisLinePaint(this.chartDefaultProperties.getChartForegroundColor());
            ((XYPlot)publicCloneable).getRangeAxis().setTickLabelPaint(this.chartDefaultProperties.getChartForegroundColor());
            ((XYPlot)publicCloneable).setRangeMinorGridlinePaint(this.chartDefaultProperties.getChartForegroundColor());
            ((XYPlot)publicCloneable).setRangeGridlinePaint(this.chartDefaultProperties.getRangeGridLineColor());
        }
    }

    public void setExampleData() {
    }

    public void addSeries(DataChartSeries dataChartSeries) {
        if (this instanceof LineChartPanel) {
            ((LineChartPanel)this).addSeries(((LineChartSeries)dataChartSeries).getDataSeries());
        } else if (this instanceof ScatterChartPanel) {
            ((ScatterChartPanel)this).addSeries(((LineChartSeries)dataChartSeries).getDataSeries());
        }
    }

    public void clearData() {
    }

    public void removeAllData() {
    }

    public int getSeriesCount() {
        return 0;
    }

    public String getChartTitle() {
        return null;
    }

    public void setChartTitle(String string) {
    }

    public String getChartXAxisLabel() {
        return null;
    }

    public void setChartXAxisLabel(String string) {
    }

    public String getChartYAxisLabel() {
        return null;
    }

    public void setChartYAxisLabel(String string) {
    }
}

