/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.scatterplot.charts;

import com.dandymadeproductions.lindyframe.LindyFrame;
import com.dandymadeproductions.scatterplot.charts.ChartsPanel;
import com.dandymadeproductions.scatterplot.data.ChartSeriesColors;
import java.awt.Color;
import java.awt.Paint;

public class ChartProperties {
    private int titleFontSize = LindyFrame.getGeneralProperties().getFontSize() + 2;
    private int chartForegroundColor = ChartsPanel.DEFAULT_FOREGROUND.getRGB();
    private int chartBackgroundColor = ChartsPanel.DEFAULT_BACKGROUND.getRGB();
    private boolean autoSort = true;
    private boolean allowDuplicateXValues = true;
    private int plotBackgroundColor = ChartsPanel.DEFAULT_PLOTBACKGROUNDCOLOR.getRGB();
    private int domainGridLineColor = ChartsPanel.DEFAULT_DOMAINGRIDLINECOLOR.getRGB();
    private int rangeGridLineColor = ChartsPanel.DEFAULT_RANGEGRIDLINECOLOR.getRGB();
    private boolean plotBaseShapeVisible = true;
    private boolean plotBaseShapeFilled = true;
    private int[] plotSeriesColors = new int[7];
    private boolean drawSeriesLinePath;
    public static final int PLOT_SERIES_SEQUENCE_NUMBER = 7;
    public static final String DATACHARTS_TITLEFONTSIZE = "DataChartsTitleFontSize";
    public static final String DATACHARTS_CHARTFOREGROUNDCOLOR = "DataChartsChartForegroundColor";
    public static final String DATACHARTS_CHARTBACKGROUNDCOLOR = "DataChartsChartBackgroundColor";
    public static final String DATACHARTS_AUTOSORT = "DataChartsAutoSort";
    public static final String DATACHARTS_ALLOWDUPLICATEXVALUES = "DataChartsAllowDuplicateXValues";
    public static final String DATACHARTS_PLOTBACKGROUNDCOLOR = "DataChartPlotBackgroundColor";
    public static final String DATACHARTS_DOMAINGRIDLINECOLOR = "DataChartsDomainGridLineColor";
    public static final String DATACHARTS_RANGEGRIDLINECOLOR = "DataChartsRangeGridLineColor";
    public static final String DATACHARTS_PLOTBASESHAPEVISIBLE = "DataChartsBaseShapeVisibile";
    public static final String DATACHARTS_PLOTBASESHAPEFILLED = "DataChartsBaseShapeFilled";
    public static final String DATACHARTS_PLOTSERIESCOLORS = "DataChartsPlotSeriesColors";
    public static final String DATACHARTS_DRAWSERIESLINEPATH = "DataChartsDrawSeriesLinePath";

    public ChartProperties() {
        Paint[] paintArray = ChartSeriesColors.createDefaultPaintArray();
        for (int i = 0; i < 7; ++i) {
            this.plotSeriesColors[i] = ((Color)paintArray[i]).getRGB();
        }
        this.drawSeriesLinePath = true;
    }

    public int getTitleFontSize() {
        return this.titleFontSize;
    }

    public Color getChartForegroundColor() {
        return new Color(this.chartForegroundColor);
    }

    public Color getChartBackgroundColor() {
        return new Color(this.chartBackgroundColor);
    }

    public boolean getAutoSort() {
        return this.autoSort;
    }

    public boolean getAllowDuplicateXValues() {
        return this.allowDuplicateXValues;
    }

    public Color getPlotBackgroundColor() {
        return new Color(this.plotBackgroundColor);
    }

    public Color getDomainGridLineColor() {
        return new Color(this.domainGridLineColor);
    }

    public Color getRangeGridLineColor() {
        return new Color(this.rangeGridLineColor);
    }

    public boolean getPlotBaseShapeVisible() {
        return this.plotBaseShapeVisible;
    }

    public boolean getPlotBaseShapeFilled() {
        return this.plotBaseShapeFilled;
    }

    public Color getPlotSeriesColor(int n) {
        if (n < 7) {
            return new Color(this.plotSeriesColors[n]);
        }
        return Color.WHITE;
    }

    public boolean getDrawSeriesLinePath() {
        return this.drawSeriesLinePath;
    }

    public void setTitleFontSize(int n) {
        this.titleFontSize = n;
    }

    public void setChartForegroundColor(int n) {
        this.chartForegroundColor = n;
    }

    public void setChartBackgroundColor(int n) {
        this.chartBackgroundColor = n;
    }

    public void setAutoSort(boolean bl) {
        this.autoSort = bl;
    }

    public void setAllowDuplicateXValues(boolean bl) {
        this.allowDuplicateXValues = bl;
    }

    public void setPlotBackgroundColor(int n) {
        this.plotBackgroundColor = n;
    }

    public void setDomainGridLineColor(int n) {
        this.domainGridLineColor = n;
    }

    public void setRangeGridLineColor(int n) {
        this.rangeGridLineColor = n;
    }

    public void setPlotBaseShapeVisible(boolean bl) {
        this.plotBaseShapeVisible = bl;
    }

    public void setPlotBaseShapeFilled(boolean bl) {
        this.plotBaseShapeFilled = bl;
    }

    public void setPlotSeriesColor(int n, int n2) {
        if (n < 7) {
            this.plotSeriesColors[n] = n2;
        }
    }

    public void setDrawSeriesLinePath(boolean bl) {
        this.drawSeriesLinePath = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[GeneralProperties: ");
        stringBuffer.append("[titleFontSize = " + this.titleFontSize + "]");
        stringBuffer.append("[chartForegroundColor = " + this.chartForegroundColor + "]");
        stringBuffer.append("[chartBackgroundColor = " + this.chartBackgroundColor + "]");
        stringBuffer.append("[autoSort = " + this.autoSort + "]");
        stringBuffer.append("[allowDuplicateXValues = " + this.allowDuplicateXValues + "]");
        stringBuffer.append("[plotBackgroundColor = " + this.plotBackgroundColor + "]");
        stringBuffer.append("[domainGridLineColor = " + this.domainGridLineColor + "]");
        stringBuffer.append("[rangeGridLineColor = " + this.rangeGridLineColor + "]");
        stringBuffer.append("[plotBaseShapeVisible = " + this.plotBaseShapeVisible + "]");
        stringBuffer.append("[plotBaseShapeFilled = " + this.plotBaseShapeFilled + "]");
        for (int i = 0; i < 7; ++i) {
            stringBuffer.append("[plotSeriesColors " + i + " = " + this.plotSeriesColors[i] + "]");
        }
        stringBuffer.append("[drawSeriesLinePath = " + this.drawSeriesLinePath + "]");
        return stringBuffer.toString();
    }
}

