/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.scatterplot;

import com.dandymadeproductions.lindyframe.LindyFrame;
import com.dandymadeproductions.lindyframe.gui.Main_Frame;
import com.dandymadeproductions.lindyframe.utilities.LindyFrame_ResourceBundle;
import com.dandymadeproductions.scatterplot.MenuActionListener;
import com.dandymadeproductions.scatterplot.PlotPanel;
import com.dandymadeproductions.scatterplot.Plotter_MenuBar;
import com.dandymadeproductions.scatterplot.Plotter_ToolBar;
import com.dandymadeproductions.scatterplot.charts.ChartProperties;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

public class ScatterPlot {
    private ImageIcon tabIcon;
    private PlotPanel plotPanel;
    private Plotter_MenuBar menuBar;
    private Plotter_ToolBar toolBar;
    private String imagesDirectory;
    private LindyFrame_ResourceBundle resourceBundle;
    public static final String LINE_CHART = "Line Chart";
    public static final String CATEGORY_LINE_CHART = "Category Line Chart";
    public static final String BAR_CHART = "Bar Chart";
    public static final String XYBAR_CHART = "XY Bar Chart";
    public static final String PIE_CHART = "Pie Chart";
    public static final String AREA_CHART = "Area Chart";
    public static final String XYAREA_CHART = "XY Area Chart";
    public static final String BUBBLE_CHART = "Bubble Chart";
    public static final String SCATTER_CHART = "Scatter Chart";
    protected static final String[] CHART_OPTIONS = new String[]{"Line Chart", "Scatter Chart"};
    protected static final int FONT_SIZE = LindyFrame.getGeneralProperties().getFontSize();
    protected static final ChartProperties CHART_PROPERTIES = new ChartProperties();
    protected static final String DELIMITER = ",";
    private static final String VERSION = "Version 1.5";
    private static final String DESCRIPTION = "The ScatterPlot plugin provides a mean to demostrate a plotting module example for the lindyFrame framework. The plugin is a basic Scatter Plot. ScatterPlot includes the libraries (LGPL) JFreeChart and JCommon.";

    public ScatterPlot(Main_Frame main_Frame, String string) {
        String string2 = string + "/ScatterPlot.jar";
        String string3 = "lib/plugins/ScatterPlot/locale/";
        this.imagesDirectory = "lib/plugins/ScatterPlot/images/";
        this.resourceBundle = new LindyFrame_ResourceBundle(string2, LindyFrame.getDebug());
        this.resourceBundle.setLocaleResource(string3, "ScatterPlot", LindyFrame.getLocaleString());
        this.tabIcon = this.resourceBundle.getResourceImage(this.imagesDirectory + "icons/chartsIcon.png");
        this.plotPanel = new PlotPanel(this.imagesDirectory, this.resourceBundle);
        MenuActionListener menuActionListener = new MenuActionListener((JFrame)main_Frame, this.plotPanel, this.resourceBundle, this.imagesDirectory);
        this.menuBar = new Plotter_MenuBar(main_Frame, this.resourceBundle, menuActionListener);
        this.toolBar = new Plotter_ToolBar("ScatterPlot ToolBar", main_Frame, this.imagesDirectory, this.resourceBundle, menuActionListener);
    }

    protected JMenuBar getMenuBar() {
        return this.menuBar;
    }

    protected JToolBar getToolBar() {
        return this.toolBar;
    }

    protected JComponent getPanel() {
        return this.plotPanel;
    }

    protected String getVersion() {
        return VERSION;
    }

    protected String getDescription() {
        return DESCRIPTION;
    }

    protected ImageIcon getTabIcon() {
        return this.tabIcon;
    }

    public static ChartProperties getChartDefaultProperties() {
        return CHART_PROPERTIES;
    }
}

