/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.scatterplot;

import com.dandymadeproductions.lindyframe.utilities.LindyFrame_ResourceBundle;
import com.dandymadeproductions.lindyframe.utilities.LindyFrame_Utils;
import com.dandymadeproductions.scatterplot.ScatterPlot;
import com.dandymadeproductions.scatterplot.charts.ChartProperties;
import com.dandymadeproductions.scatterplot.charts.ChartsPanel;
import com.dandymadeproductions.scatterplot.data.ChartSeriesColors;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class PreferencesPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 7038356098876284781L;
    private ChartProperties chartProperties;
    private GridBagConstraints constraints;
    private GridBagLayout gridbag;
    private JColorChooser panelColorChooser;
    private String actionCommand;
    private ImageIcon transparentIcon;
    private JSpinner titleFontSizeSpinner;
    private JButton chartBackgndColorButton;
    private JButton chartForegndColorButton;
    private JCheckBox autoSortCheckBox;
    private JCheckBox allowDuplicateXValuesCheckBox;
    private JButton plotBackgndColorButton;
    private JButton domainGridLineColorButton;
    private JButton rangeGridLineColorButton;
    private JCheckBox plotBaseShapeVisibleCheckBox;
    private JCheckBox plotBaseShapeFilledCheckBox;
    private JButton[] plotSeriesColorsButtons;
    private JCheckBox drawSeriesLinePathCheckBox;
    private JButton restoreDefaultsButton;
    public static final int MINIMUM_FONT_SIZE = 8;
    public static final int MAX_FONT_SIZE = 32;
    public static final int SPINNER_SIZE_STEP = 1;
    private static final String BACKGROUND = "background";
    private static final String FOREGROUND = "foreground";
    private static final String PLOT = "plot";
    private static final String PLOT_SERIES = "plot series";
    private static final String DOMAIN = "domain";
    private static final String RANGE = "range";

    public PreferencesPanel(LindyFrame_ResourceBundle lindyFrame_ResourceBundle, String string) {
        this.setLayout(new BorderLayout());
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createLoweredBevelBorder());
        this.setBorder(BorderFactory.createCompoundBorder(compoundBorder, BorderFactory.createEmptyBorder(5, 0, 0, 0)));
        this.chartProperties = ScatterPlot.getChartDefaultProperties();
        this.gridbag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.panelColorChooser = LindyFrame_Utils.createColorChooser((Component)this);
        this.transparentIcon = lindyFrame_ResourceBundle.getResourceImage(string + "icons/transparentUpIcon.png");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new EmptyBorder(2, 5, 2, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 0, 4));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 0, 10, 0));
        JPanel jPanel3 = new JPanel(this.gridbag);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.chartProperties.getTitleFontSize(), 8, 32, 1);
        this.titleFontSizeSpinner = new JSpinner(spinnerNumberModel);
        String string2 = lindyFrame_ResourceBundle.getResourceString("PreferencesPanel.label.TitleFontSize", "Title Font Size");
        JLabel jLabel = new JLabel(string2);
        this.setupPanel(this.titleFontSizeSpinner, jLabel, jPanel3);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(this.gridbag);
        this.chartBackgndColorButton = new JButton(this.transparentIcon);
        this.chartBackgndColorButton.setBackground(this.chartProperties.getChartBackgroundColor());
        this.chartBackgndColorButton.setFocusable(false);
        this.chartBackgndColorButton.setMargin(new Insets(0, 0, 0, 0));
        this.chartBackgndColorButton.setActionCommand(BACKGROUND);
        this.chartBackgndColorButton.addActionListener(this);
        string2 = lindyFrame_ResourceBundle.getResourceString("PreferencesPanel.label.ChartBackgroundColor", "Chart Background Color");
        JLabel jLabel2 = new JLabel(string2);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.setupPanel(this.chartBackgndColorButton, jLabel2, jPanel4);
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel(this.gridbag);
        this.chartForegndColorButton = new JButton(this.transparentIcon);
        this.chartForegndColorButton.setBackground(this.chartProperties.getChartForegroundColor());
        this.chartForegndColorButton.setFocusable(false);
        this.chartForegndColorButton.setMargin(new Insets(0, 0, 0, 0));
        this.chartForegndColorButton.setActionCommand(FOREGROUND);
        this.chartForegndColorButton.addActionListener(this);
        string2 = lindyFrame_ResourceBundle.getResourceString("PreferencesPanel.label.ChartForegroundColor", "Chart Foreground Color");
        JLabel jLabel3 = new JLabel(string2);
        jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.setupPanel(this.chartForegndColorButton, jLabel3, jPanel5);
        jPanel2.add(jPanel5);
        jPanel.add(jPanel2);
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1, 0, 6));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(2, 0, 10, 0));
        string2 = lindyFrame_ResourceBundle.getResourceString("PreferencesPanel.label.AutoSortX-Axis", "Auto Sort X-Axis");
        this.autoSortCheckBox = new JCheckBox(string2, this.chartProperties.getAutoSort());
        this.autoSortCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 0));
        jPanel6.add(this.autoSortCheckBox);
        string2 = lindyFrame_ResourceBundle.getResourceString("PreferencesPanel.label.AllowDuplicateXValues", "Allow Duplicate X Values");
        this.allowDuplicateXValuesCheckBox = new JCheckBox(string2, this.chartProperties.getAllowDuplicateXValues());
        this.allowDuplicateXValuesCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 0));
        jPanel6.add(this.allowDuplicateXValuesCheckBox);
        jPanel.add(jPanel6);
        JPanel jPanel7 = new JPanel(new GridLayout(6, 1, 0, 4));
        jPanel7.setBorder(BorderFactory.createEmptyBorder(2, 0, 10, 0));
        JPanel jPanel8 = new JPanel(this.gridbag);
        this.plotBackgndColorButton = new JButton(this.transparentIcon);
        this.plotBackgndColorButton.setBackground(this.chartProperties.getPlotBackgroundColor());
        this.plotBackgndColorButton.setFocusable(false);
        this.plotBackgndColorButton.setMargin(new Insets(0, 0, 0, 0));
        this.plotBackgndColorButton.setActionCommand(PLOT);
        this.plotBackgndColorButton.addActionListener(this);
        string2 = lindyFrame_ResourceBundle.getResourceString("PreferencesPanel.label.PlotBackgroundColor", "Plot Background Color");
        JLabel jLabel4 = new JLabel(string2);
        jLabel4.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.setupPanel(this.plotBackgndColorButton, jLabel4, jPanel8);
        jPanel7.add(jPanel8);
        JPanel jPanel9 = new JPanel(this.gridbag);
        this.domainGridLineColorButton = new JButton(this.transparentIcon);
        this.domainGridLineColorButton.setBackground(this.chartProperties.getDomainGridLineColor());
        this.domainGridLineColorButton.setFocusable(false);
        this.domainGridLineColorButton.setMargin(new Insets(0, 0, 0, 0));
        this.domainGridLineColorButton.setActionCommand(DOMAIN);
        this.domainGridLineColorButton.addActionListener(this);
        string2 = lindyFrame_ResourceBundle.getResourceString("PreferencesPanel.label.DomainGridLineColor", "Domain Grid Line Color");
        JLabel jLabel5 = new JLabel(string2);
        jLabel5.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.setupPanel(this.domainGridLineColorButton, jLabel5, jPanel9);
        jPanel7.add(jPanel9);
        JPanel jPanel10 = new JPanel(this.gridbag);
        this.rangeGridLineColorButton = new JButton(this.transparentIcon);
        this.rangeGridLineColorButton.setBackground(this.chartProperties.getRangeGridLineColor());
        this.rangeGridLineColorButton.setFocusable(false);
        this.rangeGridLineColorButton.setMargin(new Insets(0, 0, 0, 0));
        this.rangeGridLineColorButton.setActionCommand(RANGE);
        this.rangeGridLineColorButton.addActionListener(this);
        string2 = lindyFrame_ResourceBundle.getResourceString("PreferencesPanel.label.RangeGridLineColor", "Range Grid Line Color");
        JLabel jLabel6 = new JLabel(string2);
        jLabel6.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.setupPanel(this.rangeGridLineColorButton, jLabel6, jPanel10);
        jPanel7.add(jPanel10);
        string2 = lindyFrame_ResourceBundle.getResourceString("PreferencesPanel.label.PlotShapeVisible", "Plot Shape Visible");
        this.plotBaseShapeVisibleCheckBox = new JCheckBox(string2, this.chartProperties.getPlotBaseShapeVisible());
        this.plotBaseShapeVisibleCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 0));
        jPanel7.add(this.plotBaseShapeVisibleCheckBox);
        string2 = lindyFrame_ResourceBundle.getResourceString("PreferencesPanel.label.PlotShapeFilled", "Plot Shape Filled");
        this.plotBaseShapeFilledCheckBox = new JCheckBox(string2, this.chartProperties.getPlotBaseShapeFilled());
        this.plotBaseShapeFilledCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 0));
        jPanel7.add(this.plotBaseShapeFilledCheckBox);
        string2 = lindyFrame_ResourceBundle.getResourceString("PreferencesPanel.label.DrawLinePath", "DrawLinePath");
        this.drawSeriesLinePathCheckBox = new JCheckBox(string2, this.chartProperties.getDrawSeriesLinePath());
        this.drawSeriesLinePathCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 0));
        jPanel7.add(this.drawSeriesLinePathCheckBox);
        jPanel.add(jPanel7);
        jPanel.add(this.setupPaintSeriesButtons(lindyFrame_ResourceBundle));
        this.add((Component)jPanel, "Center");
        JPanel jPanel11 = new JPanel();
        jPanel11.setBorder(BorderFactory.createRaisedBevelBorder());
        string2 = lindyFrame_ResourceBundle.getResourceString("PreferencesPanel.button.RestoreDefaults", "Restore Defaults");
        this.restoreDefaultsButton = new JButton(string2);
        this.restoreDefaultsButton.setFocusPainted(false);
        this.restoreDefaultsButton.addActionListener(this);
        jPanel11.add(this.restoreDefaultsButton);
        this.add((Component)jPanel11, "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.restoreDefaultsButton) {
                this.titleFontSizeSpinner.setValue(ScatterPlot.FONT_SIZE + 2);
                this.chartBackgndColorButton.setBackground(ChartsPanel.DEFAULT_BACKGROUND);
                this.chartForegndColorButton.setBackground(ChartsPanel.DEFAULT_FOREGROUND);
                this.autoSortCheckBox.setSelected(true);
                this.allowDuplicateXValuesCheckBox.setSelected(true);
                this.plotBackgndColorButton.setBackground(ChartsPanel.DEFAULT_PLOTBACKGROUNDCOLOR);
                this.domainGridLineColorButton.setBackground(ChartsPanel.DEFAULT_DOMAINGRIDLINECOLOR);
                this.rangeGridLineColorButton.setBackground(ChartsPanel.DEFAULT_RANGEGRIDLINECOLOR);
                this.plotBaseShapeVisibleCheckBox.setSelected(true);
                this.plotBaseShapeFilledCheckBox.setSelected(true);
                Paint[] paintArray = ChartSeriesColors.createDefaultPaintArray();
                for (int i = 0; i < 7; ++i) {
                    this.plotSeriesColorsButtons[i].setBackground((Color)paintArray[i]);
                }
                this.drawSeriesLinePathCheckBox.setSelected(true);
            } else {
                if (object == this.chartBackgndColorButton || object == this.chartForegndColorButton || object == this.plotBackgndColorButton || object == this.domainGridLineColorButton || object == this.rangeGridLineColorButton || this.isPlotSeriesColorsButton(object)) {
                    JButton jButton = (JButton)object;
                    this.actionCommand = jButton.getActionCommand();
                    if (jButton == this.chartBackgndColorButton) {
                        this.panelColorChooser.setColor(this.chartBackgndColorButton.getBackground());
                    } else if (jButton == this.chartForegndColorButton) {
                        this.panelColorChooser.setColor(this.chartForegndColorButton.getBackground());
                    } else if (jButton == this.plotBackgndColorButton) {
                        this.panelColorChooser.setColor(this.plotBackgndColorButton.getBackground());
                    } else if (jButton == this.domainGridLineColorButton) {
                        this.panelColorChooser.setColor(this.domainGridLineColorButton.getBackground());
                    } else if (jButton == this.rangeGridLineColorButton) {
                        this.panelColorChooser.setColor(this.rangeGridLineColorButton.getBackground());
                    } else {
                        for (int i = 0; i < 7; ++i) {
                            if (jButton != this.plotSeriesColorsButtons[i]) continue;
                            this.panelColorChooser.setColor(this.plotSeriesColorsButtons[i].getBackground());
                        }
                    }
                    JDialog jDialog = JColorChooser.createDialog(this, "Color Selector", true, this.panelColorChooser, this, null);
                    jDialog.setVisible(true);
                    jDialog.dispose();
                    return;
                }
                if (((JButton)object).getText().equals("OK")) {
                    if (this.actionCommand.equals(BACKGROUND)) {
                        this.chartBackgndColorButton.setBackground(this.panelColorChooser.getColor());
                    } else if (this.actionCommand.equals(FOREGROUND)) {
                        this.chartForegndColorButton.setBackground(this.panelColorChooser.getColor());
                    } else if (this.actionCommand.equals(PLOT)) {
                        this.plotBackgndColorButton.setBackground(this.panelColorChooser.getColor());
                    } else if (this.actionCommand.equals(DOMAIN)) {
                        this.domainGridLineColorButton.setBackground(this.panelColorChooser.getColor());
                    } else if (this.actionCommand.equals(RANGE)) {
                        this.rangeGridLineColorButton.setBackground(this.panelColorChooser.getColor());
                    } else {
                        for (int i = 0; i < 7; ++i) {
                            if (!this.actionCommand.equals(PLOT_SERIES + i)) continue;
                            this.plotSeriesColorsButtons[i].setBackground(this.panelColorChooser.getColor());
                        }
                    }
                    this.actionCommand = "";
                }
            }
        }
    }

    private boolean isPlotSeriesColorsButton(Object object) {
        boolean bl = false;
        for (int i = 0; i < 7; ++i) {
            if (object != this.plotSeriesColorsButtons[i]) continue;
            bl = true;
        }
        return bl;
    }

    private void setupPanel(JComponent jComponent, JComponent jComponent2, JPanel jPanel) {
        LindyFrame_Utils.buildConstraints((GridBagConstraints)this.constraints, (int)0, (int)0, (int)1, (int)1, (double)15.0, (double)100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.gridbag.setConstraints(jComponent, this.constraints);
        jPanel.add(jComponent);
        LindyFrame_Utils.buildConstraints((GridBagConstraints)this.constraints, (int)1, (int)0, (int)1, (int)1, (double)85.0, (double)100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.gridbag.setConstraints(jComponent2, this.constraints);
        jPanel.add(jComponent2);
    }

    private JPanel setupPaintSeriesButtons(LindyFrame_ResourceBundle lindyFrame_ResourceBundle) {
        JPanel jPanel = new JPanel(this.gridbag);
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        String string = lindyFrame_ResourceBundle.getResourceString("PreferencesPanel.label.PlotSeriesColors", "Plot Series Colors");
        JLabel jLabel = new JLabel(string);
        LindyFrame_Utils.buildConstraints((GridBagConstraints)this.constraints, (int)0, (int)0, (int)7, (int)1, (double)100.0, (double)50.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jLabel, this.constraints);
        jPanel.add(jLabel);
        this.plotSeriesColorsButtons = new JButton[7];
        for (int i = 0; i < 7; ++i) {
            this.plotSeriesColorsButtons[i] = new JButton(this.transparentIcon);
            this.plotSeriesColorsButtons[i].setBackground(this.chartProperties.getPlotSeriesColor(i));
            this.plotSeriesColorsButtons[i].setFocusable(false);
            this.plotSeriesColorsButtons[i].setMargin(new Insets(0, 0, 0, 0));
            this.plotSeriesColorsButtons[i].setActionCommand(PLOT_SERIES + i);
            this.plotSeriesColorsButtons[i].addActionListener(this);
            LindyFrame_Utils.buildConstraints((GridBagConstraints)this.constraints, (int)i, (int)1, (int)1, (int)1, (double)100.0, (double)(i == 0 ? 50 : 0));
            this.constraints.fill = 0;
            this.constraints.anchor = 10;
            this.gridbag.setConstraints(this.plotSeriesColorsButtons[i], this.constraints);
            jPanel.add(this.plotSeriesColorsButtons[i]);
        }
        return jPanel;
    }

    public void setProperties() {
        ChartProperties chartProperties = ScatterPlot.getChartDefaultProperties();
        chartProperties.setTitleFontSize((Integer)this.titleFontSizeSpinner.getValue());
        chartProperties.setChartBackgroundColor(this.chartBackgndColorButton.getBackground().getRGB());
        chartProperties.setChartForegroundColor(this.chartForegndColorButton.getBackground().getRGB());
        chartProperties.setAutoSort(this.autoSortCheckBox.isSelected());
        chartProperties.setAllowDuplicateXValues(this.allowDuplicateXValuesCheckBox.isSelected());
        chartProperties.setPlotBackgroundColor(this.plotBackgndColorButton.getBackground().getRGB());
        chartProperties.setDomainGridLineColor(this.domainGridLineColorButton.getBackground().getRGB());
        chartProperties.setRangeGridLineColor(this.rangeGridLineColorButton.getBackground().getRGB());
        chartProperties.setPlotBaseShapeVisible(this.plotBaseShapeVisibleCheckBox.isSelected());
        chartProperties.setPlotBaseShapeFilled(this.plotBaseShapeFilledCheckBox.isSelected());
        for (int i = 0; i < 7; ++i) {
            chartProperties.setPlotSeriesColor(i, this.plotSeriesColorsButtons[i].getBackground().getRGB());
        }
        chartProperties.setDrawSeriesLinePath(this.drawSeriesLinePathCheckBox.isSelected());
    }
}

