/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.scatterplot;

import com.dandymadeproductions.lindyframe.utilities.LindyFrame_ResourceBundle;
import com.dandymadeproductions.lindyframe.utilities.LindyFrame_Utils;
import com.dandymadeproductions.scatterplot.ScatterPlot;
import com.dandymadeproductions.scatterplot.charts.ChartsPanel;
import com.dandymadeproductions.scatterplot.charts.LineChartPanel;
import com.dandymadeproductions.scatterplot.charts.ScatterChartPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class PlotPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 117774406001854773L;
    private JPanel dataPanel;
    private ChartsPanel chartsPanel;
    private JComboBox<String> chartSelectorComboBox;
    private JButton refreshButton;
    private JButton clearButton;
    private boolean disableActions = false;
    private String iconsDirectory;
    private String resourceExample;
    private String resourceChart;

    protected PlotPanel(String string, LindyFrame_ResourceBundle lindyFrame_ResourceBundle) {
        this.resourceExample = lindyFrame_ResourceBundle.getResourceString("PlotPanel.label.Example", "Example");
        this.resourceChart = lindyFrame_ResourceBundle.getResourceString("PlotPanel.label.Chart", "Chart");
        this.iconsDirectory = string + "icons/";
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 0, 0));
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        this.chartSelectorComboBox = new JComboBox<String>(ScatterPlot.CHART_OPTIONS);
        this.chartSelectorComboBox.setBorder(BorderFactory.createRaisedBevelBorder());
        this.chartSelectorComboBox.setSelectedItem("Scatter Chart");
        this.chartSelectorComboBox.addActionListener(this);
        LindyFrame_Utils.buildConstraints((GridBagConstraints)gridBagConstraints, (int)1, (int)0, (int)1, (int)1, (double)96.0, (double)100.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.chartSelectorComboBox, gridBagConstraints);
        jPanel2.add(this.chartSelectorComboBox);
        LindyFrame_Utils.buildConstraints((GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)1, (int)1, (double)90.0, (double)100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        ImageIcon imageIcon = lindyFrame_ResourceBundle.getResourceImage(this.iconsDirectory + "refreshIcon.png");
        this.refreshButton = new JButton(imageIcon);
        this.refreshButton.setMargin(new Insets(0, 0, 0, 0));
        this.refreshButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), this.refreshButton.getBorder()));
        this.refreshButton.setFocusPainted(false);
        this.refreshButton.addActionListener(this);
        LindyFrame_Utils.buildConstraints((GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)1, (int)1, (double)50.0, (double)100.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.refreshButton, gridBagConstraints);
        jPanel3.add(this.refreshButton);
        ImageIcon imageIcon2 = lindyFrame_ResourceBundle.getResourceImage(this.iconsDirectory + "clearIcon.png");
        this.clearButton = new JButton(imageIcon2);
        this.clearButton.setMargin(new Insets(0, 0, 0, 0));
        this.clearButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), this.clearButton.getBorder()));
        this.clearButton.setFocusPainted(false);
        this.clearButton.addActionListener(this);
        LindyFrame_Utils.buildConstraints((GridBagConstraints)gridBagConstraints, (int)2, (int)0, (int)1, (int)1, (double)50.0, (double)100.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.clearButton, gridBagConstraints);
        jPanel3.add(this.clearButton);
        LindyFrame_Utils.buildConstraints((GridBagConstraints)gridBagConstraints, (int)1, (int)0, (int)1, (int)1, (double)10.0, (double)100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        this.add((Component)jPanel, "North");
        this.dataPanel = new JPanel(new GridLayout(1, 1, 0, 0));
        this.dataPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createLoweredBevelBorder()));
        this.chartsPanel = new ScatterChartPanel(this.resourceExample, this.resourceChart);
        this.dataPanel.add(this.chartsPanel);
        this.add((Component)this.dataPanel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.disableActions) {
            return;
        }
        if (object instanceof JComboBox && object == this.chartSelectorComboBox) {
            this.setChartType(this.chartSelectorComboBox.getSelectedItem());
        }
        if (object instanceof JButton) {
            if (object == this.refreshButton) {
                this.chartsPanel.setExampleData();
                return;
            }
            if (object == this.clearButton) {
                this.chartsPanel.removeAllData();
            }
        }
    }

    private void setChartType(Object object) {
        this.dataPanel.removeAll();
        this.chartsPanel = object.equals("Line Chart") ? new LineChartPanel(this.resourceExample, this.resourceChart) : (object.equals("Scatter Chart") ? new ScatterChartPanel(this.resourceExample, this.resourceChart) : new ChartsPanel());
        this.dataPanel.add(this.chartsPanel);
        this.validate();
    }

    protected void setDisableActions(boolean bl) {
        this.disableActions = bl;
        this.chartSelectorComboBox.setEnabled(!this.disableActions);
    }

    public ChartsPanel getChartsPanel() {
        return this.chartsPanel;
    }

    public String getChartType() {
        return (String)this.chartSelectorComboBox.getSelectedItem();
    }
}

