/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.scatterplot;

import com.dandymadeproductions.lindyframe.LindyFrame;
import com.dandymadeproductions.lindyframe.utilities.ImageUtil;
import com.dandymadeproductions.lindyframe.utilities.InputDialog;
import com.dandymadeproductions.lindyframe.utilities.LindyFrame_ProgressBar;
import com.dandymadeproductions.lindyframe.utilities.LindyFrame_ResourceBundle;
import com.dandymadeproductions.lindyframe.utilities.LindyFrame_Utils;
import com.dandymadeproductions.scatterplot.PlotPanel;
import com.dandymadeproductions.scatterplot.PreferencesPanel;
import com.dandymadeproductions.scatterplot.data.DataChartSeries;
import com.dandymadeproductions.scatterplot.data.LineChartSeries;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.jfree.data.general.SeriesException;

class MenuActionListener
implements ActionListener {
    private JFrame parent;
    private PlotPanel plotPanel;
    private LindyFrame_ResourceBundle resourceBundle;
    private String imagesDirectory;
    private String resourceTitleAlert;
    private String resourceErrorFile;
    private String lastOpenDirectory;
    private String lastSaveDirectory;

    public MenuActionListener(JFrame jFrame, PlotPanel plotPanel, LindyFrame_ResourceBundle lindyFrame_ResourceBundle, String string) {
        this.parent = jFrame;
        this.plotPanel = plotPanel;
        this.resourceBundle = lindyFrame_ResourceBundle;
        this.imagesDirectory = string;
        this.lastOpenDirectory = "";
        this.resourceTitleAlert = lindyFrame_ResourceBundle.getResourceString("MenuActionListener.dialogtitle.Alert", "Alert");
        this.resourceErrorFile = lindyFrame_ResourceBundle.getResourceString("MenuActionListener.dialogmessage.FileNOTFound", "File NOT Found");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = object instanceof JMenuItem ? ((JMenuItem)object).getActionCommand() : (object instanceof JButton ? ((JButton)object).getActionCommand() : "");
        if (string.equals("File Open")) {
            this.openAction();
            return;
        }
        if (string.equals("Save As Image")) {
            this.saveAsImageAction();
            return;
        }
        if (string.equals("FE")) {
            return;
        }
        if (string.equals("Edit Preferences")) {
            this.editPreferences();
            return;
        }
        if (string.equals("Data Import CSV")) {
            this.importAction();
            return;
        }
    }

    private void openAction() {
        JFileChooser jFileChooser = this.lastOpenDirectory.equals("") ? new JFileChooser() : new JFileChooser(new File(this.lastOpenDirectory));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = "";
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string.equals("csv");
            }

            @Override
            public String getDescription() {
                return "CSV Files";
            }
        });
        int n = jFileChooser.showOpenDialog(this.parent);
        if (n == 0) {
            this.lastOpenDirectory = jFileChooser.getCurrentDirectory().toString();
            String string = jFileChooser.getSelectedFile().getName();
            string = jFileChooser.getCurrentDirectory() + LindyFrame_Utils.getFileSeparator() + string;
            if (!string.equals("")) {
                final String string2 = string;
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        MenuActionListener.this.loadCSVData(string2, true);
                    }
                }, "MenuActionListener.openAction()");
                thread.start();
            } else {
                JOptionPane.showMessageDialog(null, this.resourceErrorFile, this.resourceTitleAlert, 0);
            }
        }
    }

    private void saveAsImageAction() {
        ImageUtil imageUtil = new ImageUtil((Component)this.plotPanel.getChartsPanel(), this.lastSaveDirectory, "png");
        this.lastSaveDirectory = imageUtil.getLastSaveDiretory();
    }

    private void editPreferences() {
        PreferencesPanel preferencesPanel = new PreferencesPanel(this.resourceBundle, this.imagesDirectory);
        Object[] objectArray = new Object[]{preferencesPanel};
        String string = this.resourceBundle.getResourceString("MenuActionListener.dialogtitle.Preferences", "Preferences");
        String string2 = this.resourceBundle.getResourceString("MenuActionListener.button.OK", "OK");
        String string3 = this.resourceBundle.getResourceString("MenuActionListener.button.Cancel", "Cancel");
        InputDialog inputDialog = new InputDialog(null, string, string2, string3, objectArray, null);
        inputDialog.pack();
        inputDialog.setPreferredSize(new Dimension(350, 355));
        inputDialog.setResizable(false);
        inputDialog.center();
        inputDialog.setVisible(true);
        if (inputDialog.isActionResult()) {
            preferencesPanel.setProperties();
            this.plotPanel.getChartsPanel().setProperties(this.plotPanel.getChartType());
        }
        inputDialog.dispose();
    }

    private void importAction() {
        JFileChooser jFileChooser = this.lastOpenDirectory.equals("") ? new JFileChooser() : new JFileChooser(new File(this.lastOpenDirectory));
        String[] stringArray = new String[]{"csv"};
        jFileChooser.setFileFilter(new CustomFileFilter(stringArray));
        int n = jFileChooser.showOpenDialog(this.parent);
        if (n == 0) {
            this.lastOpenDirectory = jFileChooser.getCurrentDirectory().toString();
            String string = jFileChooser.getSelectedFile().getName();
            string = jFileChooser.getCurrentDirectory() + LindyFrame_Utils.getFileSeparator() + string;
            if (!string.equals("")) {
                final String string2 = string;
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        MenuActionListener.this.loadCSVData(string2, true);
                    }
                }, "MenuActionLisenter.importActionThread");
                thread.start();
            } else {
                JOptionPane.showMessageDialog(null, this.resourceErrorFile, this.resourceTitleAlert, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadCSVData(String string, boolean bl) {
        String string2 = this.plotPanel.getChartType();
        if (!(string2.equals("Line Chart") || string2.equals("XY Area Chart") || string2.equals("Scatter Chart"))) {
            if (!string2.equals("XY Bar Chart")) return;
        }
        LineChartSeries lineChartSeries = new LineChartSeries("Series " + (this.plotPanel.getChartsPanel().getSeriesCount() + 1));
        ArrayList<String> arrayList = new ArrayList<String>();
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        LindyFrame_ProgressBar lindyFrame_ProgressBar = null;
        int n = 0;
        String string3 = ",";
        int n2 = 0;
        boolean bl2 = false;
        this.plotPanel.setDisableActions(true);
        lindyFrame_ProgressBar = new LindyFrame_ProgressBar("CSV Import To: Graph");
        try {
            int n3;
            String string4;
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            while ((string4 = bufferedReader.readLine()) != null) {
                ++n;
            }
            lindyFrame_ProgressBar.setTaskLength(n);
            lindyFrame_ProgressBar.pack();
            lindyFrame_ProgressBar.center();
            lindyFrame_ProgressBar.setVisible(bl);
            bufferedReader.close();
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            int n4 = 0;
            n2 = 1;
            bufferedReader.mark(5);
            string4 = bufferedReader.readLine();
            if (string4 == null) throw new IOException();
            String[] stringArray = string4.split(string3, 0);
            n4 = stringArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                arrayList.add(stringArray[n3]);
            }
            if (n4 == 1) {
                this.plotPanel.getChartsPanel().setChartXAxisLabel("Line Index");
                this.plotPanel.getChartsPanel().setChartYAxisLabel((String)arrayList.get(0));
            } else {
                this.plotPanel.getChartsPanel().setChartXAxisLabel((String)arrayList.get(0));
                this.plotPanel.getChartsPanel().setChartYAxisLabel((String)arrayList.get(1));
            }
            while ((string4 = bufferedReader.readLine()) != null && !lindyFrame_ProgressBar.isCanceled()) {
                block61: {
                    stringArray = string4.split(string3, n4);
                    if (n4 != stringArray.length) {
                        this.showError(n2 + 1, "");
                        lindyFrame_ProgressBar.setCanceled(true);
                        bl2 = true;
                        continue;
                    }
                    if (n4 == 1) {
                        String string5 = stringArray[0];
                        stringArray = new String[]{String.valueOf(n2 - 1), string5};
                    }
                    for (n3 = 1; n3 < n4; ++n3) {
                        if (!stringArray[n3].isEmpty()) continue;
                        stringArray[n3] = "0.0";
                    }
                    try {
                        if (n4 < 1) break block61;
                        if (string2.equals("Line Chart") || string2.equals("XY Area Chart") || string2.equals("Scatter Chart") || string2.equalsIgnoreCase("XY Bar Chart")) {
                            ((DataChartSeries)lineChartSeries).addDataPoint((Number)Double.valueOf(stringArray[0]), (Number)Double.valueOf(stringArray[1]));
                            break block61;
                        }
                        if (string2.equals("Bubble Chart")) {
                            if (n4 <= 2) {
                                lineChartSeries.addDataPoint(Double.valueOf(stringArray[0]), Double.valueOf(stringArray[1]), Double.valueOf(stringArray[1]));
                                break block61;
                            } else {
                                lineChartSeries.addDataPoint(Double.valueOf(stringArray[0]), Double.valueOf(stringArray[1]), Double.valueOf(stringArray[2]));
                            }
                            break block61;
                        }
                        if (string2.equals("Category Line Chart") || string2.equals("Bar Chart") || string2.equals("Area Chart") || string2.equals("Pie Chart")) {
                            lineChartSeries.addDataPoint(stringArray[0], (Number)Double.valueOf(stringArray[1]));
                        } else {
                            lineChartSeries.addDataPoint((Number)Double.valueOf(stringArray[0]), stringArray[1]);
                        }
                    }
                    catch (NumberFormatException | SeriesException runtimeException) {
                        this.showError(n2 + 1, runtimeException.getMessage());
                        if (LindyFrame.getDebug()) {
                            System.out.println("MenuActionListener loadCSVData() " + runtimeException.getMessage());
                        }
                        lindyFrame_ProgressBar.setCanceled(true);
                        bl2 = true;
                    }
                }
                if (bl2) continue;
                lindyFrame_ProgressBar.setCurrentValue(n2++);
            }
            if (!bl2) {
                this.plotPanel.getChartsPanel().addSeries(lineChartSeries);
                if (string.indexOf(LindyFrame_Utils.getFileSeparator()) != -1) {
                    n3 = string.lastIndexOf(LindyFrame_Utils.getFileSeparator());
                    this.plotPanel.getChartsPanel().setChartTitle(string.substring(n3 + 1));
                } else {
                    this.plotPanel.getChartsPanel().setChartTitle(string);
                }
            } else {
                ((DataChartSeries)lineChartSeries).clear();
                Runtime.getRuntime().gc();
            }
            lindyFrame_ProgressBar.dispose();
            return;
        }
        catch (IOException iOException) {
            lindyFrame_ProgressBar.dispose();
            JOptionPane.showMessageDialog(null, "Unable to Read Input File!", this.resourceTitleAlert, 0);
            return;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                if (LindyFrame.getDebug()) {
                    System.out.println("MenuActionListener loadCSVData() Failed to Close BufferedReader. " + iOException);
                }
            }
            finally {
                block64: {
                    try {
                        if (fileReader != null) {
                            fileReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!LindyFrame.getDebug()) break block64;
                        System.out.println("MenuActionListener loadCSVData() Failed to Close FileReader. " + iOException);
                    }
                }
            }
            this.plotPanel.setDisableActions(false);
        }
    }

    private void showError(int n, String string) {
        JOptionPane.showMessageDialog(null, "Error Line: " + n + "\n" + string, this.resourceTitleAlert, 0);
    }

    static class CustomFileFilter
    extends FileFilter {
        String[] extensions;

        public CustomFileFilter(String[] stringArray) {
            this.extensions = stringArray;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            for (String string : this.extensions) {
                if (!string.equals("*") && !file.getName().toLowerCase().endsWith(string)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.extensions) {
                stringBuilder.append("*." + string + ", ");
            }
            if (stringBuilder.toString().endsWith(", ")) {
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            }
            return stringBuilder.toString() + " Files";
        }
    }
}

